/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.replacements;

import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.CompressEncoding;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfigBase;
import org.graalvm.compiler.hotspot.meta.HotSpotForeignCallsProviderImpl;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.hotspot.meta.HotSpotRegistersProvider;
import org.graalvm.compiler.hotspot.nodes.GraalHotSpotVMConfigNode;
import org.graalvm.compiler.hotspot.nodes.HotSpotCompressionNode;
import org.graalvm.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import org.graalvm.compiler.hotspot.replacements.Log;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.gc.G1ArrayRangePostWriteBarrier;
import org.graalvm.compiler.nodes.gc.G1ArrayRangePreWriteBarrier;
import org.graalvm.compiler.nodes.gc.G1PostWriteBarrier;
import org.graalvm.compiler.nodes.gc.G1PreWriteBarrier;
import org.graalvm.compiler.nodes.gc.G1ReferentFieldReadBarrier;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.replacements.ReplacementsUtil;
import org.graalvm.compiler.replacements.SnippetCounter;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.gc.G1WriteBarrierSnippets;
import org.graalvm.compiler.replacements.gc.WriteBarrierSnippets;
import org.graalvm.compiler.word.Word;
import org.graalvm.word.WordFactory;

public final class HotSpotG1WriteBarrierSnippets
extends G1WriteBarrierSnippets {
    public static final ForeignCallDescriptor G1WBPRECALL = new ForeignCallDescriptor("write_barrier_pre", Void.TYPE, Object.class);
    public static final ForeignCallDescriptor G1WBPOSTCALL = new ForeignCallDescriptor("write_barrier_post", Void.TYPE, Word.class);
    public static final ForeignCallDescriptor VALIDATE_OBJECT = new ForeignCallDescriptor("validate_object", Boolean.TYPE, Word.class, Word.class);
    private final GraalHotSpotVMConfig config;
    private final Register threadRegister;

    public HotSpotG1WriteBarrierSnippets(GraalHotSpotVMConfig config, HotSpotRegistersProvider registers) {
        this.config = config;
        this.threadRegister = registers.getThreadRegister();
    }

    @Override
    protected Word getThread() {
        return HotSpotReplacementsUtil.registerAsWord(this.threadRegister);
    }

    @Override
    protected int wordSize() {
        return HotSpotReplacementsUtil.wordSize();
    }

    @Override
    protected int objectArrayIndexScale() {
        return ReplacementsUtil.arrayIndexScale(GraalHotSpotVMConfigBase.INJECTED_METAACCESS, JavaKind.Object);
    }

    @Override
    protected int satbQueueMarkingOffset() {
        return HotSpotReplacementsUtil.g1SATBQueueMarkingOffset(GraalHotSpotVMConfigBase.INJECTED_VMCONFIG);
    }

    @Override
    protected int satbQueueBufferOffset() {
        return HotSpotReplacementsUtil.g1SATBQueueBufferOffset(GraalHotSpotVMConfigBase.INJECTED_VMCONFIG);
    }

    @Override
    protected int satbQueueIndexOffset() {
        return HotSpotReplacementsUtil.g1SATBQueueIndexOffset(GraalHotSpotVMConfigBase.INJECTED_VMCONFIG);
    }

    @Override
    protected int cardQueueBufferOffset() {
        return HotSpotReplacementsUtil.g1CardQueueBufferOffset(GraalHotSpotVMConfigBase.INJECTED_VMCONFIG);
    }

    @Override
    protected int cardQueueIndexOffset() {
        return HotSpotReplacementsUtil.g1CardQueueIndexOffset(GraalHotSpotVMConfigBase.INJECTED_VMCONFIG);
    }

    @Override
    protected byte dirtyCardValue() {
        return HotSpotReplacementsUtil.dirtyCardValue(GraalHotSpotVMConfigBase.INJECTED_VMCONFIG);
    }

    @Override
    protected byte youngCardValue() {
        return HotSpotReplacementsUtil.g1YoungCardValue(GraalHotSpotVMConfigBase.INJECTED_VMCONFIG);
    }

    @Override
    protected Word cardTableAddress() {
        return (Word)WordFactory.unsigned((long)GraalHotSpotVMConfigNode.cardTableAddress());
    }

    @Override
    protected int cardTableShift() {
        return HotSpotReplacementsUtil.cardTableShift(GraalHotSpotVMConfigBase.INJECTED_VMCONFIG);
    }

    @Override
    protected int logOfHeapRegionGrainBytes() {
        return GraalHotSpotVMConfigNode.logOfHeapRegionGrainBytes();
    }

    @Override
    protected ForeignCallDescriptor preWriteBarrierCallDescriptor() {
        return G1WBPRECALL;
    }

    @Override
    protected ForeignCallDescriptor postWriteBarrierCallDescriptor() {
        return G1WBPOSTCALL;
    }

    @Override
    protected boolean verifyOops() {
        return HotSpotReplacementsUtil.verifyOops(GraalHotSpotVMConfigBase.INJECTED_VMCONFIG);
    }

    @Override
    protected boolean verifyBarrier() {
        return ReplacementsUtil.REPLACEMENTS_ASSERTIONS_ENABLED || this.config.verifyBeforeGC || this.config.verifyAfterGC;
    }

    @Override
    protected long gcTotalCollectionsAddress() {
        return HotSpotReplacementsUtil.gcTotalCollectionsAddress(GraalHotSpotVMConfigBase.INJECTED_VMCONFIG);
    }

    @Override
    protected ForeignCallDescriptor verifyOopCallDescriptor() {
        return HotSpotForeignCallsProviderImpl.VERIFY_OOP;
    }

    @Override
    protected ForeignCallDescriptor validateObjectCallDescriptor() {
        return VALIDATE_OBJECT;
    }

    @Override
    protected ForeignCallDescriptor printfCallDescriptor() {
        return Log.LOG_PRINTF;
    }

    static final class HotspotG1WriteBarrierLowerer
    extends G1WriteBarrierSnippets.G1WriteBarrierLowerer {
        private final CompressEncoding oopEncoding;

        HotspotG1WriteBarrierLowerer(GraalHotSpotVMConfig config, SnippetCounter.Group.Factory factory) {
            super(factory);
            this.oopEncoding = config.useCompressedOops ? config.getOopEncoding() : null;
        }

        @Override
        public ValueNode uncompress(ValueNode expected) {
            assert (this.oopEncoding != null);
            return HotSpotCompressionNode.uncompress(expected, this.oopEncoding);
        }
    }

    public static class Templates
    extends SnippetTemplate.AbstractTemplates {
        private final SnippetTemplate.SnippetInfo g1PreWriteBarrier;
        private final SnippetTemplate.SnippetInfo g1ReferentReadBarrier;
        private final SnippetTemplate.SnippetInfo g1PostWriteBarrier;
        private final SnippetTemplate.SnippetInfo g1ArrayRangePreWriteBarrier;
        private final SnippetTemplate.SnippetInfo g1ArrayRangePostWriteBarrier;
        private final G1WriteBarrierSnippets.G1WriteBarrierLowerer lowerer;

        public Templates(OptionValues options, Iterable<DebugHandlersFactory> factories, SnippetCounter.Group.Factory factory, HotSpotProviders providers, TargetDescription target, GraalHotSpotVMConfig config) {
            super(options, factories, providers, providers.getSnippetReflection(), target);
            this.lowerer = new HotspotG1WriteBarrierLowerer(config, factory);
            HotSpotG1WriteBarrierSnippets receiver = new HotSpotG1WriteBarrierSnippets(config, providers.getRegisters());
            this.g1ReferentReadBarrier = this.g1PreWriteBarrier = this.snippet(G1WriteBarrierSnippets.class, "g1PreWriteBarrier", null, receiver, G1WriteBarrierSnippets.GC_INDEX_LOCATION, G1WriteBarrierSnippets.GC_LOG_LOCATION, G1WriteBarrierSnippets.SATB_QUEUE_MARKING_LOCATION, G1WriteBarrierSnippets.SATB_QUEUE_INDEX_LOCATION, G1WriteBarrierSnippets.SATB_QUEUE_BUFFER_LOCATION);
            this.g1PostWriteBarrier = this.snippet(G1WriteBarrierSnippets.class, "g1PostWriteBarrier", null, receiver, WriteBarrierSnippets.GC_CARD_LOCATION, G1WriteBarrierSnippets.GC_INDEX_LOCATION, G1WriteBarrierSnippets.GC_LOG_LOCATION, G1WriteBarrierSnippets.CARD_QUEUE_INDEX_LOCATION, G1WriteBarrierSnippets.CARD_QUEUE_BUFFER_LOCATION);
            this.g1ArrayRangePreWriteBarrier = this.snippet(G1WriteBarrierSnippets.class, "g1ArrayRangePreWriteBarrier", null, receiver, G1WriteBarrierSnippets.GC_INDEX_LOCATION, G1WriteBarrierSnippets.GC_LOG_LOCATION, G1WriteBarrierSnippets.SATB_QUEUE_MARKING_LOCATION, G1WriteBarrierSnippets.SATB_QUEUE_INDEX_LOCATION, G1WriteBarrierSnippets.SATB_QUEUE_BUFFER_LOCATION);
            this.g1ArrayRangePostWriteBarrier = this.snippet(G1WriteBarrierSnippets.class, "g1ArrayRangePostWriteBarrier", null, receiver, WriteBarrierSnippets.GC_CARD_LOCATION, G1WriteBarrierSnippets.GC_INDEX_LOCATION, G1WriteBarrierSnippets.GC_LOG_LOCATION, G1WriteBarrierSnippets.CARD_QUEUE_INDEX_LOCATION, G1WriteBarrierSnippets.CARD_QUEUE_BUFFER_LOCATION);
        }

        public void lower(G1PreWriteBarrier barrier, LoweringTool tool) {
            this.lowerer.lower((SnippetTemplate.AbstractTemplates)this, this.g1PreWriteBarrier, barrier, tool);
        }

        public void lower(G1ReferentFieldReadBarrier barrier, LoweringTool tool) {
            this.lowerer.lower((SnippetTemplate.AbstractTemplates)this, this.g1ReferentReadBarrier, barrier, tool);
        }

        public void lower(G1PostWriteBarrier barrier, LoweringTool tool) {
            this.lowerer.lower((SnippetTemplate.AbstractTemplates)this, this.g1PostWriteBarrier, barrier, tool);
        }

        public void lower(G1ArrayRangePreWriteBarrier barrier, LoweringTool tool) {
            this.lowerer.lower((SnippetTemplate.AbstractTemplates)this, this.g1ArrayRangePreWriteBarrier, barrier, tool);
        }

        public void lower(G1ArrayRangePostWriteBarrier barrier, LoweringTool tool) {
            this.lowerer.lower((SnippetTemplate.AbstractTemplates)this, this.g1ArrayRangePostWriteBarrier, barrier, tool);
        }
    }
}

