/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.replacements;

import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.api.replacements.ClassSubstitution;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.api.replacements.MethodSubstitution;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfigBase;
import org.graalvm.compiler.hotspot.HotSpotBackend;
import org.graalvm.compiler.hotspot.replacements.AESCryptSubstitutions;
import org.graalvm.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import org.graalvm.compiler.nodes.ComputeObjectAddressNode;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.nodes.extended.RawLoadNode;
import org.graalvm.compiler.nodes.graphbuilderconf.IntrinsicContext;
import org.graalvm.compiler.nodes.java.InstanceOfNode;
import org.graalvm.compiler.replacements.ReplacementsUtil;
import org.graalvm.compiler.word.Word;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;
import org.graalvm.word.WordFactory;

@ClassSubstitution(className={"com.sun.crypto.provider.CipherBlockChaining"}, optional=true)
public class CipherBlockChainingSubstitutions {
    @Fold
    static ResolvedJavaType aesCryptType(@Fold.InjectedParameter IntrinsicContext context) {
        return HotSpotReplacementsUtil.getType(context, "Lcom/sun/crypto/provider/AESCrypt;");
    }

    @MethodSubstitution(isStatic=false)
    static int encrypt(Object rcvr, byte[] in, int inOffset, int inLength, byte[] out, int outOffset) {
        Object realReceiver = PiNode.piCastNonNull(rcvr, HotSpotReplacementsUtil.methodHolderClass(GraalHotSpotVMConfigBase.INJECTED_INTRINSIC_CONTEXT));
        Object embeddedCipher = RawLoadNode.load(realReceiver, CipherBlockChainingSubstitutions.embeddedCipherOffset(GraalHotSpotVMConfigBase.INJECTED_INTRINSIC_CONTEXT), JavaKind.Object, LocationIdentity.any());
        if (InstanceOfNode.doInstanceof(CipherBlockChainingSubstitutions.aesCryptType(GraalHotSpotVMConfigBase.INJECTED_INTRINSIC_CONTEXT), embeddedCipher)) {
            Object aesCipher = PiNode.piCastNonNull(embeddedCipher, CipherBlockChainingSubstitutions.aesCryptType(GraalHotSpotVMConfigBase.INJECTED_INTRINSIC_CONTEXT));
            CipherBlockChainingSubstitutions.crypt(realReceiver, in, inOffset, inLength, out, outOffset, aesCipher, true, false);
            return inLength;
        }
        return CipherBlockChainingSubstitutions.encrypt(realReceiver, in, inOffset, inLength, out, outOffset);
    }

    @Fold
    static long embeddedCipherOffset(@Fold.InjectedParameter IntrinsicContext context) {
        return HotSpotReplacementsUtil.getFieldOffset(HotSpotReplacementsUtil.getType(context, "Lcom/sun/crypto/provider/FeedbackCipher;"), "embeddedCipher");
    }

    @Fold
    static long rOffset(@Fold.InjectedParameter IntrinsicContext intrinsicContext) {
        return HotSpotReplacementsUtil.getFieldOffset(HotSpotReplacementsUtil.methodHolderClass(intrinsicContext), "r");
    }

    @MethodSubstitution(isStatic=false, value="implEncrypt")
    static int implEncrypt(Object rcvr, byte[] in, int inOffset, int inLength, byte[] out, int outOffset) {
        Object realReceiver = PiNode.piCastNonNull(rcvr, HotSpotReplacementsUtil.methodHolderClass(GraalHotSpotVMConfigBase.INJECTED_INTRINSIC_CONTEXT));
        Object embeddedCipher = RawLoadNode.load(realReceiver, CipherBlockChainingSubstitutions.embeddedCipherOffset(GraalHotSpotVMConfigBase.INJECTED_INTRINSIC_CONTEXT), JavaKind.Object, LocationIdentity.any());
        if (InstanceOfNode.doInstanceof(CipherBlockChainingSubstitutions.aesCryptType(GraalHotSpotVMConfigBase.INJECTED_INTRINSIC_CONTEXT), embeddedCipher)) {
            Object aesCipher = PiNode.piCastNonNull(embeddedCipher, CipherBlockChainingSubstitutions.aesCryptType(GraalHotSpotVMConfigBase.INJECTED_INTRINSIC_CONTEXT));
            CipherBlockChainingSubstitutions.crypt(realReceiver, in, inOffset, inLength, out, outOffset, aesCipher, true, false);
            return inLength;
        }
        return CipherBlockChainingSubstitutions.implEncrypt(realReceiver, in, inOffset, inLength, out, outOffset);
    }

    @MethodSubstitution(isStatic=false)
    static int decrypt(Object rcvr, byte[] in, int inOffset, int inLength, byte[] out, int outOffset) {
        Object realReceiver = PiNode.piCastNonNull(rcvr, HotSpotReplacementsUtil.methodHolderClass(GraalHotSpotVMConfigBase.INJECTED_INTRINSIC_CONTEXT));
        Object embeddedCipher = RawLoadNode.load(realReceiver, CipherBlockChainingSubstitutions.embeddedCipherOffset(GraalHotSpotVMConfigBase.INJECTED_INTRINSIC_CONTEXT), JavaKind.Object, LocationIdentity.any());
        if (in != out && InstanceOfNode.doInstanceof(CipherBlockChainingSubstitutions.aesCryptType(GraalHotSpotVMConfigBase.INJECTED_INTRINSIC_CONTEXT), embeddedCipher)) {
            Object aesCipher = PiNode.piCastNonNull(embeddedCipher, CipherBlockChainingSubstitutions.aesCryptType(GraalHotSpotVMConfigBase.INJECTED_INTRINSIC_CONTEXT));
            CipherBlockChainingSubstitutions.crypt(realReceiver, in, inOffset, inLength, out, outOffset, aesCipher, false, false);
            return inLength;
        }
        return CipherBlockChainingSubstitutions.decrypt(realReceiver, in, inOffset, inLength, out, outOffset);
    }

    @MethodSubstitution(isStatic=false)
    static int implDecrypt(Object rcvr, byte[] in, int inOffset, int inLength, byte[] out, int outOffset) {
        Object realReceiver = PiNode.piCastNonNull(rcvr, HotSpotReplacementsUtil.methodHolderClass(GraalHotSpotVMConfigBase.INJECTED_INTRINSIC_CONTEXT));
        Object embeddedCipher = RawLoadNode.load(realReceiver, CipherBlockChainingSubstitutions.embeddedCipherOffset(GraalHotSpotVMConfigBase.INJECTED_INTRINSIC_CONTEXT), JavaKind.Object, LocationIdentity.any());
        if (in != out && InstanceOfNode.doInstanceof(CipherBlockChainingSubstitutions.aesCryptType(GraalHotSpotVMConfigBase.INJECTED_INTRINSIC_CONTEXT), embeddedCipher)) {
            Object aesCipher = PiNode.piCastNonNull(embeddedCipher, CipherBlockChainingSubstitutions.aesCryptType(GraalHotSpotVMConfigBase.INJECTED_INTRINSIC_CONTEXT));
            CipherBlockChainingSubstitutions.crypt(realReceiver, in, inOffset, inLength, out, outOffset, aesCipher, false, false);
            return inLength;
        }
        return CipherBlockChainingSubstitutions.implDecrypt(realReceiver, in, inOffset, inLength, out, outOffset);
    }

    @MethodSubstitution(isStatic=false, value="decrypt")
    static int decryptWithOriginalKey(Object rcvr, byte[] in, int inOffset, int inLength, byte[] out, int outOffset) {
        Object realReceiver = PiNode.piCastNonNull(rcvr, HotSpotReplacementsUtil.methodHolderClass(GraalHotSpotVMConfigBase.INJECTED_INTRINSIC_CONTEXT));
        Object embeddedCipher = RawLoadNode.load(realReceiver, CipherBlockChainingSubstitutions.embeddedCipherOffset(GraalHotSpotVMConfigBase.INJECTED_INTRINSIC_CONTEXT), JavaKind.Object, LocationIdentity.any());
        if (in != out && InstanceOfNode.doInstanceof(CipherBlockChainingSubstitutions.aesCryptType(GraalHotSpotVMConfigBase.INJECTED_INTRINSIC_CONTEXT), embeddedCipher)) {
            Object aesCipher = PiNode.piCastNonNull(embeddedCipher, CipherBlockChainingSubstitutions.aesCryptType(GraalHotSpotVMConfigBase.INJECTED_INTRINSIC_CONTEXT));
            CipherBlockChainingSubstitutions.crypt(realReceiver, in, inOffset, inLength, out, outOffset, aesCipher, false, true);
            return inLength;
        }
        return CipherBlockChainingSubstitutions.decryptWithOriginalKey(realReceiver, in, inOffset, inLength, out, outOffset);
    }

    @MethodSubstitution(isStatic=false, value="implDecrypt")
    static int implDecryptWithOriginalKey(Object rcvr, byte[] in, int inOffset, int inLength, byte[] out, int outOffset) {
        Object realReceiver = PiNode.piCastNonNull(rcvr, HotSpotReplacementsUtil.methodHolderClass(GraalHotSpotVMConfigBase.INJECTED_INTRINSIC_CONTEXT));
        Object embeddedCipher = RawLoadNode.load(realReceiver, CipherBlockChainingSubstitutions.embeddedCipherOffset(GraalHotSpotVMConfigBase.INJECTED_INTRINSIC_CONTEXT), JavaKind.Object, LocationIdentity.any());
        if (in != out && InstanceOfNode.doInstanceof(CipherBlockChainingSubstitutions.aesCryptType(GraalHotSpotVMConfigBase.INJECTED_INTRINSIC_CONTEXT), embeddedCipher)) {
            Object aesCipher = PiNode.piCastNonNull(embeddedCipher, CipherBlockChainingSubstitutions.aesCryptType(GraalHotSpotVMConfigBase.INJECTED_INTRINSIC_CONTEXT));
            CipherBlockChainingSubstitutions.crypt(realReceiver, in, inOffset, inLength, out, outOffset, aesCipher, false, true);
            return inLength;
        }
        return CipherBlockChainingSubstitutions.implDecryptWithOriginalKey(realReceiver, in, inOffset, inLength, out, outOffset);
    }

    private static void crypt(Object rcvr, byte[] in, int inOffset, int inLength, byte[] out, int outOffset, Object embeddedCipher, boolean encrypt, boolean withOriginalKey) {
        AESCryptSubstitutions.checkArgs(in, inOffset, out, outOffset);
        Object realReceiver = PiNode.piCastNonNull(rcvr, HotSpotReplacementsUtil.methodHolderClass(GraalHotSpotVMConfigBase.INJECTED_INTRINSIC_CONTEXT));
        Object aesCipher = PiNode.piCastNonNull(embeddedCipher, CipherBlockChainingSubstitutions.aesCryptType(GraalHotSpotVMConfigBase.INJECTED_INTRINSIC_CONTEXT));
        Object kObject = RawLoadNode.load(aesCipher, AESCryptSubstitutions.kOffset(GraalHotSpotVMConfigBase.INJECTED_INTRINSIC_CONTEXT), JavaKind.Object, LocationIdentity.any());
        Object rObject = RawLoadNode.load(realReceiver, CipherBlockChainingSubstitutions.rOffset(GraalHotSpotVMConfigBase.INJECTED_INTRINSIC_CONTEXT), JavaKind.Object, LocationIdentity.any());
        Word kAddr = Word.objectToTrackedPointer(kObject).add(ReplacementsUtil.getArrayBaseOffset(GraalHotSpotVMConfig.INJECTED_METAACCESS, JavaKind.Int));
        Word rAddr = Word.objectToTrackedPointer(rObject).add(ReplacementsUtil.getArrayBaseOffset(GraalHotSpotVMConfig.INJECTED_METAACCESS, JavaKind.Byte));
        Word inAddr = (Word)WordFactory.unsigned((long)ComputeObjectAddressNode.get(in, ReplacementsUtil.getArrayBaseOffset(GraalHotSpotVMConfig.INJECTED_METAACCESS, JavaKind.Byte) + inOffset));
        Word outAddr = (Word)WordFactory.unsigned((long)ComputeObjectAddressNode.get(out, ReplacementsUtil.getArrayBaseOffset(GraalHotSpotVMConfig.INJECTED_METAACCESS, JavaKind.Byte) + outOffset));
        if (encrypt) {
            CipherBlockChainingSubstitutions.encryptAESCryptStub(HotSpotBackend.ENCRYPT, inAddr, outAddr, kAddr, rAddr, inLength);
        } else if (withOriginalKey) {
            Object lastKeyObject = RawLoadNode.load(aesCipher, AESCryptSubstitutions.lastKeyOffset(GraalHotSpotVMConfigBase.INJECTED_INTRINSIC_CONTEXT), JavaKind.Object, LocationIdentity.any());
            Word lastKeyAddr = Word.objectToTrackedPointer(lastKeyObject).add(ReplacementsUtil.getArrayBaseOffset(GraalHotSpotVMConfig.INJECTED_METAACCESS, JavaKind.Byte));
            CipherBlockChainingSubstitutions.decryptAESCryptWithOriginalKeyStub(HotSpotBackend.DECRYPT_WITH_ORIGINAL_KEY, inAddr, outAddr, kAddr, rAddr, inLength, lastKeyAddr);
        } else {
            CipherBlockChainingSubstitutions.decryptAESCryptStub(HotSpotBackend.DECRYPT, inAddr, outAddr, kAddr, rAddr, inLength);
        }
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    public static native void encryptAESCryptStub(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Word var1, Word var2, Pointer var3, Pointer var4, int var5);

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    public static native void decryptAESCryptStub(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Word var1, Word var2, Pointer var3, Pointer var4, int var5);

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    public static native void decryptAESCryptWithOriginalKeyStub(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Word var1, Word var2, Pointer var3, Pointer var4, int var5, Pointer var6);
}

