/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.replacements;

import jdk.vm.ci.hotspot.HotSpotObjectConstant;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.spi.Canonicalizable;
import org.graalvm.compiler.graph.spi.CanonicalizerTool;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.InvokeNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.replacements.nodes.MacroStateSplitNode;

@NodeInfo
public final class CallSiteTargetNode
extends MacroStateSplitNode
implements Canonicalizable,
Lowerable {
    public static final NodeClass<CallSiteTargetNode> TYPE = NodeClass.create(CallSiteTargetNode.class);

    public CallSiteTargetNode(CallTargetNode.InvokeKind invokeKind, ResolvedJavaMethod targetMethod, int bci, StampPair returnStamp, ValueNode receiver) {
        super(TYPE, invokeKind, targetMethod, bci, returnStamp, receiver);
    }

    private ValueNode getCallSite() {
        return (ValueNode)this.arguments.get(0);
    }

    public static ConstantNode tryFold(ValueNode callSite, MetaAccessProvider metaAccess, Assumptions assumptions) {
        HotSpotObjectConstant c;
        JavaConstant target;
        if (callSite != null && callSite.isConstant() && !callSite.isNullConstant() && (target = (c = (HotSpotObjectConstant)callSite.asConstant()).getCallSiteTarget(assumptions)) != null) {
            return ConstantNode.forConstant(target, metaAccess);
        }
        return null;
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        ConstantNode target = CallSiteTargetNode.tryFold(this.getCallSite(), tool.getMetaAccess(), this.graph().getAssumptions());
        if (target != null) {
            return target;
        }
        return this;
    }

    @Override
    public void lower(LoweringTool tool) {
        ConstantNode target = CallSiteTargetNode.tryFold(this.getCallSite(), tool.getMetaAccess(), this.graph().getAssumptions());
        if (target != null) {
            this.graph().replaceFixedWithFloating(this, target);
        } else {
            InvokeNode invoke = this.createInvoke();
            this.graph().replaceFixedWithFixed(this, invoke);
            invoke.lower(tool);
        }
    }
}

