/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.phases.aot;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jdk.vm.ci.hotspot.HotSpotMetaspaceConstant;
import jdk.vm.ci.hotspot.HotSpotResolvedObjectType;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.EconomicSet;
import org.graalvm.compiler.hotspot.nodes.aot.InitializeKlassNode;
import org.graalvm.compiler.hotspot.nodes.aot.ResolveConstantNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.graph.MergeableState;
import org.graalvm.compiler.phases.graph.PostOrderNodeIterator;
import org.graalvm.util.CollectionsUtil;

public class EliminateRedundantInitializationPhase
extends BasePhase<CoreProviders> {
    private static void removeInitsAtStaticCalls(StructuredGraph graph) {
        for (Invoke invoke : graph.getInvokes()) {
            ValueNode classInit = invoke.classInit();
            if (classInit == null) continue;
            classInit.replaceAtUsages(null);
            graph.removeFixed((FixedWithNextNode)classInit);
        }
    }

    private static void removeRedundantInits(StructuredGraph graph) {
        List<FixedWithNextNode> redundantNodes = EliminateRedundantInitializationPhase.findRedundantInits(graph);
        for (FixedWithNextNode n : redundantNodes) {
            graph.removeFixed(n);
        }
    }

    private static List<FixedWithNextNode> findRedundantInits(StructuredGraph graph) {
        EliminateRedundantInitializationIterator i = new EliminateRedundantInitializationIterator((FixedNode)graph.start(), new InitializedTypes());
        i.apply();
        return i.getRedundantNodes();
    }

    @Override
    protected void run(StructuredGraph graph, CoreProviders context) {
        EliminateRedundantInitializationPhase.removeInitsAtStaticCalls(graph);
        EliminateRedundantInitializationPhase.removeRedundantInits(graph);
    }

    private static class EliminateRedundantInitializationIterator
    extends PostOrderNodeIterator<InitializedTypes> {
        private List<FixedWithNextNode> redundantNodes = new ArrayList<FixedWithNextNode>();

        public List<FixedWithNextNode> getRedundantNodes() {
            return this.redundantNodes;
        }

        EliminateRedundantInitializationIterator(FixedNode start, InitializedTypes initialState) {
            super(start, initialState);
        }

        private void processType(FixedWithNextNode node, Constant c) {
            HotSpotMetaspaceConstant klass = (HotSpotMetaspaceConstant)c;
            HotSpotResolvedObjectType t = klass.asResolvedJavaType();
            if (t != null) {
                if (((InitializedTypes)this.state).contains((ResolvedJavaType)t)) {
                    this.redundantNodes.add(node);
                } else {
                    ((InitializedTypes)this.state).add((ResolvedJavaType)t);
                }
            }
        }

        @Override
        protected void node(FixedNode node) {
            ResolveConstantNode r;
            if (node instanceof InitializeKlassNode) {
                InitializeKlassNode i = (InitializeKlassNode)node;
                if (i.value().isConstant()) {
                    this.processType(i, i.value().asConstant());
                }
            } else if (node instanceof ResolveConstantNode && (r = (ResolveConstantNode)node).hasNoUsages() && r.value().isConstant()) {
                this.processType(r, r.value().asConstant());
            }
        }
    }

    private static class InitializedTypes
    extends MergeableState<InitializedTypes>
    implements Cloneable {
        private EconomicSet<ResolvedJavaType> types;

        InitializedTypes() {
            this.types = EconomicSet.create();
        }

        private InitializedTypes(EconomicSet<ResolvedJavaType> types) {
            this.types = types;
        }

        @Override
        public InitializedTypes clone() {
            return new InitializedTypes((EconomicSet<ResolvedJavaType>)EconomicSet.create(this.types));
        }

        public boolean contains(ResolvedJavaType type) {
            if (type.isInterface() || type.isArray()) {
                return this.types.contains((Object)type);
            }
            return CollectionsUtil.anyMatch(this.types, t -> type.isAssignableFrom(t));
        }

        public void add(ResolvedJavaType type) {
            this.types.add((Object)type);
        }

        private static ResolvedJavaType merge(ResolvedJavaType a, ResolvedJavaType b) {
            if (a.isInterface() || b.isInterface() || a.isArray() || b.isArray()) {
                if (a.equals(b)) {
                    return a;
                }
                return null;
            }
            ResolvedJavaType c = a.findLeastCommonAncestor(b);
            if (c.isJavaLangObject()) {
                return null;
            }
            return c;
        }

        private static EconomicSet<ResolvedJavaType> merge(EconomicSet<ResolvedJavaType> a, EconomicSet<ResolvedJavaType> b) {
            EconomicSet c = EconomicSet.create();
            block0: for (ResolvedJavaType ta : a) {
                for (ResolvedJavaType tb : b) {
                    ResolvedJavaType tc = InitializedTypes.merge(ta, tb);
                    if (tc == null) continue;
                    c.add((Object)tc);
                    if (!tc.isInterface() && !tc.isArray()) continue;
                    continue block0;
                }
            }
            return c;
        }

        @Override
        public boolean merge(AbstractMergeNode merge, List<InitializedTypes> withStates) {
            for (InitializedTypes ts : withStates) {
                this.types = InitializedTypes.merge(this.types, ts.types);
            }
            return true;
        }

        protected static String toString(EconomicSet<ResolvedJavaType> types) {
            StringBuilder b = new StringBuilder();
            b.append("[");
            Iterator i = types.iterator();
            while (i.hasNext()) {
                ResolvedJavaType t = (ResolvedJavaType)i.next();
                b.append(t.toString());
                if (!i.hasNext()) continue;
                b.append(",");
            }
            b.append("]");
            return b.toString();
        }

        public String toString() {
            return InitializedTypes.toString(this.types);
        }
    }
}

