/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.nodes.aot;

import jdk.vm.ci.hotspot.HotSpotMetaspaceConstant;
import jdk.vm.ci.hotspot.HotSpotObjectConstant;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.PermanentBailoutException;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.spi.Canonicalizable;
import org.graalvm.compiler.graph.spi.CanonicalizerTool;
import org.graalvm.compiler.hotspot.HotSpotLIRGenerator;
import org.graalvm.compiler.hotspot.meta.HotSpotConstantLoadAction;
import org.graalvm.compiler.hotspot.nodes.DeoptimizingStubCall;
import org.graalvm.compiler.hotspot.word.KlassPointer;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.word.Word;

@NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, size=NodeSize.SIZE_16)
public class ResolveConstantStubCall
extends DeoptimizingStubCall
implements Canonicalizable,
LIRLowerable {
    public static final NodeClass<ResolveConstantStubCall> TYPE = NodeClass.create(ResolveConstantStubCall.class);
    @Node.OptionalInput
    protected ValueNode value;
    @Node.Input
    protected ValueNode string;
    protected Constant constant;
    protected HotSpotConstantLoadAction action;

    public ResolveConstantStubCall(ValueNode value, ValueNode string) {
        super((NodeClass<? extends DeoptimizingStubCall>)TYPE, value.stamp(NodeView.DEFAULT));
        this.value = value;
        this.string = string;
        this.action = HotSpotConstantLoadAction.RESOLVE;
    }

    public ResolveConstantStubCall(ValueNode value, ValueNode string, HotSpotConstantLoadAction action) {
        super((NodeClass<? extends DeoptimizingStubCall>)TYPE, value.stamp(NodeView.DEFAULT));
        this.value = value;
        this.string = string;
        this.action = action;
    }

    @Node.NodeIntrinsic
    public static native Object resolveObject(Object var0, Object var1);

    @Node.NodeIntrinsic
    public static native KlassPointer resolveKlass(KlassPointer var0, Word var1);

    @Node.NodeIntrinsic
    public static native KlassPointer resolveKlass(KlassPointer var0, Word var1, @Node.ConstantNodeParameter HotSpotConstantLoadAction var2);

    @Override
    public Node canonical(CanonicalizerTool tool) {
        if (this.value != null) {
            this.constant = GraphUtil.foldIfConstantAndRemove(this, this.value);
        }
        return this;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        Value result;
        assert (this.constant != null) : "Expected the value to fold: " + this.value;
        Value stringValue = gen.operand(this.string);
        LIRFrameState fs = gen.state(this);
        assert (fs != null) : "The stateAfter is null";
        if (this.constant instanceof HotSpotObjectConstant) {
            result = ((HotSpotLIRGenerator)gen.getLIRGeneratorTool()).emitObjectConstantRetrieval(this.constant, stringValue, fs);
        } else if (this.constant instanceof HotSpotMetaspaceConstant) {
            if (this.action == HotSpotConstantLoadAction.RESOLVE) {
                result = ((HotSpotLIRGenerator)gen.getLIRGeneratorTool()).emitMetaspaceConstantRetrieval(this.constant, stringValue, fs);
            } else {
                assert (this.action == HotSpotConstantLoadAction.INITIALIZE);
                result = ((HotSpotLIRGenerator)gen.getLIRGeneratorTool()).emitKlassInitializationAndRetrieval(this.constant, stringValue, fs);
            }
        } else {
            throw new PermanentBailoutException("Unsupported constant type: " + this.constant);
        }
        gen.setResult(this, result);
    }
}

