/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.nodes;

import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.lir.VirtualStackSlot;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.word.Word;
import org.graalvm.compiler.word.WordTypes;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_1)
public final class DimensionsNode
extends FixedWithNextNode
implements LIRLowerable {
    public static final NodeClass<DimensionsNode> TYPE = NodeClass.create(DimensionsNode.class);
    protected final int rank;

    public DimensionsNode(@Node.InjectedNodeParameter WordTypes wordTypes, int rank) {
        super((NodeClass<? extends FixedWithNextNode>)TYPE, StampFactory.forKind(wordTypes.getWordKind()));
        this.rank = rank;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        LIRGeneratorTool lirGen = gen.getLIRGeneratorTool();
        int size = this.rank * 4;
        int wordSize = lirGen.target().wordSize;
        int slots = NumUtil.roundUp(size, wordSize) / wordSize;
        VirtualStackSlot array = lirGen.allocateStackSlots(slots);
        Variable result = lirGen.emitAddress(array);
        gen.setResult(this, (Value)result);
    }

    @Node.NodeIntrinsic
    public static native Word allocaDimsArray(@Node.ConstantNodeParameter int var0);
}

