/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.meta;

import org.graalvm.compiler.api.replacements.ClassSubstitution;
import org.graalvm.compiler.api.replacements.MethodSubstitution;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotBackend;
import org.graalvm.compiler.hotspot.nodes.CurrentJavaThreadNode;
import org.graalvm.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import org.graalvm.compiler.nodes.ComputeObjectAddressNode;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.compiler.word.Word;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.WordFactory;

@ClassSubstitution(className={"jdk.internal.misc.Unsafe", "sun.misc.Unsafe"})
public class HotSpotUnsafeSubstitutions {
    public static final String copyMemoryName = JavaVersionUtil.JAVA_SPEC <= 8 ? "copyMemory" : "copyMemory0";

    @MethodSubstitution(isStatic=false)
    static void copyMemory(Object receiver, Object srcBase, long srcOffset, Object destBase, long destOffset, long bytes) {
        Word srcAddr = (Word)WordFactory.unsigned((long)ComputeObjectAddressNode.get(srcBase, srcOffset));
        Word dstAddr = (Word)WordFactory.unsigned((long)ComputeObjectAddressNode.get(destBase, destOffset));
        Word size = (Word)WordFactory.signed((long)bytes);
        HotSpotBackend.unsafeArraycopy(srcAddr, dstAddr, size);
    }

    @MethodSubstitution(value="copyMemory", isStatic=false)
    static void copyMemoryGuarded(Object receiver, Object srcBase, long srcOffset, Object destBase, long destOffset, long bytes) {
        Word srcAddr = (Word)WordFactory.unsigned((long)ComputeObjectAddressNode.get(srcBase, srcOffset));
        Word dstAddr = (Word)WordFactory.unsigned((long)ComputeObjectAddressNode.get(destBase, destOffset));
        Word size = (Word)WordFactory.signed((long)bytes);
        Word javaThread = CurrentJavaThreadNode.get();
        int offset = HotSpotReplacementsUtil.doingUnsafeAccessOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG);
        LocationIdentity any = LocationIdentity.any();
        javaThread.writeByte(offset, (byte)1, any);
        HotSpotBackend.unsafeArraycopy(srcAddr, dstAddr, size);
        javaThread.writeByte(offset, (byte)0, any);
    }
}

