/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.meta;

import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.gc.BarrierSet;
import org.graalvm.compiler.nodes.gc.CardTableBarrierSet;
import org.graalvm.compiler.nodes.gc.G1BarrierSet;
import org.graalvm.compiler.nodes.java.AbstractNewObjectNode;
import org.graalvm.compiler.nodes.memory.FixedAccessNode;
import org.graalvm.compiler.nodes.spi.GCProvider;

public class HotSpotGCProvider
implements GCProvider {
    private final BarrierSet barrierSet;

    public HotSpotGCProvider(GraalHotSpotVMConfig config) {
        this.barrierSet = this.createBarrierSet(config);
    }

    @Override
    public BarrierSet getBarrierSet() {
        return this.barrierSet;
    }

    private BarrierSet createBarrierSet(GraalHotSpotVMConfig config) {
        final boolean useDeferredInitBarriers = config.useDeferredInitBarriers;
        if (config.useG1GC) {
            return new G1BarrierSet(){

                @Override
                protected boolean writeRequiresPostBarrier(FixedAccessNode initializingWrite, ValueNode writtenValue) {
                    if (!super.writeRequiresPostBarrier(initializingWrite, writtenValue)) {
                        return false;
                    }
                    return !useDeferredInitBarriers || !HotSpotGCProvider.this.isWriteToNewObject(initializingWrite);
                }
            };
        }
        return new CardTableBarrierSet(){

            @Override
            protected boolean writeRequiresBarrier(FixedAccessNode initializingWrite, ValueNode writtenValue) {
                if (!super.writeRequiresBarrier(initializingWrite, writtenValue)) {
                    return false;
                }
                return !useDeferredInitBarriers || !HotSpotGCProvider.this.isWriteToNewObject(initializingWrite);
            }
        };
    }

    protected boolean isWriteToNewObject(FixedAccessNode initializingWrite) {
        if (!initializingWrite.getLocationIdentity().isInit()) {
            return false;
        }
        ValueNode base = initializingWrite.getAddress().getBase();
        if (base instanceof AbstractNewObjectNode) {
            for (Node pred = initializingWrite.predecessor(); pred != null; pred = pred.predecessor()) {
                if (pred == base) {
                    return true;
                }
                if (!(pred instanceof AbstractNewObjectNode)) continue;
                initializingWrite.getDebug().log(2, "Disallowed deferred init because %s was last allocation instead of %s", (Object)pred, (Object)base);
                return false;
            }
        }
        initializingWrite.getDebug().log(2, "Unable to find allocation for deferred init for %s with base %s", (Object)initializingWrite, (Object)base);
        return false;
    }
}

