/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.meta;

import java.util.ArrayList;
import java.util.List;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.hotspot.HotSpotCallingConventionType;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.hotspot.HotSpotForeignCallLinkage;
import org.graalvm.compiler.hotspot.HotSpotForeignCallLinkageImpl;
import org.graalvm.compiler.hotspot.HotSpotGraalRuntimeProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotForeignCallsProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.hotspot.stubs.ForeignCallStub;
import org.graalvm.compiler.hotspot.stubs.Stub;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.word.Word;
import org.graalvm.compiler.word.WordTypes;
import org.graalvm.word.LocationIdentity;

public abstract class HotSpotForeignCallsProviderImpl
implements HotSpotForeignCallsProvider {
    public static final ForeignCallDescriptor OSR_MIGRATION_END = new ForeignCallDescriptor("OSR_migration_end", Void.TYPE, Long.TYPE);
    public static final ForeignCallDescriptor IDENTITY_HASHCODE = new ForeignCallDescriptor("identity_hashcode", Integer.TYPE, Object.class);
    public static final ForeignCallDescriptor VERIFY_OOP = new ForeignCallDescriptor("verify_oop", Object.class, Object.class);
    public static final ForeignCallDescriptor LOAD_AND_CLEAR_EXCEPTION = new ForeignCallDescriptor("load_and_clear_exception", Object.class, Word.class);
    public static final ForeignCallDescriptor TEST_DEOPTIMIZE_CALL_INT = new ForeignCallDescriptor("test_deoptimize_call_int", Integer.TYPE, Integer.TYPE);
    protected final HotSpotJVMCIRuntime jvmciRuntime;
    protected final HotSpotGraalRuntimeProvider runtime;
    protected final EconomicMap<ForeignCallDescriptor, HotSpotForeignCallLinkage> foreignCalls = EconomicMap.create();
    protected final MetaAccessProvider metaAccess;
    protected final CodeCacheProvider codeCache;
    protected final WordTypes wordTypes;
    public static final boolean PREPEND_THREAD = true;
    public static final boolean DONT_PREPEND_THREAD = false;
    public static final LocationIdentity[] NO_LOCATIONS = new LocationIdentity[0];

    public HotSpotForeignCallsProviderImpl(HotSpotJVMCIRuntime jvmciRuntime, HotSpotGraalRuntimeProvider runtime, MetaAccessProvider metaAccess, CodeCacheProvider codeCache, WordTypes wordTypes) {
        this.jvmciRuntime = jvmciRuntime;
        this.runtime = runtime;
        this.metaAccess = metaAccess;
        this.codeCache = codeCache;
        this.wordTypes = wordTypes;
    }

    public HotSpotForeignCallLinkage register(HotSpotForeignCallLinkage linkage) {
        assert (!this.foreignCalls.containsKey((Object)linkage.getDescriptor())) : "already registered linkage for " + linkage.getDescriptor();
        this.foreignCalls.put((Object)linkage.getDescriptor(), (Object)linkage);
        return linkage;
    }

    public boolean isRegistered(ForeignCallDescriptor descriptor) {
        return this.foreignCalls.containsKey((Object)descriptor);
    }

    public HotSpotForeignCallLinkage registerStubCall(ForeignCallDescriptor descriptor, HotSpotForeignCallLinkage.Transition transition, HotSpotForeignCallLinkage.Reexecutability reexecutability, HotSpotForeignCallLinkage.RegisterEffect effect, LocationIdentity ... killedLocations) {
        return this.register(HotSpotForeignCallLinkageImpl.create(this.metaAccess, this.codeCache, this.wordTypes, this, descriptor, 0L, effect, (CallingConvention.Type)HotSpotCallingConventionType.JavaCall, (CallingConvention.Type)HotSpotCallingConventionType.JavaCallee, transition, reexecutability, killedLocations));
    }

    public HotSpotForeignCallLinkage registerForeignCall(ForeignCallDescriptor descriptor, long address, CallingConvention.Type outgoingCcType, HotSpotForeignCallLinkage.Transition transition, HotSpotForeignCallLinkage.Reexecutability reexecutability, LocationIdentity ... killedLocations) {
        Class<?> resultType = descriptor.getResultType();
        assert (address != 0L) : descriptor;
        assert (transition != HotSpotForeignCallLinkage.Transition.SAFEPOINT || resultType.isPrimitive() || Word.class.isAssignableFrom(resultType)) : "non-leaf foreign calls must return objects in thread local storage: " + descriptor;
        return this.register(HotSpotForeignCallLinkageImpl.create(this.metaAccess, this.codeCache, this.wordTypes, this, descriptor, address, HotSpotForeignCallLinkage.RegisterEffect.DESTROYS_ALL_CALLER_SAVE_REGISTERS, outgoingCcType, null, transition, reexecutability, killedLocations));
    }

    public void linkForeignCall(OptionValues options, HotSpotProviders providers, ForeignCallDescriptor descriptor, long address, boolean prependThread, HotSpotForeignCallLinkage.Transition transition, HotSpotForeignCallLinkage.Reexecutability reexecutability, LocationIdentity ... killedLocations) {
        if (address != 0L) {
            ForeignCallStub stub = new ForeignCallStub(options, this.jvmciRuntime, providers, address, descriptor, prependThread, transition, reexecutability, killedLocations);
            HotSpotForeignCallLinkage linkage = stub.getLinkage();
            HotSpotForeignCallLinkage targetLinkage = stub.getTargetLinkage();
            linkage.setCompiledStub(stub);
            this.register(linkage);
            this.register(targetLinkage);
        }
    }

    @Override
    public HotSpotForeignCallLinkage lookupForeignCall(ForeignCallDescriptor descriptor) {
        assert (this.foreignCalls != null) : descriptor;
        HotSpotForeignCallLinkage callTarget = (HotSpotForeignCallLinkage)this.foreignCalls.get((Object)descriptor);
        if (callTarget == null) {
            throw GraalError.shouldNotReachHere("missing implementation for runtime call: " + descriptor);
        }
        callTarget.finalizeAddress(this.runtime.getHostBackend());
        return callTarget;
    }

    @Override
    public boolean isAvailable(ForeignCallDescriptor descriptor) {
        return this.foreignCalls.containsKey((Object)descriptor);
    }

    @Override
    public boolean isReexecutable(ForeignCallDescriptor descriptor) {
        assert (this.foreignCalls.containsKey((Object)descriptor)) : "unknown foreign call: " + descriptor;
        return ((HotSpotForeignCallLinkage)this.foreignCalls.get((Object)descriptor)).isReexecutable();
    }

    @Override
    public boolean canDeoptimize(ForeignCallDescriptor descriptor) {
        assert (this.foreignCalls.containsKey((Object)descriptor)) : "unknown foreign call: " + descriptor;
        return ((HotSpotForeignCallLinkage)this.foreignCalls.get((Object)descriptor)).needsDebugInfo();
    }

    @Override
    public boolean isGuaranteedSafepoint(ForeignCallDescriptor descriptor) {
        assert (this.foreignCalls.containsKey((Object)descriptor)) : "unknown foreign call: " + descriptor;
        return ((HotSpotForeignCallLinkage)this.foreignCalls.get((Object)descriptor)).isGuaranteedSafepoint();
    }

    @Override
    public LocationIdentity[] getKilledLocations(ForeignCallDescriptor descriptor) {
        assert (this.foreignCalls.containsKey((Object)descriptor)) : "unknown foreign call: " + descriptor;
        return ((HotSpotForeignCallLinkage)this.foreignCalls.get((Object)descriptor)).getKilledLocations();
    }

    public LIRKind getValueKind(JavaKind javaKind) {
        return LIRKind.fromJavaKind(this.codeCache.getTarget().arch, javaKind);
    }

    @Override
    public List<Stub> getStubs() {
        ArrayList<Stub> stubs = new ArrayList<Stub>();
        for (HotSpotForeignCallLinkage linkage : this.foreignCalls.getValues()) {
            if (!linkage.isCompiledStub()) continue;
            Stub stub = linkage.getStub();
            assert (stub != null);
            stubs.add(stub);
        }
        return stubs;
    }
}

