/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.meta;

import jdk.vm.ci.hotspot.HotSpotResolvedObjectType;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.hotspot.meta.HotSpotProfilingPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionType;
import org.graalvm.compiler.options.OptionValues;

public class HotSpotAOTProfilingPlugin
extends HotSpotProfilingPlugin {
    @Override
    public boolean shouldProfile(GraphBuilderContext builder, ResolvedJavaMethod method) {
        return super.shouldProfile(builder, method) && ((HotSpotResolvedObjectType)method.getDeclaringClass()).getFingerprint() != 0L;
    }

    @Override
    public int invokeNotifyFreqLog(OptionValues options) {
        return Options.TierAInvokeNotifyFreqLog.getValue(options);
    }

    @Override
    public int invokeInlineeNotifyFreqLog(OptionValues options) {
        return Options.TierAInvokeInlineeNotifyFreqLog.getValue(options);
    }

    @Override
    public int invokeProfilePobabilityLog(OptionValues options) {
        return Options.TierAInvokeProfileProbabilityLog.getValue(options);
    }

    @Override
    public int backedgeNotifyFreqLog(OptionValues options) {
        return Options.TierABackedgeNotifyFreqLog.getValue(options);
    }

    @Override
    public int backedgeProfilePobabilityLog(OptionValues options) {
        return Options.TierABackedgeProfileProbabilityLog.getValue(options);
    }

    public static class Options {
        @Option(help={"Do profiling and callbacks to tiered runtime"}, type=OptionType.User)
        public static final OptionKey<Boolean> TieredAOT = new OptionKey<Boolean>(false);
        @Option(help={"Invocation notification frequency"}, type=OptionType.Expert)
        public static final OptionKey<Integer> TierAInvokeNotifyFreqLog = new OptionKey<Integer>(13);
        @Option(help={"Inlinee invocation notification frequency (-1 means count, but do not notify)"}, type=OptionType.Expert)
        public static final OptionKey<Integer> TierAInvokeInlineeNotifyFreqLog = new OptionKey<Integer>(-1);
        @Option(help={"Invocation profile probability"}, type=OptionType.Expert)
        public static final OptionKey<Integer> TierAInvokeProfileProbabilityLog = new OptionKey<Integer>(8);
        @Option(help={"Backedge notification frequency"}, type=OptionType.Expert)
        public static final OptionKey<Integer> TierABackedgeNotifyFreqLog = new OptionKey<Integer>(16);
        @Option(help={"Backedge profile probability"}, type=OptionType.Expert)
        public static final OptionKey<Integer> TierABackedgeProfileProbabilityLog = new OptionKey<Integer>(12);
    }
}

