/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.amd64;

import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.amd64.AMD64Address;
import org.graalvm.compiler.asm.amd64.AMD64Assembler;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.core.common.spi.ForeignCallLinkage;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotHostBackend;
import org.graalvm.compiler.hotspot.amd64.AMD64HotSpotEpilogueBlockEndOp;
import org.graalvm.compiler.hotspot.amd64.AMD64HotSpotSafepointOp;
import org.graalvm.compiler.hotspot.meta.HotSpotForeignCallsProvider;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.amd64.AMD64Call;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.gen.DiagnosticLIRGeneratorTool;

@Opcode(value="RETURN")
final class AMD64HotSpotReturnOp
extends AMD64HotSpotEpilogueBlockEndOp
implements DiagnosticLIRGeneratorTool.ZapStackArgumentSpaceBeforeInstruction {
    public static final LIRInstructionClass<AMD64HotSpotReturnOp> TYPE = LIRInstructionClass.create(AMD64HotSpotReturnOp.class);
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    protected Value value;
    private final boolean isStub;
    private final Register thread;
    private final Register scratchForSafepointOnReturn;
    private final GraalHotSpotVMConfig config;
    private final boolean requiresReservedStackAccessCheck;

    AMD64HotSpotReturnOp(Value value, boolean isStub, Register thread, Register scratchForSafepointOnReturn, GraalHotSpotVMConfig config, boolean requiresReservedStackAccessCheck) {
        super((LIRInstructionClass<? extends AMD64HotSpotEpilogueBlockEndOp>)TYPE);
        this.value = value;
        this.isStub = isStub;
        this.thread = thread;
        this.scratchForSafepointOnReturn = scratchForSafepointOnReturn;
        this.config = config;
        this.requiresReservedStackAccessCheck = requiresReservedStackAccessCheck;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        this.leaveFrameAndRestoreRbp(crb, masm);
        if (!this.isStub) {
            if (this.requiresReservedStackAccessCheck) {
                assert (this.scratchForSafepointOnReturn != null);
                HotSpotForeignCallsProvider foreignCalls = (HotSpotForeignCallsProvider)crb.foreignCalls;
                Label noReserved = new Label();
                masm.cmpptr(AMD64.rsp, new AMD64Address(AMD64.r15, this.config.javaThreadReservedStackActivationOffset));
                masm.jccb(AMD64Assembler.ConditionFlag.Below, noReserved);
                int stackAdjust = crb.target.stackAlignment - crb.target.wordSize;
                if (stackAdjust > 0) {
                    masm.subq(AMD64.rsp, stackAdjust);
                }
                ForeignCallLinkage enableStackReservedZone = foreignCalls.lookupForeignCall(HotSpotHostBackend.ENABLE_STACK_RESERVED_ZONE);
                CallingConvention cc = enableStackReservedZone.getOutgoingCallingConvention();
                assert (cc.getArgumentCount() == 1);
                Register arg0 = ((RegisterValue)cc.getArgument(0)).getRegister();
                masm.movq(arg0, this.thread);
                AMD64Call.directCall(crb, masm, enableStackReservedZone, this.scratchForSafepointOnReturn, false, null);
                if (stackAdjust > 0) {
                    masm.addq(AMD64.rsp, stackAdjust);
                }
                AMD64Call.directJmp(crb, masm, foreignCalls.lookupForeignCall(HotSpotHostBackend.THROW_DELAYED_STACKOVERFLOW_ERROR), this.scratchForSafepointOnReturn);
                masm.bind(noReserved);
            }
            AMD64HotSpotSafepointOp.emitCode(crb, masm, this.config, true, null, this.thread, this.scratchForSafepointOnReturn);
            if (masm.supports(AMD64.CPUFeature.AVX)) {
                masm.vzeroupper();
            }
        }
        masm.ret(0);
    }
}

