/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.amd64;

import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.hotspot.HotSpotCallingConventionType;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotBackend;
import org.graalvm.compiler.hotspot.HotSpotForeignCallLinkage;
import org.graalvm.compiler.hotspot.HotSpotForeignCallLinkageImpl;
import org.graalvm.compiler.hotspot.HotSpotGraalRuntimeProvider;
import org.graalvm.compiler.hotspot.amd64.AMD64ArrayCompareToStub;
import org.graalvm.compiler.hotspot.amd64.AMD64ArrayEqualsStub;
import org.graalvm.compiler.hotspot.amd64.AMD64ArrayIndexOfStub;
import org.graalvm.compiler.hotspot.amd64.AMD64MathStub;
import org.graalvm.compiler.hotspot.meta.HotSpotHostForeignCallsProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.hotspot.replacements.CRC32CSubstitutions;
import org.graalvm.compiler.hotspot.replacements.CRC32Substitutions;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.replacements.amd64.AMD64ArrayIndexOf;
import org.graalvm.compiler.replacements.nodes.BinaryMathIntrinsicNode;
import org.graalvm.compiler.replacements.nodes.UnaryMathIntrinsicNode;
import org.graalvm.compiler.word.WordTypes;
import org.graalvm.word.LocationIdentity;

public class AMD64HotSpotForeignCallsProvider
extends HotSpotHostForeignCallsProvider {
    private final Value[] nativeABICallerSaveRegisters;

    public AMD64HotSpotForeignCallsProvider(HotSpotJVMCIRuntime jvmciRuntime, HotSpotGraalRuntimeProvider runtime, MetaAccessProvider metaAccess, CodeCacheProvider codeCache, WordTypes wordTypes, Value[] nativeABICallerSaveRegisters) {
        super(jvmciRuntime, runtime, metaAccess, codeCache, wordTypes);
        this.nativeABICallerSaveRegisters = nativeABICallerSaveRegisters;
    }

    @Override
    public void initialize(HotSpotProviders providers, OptionValues options) {
        GraalHotSpotVMConfig config = this.runtime.getVMConfig();
        TargetDescription target = providers.getCodeCache().getTarget();
        PlatformKind word = target.arch.getWordKind();
        RegisterValue exception = AMD64.rax.asValue((ValueKind)LIRKind.reference(word));
        RegisterValue exceptionPc = AMD64.rdx.asValue((ValueKind)LIRKind.value(word));
        CallingConvention exceptionCc = new CallingConvention(0, Value.ILLEGAL, new AllocatableValue[]{exception, exceptionPc});
        this.register(new HotSpotForeignCallLinkageImpl(HotSpotBackend.EXCEPTION_HANDLER, 0L, HotSpotForeignCallLinkage.RegisterEffect.DESTROYS_ALL_CALLER_SAVE_REGISTERS, HotSpotForeignCallLinkage.Transition.LEAF_NO_VZERO, HotSpotForeignCallLinkage.Reexecutability.NOT_REEXECUTABLE, exceptionCc, null, LocationIdentity.any()));
        this.register(new HotSpotForeignCallLinkageImpl(HotSpotBackend.EXCEPTION_HANDLER_IN_CALLER, -2401018188504514833L, HotSpotForeignCallLinkage.RegisterEffect.DESTROYS_ALL_CALLER_SAVE_REGISTERS, HotSpotForeignCallLinkage.Transition.LEAF_NO_VZERO, HotSpotForeignCallLinkage.Reexecutability.NOT_REEXECUTABLE, exceptionCc, null, LocationIdentity.any()));
        if (config.useCRC32Intrinsics) {
            this.registerForeignCall(CRC32Substitutions.UPDATE_BYTES_CRC32, config.updateBytesCRC32Stub, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall, HotSpotForeignCallLinkage.Transition.LEAF_NO_VZERO, HotSpotForeignCallLinkage.Reexecutability.NOT_REEXECUTABLE, LocationIdentity.any());
        }
        if (config.useCRC32CIntrinsics) {
            this.registerForeignCall(CRC32CSubstitutions.UPDATE_BYTES_CRC32C, config.updateBytesCRC32C, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall, HotSpotForeignCallLinkage.Transition.LEAF_NO_VZERO, HotSpotForeignCallLinkage.Reexecutability.NOT_REEXECUTABLE, LocationIdentity.any());
        }
        AMD64HotSpotForeignCallsProvider.link(new AMD64ArrayIndexOfStub(AMD64ArrayIndexOf.STUB_INDEX_OF_TWO_CONSECUTIVE_BYTES, options, providers, this.registerStubCall(AMD64ArrayIndexOf.STUB_INDEX_OF_TWO_CONSECUTIVE_BYTES, HotSpotForeignCallLinkage.Transition.LEAF, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, HotSpotForeignCallLinkage.RegisterEffect.COMPUTES_REGISTERS_KILLED, NO_LOCATIONS)));
        AMD64HotSpotForeignCallsProvider.link(new AMD64ArrayIndexOfStub(AMD64ArrayIndexOf.STUB_INDEX_OF_TWO_CONSECUTIVE_CHARS, options, providers, this.registerStubCall(AMD64ArrayIndexOf.STUB_INDEX_OF_TWO_CONSECUTIVE_CHARS, HotSpotForeignCallLinkage.Transition.LEAF, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, HotSpotForeignCallLinkage.RegisterEffect.COMPUTES_REGISTERS_KILLED, NO_LOCATIONS)));
        AMD64HotSpotForeignCallsProvider.link(new AMD64ArrayIndexOfStub(AMD64ArrayIndexOf.STUB_INDEX_OF_TWO_CONSECUTIVE_CHARS_COMPACT, options, providers, this.registerStubCall(AMD64ArrayIndexOf.STUB_INDEX_OF_TWO_CONSECUTIVE_CHARS_COMPACT, HotSpotForeignCallLinkage.Transition.LEAF, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, HotSpotForeignCallLinkage.RegisterEffect.COMPUTES_REGISTERS_KILLED, NO_LOCATIONS)));
        AMD64HotSpotForeignCallsProvider.link(new AMD64ArrayIndexOfStub(AMD64ArrayIndexOf.STUB_INDEX_OF_1_BYTE, options, providers, this.registerStubCall(AMD64ArrayIndexOf.STUB_INDEX_OF_1_BYTE, HotSpotForeignCallLinkage.Transition.LEAF, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, HotSpotForeignCallLinkage.RegisterEffect.COMPUTES_REGISTERS_KILLED, NO_LOCATIONS)));
        AMD64HotSpotForeignCallsProvider.link(new AMD64ArrayIndexOfStub(AMD64ArrayIndexOf.STUB_INDEX_OF_2_BYTES, options, providers, this.registerStubCall(AMD64ArrayIndexOf.STUB_INDEX_OF_2_BYTES, HotSpotForeignCallLinkage.Transition.LEAF, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, HotSpotForeignCallLinkage.RegisterEffect.COMPUTES_REGISTERS_KILLED, NO_LOCATIONS)));
        AMD64HotSpotForeignCallsProvider.link(new AMD64ArrayIndexOfStub(AMD64ArrayIndexOf.STUB_INDEX_OF_3_BYTES, options, providers, this.registerStubCall(AMD64ArrayIndexOf.STUB_INDEX_OF_3_BYTES, HotSpotForeignCallLinkage.Transition.LEAF, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, HotSpotForeignCallLinkage.RegisterEffect.COMPUTES_REGISTERS_KILLED, NO_LOCATIONS)));
        AMD64HotSpotForeignCallsProvider.link(new AMD64ArrayIndexOfStub(AMD64ArrayIndexOf.STUB_INDEX_OF_4_BYTES, options, providers, this.registerStubCall(AMD64ArrayIndexOf.STUB_INDEX_OF_4_BYTES, HotSpotForeignCallLinkage.Transition.LEAF, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, HotSpotForeignCallLinkage.RegisterEffect.COMPUTES_REGISTERS_KILLED, NO_LOCATIONS)));
        AMD64HotSpotForeignCallsProvider.link(new AMD64ArrayIndexOfStub(AMD64ArrayIndexOf.STUB_INDEX_OF_1_CHAR, options, providers, this.registerStubCall(AMD64ArrayIndexOf.STUB_INDEX_OF_1_CHAR, HotSpotForeignCallLinkage.Transition.LEAF, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, HotSpotForeignCallLinkage.RegisterEffect.COMPUTES_REGISTERS_KILLED, NO_LOCATIONS)));
        AMD64HotSpotForeignCallsProvider.link(new AMD64ArrayIndexOfStub(AMD64ArrayIndexOf.STUB_INDEX_OF_2_CHARS, options, providers, this.registerStubCall(AMD64ArrayIndexOf.STUB_INDEX_OF_2_CHARS, HotSpotForeignCallLinkage.Transition.LEAF, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, HotSpotForeignCallLinkage.RegisterEffect.COMPUTES_REGISTERS_KILLED, NO_LOCATIONS)));
        AMD64HotSpotForeignCallsProvider.link(new AMD64ArrayIndexOfStub(AMD64ArrayIndexOf.STUB_INDEX_OF_3_CHARS, options, providers, this.registerStubCall(AMD64ArrayIndexOf.STUB_INDEX_OF_3_CHARS, HotSpotForeignCallLinkage.Transition.LEAF, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, HotSpotForeignCallLinkage.RegisterEffect.COMPUTES_REGISTERS_KILLED, NO_LOCATIONS)));
        AMD64HotSpotForeignCallsProvider.link(new AMD64ArrayIndexOfStub(AMD64ArrayIndexOf.STUB_INDEX_OF_4_CHARS, options, providers, this.registerStubCall(AMD64ArrayIndexOf.STUB_INDEX_OF_4_CHARS, HotSpotForeignCallLinkage.Transition.LEAF, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, HotSpotForeignCallLinkage.RegisterEffect.COMPUTES_REGISTERS_KILLED, NO_LOCATIONS)));
        AMD64HotSpotForeignCallsProvider.link(new AMD64ArrayIndexOfStub(AMD64ArrayIndexOf.STUB_INDEX_OF_1_CHAR_COMPACT, options, providers, this.registerStubCall(AMD64ArrayIndexOf.STUB_INDEX_OF_1_CHAR_COMPACT, HotSpotForeignCallLinkage.Transition.LEAF, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, HotSpotForeignCallLinkage.RegisterEffect.COMPUTES_REGISTERS_KILLED, NO_LOCATIONS)));
        AMD64HotSpotForeignCallsProvider.link(new AMD64ArrayIndexOfStub(AMD64ArrayIndexOf.STUB_INDEX_OF_2_CHARS_COMPACT, options, providers, this.registerStubCall(AMD64ArrayIndexOf.STUB_INDEX_OF_2_CHARS_COMPACT, HotSpotForeignCallLinkage.Transition.LEAF, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, HotSpotForeignCallLinkage.RegisterEffect.COMPUTES_REGISTERS_KILLED, NO_LOCATIONS)));
        AMD64HotSpotForeignCallsProvider.link(new AMD64ArrayIndexOfStub(AMD64ArrayIndexOf.STUB_INDEX_OF_3_CHARS_COMPACT, options, providers, this.registerStubCall(AMD64ArrayIndexOf.STUB_INDEX_OF_3_CHARS_COMPACT, HotSpotForeignCallLinkage.Transition.LEAF, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, HotSpotForeignCallLinkage.RegisterEffect.COMPUTES_REGISTERS_KILLED, NO_LOCATIONS)));
        AMD64HotSpotForeignCallsProvider.link(new AMD64ArrayIndexOfStub(AMD64ArrayIndexOf.STUB_INDEX_OF_4_CHARS_COMPACT, options, providers, this.registerStubCall(AMD64ArrayIndexOf.STUB_INDEX_OF_4_CHARS_COMPACT, HotSpotForeignCallLinkage.Transition.LEAF, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, HotSpotForeignCallLinkage.RegisterEffect.COMPUTES_REGISTERS_KILLED, NO_LOCATIONS)));
        AMD64HotSpotForeignCallsProvider.link(new AMD64ArrayEqualsStub(AMD64ArrayEqualsStub.STUB_BOOLEAN_ARRAY_EQUALS, options, providers, this.registerStubCall(AMD64ArrayEqualsStub.STUB_BOOLEAN_ARRAY_EQUALS, HotSpotForeignCallLinkage.Transition.LEAF, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, HotSpotForeignCallLinkage.RegisterEffect.COMPUTES_REGISTERS_KILLED, NO_LOCATIONS)));
        AMD64HotSpotForeignCallsProvider.link(new AMD64ArrayEqualsStub(AMD64ArrayEqualsStub.STUB_BYTE_ARRAY_EQUALS, options, providers, this.registerStubCall(AMD64ArrayEqualsStub.STUB_BYTE_ARRAY_EQUALS, HotSpotForeignCallLinkage.Transition.LEAF, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, HotSpotForeignCallLinkage.RegisterEffect.COMPUTES_REGISTERS_KILLED, NO_LOCATIONS)));
        AMD64HotSpotForeignCallsProvider.link(new AMD64ArrayEqualsStub(AMD64ArrayEqualsStub.STUB_CHAR_ARRAY_EQUALS, options, providers, this.registerStubCall(AMD64ArrayEqualsStub.STUB_CHAR_ARRAY_EQUALS, HotSpotForeignCallLinkage.Transition.LEAF, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, HotSpotForeignCallLinkage.RegisterEffect.COMPUTES_REGISTERS_KILLED, NO_LOCATIONS)));
        AMD64HotSpotForeignCallsProvider.link(new AMD64ArrayEqualsStub(AMD64ArrayEqualsStub.STUB_SHORT_ARRAY_EQUALS, options, providers, this.registerStubCall(AMD64ArrayEqualsStub.STUB_SHORT_ARRAY_EQUALS, HotSpotForeignCallLinkage.Transition.LEAF, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, HotSpotForeignCallLinkage.RegisterEffect.COMPUTES_REGISTERS_KILLED, NO_LOCATIONS)));
        AMD64HotSpotForeignCallsProvider.link(new AMD64ArrayEqualsStub(AMD64ArrayEqualsStub.STUB_INT_ARRAY_EQUALS, options, providers, this.registerStubCall(AMD64ArrayEqualsStub.STUB_INT_ARRAY_EQUALS, HotSpotForeignCallLinkage.Transition.LEAF, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, HotSpotForeignCallLinkage.RegisterEffect.COMPUTES_REGISTERS_KILLED, NO_LOCATIONS)));
        AMD64HotSpotForeignCallsProvider.link(new AMD64ArrayEqualsStub(AMD64ArrayEqualsStub.STUB_LONG_ARRAY_EQUALS, options, providers, this.registerStubCall(AMD64ArrayEqualsStub.STUB_LONG_ARRAY_EQUALS, HotSpotForeignCallLinkage.Transition.LEAF, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, HotSpotForeignCallLinkage.RegisterEffect.COMPUTES_REGISTERS_KILLED, NO_LOCATIONS)));
        AMD64HotSpotForeignCallsProvider.link(new AMD64ArrayEqualsStub(AMD64ArrayEqualsStub.STUB_FLOAT_ARRAY_EQUALS, options, providers, this.registerStubCall(AMD64ArrayEqualsStub.STUB_FLOAT_ARRAY_EQUALS, HotSpotForeignCallLinkage.Transition.LEAF, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, HotSpotForeignCallLinkage.RegisterEffect.COMPUTES_REGISTERS_KILLED, NO_LOCATIONS)));
        AMD64HotSpotForeignCallsProvider.link(new AMD64ArrayEqualsStub(AMD64ArrayEqualsStub.STUB_DOUBLE_ARRAY_EQUALS, options, providers, this.registerStubCall(AMD64ArrayEqualsStub.STUB_DOUBLE_ARRAY_EQUALS, HotSpotForeignCallLinkage.Transition.LEAF, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, HotSpotForeignCallLinkage.RegisterEffect.COMPUTES_REGISTERS_KILLED, NO_LOCATIONS)));
        AMD64HotSpotForeignCallsProvider.link(new AMD64ArrayEqualsStub(AMD64ArrayEqualsStub.STUB_BYTE_ARRAY_EQUALS_DIRECT, options, providers, this.registerStubCall(AMD64ArrayEqualsStub.STUB_BYTE_ARRAY_EQUALS_DIRECT, HotSpotForeignCallLinkage.Transition.LEAF, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, HotSpotForeignCallLinkage.RegisterEffect.COMPUTES_REGISTERS_KILLED, NO_LOCATIONS)));
        AMD64HotSpotForeignCallsProvider.link(new AMD64ArrayEqualsStub(AMD64ArrayEqualsStub.STUB_CHAR_ARRAY_EQUALS_DIRECT, options, providers, this.registerStubCall(AMD64ArrayEqualsStub.STUB_CHAR_ARRAY_EQUALS_DIRECT, HotSpotForeignCallLinkage.Transition.LEAF, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, HotSpotForeignCallLinkage.RegisterEffect.COMPUTES_REGISTERS_KILLED, NO_LOCATIONS)));
        AMD64HotSpotForeignCallsProvider.link(new AMD64ArrayEqualsStub(AMD64ArrayEqualsStub.STUB_CHAR_ARRAY_EQUALS_BYTE_ARRAY, options, providers, this.registerStubCall(AMD64ArrayEqualsStub.STUB_CHAR_ARRAY_EQUALS_BYTE_ARRAY, HotSpotForeignCallLinkage.Transition.LEAF, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, HotSpotForeignCallLinkage.RegisterEffect.COMPUTES_REGISTERS_KILLED, NO_LOCATIONS)));
        AMD64HotSpotForeignCallsProvider.link(new AMD64ArrayCompareToStub(AMD64ArrayCompareToStub.STUB_BYTE_ARRAY_COMPARE_TO_BYTE_ARRAY, options, providers, this.registerStubCall(AMD64ArrayCompareToStub.STUB_BYTE_ARRAY_COMPARE_TO_BYTE_ARRAY, HotSpotForeignCallLinkage.Transition.LEAF, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, HotSpotForeignCallLinkage.RegisterEffect.COMPUTES_REGISTERS_KILLED, NO_LOCATIONS)));
        AMD64HotSpotForeignCallsProvider.link(new AMD64ArrayCompareToStub(AMD64ArrayCompareToStub.STUB_BYTE_ARRAY_COMPARE_TO_CHAR_ARRAY, options, providers, this.registerStubCall(AMD64ArrayCompareToStub.STUB_BYTE_ARRAY_COMPARE_TO_CHAR_ARRAY, HotSpotForeignCallLinkage.Transition.LEAF, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, HotSpotForeignCallLinkage.RegisterEffect.COMPUTES_REGISTERS_KILLED, NO_LOCATIONS)));
        AMD64HotSpotForeignCallsProvider.link(new AMD64ArrayCompareToStub(AMD64ArrayCompareToStub.STUB_CHAR_ARRAY_COMPARE_TO_BYTE_ARRAY, options, providers, this.registerStubCall(AMD64ArrayCompareToStub.STUB_CHAR_ARRAY_COMPARE_TO_BYTE_ARRAY, HotSpotForeignCallLinkage.Transition.LEAF, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, HotSpotForeignCallLinkage.RegisterEffect.COMPUTES_REGISTERS_KILLED, NO_LOCATIONS)));
        AMD64HotSpotForeignCallsProvider.link(new AMD64ArrayCompareToStub(AMD64ArrayCompareToStub.STUB_CHAR_ARRAY_COMPARE_TO_CHAR_ARRAY, options, providers, this.registerStubCall(AMD64ArrayCompareToStub.STUB_CHAR_ARRAY_COMPARE_TO_CHAR_ARRAY, HotSpotForeignCallLinkage.Transition.LEAF, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, HotSpotForeignCallLinkage.RegisterEffect.COMPUTES_REGISTERS_KILLED, NO_LOCATIONS)));
        super.initialize(providers, options);
    }

    @Override
    public Value[] getNativeABICallerSaveRegisters() {
        return this.nativeABICallerSaveRegisters;
    }

    @Override
    protected void registerMathStubs(GraalHotSpotVMConfig hotSpotVMConfig, HotSpotProviders providers, OptionValues options) {
        if (HotSpotBackend.Options.GraalArithmeticStubs.getValue(options).booleanValue()) {
            AMD64HotSpotForeignCallsProvider.link(new AMD64MathStub(UnaryMathIntrinsicNode.UnaryOperation.SIN, options, providers, this.registerStubCall(UnaryMathIntrinsicNode.UnaryOperation.SIN.foreignCallDescriptor, HotSpotForeignCallLinkage.Transition.LEAF, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, HotSpotForeignCallLinkage.RegisterEffect.COMPUTES_REGISTERS_KILLED, NO_LOCATIONS)));
            AMD64HotSpotForeignCallsProvider.link(new AMD64MathStub(UnaryMathIntrinsicNode.UnaryOperation.COS, options, providers, this.registerStubCall(UnaryMathIntrinsicNode.UnaryOperation.COS.foreignCallDescriptor, HotSpotForeignCallLinkage.Transition.LEAF, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, HotSpotForeignCallLinkage.RegisterEffect.COMPUTES_REGISTERS_KILLED, NO_LOCATIONS)));
            AMD64HotSpotForeignCallsProvider.link(new AMD64MathStub(UnaryMathIntrinsicNode.UnaryOperation.TAN, options, providers, this.registerStubCall(UnaryMathIntrinsicNode.UnaryOperation.TAN.foreignCallDescriptor, HotSpotForeignCallLinkage.Transition.LEAF, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, HotSpotForeignCallLinkage.RegisterEffect.COMPUTES_REGISTERS_KILLED, NO_LOCATIONS)));
            AMD64HotSpotForeignCallsProvider.link(new AMD64MathStub(UnaryMathIntrinsicNode.UnaryOperation.EXP, options, providers, this.registerStubCall(UnaryMathIntrinsicNode.UnaryOperation.EXP.foreignCallDescriptor, HotSpotForeignCallLinkage.Transition.LEAF, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, HotSpotForeignCallLinkage.RegisterEffect.COMPUTES_REGISTERS_KILLED, NO_LOCATIONS)));
            AMD64HotSpotForeignCallsProvider.link(new AMD64MathStub(UnaryMathIntrinsicNode.UnaryOperation.LOG, options, providers, this.registerStubCall(UnaryMathIntrinsicNode.UnaryOperation.LOG.foreignCallDescriptor, HotSpotForeignCallLinkage.Transition.LEAF, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, HotSpotForeignCallLinkage.RegisterEffect.COMPUTES_REGISTERS_KILLED, NO_LOCATIONS)));
            AMD64HotSpotForeignCallsProvider.link(new AMD64MathStub(UnaryMathIntrinsicNode.UnaryOperation.LOG10, options, providers, this.registerStubCall(UnaryMathIntrinsicNode.UnaryOperation.LOG10.foreignCallDescriptor, HotSpotForeignCallLinkage.Transition.LEAF, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, HotSpotForeignCallLinkage.RegisterEffect.COMPUTES_REGISTERS_KILLED, NO_LOCATIONS)));
            AMD64HotSpotForeignCallsProvider.link(new AMD64MathStub(BinaryMathIntrinsicNode.BinaryOperation.POW, options, providers, this.registerStubCall(BinaryMathIntrinsicNode.BinaryOperation.POW.foreignCallDescriptor, HotSpotForeignCallLinkage.Transition.LEAF, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, HotSpotForeignCallLinkage.RegisterEffect.COMPUTES_REGISTERS_KILLED, NO_LOCATIONS)));
        } else {
            super.registerMathStubs(hotSpotVMConfig, providers, options);
        }
    }
}

