/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.aarch64;

import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.code.site.InfopointReason;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.aarch64.AArch64Address;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.aarch64.AArch64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

@Opcode(value="SAFEPOINT")
public class AArch64HotSpotSafepointOp
extends AArch64LIRInstruction {
    public static final LIRInstructionClass<AArch64HotSpotSafepointOp> TYPE = LIRInstructionClass.create(AArch64HotSpotSafepointOp.class);
    @LIRInstruction.State
    protected LIRFrameState state;
    @LIRInstruction.Temp
    protected AllocatableValue scratchValue;
    private final GraalHotSpotVMConfig config;
    private final Register thread;

    public AArch64HotSpotSafepointOp(LIRFrameState state, GraalHotSpotVMConfig config, Register thread, AllocatableValue scratch) {
        super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
        this.state = state;
        this.config = config;
        this.thread = thread;
        this.scratchValue = scratch;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        Register scratch = ValueUtil.asRegister((Value)this.scratchValue);
        AArch64HotSpotSafepointOp.emitCode(crb, masm, this.config, false, this.thread, scratch, this.state);
    }

    private static boolean isPollingPageFar(GraalHotSpotVMConfig config) {
        long pollingPageAddress = config.safepointPollingAddress;
        return !NumUtil.isSignedNbit(21, pollingPageAddress - config.codeCacheLowBound) || !NumUtil.isSignedNbit(21, pollingPageAddress - config.codeCacheHighBound);
    }

    public static void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm, GraalHotSpotVMConfig config, boolean onReturn, Register thread, Register scratch, LIRFrameState state) {
        if (config.threadLocalHandshakes) {
            AArch64HotSpotSafepointOp.emitThreadLocalPoll(crb, masm, config, onReturn, thread, scratch, state);
        } else {
            AArch64HotSpotSafepointOp.emitGlobalPoll(crb, masm, config, onReturn, scratch, state);
        }
    }

    private static void emitGlobalPoll(CompilationResultBuilder crb, AArch64MacroAssembler masm, GraalHotSpotVMConfig config, boolean onReturn, Register scratch, LIRFrameState state) {
        if (AArch64HotSpotSafepointOp.isPollingPageFar(config)) {
            crb.recordMark(onReturn ? config.MARKID_POLL_RETURN_FAR : config.MARKID_POLL_FAR);
            masm.movNativeAddress(scratch, config.safepointPollingAddress);
            crb.recordMark(onReturn ? config.MARKID_POLL_RETURN_FAR : config.MARKID_POLL_FAR);
            if (state != null) {
                crb.recordInfopoint(masm.position(), state, InfopointReason.SAFEPOINT);
            }
            masm.ldr(32, AArch64.zr, AArch64Address.createBaseRegisterOnlyAddress(scratch));
        } else {
            crb.recordMark(onReturn ? config.MARKID_POLL_RETURN_NEAR : config.MARKID_POLL_NEAR);
            if (state != null) {
                crb.recordInfopoint(masm.position(), state, InfopointReason.SAFEPOINT);
            }
            masm.ldr(32, AArch64.zr, AArch64Address.createPcLiteralAddress(0));
        }
    }

    private static void emitThreadLocalPoll(CompilationResultBuilder crb, AArch64MacroAssembler masm, GraalHotSpotVMConfig config, boolean onReturn, Register thread, Register scratch, LIRFrameState state) {
        assert (config.threadPollingPageOffset >= 0);
        masm.ldr(64, scratch, masm.makeAddress(thread, config.threadPollingPageOffset, 8));
        crb.recordMark(onReturn ? config.MARKID_POLL_RETURN_FAR : config.MARKID_POLL_FAR);
        if (state != null) {
            crb.recordInfopoint(masm.position(), state, InfopointReason.SAFEPOINT);
        }
        masm.ldr(32, AArch64.zr, AArch64Address.createBaseRegisterOnlyAddress(scratch));
    }
}

