/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaField;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethod;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaType;
import jdk.vm.ci.hotspot.HotSpotSignature;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MemoryAccessProvider;
import jdk.vm.ci.meta.MethodHandleAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.UnresolvedJavaField;
import jdk.vm.ci.meta.UnresolvedJavaMethod;
import jdk.vm.ci.meta.UnresolvedJavaType;
import jdk.vm.ci.runtime.JVMCI;
import jdk.vm.ci.services.Services;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.api.replacements.MethodSubstitution;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.api.runtime.GraalJVMCICompiler;
import org.graalvm.compiler.api.runtime.GraalRuntime;
import org.graalvm.compiler.bytecode.BytecodeProvider;
import org.graalvm.compiler.bytecode.ResolvedJavaMethodBytecode;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.type.AbstractObjectStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.core.common.type.SymbolicJVMCIReference;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.NodeMap;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotReplacementsImpl;
import org.graalvm.compiler.hotspot.meta.HotSpotForeignCallsProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.java.BytecodeParser;
import org.graalvm.compiler.java.GraphBuilderPhase;
import org.graalvm.compiler.nodeinfo.Verbosity;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.Cancellable;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.EncodedGraph;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.FullInfopointNode;
import org.graalvm.compiler.nodes.GraphEncoder;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.ProxyNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.cfg.Block;
import org.graalvm.compiler.nodes.graphbuilderconf.GeneratedInvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.IntrinsicContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.nodes.graphbuilderconf.MethodSubstitutionPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.NodePlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.ParameterPlugin;
import org.graalvm.compiler.nodes.java.AccessFieldNode;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.OptimisticOptimizations;
import org.graalvm.compiler.phases.schedule.SchedulePhase;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.PEGraphDecoder;
import org.graalvm.compiler.replacements.ReplacementsImpl;
import org.graalvm.compiler.replacements.SnippetCounter;
import org.graalvm.compiler.replacements.SnippetIntegerHistogram;

public class SymbolicSnippetEncoder {
    private final HotSpotSnippetReplacementsImpl snippetReplacements;
    private final Set<ResolvedJavaMethod> snippetMethods = Collections.synchronizedSet(new HashSet());
    private final Map<String, String> originalMethods = new ConcurrentHashMap<String, String>();
    private final HotSpotReplacementsImpl originalReplacements;
    private int encodedGraphs = 0;
    private Map<String, StructuredGraph> preparedSnippetGraphs = new HashMap<String, StructuredGraph>();
    private Set<MethodSubstitutionPlugin> knownPlugins = new HashSet<MethodSubstitutionPlugin>();
    private Set<InvocationPlugin> conditionalPlugins = new HashSet<InvocationPlugin>();
    private int preparedPlugins = 0;
    private Set<ResolvedJavaMethod> delayedInvocationPluginMethods = new HashSet<ResolvedJavaMethod>();

    void addDelayedInvocationPluginMethod(ResolvedJavaMethod method) {
        this.delayedInvocationPluginMethods.add(method);
    }

    Set<ResolvedJavaMethod> getSnippetMethods() {
        return this.snippetMethods;
    }

    private static String methodKey(ResolvedJavaMethod method) {
        return method.format("%H.%n(%P)");
    }

    SymbolicSnippetEncoder(HotSpotReplacementsImpl replacements) {
        this.originalReplacements = replacements;
        GraphBuilderConfiguration.Plugins plugins = replacements.getGraphBuilderPlugins();
        SnippetInvocationPlugins invocationPlugins = new SnippetInvocationPlugins(plugins.getInvocationPlugins());
        GraphBuilderConfiguration.Plugins copy = new GraphBuilderConfiguration.Plugins(plugins, invocationPlugins);
        copy.clearInlineInvokePlugins();
        copy.appendInlineInvokePlugin(new SnippetInlineInvokePlugin());
        copy.appendNodePlugin(new SnippetCounterPlugin());
        HotSpotProviders providers = (HotSpotProviders)replacements.getProviders().copyWith(new HotSpotSubstrateConstantReflectionProvider(replacements.getProviders().getConstantReflection()));
        this.snippetReplacements = new HotSpotSnippetReplacementsImpl(replacements, providers.copyWith(copy));
        this.snippetReplacements.setGraphBuilderPlugins(copy);
    }

    synchronized void registerMethodSubstitution(MethodSubstitutionPlugin plugin) {
        this.knownPlugins.add(plugin);
    }

    void registerConditionalPlugin(InvocationPlugin plugin) {
        this.conditionalPlugins.add(plugin);
    }

    synchronized void checkRegistered(MethodSubstitutionPlugin plugin) {
        if (!this.knownPlugins.contains(plugin)) {
            throw new GraalError("missing plugin should have been registered during construction");
        }
    }

    private synchronized void registerMethodSubstitution(MethodSubstitutionPlugin plugin, ResolvedJavaMethod original, IntrinsicContext.CompilationContext context, OptionValues options) {
        ResolvedJavaMethod method = plugin.getSubstitute(this.snippetReplacements.getProviders().getMetaAccess());
        assert (method.getAnnotation(MethodSubstitution.class) != null) : "MethodSubstitution must be annotated with @" + MethodSubstitution.class.getSimpleName();
        String originalMethodString = plugin.originalMethodAsString();
        StructuredGraph subst = this.buildGraph(method, original, originalMethodString, null, true, false, context, options);
        this.snippetMethods.add(method);
        this.originalMethods.put(SymbolicSnippetEncoder.methodKey(method), originalMethodString);
        this.preparedSnippetGraphs.put(plugin.toString() + (Object)((Object)context), subst);
    }

    private StructuredGraph buildGraph(ResolvedJavaMethod method, ResolvedJavaMethod original, String originalMethodString, Object receiver, boolean requireInlining, boolean trackNodeSourcePosition, IntrinsicContext.CompilationContext context, OptionValues options) {
        assert (method.hasBytecodes()) : "Snippet must not be abstract or native";
        Object[] args = null;
        if (receiver != null) {
            args = new Object[method.getSignature().getParameterCount(true)];
            args[0] = receiver;
        }
        try (DebugContext debug = this.openDebugContext("SymbolicSnippetEncoder_", method, options);){
            StructuredGraph graph = this.snippetReplacements.makeGraph(debug, this.snippetReplacements.getDefaultReplacementBytecodeProvider(), method, args, original, trackNodeSourcePosition, null, context);
            for (MethodCallTargetNode callTarget : graph.getNodes(MethodCallTargetNode.TYPE)) {
                ResolvedJavaMethod callee = callTarget.targetMethod();
                if (!requireInlining || this.delayedInvocationPluginMethods.contains(callee) || Objects.equals(callee, original)) continue;
                throw GraalError.shouldNotReachHere("method " + callee.format("%H.%n") + " not inlined in snippet " + method.getName() + " (maybe not final?)");
            }
            assert (this.verifySnippetEncodeDecode(debug, method, original, originalMethodString, trackNodeSourcePosition, graph));
            debug.dump(3, graph, "After buildGraph");
            StructuredGraph structuredGraph = graph;
            return structuredGraph;
        }
    }

    /*
     * Exception decompiling
     */
    private static StructuredGraph decodeSnippetGraph(SymbolicEncodedGraph encodedGraph, ResolvedJavaMethod method, ReplacementsImpl replacements, Object[] args, StructuredGraph.AllowAssumptions allowAssumptions, OptionValues options) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean verifySnippetEncodeDecode(DebugContext debug, ResolvedJavaMethod method, ResolvedJavaMethod original, String originalMethodString, boolean trackNodeSourcePosition, StructuredGraph graph) {
        EncodedGraph encodedGraph = GraphEncoder.encodeSingleGraph(graph, HotSpotJVMCIRuntime.runtime().getHostJVMCIBackend().getTarget().arch);
        HotSpotProviders originalProvider = (HotSpotProviders)this.snippetReplacements.getProviders();
        SnippetReflectionProvider snippetReflection = originalProvider.getSnippetReflection();
        HotSpotSubstrateConstantReflectionProvider constantReflection = new HotSpotSubstrateConstantReflectionProvider(originalProvider.getConstantReflection());
        HotSpotProviders newProviders = new HotSpotProviders(originalProvider.getMetaAccess(), originalProvider.getCodeCache(), constantReflection, originalProvider.getConstantFieldProvider(), originalProvider.getForeignCalls(), originalProvider.getLowerer(), null, originalProvider.getSuites(), originalProvider.getRegisters(), snippetReflection, originalProvider.getWordTypes(), originalProvider.getGraphBuilderPlugins(), originalProvider.getGC());
        HotSpotSnippetReplacementsImpl filteringReplacements = new HotSpotSnippetReplacementsImpl((Providers)newProviders, snippetReflection, originalProvider.getReplacements().getDefaultReplacementBytecodeProvider(), originalProvider.getCodeCache().getTarget());
        filteringReplacements.setGraphBuilderPlugins(originalProvider.getReplacements().getGraphBuilderPlugins());
        try (DebugContext.Scope scaope = debug.scope((Object)"VerifySnippetEncodeDecode", graph);){
            String decodedSnippetString;
            for (int i = 0; i < encodedGraph.getNumObjects(); ++i) {
                SymbolicSnippetEncoder.filterSnippetObject(encodedGraph.getObject(i));
            }
            StructuredGraph snippet = filteringReplacements.makeGraph(debug, filteringReplacements.getDefaultReplacementBytecodeProvider(), method, null, original, trackNodeSourcePosition, null);
            SymbolicEncodedGraph symbolicGraph = new SymbolicEncodedGraph(encodedGraph, method.getDeclaringClass(), originalMethodString);
            StructuredGraph decodedSnippet = SymbolicSnippetEncoder.decodeSnippetGraph(symbolicGraph, original != null ? original : method, this.originalReplacements, null, StructuredGraph.AllowAssumptions.ifNonNull(graph.getAssumptions()), graph.getOptions());
            String snippetString = SymbolicSnippetEncoder.getCanonicalGraphString(snippet, true, false);
            if (snippetString.equals(decodedSnippetString = SymbolicSnippetEncoder.getCanonicalGraphString(decodedSnippet, true, false))) {
                debug.log("Snippet decode for %s produces exactly same graph", method);
                debug.dump(3, (Object)decodedSnippet, "Decoded snippet graph for %s", method);
            } else {
                debug.log("Snippet decode for %s produces different graph", method);
                debug.log("%s", (Object)SymbolicSnippetEncoder.compareGraphStrings(snippet, snippetString, decodedSnippet, decodedSnippetString));
                debug.dump(3, (Object)snippet, "Snippet graph for %s", method);
                debug.dump(3, (Object)graph, "Encoded snippet graph for %s", method);
                debug.dump(3, (Object)decodedSnippet, "Decoded snippet graph for %s", method);
            }
        }
        catch (Throwable t) {
            throw debug.handle(t);
        }
        return true;
    }

    private synchronized EncodedSnippets maybeEncodeSnippets(OptionValues options) {
        Map<String, StructuredGraph> graphs;
        Set<MethodSubstitutionPlugin> plugins = this.knownPlugins;
        if (this.preparedPlugins != plugins.size()) {
            for (MethodSubstitutionPlugin plugin : plugins) {
                ResolvedJavaMethod original = plugin.getOriginalMethod(this.originalReplacements.getProviders().getMetaAccess());
                this.registerMethodSubstitution(plugin, original, IntrinsicContext.CompilationContext.INLINE_AFTER_PARSING, options);
                if (original.isNative()) continue;
                this.registerMethodSubstitution(plugin, original, IntrinsicContext.CompilationContext.ROOT_COMPILATION, options);
            }
            this.preparedPlugins = plugins.size();
        }
        if (this.encodedGraphs != (graphs = this.preparedSnippetGraphs).size()) {
            DebugContext debug = this.openDebugContext("SnippetEncoder", null, options);
            try (DebugContext.Scope scope = debug.scope("SnippetSupportEncode");){
                this.encodedGraphs = graphs.size();
                for (StructuredGraph graph : graphs.values()) {
                    for (Node node : graph.getNodes()) {
                        node.setNodeSourcePosition(null);
                    }
                }
                EncodedSnippets encodedSnippets = this.encodeSnippets(debug);
                return encodedSnippets;
            }
        }
        return null;
    }

    synchronized void registerSnippet(ResolvedJavaMethod method, ResolvedJavaMethod original, Object receiver, boolean trackNodeSourcePosition, OptionValues options) {
        if (Services.IS_BUILDING_NATIVE_IMAGE || GraalOptions.UseEncodedGraphs.getValue(options).booleanValue()) {
            assert (method.getAnnotation(Snippet.class) != null) : "Snippet must be annotated with @" + Snippet.class.getSimpleName();
            String key = SymbolicSnippetEncoder.methodKey(method);
            if (!this.preparedSnippetGraphs.containsKey(key)) {
                if (original != null) {
                    this.originalMethods.put(key, SymbolicSnippetEncoder.methodKey(original));
                }
                StructuredGraph snippet = this.buildGraph(method, original, null, receiver, true, trackNodeSourcePosition, IntrinsicContext.CompilationContext.INLINE_AFTER_PARSING, options);
                this.snippetMethods.add(method);
                this.preparedSnippetGraphs.put(key, snippet);
            }
        }
    }

    private synchronized EncodedSnippets encodeSnippets(DebugContext debug) {
        GraphEncoder encoder = new GraphEncoder(HotSpotJVMCIRuntime.runtime().getHostJVMCIBackend().getTarget().arch, debug);
        for (StructuredGraph graph : this.preparedSnippetGraphs.values()) {
            encoder.prepare(graph);
        }
        encoder.finishPrepare();
        HashMap<String, Integer> snippetStartOffsets = new HashMap<String, Integer>();
        for (Map.Entry<String, StructuredGraph> entry : this.preparedSnippetGraphs.entrySet()) {
            snippetStartOffsets.put(entry.getKey(), encoder.encode(entry.getValue()));
        }
        byte[] snippetEncoding = encoder.getEncoding();
        Object[] snippetObjects = encoder.getObjects();
        NodeClass<?>[] snippetNodeClasses = encoder.getNodeClasses();
        for (int i = 0; i < snippetObjects.length; ++i) {
            Object o = SymbolicSnippetEncoder.filterSnippetObject(snippetObjects[i]);
            debug.log("snippetObjects[%d] = %s -> %s", (Object)i, (Object)(o != null ? o.getClass().getSimpleName() : null), o);
            snippetObjects[i] = o;
        }
        debug.log("Encoded %d snippet preparedSnippetGraphs using %d bytes with %d objects", snippetStartOffsets.size(), snippetEncoding.length, snippetObjects.length);
        return new EncodedSnippets(snippetEncoding, snippetObjects, snippetNodeClasses, snippetStartOffsets, this.originalMethods);
    }

    public boolean encode(OptionValues options) {
        EncodedSnippets encodedSnippets = this.maybeEncodeSnippets(options);
        if (encodedSnippets != null) {
            HotSpotReplacementsImpl.setEncodedSnippets(encodedSnippets);
            return true;
        }
        return false;
    }

    private DebugContext openDebugContext(String idPrefix, ResolvedJavaMethod method, OptionValues options) {
        return this.snippetReplacements.openDebugContext(idPrefix, method, options);
    }

    private static Object maybeMakeSymbolic(Stamp trustedStamp) {
        SymbolicJVMCIReference<? extends Stamp> symbolicJVMCIReference;
        if (trustedStamp != null && (symbolicJVMCIReference = trustedStamp.makeSymbolic()) != null) {
            return symbolicJVMCIReference;
        }
        return trustedStamp;
    }

    private static Stamp resolveStamp(ResolvedJavaType accessingClass, Object stamp) {
        if (stamp == null) {
            return null;
        }
        if (stamp instanceof Stamp) {
            return (Stamp)stamp;
        }
        return (Stamp)((SymbolicJVMCIReference)stamp).resolve(accessingClass);
    }

    private static Object filterSnippetObject(Object o) {
        if (o instanceof HotSpotResolvedJavaMethod) {
            return new SymbolicResolvedJavaMethod((ResolvedJavaMethod)((HotSpotResolvedJavaMethod)o));
        }
        if (o instanceof HotSpotResolvedJavaField) {
            return new SymbolicResolvedJavaField((ResolvedJavaField)((HotSpotResolvedJavaField)o));
        }
        if (o instanceof HotSpotResolvedJavaType) {
            return UnresolvedJavaType.create((String)((ResolvedJavaType)o).getName());
        }
        if (o instanceof NodeSourcePosition) {
            return null;
        }
        if (o instanceof HotSpotForeignCallsProvider || o instanceof GraalHotSpotVMConfig) {
            return new GraalCapability(o.getClass());
        }
        if (o instanceof Stamp) {
            SymbolicJVMCIReference<? extends Stamp> ref = ((Stamp)o).makeSymbolic();
            if (ref != null) {
                return ref;
            }
            return o;
        }
        if (o instanceof StampPair) {
            if (((StampPair)o).getTrustedStamp() instanceof AbstractObjectStamp) {
                return new SymbolicStampPair((StampPair)o);
            }
        } else {
            if (o instanceof ResolvedJavaMethodBytecode) {
                return new SymbolicResolvedJavaMethodBytecode((ResolvedJavaMethodBytecode)o);
            }
            if (o instanceof HotSpotSignature) {
                throw new GraalError(o.toString());
            }
        }
        return o;
    }

    private static String compareGraphStrings(StructuredGraph expectedGraph, String expectedString, StructuredGraph actualGraph, String actualString) {
        if (!expectedString.equals(actualString)) {
            CharSequence[] expectedLines = expectedString.split("\n");
            CharSequence[] actualLines = actualString.split("\n");
            int diffIndex = -1;
            int limit = Math.min(actualLines.length, expectedLines.length);
            String marker = " <<<";
            for (int i = 0; i < limit; ++i) {
                if (expectedLines[i].equals(actualLines[i])) continue;
                diffIndex = i;
                break;
            }
            if (diffIndex == -1) {
                diffIndex = limit;
                if (actualLines.length == limit) {
                    actualLines = Arrays.copyOf(actualLines, limit + 1);
                    actualLines[diffIndex] = "";
                } else {
                    assert (expectedLines.length == limit);
                    expectedLines = Arrays.copyOf(expectedLines, limit + 1);
                    expectedLines[diffIndex] = "";
                }
            }
            expectedLines[diffIndex] = expectedLines[diffIndex] + marker;
            actualLines[diffIndex] = actualLines[diffIndex] + marker;
            String ediff = String.join((CharSequence)"\n", expectedLines);
            String adiff = String.join((CharSequence)"\n", actualLines);
            return "mismatch in preparedSnippetGraphs:\n========= expected (" + expectedGraph + ") =========\n" + ediff + "\n\n========= actual (" + actualGraph + ") =========\n" + adiff;
        }
        return "mismatch in preparedSnippetGraphs";
    }

    private static String getCanonicalGraphString(StructuredGraph graph, boolean excludeVirtual, boolean checkConstants) {
        SchedulePhase schedule = new SchedulePhase(SchedulePhase.SchedulingStrategy.EARLIEST);
        schedule.apply(graph);
        StructuredGraph.ScheduleResult scheduleResult = graph.getLastSchedule();
        NodeMap<Integer> canonicalId = graph.createNodeMap();
        int nextId = 0;
        ArrayList<String> constantsLines = new ArrayList<String>();
        StringBuilder result = new StringBuilder();
        for (Block block : scheduleResult.getCFG().getBlocks()) {
            result.append("Block ").append(block).append(' ');
            if (block == scheduleResult.getCFG().getStartBlock()) {
                result.append("* ");
            }
            result.append("-> ");
            for (Block succ : (Block[])block.getSuccessors()) {
                result.append(succ).append(' ');
            }
            result.append('\n');
            for (Node node : scheduleResult.getBlockToNodesMap().get(block)) {
                int id;
                if (!(node instanceof ValueNode) || !node.isAlive() || excludeVirtual && (node instanceof VirtualObjectNode || node instanceof ProxyNode || node instanceof FullInfopointNode || node instanceof ParameterNode)) continue;
                if (node instanceof ConstantNode) {
                    if (!checkConstants) continue;
                    String name = node.toString(Verbosity.Name);
                    if (excludeVirtual) {
                        constantsLines.add(name);
                        continue;
                    }
                    constantsLines.add(name + "    (" + SymbolicSnippetEncoder.filteredUsageCount(node) + ")");
                    continue;
                }
                if (canonicalId.get(node) != null) {
                    id = (Integer)canonicalId.get(node);
                } else {
                    id = nextId++;
                    canonicalId.set(node, id);
                }
                String name = node.getClass().getSimpleName();
                result.append("  ").append(id).append('|').append(name);
                if (node instanceof AccessFieldNode) {
                    result.append('#');
                    result.append(((AccessFieldNode)node).field());
                }
                if (!excludeVirtual) {
                    result.append("    (");
                    result.append(SymbolicSnippetEncoder.filteredUsageCount(node));
                    result.append(')');
                }
                result.append('\n');
            }
        }
        StringBuilder constantsLinesResult = new StringBuilder();
        if (checkConstants) {
            constantsLinesResult.append(constantsLines.size()).append(" constants:\n");
        }
        Collections.sort(constantsLines);
        for (String s : constantsLines) {
            constantsLinesResult.append(s);
            constantsLinesResult.append('\n');
        }
        return constantsLinesResult.toString() + result.toString();
    }

    private static int filteredUsageCount(Node node) {
        return node.usages().filter(n -> !(n instanceof FrameState)).count();
    }

    class HotSpotSnippetBytecodeParser
    extends BytecodeParser {
        HotSpotSnippetBytecodeParser(GraphBuilderPhase.Instance graphBuilderInstance, StructuredGraph graph, BytecodeParser parent, ResolvedJavaMethod method, int entryBCI, IntrinsicContext intrinsicContext) {
            super(graphBuilderInstance, graph, parent, method, entryBCI, intrinsicContext);
        }

        @Override
        public boolean canDeferPlugin(GeneratedInvocationPlugin plugin) {
            return plugin.isGeneratedFromFoldOrNodeIntrinsic();
        }

        @Override
        protected boolean canInlinePartialIntrinsicExit() {
            return false;
        }

        @Override
        protected boolean tryInvocationPlugin(CallTargetNode.InvokeKind invokeKind, ValueNode[] args, ResolvedJavaMethod targetMethod, JavaKind resultType) {
            if (this.intrinsicContext != null && this.intrinsicContext.isCallToOriginal(targetMethod)) {
                return false;
            }
            if (targetMethod.getAnnotation(Fold.class) != null) {
                return false;
            }
            InvocationPlugin plugin = this.graphBuilderConfig.getPlugins().getInvocationPlugins().lookupInvocation(targetMethod);
            if (SymbolicSnippetEncoder.this.conditionalPlugins.contains(plugin)) {
                throw new GraalError("conditional plugins are unsupported in snippets and method substitutions: " + targetMethod + " " + plugin);
            }
            return super.tryInvocationPlugin(invokeKind, args, targetMethod, resultType);
        }
    }

    class HotSpotSnippetGraphBuilderPhase
    extends GraphBuilderPhase.Instance {
        HotSpotSnippetGraphBuilderPhase(Providers theProviders, GraphBuilderConfiguration graphBuilderConfig, OptimisticOptimizations optimisticOpts, IntrinsicContext initialIntrinsicContext) {
            super(theProviders, graphBuilderConfig, optimisticOpts, initialIntrinsicContext);
        }

        @Override
        protected BytecodeParser createBytecodeParser(StructuredGraph graph, BytecodeParser parent, ResolvedJavaMethod method, int entryBCI, IntrinsicContext intrinsicContext) {
            return new HotSpotSnippetBytecodeParser(this, graph, parent, method, entryBCI, intrinsicContext);
        }
    }

    class SnippetGraphMaker
    extends ReplacementsImpl.GraphMaker {
        SnippetGraphMaker(ReplacementsImpl replacements, ResolvedJavaMethod substitute, ResolvedJavaMethod substitutedMethod) {
            super(replacements, substitute, substitutedMethod);
        }

        @Override
        protected GraphBuilderPhase.Instance createGraphBuilder(Providers providers, GraphBuilderConfiguration graphBuilderConfig, OptimisticOptimizations optimisticOpts, IntrinsicContext initialIntrinsicContext) {
            return new HotSpotSnippetGraphBuilderPhase(providers, graphBuilderConfig, optimisticOpts, initialIntrinsicContext);
        }
    }

    class HotSpotSnippetReplacementsImpl
    extends HotSpotReplacementsImpl {
        HotSpotSnippetReplacementsImpl(HotSpotReplacementsImpl replacements, Providers providers) {
            super(replacements, providers);
        }

        HotSpotSnippetReplacementsImpl(Providers providers, SnippetReflectionProvider snippetReflection, BytecodeProvider bytecodeProvider, TargetDescription target) {
            super(providers, snippetReflection, bytecodeProvider, target);
        }

        @Override
        protected ReplacementsImpl.GraphMaker createGraphMaker(ResolvedJavaMethod substitute, ResolvedJavaMethod original) {
            return new SnippetGraphMaker(this, substitute, original);
        }
    }

    public static class HotSpotSubstrateConstantReflectionProvider
    implements ConstantReflectionProvider {
        private final ConstantReflectionProvider constantReflection;
        HashSet<JavaConstant> safeConstants = new HashSet();

        HotSpotSubstrateConstantReflectionProvider(ConstantReflectionProvider constantReflection) {
            this.constantReflection = constantReflection;
        }

        public Boolean constantEquals(Constant x, Constant y) {
            return this.constantReflection.constantEquals(x, y);
        }

        public Integer readArrayLength(JavaConstant array) {
            return this.constantReflection.readArrayLength(array);
        }

        public JavaConstant readArrayElement(JavaConstant array, int index) {
            return this.constantReflection.readArrayElement(array, index);
        }

        public JavaConstant readFieldValue(ResolvedJavaField field, JavaConstant receiver) {
            JavaConstant javaConstant = this.constantReflection.readFieldValue(field, receiver);
            if (!(this.safeConstants.contains(receiver) || field.getDeclaringClass().getName().contains("graalvm") || field.getDeclaringClass().getName().contains("jdk/vm/ci/") || field.getDeclaringClass().getName().contains("jdk/internal/vm/compiler") || field.getName().equals("TYPE"))) {
                return null;
            }
            if (javaConstant.getJavaKind() == JavaKind.Object) {
                this.safeConstants.add(javaConstant);
            }
            return javaConstant;
        }

        public JavaConstant boxPrimitive(JavaConstant source) {
            return this.constantReflection.boxPrimitive(source);
        }

        public JavaConstant unboxPrimitive(JavaConstant source) {
            return this.constantReflection.unboxPrimitive(source);
        }

        public JavaConstant forString(String value) {
            return this.constantReflection.forString(value);
        }

        public ResolvedJavaType asJavaType(Constant constant) {
            return this.constantReflection.asJavaType(constant);
        }

        public MethodHandleAccessProvider getMethodHandleAccess() {
            return this.constantReflection.getMethodHandleAccess();
        }

        public MemoryAccessProvider getMemoryAccessProvider() {
            return this.constantReflection.getMemoryAccessProvider();
        }

        public JavaConstant asJavaClass(ResolvedJavaType type) {
            return this.constantReflection.asJavaClass(type);
        }

        public Constant asObjectHub(ResolvedJavaType type) {
            return this.constantReflection.asObjectHub(type);
        }
    }

    static class SymbolicStampPair
    implements SymbolicJVMCIReference<StampPair> {
        Object trustedStamp;
        Object uncheckdStamp;

        SymbolicStampPair(StampPair stamp) {
            this.trustedStamp = SymbolicSnippetEncoder.maybeMakeSymbolic(stamp.getTrustedStamp());
            this.uncheckdStamp = SymbolicSnippetEncoder.maybeMakeSymbolic(stamp.getUncheckedStamp());
        }

        @Override
        public StampPair resolve(ResolvedJavaType accessingClass) {
            return StampPair.create(SymbolicSnippetEncoder.resolveStamp(accessingClass, this.trustedStamp), SymbolicSnippetEncoder.resolveStamp(accessingClass, this.uncheckdStamp));
        }
    }

    static class SymbolicResolvedJavaMethodBytecode
    implements SymbolicJVMCIReference<ResolvedJavaMethodBytecode> {
        SymbolicResolvedJavaMethod method;

        SymbolicResolvedJavaMethodBytecode(ResolvedJavaMethodBytecode bytecode) {
            this.method = new SymbolicResolvedJavaMethod(bytecode.getMethod());
        }

        @Override
        public ResolvedJavaMethodBytecode resolve(ResolvedJavaType accessingClass) {
            return new ResolvedJavaMethodBytecode(this.method.resolve(accessingClass));
        }
    }

    static class SymbolicResolvedJavaField
    implements SymbolicJVMCIReference<ResolvedJavaField> {
        final UnresolvedJavaType declaringType;
        final String name;
        final UnresolvedJavaType signature;
        private final boolean isStatic;

        SymbolicResolvedJavaField(ResolvedJavaField field) {
            this.declaringType = UnresolvedJavaType.create((String)field.getDeclaringClass().getName());
            this.name = field.getName();
            this.signature = UnresolvedJavaType.create((String)field.getType().getName());
            this.isStatic = field.isStatic();
        }

        @Override
        public ResolvedJavaField resolve(ResolvedJavaType accessingClass) {
            ResolvedJavaField[] fields;
            ResolvedJavaType resolvedType = this.declaringType.resolve(accessingClass);
            ResolvedJavaType resolvedFieldType = this.signature.resolve(accessingClass);
            for (ResolvedJavaField field : fields = this.isStatic ? resolvedType.getStaticFields() : resolvedType.getInstanceFields(true)) {
                if (!field.getName().equals(this.name) || !field.getType().equals(resolvedFieldType)) continue;
                return field;
            }
            throw new InternalError("Could not resolve " + this + " in context of " + accessingClass.toJavaName());
        }

        public String toString() {
            return "SymbolicResolvedJavaField{" + this.signature.getName() + ' ' + this.declaringType.getName() + '.' + this.name + '}';
        }
    }

    static class SymbolicResolvedJavaMethod
    implements SymbolicJVMCIReference<ResolvedJavaMethod> {
        final UnresolvedJavaType type;
        final String methodName;
        final String signature;

        SymbolicResolvedJavaMethod(ResolvedJavaMethod method) {
            this.type = UnresolvedJavaType.create((String)method.getDeclaringClass().getName());
            this.methodName = method.getName();
            this.signature = method.getSignature().toMethodDescriptor();
        }

        public String toString() {
            return "SymbolicResolvedJavaMethod{declaringType='" + this.type.getName() + '\'' + ", methodName='" + this.methodName + '\'' + ", signature='" + this.signature + '\'' + '}';
        }

        @Override
        public ResolvedJavaMethod resolve(ResolvedJavaType accessingClass) {
            ResolvedJavaType resolvedType = this.type.resolve(accessingClass);
            if (resolvedType == null) {
                throw new InternalError("Could not resolve " + this + " in context of " + accessingClass.toJavaName());
            }
            for (ResolvedJavaMethod method : this.methodName.equals("<init>") ? resolvedType.getDeclaredConstructors() : resolvedType.getDeclaredMethods()) {
                if (!method.getName().equals(this.methodName) || !method.getSignature().toMethodDescriptor().equals(this.signature)) continue;
                return method;
            }
            throw new InternalError("Could not resolve " + this + " in context of " + accessingClass.toJavaName());
        }
    }

    static class GraalCapability {
        final Class<?> capabilityClass;

        GraalCapability(Class<?> capabilityClass) {
            this.capabilityClass = capabilityClass;
        }

        public Object resolve(GraalRuntime runtime) {
            Object capability = runtime.getCapability(this.capabilityClass);
            if (capability != null) {
                assert (capability.getClass() == this.capabilityClass);
                return capability;
            }
            throw new InternalError(this.capabilityClass.getName());
        }
    }

    static class SymbolicEncodedGraph
    extends EncodedGraph {
        private final ResolvedJavaType[] accessingClasses;
        private final String originalMethod;

        SymbolicEncodedGraph(byte[] encoding, int startOffset, Object[] objects, NodeClass<?>[] types, String originalMethod, ResolvedJavaType ... accessingClasses) {
            super(encoding, startOffset, objects, types, null, null, null, false, false);
            this.accessingClasses = accessingClasses;
            this.originalMethod = originalMethod;
        }

        SymbolicEncodedGraph(EncodedGraph encodedGraph, ResolvedJavaType declaringClass, String originalMethod) {
            this(encodedGraph.getEncoding(), encodedGraph.getStartOffset(), encodedGraph.getObjects(), encodedGraph.getNodeClasses(), originalMethod, declaringClass);
        }

        @Override
        public Object getObject(int i) {
            Object o = this.objects[i];
            Object replacement = null;
            if (o instanceof SymbolicJVMCIReference) {
                for (ResolvedJavaType type : this.accessingClasses) {
                    try {
                        replacement = ((SymbolicJVMCIReference)o).resolve(type);
                        break;
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {
                    }
                }
            } else if (o instanceof UnresolvedJavaType) {
                for (ResolvedJavaType type : this.accessingClasses) {
                    try {
                        replacement = ((UnresolvedJavaType)o).resolve(type);
                        break;
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {
                    }
                }
            } else {
                if (o instanceof UnresolvedJavaMethod) {
                    throw new InternalError(o.toString());
                }
                if (o instanceof UnresolvedJavaField) {
                    for (ResolvedJavaType type : this.accessingClasses) {
                        try {
                            replacement = ((UnresolvedJavaField)o).resolve(type);
                            break;
                        }
                        catch (NoClassDefFoundError noClassDefFoundError) {
                        }
                    }
                } else if (o instanceof GraalCapability) {
                    replacement = ((GraalCapability)o).resolve(((GraalJVMCICompiler)JVMCI.getRuntime().getCompiler()).getGraalRuntime());
                } else {
                    return o;
                }
            }
            if (replacement == null) {
                throw new GraalError("Can't resolve " + o);
            }
            this.objects[i] = o = replacement;
            return o;
        }

        @Override
        public boolean isCallToOriginal(ResolvedJavaMethod callTarget) {
            if (this.originalMethod != null && this.originalMethod.equals(SymbolicSnippetEncoder.methodKey(callTarget))) {
                return true;
            }
            return super.isCallToOriginal(callTarget);
        }
    }

    private static class SubstitutionGraphDecoder
    extends PEGraphDecoder {
        private final ResolvedJavaMethod method;
        private final EncodedGraph encodedGraph;
        private IntrinsicContext intrinsic;

        SubstitutionGraphDecoder(Providers providers, StructuredGraph result, ReplacementsImpl replacements, ParameterPlugin parameterPlugin, ResolvedJavaMethod method, IntrinsicContext.CompilationContext context, EncodedGraph encodedGraph) {
            super(providers.getCodeCache().getTarget().arch, result, providers, null, replacements.getGraphBuilderPlugins().getInvocationPlugins(), new InlineInvokePlugin[0], parameterPlugin, null, null, null, null);
            this.method = method;
            this.encodedGraph = encodedGraph;
            this.intrinsic = new IntrinsicContext(method, null, replacements.getDefaultReplacementBytecodeProvider(), context, false);
        }

        @Override
        protected EncodedGraph lookupEncodedGraph(ResolvedJavaMethod lookupMethod, MethodSubstitutionPlugin plugin, BytecodeProvider intrinsicBytecodeProvider, boolean isSubstitution, boolean trackNodeSourcePosition) {
            if (lookupMethod.equals(this.method)) {
                return this.encodedGraph;
            }
            throw GraalError.shouldNotReachHere(this.method.format("%H.%n(%p)"));
        }

        @Override
        protected IntrinsicContext getIntrinsic() {
            return this.intrinsic;
        }
    }

    static class EncodedSnippets {
        private byte[] snippetEncoding;
        private Object[] snippetObjects;
        private NodeClass<?>[] snippetNodeClasses;
        private Map<String, Integer> snippetStartOffsets;
        private Map<String, String> originalMethods;

        EncodedSnippets(byte[] snippetEncoding, Object[] snippetObjects, NodeClass<?>[] snippetNodeClasses, Map<String, Integer> snippetStartOffsets, Map<String, String> originalMethods) {
            this.snippetEncoding = snippetEncoding;
            this.snippetObjects = snippetObjects;
            this.snippetNodeClasses = snippetNodeClasses;
            this.snippetStartOffsets = snippetStartOffsets;
            this.originalMethods = originalMethods;
        }

        StructuredGraph getMethodSubstitutionGraph(MethodSubstitutionPlugin plugin, ResolvedJavaMethod original, ReplacementsImpl replacements, IntrinsicContext.CompilationContext context, StructuredGraph.AllowAssumptions allowAssumptions, Cancellable cancellable, OptionValues options) {
            Integer startOffset = this.snippetStartOffsets.get(plugin.toString() + (Object)((Object)context));
            if (startOffset == null) {
                throw GraalError.shouldNotReachHere("plugin graph not found: " + plugin + " with " + (Object)((Object)context));
            }
            ResolvedJavaType accessingClass = replacements.getProviders().getMetaAccess().lookupJavaType(plugin.getDeclaringClass());
            return this.decodeGraph(original, accessingClass, startOffset, replacements, context, allowAssumptions, cancellable, options);
        }

        private StructuredGraph decodeGraph(ResolvedJavaMethod method, ResolvedJavaType accessingClass, int startOffset, ReplacementsImpl replacements, IntrinsicContext.CompilationContext context, StructuredGraph.AllowAssumptions allowAssumptions, Cancellable cancellable, OptionValues options) {
            Providers providers = replacements.getProviders();
            SymbolicEncodedGraph encodedGraph = new SymbolicEncodedGraph(this.snippetEncoding, startOffset, this.snippetObjects, this.snippetNodeClasses, SymbolicSnippetEncoder.methodKey(method), accessingClass, method.getDeclaringClass());
            try (DebugContext debug = replacements.openDebugContext("SVMSnippet_", method, options);){
                StructuredGraph result = new StructuredGraph.Builder(options, debug, allowAssumptions).cancellable(cancellable).method(method).setIsSubstitution(true).build();
                SubstitutionGraphDecoder graphDecoder = new SubstitutionGraphDecoder(providers, result, replacements, null, method, context, encodedGraph);
                graphDecoder.decode(method, result.isSubstitution(), encodedGraph.trackNodeSourcePosition());
                assert (result.verify());
                StructuredGraph structuredGraph = result;
                return structuredGraph;
            }
        }

        StructuredGraph getEncodedSnippet(ResolvedJavaMethod method, ReplacementsImpl replacements, Object[] args, StructuredGraph.AllowAssumptions allowAssumptions, OptionValues options) {
            Integer startOffset = null;
            if (this.snippetStartOffsets != null) {
                startOffset = this.snippetStartOffsets.get(SymbolicSnippetEncoder.methodKey(method));
            }
            if (startOffset == null) {
                if (Services.IS_IN_NATIVE_IMAGE) {
                    throw GraalError.shouldNotReachHere("snippet not found: " + method.format("%H.%n(%p)"));
                }
                return null;
            }
            SymbolicEncodedGraph encodedGraph = new SymbolicEncodedGraph(this.snippetEncoding, (int)startOffset, this.snippetObjects, this.snippetNodeClasses, this.originalMethods.get(SymbolicSnippetEncoder.methodKey(method)), method.getDeclaringClass());
            return SymbolicSnippetEncoder.decodeSnippetGraph(encodedGraph, method, replacements, args, allowAssumptions, options);
        }
    }

    private class SnippetCounterPlugin
    implements NodePlugin {
        String snippetCounterName = 'L' + SnippetCounter.class.getName().replace('.', '/') + ';';
        String snippetIntegerHistogramName = 'L' + SnippetIntegerHistogram.class.getName().replace('.', '/') + ';';

        private SnippetCounterPlugin() {
        }

        @Override
        public boolean handleLoadField(GraphBuilderContext b, ValueNode object, ResolvedJavaField field) {
            if (field.getName().equals("group") && field.getDeclaringClass().getName().equals(this.snippetCounterName)) {
                b.addPush(JavaKind.Object, ConstantNode.forConstant(JavaConstant.NULL_POINTER, b.getMetaAccess()));
                return true;
            }
            if (field.getType().getName().equals(this.snippetCounterName)) {
                b.addPush(JavaKind.Object, ConstantNode.forConstant(((SymbolicSnippetEncoder)SymbolicSnippetEncoder.this).snippetReplacements.snippetReflection.forObject(SnippetCounter.DISABLED_COUNTER), b.getMetaAccess()));
                return true;
            }
            if (field.getType().getName().equals(this.snippetIntegerHistogramName)) {
                b.addPush(JavaKind.Object, ConstantNode.forConstant(((SymbolicSnippetEncoder)SymbolicSnippetEncoder.this).snippetReplacements.snippetReflection.forObject(SnippetIntegerHistogram.DISABLED_COUNTER), b.getMetaAccess()));
                return true;
            }
            return false;
        }
    }

    public static class SnippetInvocationPlugins
    extends InvocationPlugins {
        SnippetInvocationPlugins(InvocationPlugins invocationPlugins) {
            super(invocationPlugins);
        }

        @Override
        public InvocationPlugin lookupInvocation(ResolvedJavaMethod method) {
            if (method.getAnnotation(Fold.class) != null) {
                return null;
            }
            return super.lookupInvocation(method);
        }
    }

    protected class SnippetInlineInvokePlugin
    implements InlineInvokePlugin {
        protected SnippetInlineInvokePlugin() {
        }

        @Override
        public InlineInvokePlugin.InlineInfo shouldInlineInvoke(GraphBuilderContext b, ResolvedJavaMethod method, ValueNode[] args) {
            if (method.getAnnotation(Fold.class) != null) {
                SymbolicSnippetEncoder.this.delayedInvocationPluginMethods.add(method);
                return InlineInvokePlugin.InlineInfo.DO_NOT_INLINE_NO_EXCEPTION;
            }
            if (SymbolicSnippetEncoder.this.snippetReplacements.getIntrinsifyingPlugin(method) != null) {
                SymbolicSnippetEncoder.this.delayedInvocationPluginMethods.add(method);
                return InlineInvokePlugin.InlineInfo.DO_NOT_INLINE_NO_EXCEPTION;
            }
            return InlineInvokePlugin.InlineInfo.createIntrinsicInlineInfo(method, SymbolicSnippetEncoder.this.snippetReplacements.getDefaultReplacementBytecodeProvider());
        }

        @Override
        public void notifyAfterInline(ResolvedJavaMethod methodToInline) {
            assert (methodToInline.getAnnotation(Fold.class) == null) : methodToInline;
        }
    }
}

