/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot;

import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.hotspot.meta.HotSpotConstantLoadAction;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.VirtualStackSlot;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;

public interface HotSpotLIRGenerator
extends LIRGeneratorTool {
    public void emitTailcall(Value[] var1, Value var2);

    public void emitDeoptimizeCaller(DeoptimizationAction var1, DeoptimizationReason var2);

    default public Value emitLoadObjectAddress(Constant constant) {
        throw new GraalError("Emitting code to load an object address is not currently supported on %s", this.target().arch);
    }

    default public Value emitLoadMetaspaceAddress(Constant constant, HotSpotConstantLoadAction action) {
        throw new GraalError("Emitting code to load a metaspace address is not currently supported on %s", this.target().arch);
    }

    default public Value emitLoadConfigValue(int markId, LIRKind kind) {
        throw new GraalError("Emitting code to load a config value is not currently supported on %s", this.target().arch);
    }

    default public Value emitObjectConstantRetrieval(Constant constant, Value constantDescription, LIRFrameState frameState) {
        throw new GraalError("Emitting code to resolve an object constant is not currently supported on %s", this.target().arch);
    }

    default public Value emitResolveDynamicInvoke(Constant constant, LIRFrameState frameState) {
        throw new GraalError("Emitting code to resolve a dynamic constant is not currently supported on %s", this.target().arch);
    }

    default public Value emitMetaspaceConstantRetrieval(Constant constant, Value constantDescription, LIRFrameState frameState) {
        throw new GraalError("Emitting code to resolve a metaspace constant is not currently supported on %s", this.target().arch);
    }

    default public Value emitResolveMethodAndLoadCounters(Constant method, Value klassHint, Value methodDescription, LIRFrameState frameState) {
        throw new GraalError("Emitting code to resolve a method and load counters is not currently supported on %s", this.target().arch);
    }

    default public Value emitKlassInitializationAndRetrieval(Constant constant, Value constantDescription, LIRFrameState frameState) {
        throw new GraalError("Emitting code to initialize a class is not currently supported on %s", this.target().arch);
    }

    default public Value emitRandomSeed() {
        throw new GraalError("Emitting code to return a random seed is not currently supported on %s", this.target().arch);
    }

    public VirtualStackSlot getLockSlot(int var1);

    @Override
    public HotSpotProviders getProviders();
}

