/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.graph.iterators;

import java.util.Iterator;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.iterators.NodeIterable;
import org.graalvm.compiler.graph.iterators.NodePredicate;
import org.graalvm.compiler.graph.iterators.NodePredicates;
import org.graalvm.compiler.graph.iterators.PredicatedProxyNodeIterator;

public class FilteredNodeIterable<T extends Node>
implements NodeIterable<T> {
    protected final NodeIterable<T> nodeIterable;
    protected NodePredicate predicate = NodePredicates.alwaysTrue();

    public FilteredNodeIterable(NodeIterable<T> nodeIterable) {
        this.nodeIterable = nodeIterable;
    }

    public FilteredNodeIterable<T> and(NodePredicate nodePredicate) {
        this.predicate = this.predicate.and(nodePredicate);
        return this;
    }

    @Override
    public Iterator<T> iterator() {
        return new PredicatedProxyNodeIterator(this.nodeIterable.iterator(), this.predicate);
    }

    @Override
    public <F extends T> FilteredNodeIterable<F> filter(Class<F> clazz) {
        return this.and(NodePredicates.isA(clazz));
    }

    @Override
    public FilteredNodeIterable<T> filter(NodePredicate p) {
        return this.and(p);
    }
}

