/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.debug;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import jdk.vm.ci.services.Services;

public final class Versions {
    static final Versions VERSIONS;
    private final Map<Object, Object> versions;

    public Versions(Path home) {
        HashMap<String, String> map;
        block4: {
            map = new HashMap<String, String>();
            try {
                Path info = Versions.findReleaseInfo(home);
                if (info == null) break block4;
                for (String line : Files.readAllLines(info)) {
                    String prefix = "SOURCE=";
                    if (!line.startsWith("SOURCE=")) continue;
                    for (String versionInfo : line.substring("SOURCE=".length()).replace('\"', ' ').split(" ")) {
                        String[] idVersion = versionInfo.split(":");
                        if (idVersion == null || idVersion.length != 2) continue;
                        map.put("version." + idVersion[0], idVersion[1]);
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.versions = Collections.unmodifiableMap(map);
    }

    public Map<Object, Object> withVersions(Map<Object, Object> properties) {
        if (properties == null) {
            return this.versions;
        }
        properties.putAll(this.versions);
        return properties;
    }

    private static Path findReleaseInfo(Path jreDir) {
        if (jreDir == null) {
            return null;
        }
        Path releaseInJre = jreDir.resolve("release");
        if (Files.exists(releaseInJre, new LinkOption[0])) {
            return releaseInJre;
        }
        Path jdkDir = jreDir.getParent();
        if (jdkDir == null) {
            return null;
        }
        Path releaseInJdk = jdkDir.resolve("release");
        return Files.exists(releaseInJdk, new LinkOption[0]) ? releaseInJdk : null;
    }

    static {
        String home = (String)Services.getSavedProperties().get("java.home");
        VERSIONS = new Versions(home == null ? null : new File(home).toPath());
    }
}

