/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.debug;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.MapCursor;
import org.graalvm.collections.Pair;
import org.graalvm.compiler.debug.AbstractKey;
import org.graalvm.compiler.debug.CSVUtil;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugOptions;
import org.graalvm.compiler.debug.KeyRegistry;
import org.graalvm.compiler.debug.MetricKey;
import org.graalvm.compiler.options.OptionValues;

public class GlobalMetrics {
    long[] values;

    public synchronized void add(DebugContext debug) {
        this.values = debug.addValuesTo(this.values);
    }

    public void clear() {
        this.values = null;
    }

    public EconomicMap<MetricKey, Long> asKeyValueMap() {
        List<MetricKey> keys = KeyRegistry.getKeys();
        Collections.sort(keys, MetricKey.NAME_COMPARATOR);
        EconomicMap res = EconomicMap.create((int)keys.size());
        long[] vals = this.values;
        for (MetricKey key : keys) {
            int index = ((AbstractKey)key).getIndex();
            if (vals == null || index >= vals.length) {
                res.put((Object)key, (Object)0L);
                continue;
            }
            res.put((Object)key, (Object)vals[index]);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(OptionValues options) {
        long[] vals = this.values;
        if (vals != null) {
            EconomicMap<MetricKey, Long> map = this.asKeyValueMap();
            String metricsFile = DebugOptions.AggregatedMetricsFile.getValue(options);
            boolean csv = metricsFile != null && (metricsFile.endsWith(".csv") || metricsFile.endsWith(".CSV"));
            PrintStream p = null;
            try {
                PrintStream printStream = p = metricsFile == null ? DebugContext.DEFAULT_LOG_STREAM : new PrintStream(Files.newOutputStream(Paths.get(metricsFile, new String[0]), new OpenOption[0]));
                if (!csv && !map.isEmpty()) {
                    p.println("++ Aggregated Metrics ++");
                }
                String csvFormat = CSVUtil.buildFormatString("%s", "%s", "%s");
                MapCursor e = map.getEntries();
                while (e.advance()) {
                    MetricKey key = (MetricKey)e.getKey();
                    if (csv) {
                        Pair<String, String> valueAndUnit = key.toCSVFormat((Long)e.getValue());
                        CSVUtil.Escape.println(p, csvFormat, key.getName(), valueAndUnit.getLeft(), valueAndUnit.getRight());
                        continue;
                    }
                    p.println(key.getName() + "=" + key.toHumanReadableFormat((Long)e.getValue()));
                }
                if (!csv && !map.isEmpty()) {
                    p.println("-- Aggregated Metrics --");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (metricsFile != null && p != null) {
                    p.close();
                }
            }
        }
        if (DebugOptions.ListMetrics.getValue(options).booleanValue()) {
            PrintStream p = System.out;
            p.println("++ Metric Keys ++");
            List<MetricKey> keys = KeyRegistry.getKeys();
            Collections.sort(keys, MetricKey.NAME_COMPARATOR);
            for (MetricKey key : keys) {
                String name = key.getDocName();
                if (name == null) continue;
                String doc = key.getDoc();
                if (doc != null) {
                    p.println(name + ": " + doc);
                    continue;
                }
                p.println(name);
            }
            p.println("-- Metric Keys --");
        }
    }
}

