/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.sparc;

import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.sparc.SPARCKind;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.calc.CanonicalCondition;
import org.graalvm.compiler.core.common.calc.Condition;
import org.graalvm.compiler.core.gen.NodeMatchRules;
import org.graalvm.compiler.core.match.ComplexMatchResult;
import org.graalvm.compiler.core.match.MatchRule;
import org.graalvm.compiler.core.match.MatchRules;
import org.graalvm.compiler.core.sparc.SPARCArithmeticLIRGenerator;
import org.graalvm.compiler.core.sparc.SPARCLIRGenerator;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.LabelRef;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.lir.sparc.SPARCAddressValue;
import org.graalvm.compiler.nodes.DeoptimizingNode;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.CompareNode;
import org.graalvm.compiler.nodes.calc.SignExtendNode;
import org.graalvm.compiler.nodes.calc.ZeroExtendNode;
import org.graalvm.compiler.nodes.java.LogicCompareAndSwapNode;
import org.graalvm.compiler.nodes.memory.Access;
import org.graalvm.compiler.nodes.memory.LIRLowerableAccess;

public class SPARCNodeMatchRules
extends NodeMatchRules {
    public SPARCNodeMatchRules(LIRGeneratorTool gen) {
        super(gen);
    }

    protected LIRFrameState getState(Access access) {
        if (access instanceof DeoptimizingNode) {
            return this.state((DeoptimizingNode)((Object)access));
        }
        return null;
    }

    protected LIRKind getLirKind(LIRLowerableAccess access) {
        return this.gen.getLIRKind(access.getAccessStamp());
    }

    private ComplexMatchResult emitSignExtendMemory(Access access, int fromBits, int toBits) {
        assert (fromBits <= toBits && toBits <= 64);
        SPARCKind toKind = null;
        SPARCKind fromKind = null;
        if (fromBits == toBits) {
            return null;
        }
        toKind = toBits > 32 ? SPARCKind.XWORD : SPARCKind.WORD;
        switch (fromBits) {
            case 8: {
                fromKind = SPARCKind.BYTE;
                break;
            }
            case 16: {
                fromKind = SPARCKind.HWORD;
                break;
            }
            case 32: {
                fromKind = SPARCKind.WORD;
                break;
            }
            default: {
                throw GraalError.unimplemented("unsupported sign extension (" + fromBits + " bit -> " + toBits + " bit)");
            }
        }
        SPARCKind localFromKind = fromKind;
        SPARCKind localToKind = toKind;
        return builder -> this.getLIRGeneratorTool().emitSignExtendLoad(LIRKind.value((PlatformKind)localFromKind), LIRKind.value((PlatformKind)localToKind), this.operand(access.getAddress()), this.getState(access));
    }

    private ComplexMatchResult emitZeroExtendMemory(Access access, int fromBits, int toBits) {
        assert (fromBits <= toBits && toBits <= 64);
        SPARCKind toKind = null;
        SPARCKind fromKind = null;
        if (fromBits == toBits) {
            return null;
        }
        toKind = toBits > 32 ? SPARCKind.XWORD : SPARCKind.WORD;
        switch (fromBits) {
            case 8: {
                fromKind = SPARCKind.BYTE;
                break;
            }
            case 16: {
                fromKind = SPARCKind.HWORD;
                break;
            }
            case 32: {
                fromKind = SPARCKind.WORD;
                break;
            }
            default: {
                throw GraalError.unimplemented("unsupported sign extension (" + fromBits + " bit -> " + toBits + " bit)");
            }
        }
        SPARCKind localFromKind = fromKind;
        SPARCKind localToKind = toKind;
        return builder -> this.getLIRGeneratorTool().emitZeroExtendLoad(LIRKind.value((PlatformKind)localFromKind), LIRKind.value((PlatformKind)localToKind), this.operand(access.getAddress()), this.getState(access));
    }

    @MatchRules(value={@MatchRule(value="(SignExtend Read=access)"), @MatchRule(value="(SignExtend FloatingRead=access)"), @MatchRule(value="(SignExtend VolatileRead=access)")})
    public ComplexMatchResult signExtend(SignExtendNode root, Access access) {
        return this.emitSignExtendMemory(access, root.getInputBits(), root.getResultBits());
    }

    @MatchRules(value={@MatchRule(value="(ZeroExtend Read=access)"), @MatchRule(value="(ZeroExtend FloatingRead=access)"), @MatchRule(value="(ZeroExtend VolatileRead=access)")})
    public ComplexMatchResult zeroExtend(ZeroExtendNode root, Access access) {
        return this.emitZeroExtendMemory(access, root.getInputBits(), root.getResultBits());
    }

    @MatchRules(value={@MatchRule(value="(If (ObjectEquals=compare value LogicCompareAndSwap=cas))"), @MatchRule(value="(If (PointerEquals=compare value LogicCompareAndSwap=cas))"), @MatchRule(value="(If (FloatEquals=compare value LogicCompareAndSwap=cas))"), @MatchRule(value="(If (IntegerEquals=compare value LogicCompareAndSwap=cas))")})
    public ComplexMatchResult ifCompareLogicCas(IfNode root, CompareNode compare, ValueNode value, LogicCompareAndSwapNode cas) {
        JavaConstant constant = value.asJavaConstant();
        assert (compare.condition() == CanonicalCondition.EQ);
        if (constant != null && cas.hasExactlyOneUsage()) {
            boolean successIsTrue;
            long constantValue = constant.asLong();
            if (constantValue == 0L) {
                successIsTrue = false;
            } else if (constantValue == 1L) {
                successIsTrue = true;
            } else {
                return null;
            }
            return builder -> {
                LIRKind kind = this.getLirKind(cas);
                LabelRef trueLabel = this.getLIRBlock(root.trueSuccessor());
                LabelRef falseLabel = this.getLIRBlock(root.falseSuccessor());
                double trueLabelProbability = root.probability(root.trueSuccessor());
                Value expectedValue = this.operand(cas.getExpectedValue());
                Value newValue = this.operand(cas.getNewValue());
                SPARCAddressValue address = (SPARCAddressValue)this.operand(cas.getAddress());
                Condition condition = successIsTrue ? Condition.EQ : Condition.NE;
                Value result = this.getLIRGeneratorTool().emitValueCompareAndSwap(kind, address, expectedValue, newValue);
                this.getLIRGeneratorTool().emitCompareBranch(kind.getPlatformKind(), result, expectedValue, condition, false, trueLabel, falseLabel, trueLabelProbability);
                return null;
            };
        }
        return null;
    }

    @Override
    public SPARCLIRGenerator getLIRGeneratorTool() {
        return (SPARCLIRGenerator)super.getLIRGeneratorTool();
    }

    protected SPARCArithmeticLIRGenerator getArithmeticLIRGenerator() {
        return (SPARCArithmeticLIRGenerator)this.getLIRGeneratorTool().getArithmetic();
    }
}

