/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.sparc;

import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.sparc.SPARCAssembler;
import org.graalvm.compiler.core.common.type.DataPointerConstant;
import org.graalvm.compiler.core.sparc.SPARCLIRGenerator;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRValueUtil;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.lir.sparc.SPARCAddressValue;
import org.graalvm.compiler.lir.sparc.SPARCMove;

public class SPARCMoveFactory
implements LIRGeneratorTool.MoveFactory {
    protected final SPARCLIRGenerator.ConstantTableBaseProvider constantTableBaseProvider;

    public SPARCMoveFactory(SPARCLIRGenerator.ConstantTableBaseProvider constantTableBaseProvider) {
        this.constantTableBaseProvider = constantTableBaseProvider;
    }

    @Override
    public LIRInstruction createMove(AllocatableValue dst, Value src) {
        boolean srcIsSlot = LIRValueUtil.isStackSlotValue(src);
        boolean dstIsSlot = LIRValueUtil.isStackSlotValue((Value)dst);
        if (LIRValueUtil.isConstantValue(src)) {
            return this.createLoad(dst, LIRValueUtil.asConstant(src));
        }
        if (src instanceof SPARCAddressValue) {
            return new SPARCMove.LoadAddressOp(dst, (SPARCAddressValue)src);
        }
        assert (src instanceof AllocatableValue);
        if (srcIsSlot && dstIsSlot) {
            throw GraalError.shouldNotReachHere(src.getClass() + " " + dst.getClass());
        }
        return new SPARCMove.Move(dst, (AllocatableValue)src);
    }

    @Override
    public LIRInstruction createStackMove(AllocatableValue result, AllocatableValue input) {
        return new SPARCMove.Move(result, input);
    }

    @Override
    public LIRInstruction createLoad(AllocatableValue dst, Constant src) {
        if (src instanceof JavaConstant) {
            JavaConstant javaConstant = (JavaConstant)src;
            if (this.canInlineConstant((Constant)javaConstant)) {
                return new SPARCMove.LoadInlineConstant(javaConstant, dst);
            }
            return new SPARCMove.LoadConstantFromTable(javaConstant, this.constantTableBaseProvider.getConstantTableBase(), dst);
        }
        if (src instanceof DataPointerConstant) {
            return new SPARCMove.LoadDataAddressOp(dst, (DataPointerConstant)src);
        }
        throw GraalError.shouldNotReachHere(src.getClass().toString());
    }

    @Override
    public LIRInstruction createStackLoad(AllocatableValue result, Constant input) {
        if (input instanceof DataPointerConstant) {
            throw GraalError.shouldNotReachHere("unsupported constant for stack load: " + input);
        }
        return this.createLoad(result, input);
    }

    @Override
    public boolean canInlineConstant(Constant con) {
        if (con instanceof JavaConstant) {
            JavaConstant c = (JavaConstant)con;
            switch (c.getJavaKind()) {
                case Boolean: 
                case Byte: 
                case Char: 
                case Short: 
                case Int: {
                    return SPARCAssembler.isSimm13(c.asInt());
                }
                case Long: {
                    return SPARCAssembler.isSimm13(c.asLong());
                }
                case Object: {
                    return c.isNull();
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean allowConstantToStackMove(Constant value) {
        return false;
    }
}

