/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.sparc;

import jdk.vm.ci.meta.AllocatableValue;
import org.graalvm.compiler.asm.sparc.SPARCAssembler;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.sparc.SPARCLIRGenerator;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.sparc.SPARCImmediateAddressValue;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo
public class SPARCImmediateAddressNode
extends AddressNode
implements LIRLowerable {
    public static final NodeClass<SPARCImmediateAddressNode> TYPE = NodeClass.create(SPARCImmediateAddressNode.class);
    @Node.Input
    private ValueNode base;
    private int displacement;

    public SPARCImmediateAddressNode(ValueNode base, int displacement) {
        super((NodeClass<? extends AddressNode>)TYPE);
        assert (SPARCAssembler.isSimm13(displacement));
        this.base = base;
        this.displacement = displacement;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        SPARCLIRGenerator tool = (SPARCLIRGenerator)gen.getLIRGeneratorTool();
        AllocatableValue baseValue = tool.asAllocatable(gen.operand(this.base));
        LIRKind kind = tool.getLIRKind(this.stamp(NodeView.DEFAULT));
        AllocatableValue baseReference = LIRKind.derivedBaseFromValue(baseValue);
        if (baseReference != null) {
            kind = kind.makeDerivedReference(baseReference);
        }
        gen.setResult(this, new SPARCImmediateAddressValue(kind, baseValue, this.displacement));
    }

    @Override
    public ValueNode getBase() {
        return this.base;
    }

    @Override
    public long getMaxConstantDisplacement() {
        return this.displacement;
    }

    @Override
    public ValueNode getIndex() {
        return null;
    }
}

