/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.common.util;

public final class UnsignedLong {
    private final long value;

    public UnsignedLong(long value) {
        this.value = value;
    }

    public long asLong() {
        return this.value;
    }

    public boolean equals(long unsignedValue) {
        return this.value == unsignedValue;
    }

    public boolean isLessThan(long unsignedValue) {
        return Long.compareUnsigned(this.value, unsignedValue) < 0;
    }

    public boolean isGreaterThan(long unsignedValue) {
        return Long.compareUnsigned(this.value, unsignedValue) > 0;
    }

    public boolean isLessOrEqualTo(long unsignedValue) {
        return Long.compareUnsigned(this.value, unsignedValue) <= 0;
    }

    public UnsignedLong times(long unsignedValue) {
        if (unsignedValue != 0L && Long.compareUnsigned(this.value, Long.divideUnsigned(-1L, unsignedValue)) > 0) {
            throw new ArithmeticException();
        }
        return new UnsignedLong(this.value * unsignedValue);
    }

    public UnsignedLong minus(long unsignedValue) {
        if (Long.compareUnsigned(this.value, unsignedValue) < 0) {
            throw new ArithmeticException();
        }
        return new UnsignedLong(this.value - unsignedValue);
    }

    public UnsignedLong plus(long unsignedValue) {
        if (Long.compareUnsigned(-1L - unsignedValue, this.value) < 0) {
            throw new ArithmeticException();
        }
        return new UnsignedLong(this.value + unsignedValue);
    }

    public UnsignedLong wrappingPlus(long unsignedValue) {
        return new UnsignedLong(this.value + unsignedValue);
    }

    public UnsignedLong wrappingTimes(long unsignedValue) {
        return new UnsignedLong(this.value * unsignedValue);
    }

    public String toString() {
        return "UnsignedLong(" + Long.toUnsignedString(this.value) + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnsignedLong that = (UnsignedLong)o;
        return this.value == that.value;
    }

    public int hashCode() {
        return Long.hashCode(this.value);
    }
}

