/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.common.util;

import java.util.BitSet;

public final class BitMap2D {
    private BitSet map;
    private final int bitsPerSlot;

    private int bitIndex(int slotIndex, int bitWithinSlotIndex) {
        return slotIndex * this.bitsPerSlot + bitWithinSlotIndex;
    }

    private boolean verifyBitWithinSlotIndex(int index) {
        assert (index < this.bitsPerSlot) : "index " + index + " is out of bounds " + this.bitsPerSlot;
        return true;
    }

    public BitMap2D(int sizeInSlots, int bitsPerSlot) {
        this.map = new BitSet(sizeInSlots * bitsPerSlot);
        this.bitsPerSlot = bitsPerSlot;
    }

    public int sizeInBits() {
        return this.map.size();
    }

    public int sizeInSlots() {
        return this.map.size() / this.bitsPerSlot;
    }

    public boolean isValidIndex(int slotIndex, int bitWithinSlotIndex) {
        assert (this.verifyBitWithinSlotIndex(bitWithinSlotIndex));
        return this.bitIndex(slotIndex, bitWithinSlotIndex) < this.sizeInBits();
    }

    public boolean at(int slotIndex, int bitWithinSlotIndex) {
        assert (this.verifyBitWithinSlotIndex(bitWithinSlotIndex));
        return this.map.get(this.bitIndex(slotIndex, bitWithinSlotIndex));
    }

    public void setBit(int slotIndex, int bitWithinSlotIndex) {
        assert (this.verifyBitWithinSlotIndex(bitWithinSlotIndex));
        this.map.set(this.bitIndex(slotIndex, bitWithinSlotIndex));
    }

    public void clearBit(int slotIndex, int bitWithinSlotIndex) {
        assert (this.verifyBitWithinSlotIndex(bitWithinSlotIndex));
        this.map.clear(this.bitIndex(slotIndex, bitWithinSlotIndex));
    }

    public void atPutGrow(int slotIndex, int bitWithinSlotIndex, boolean value) {
        int size = this.sizeInSlots();
        if (size <= slotIndex) {
            while (size <= slotIndex) {
                size *= 2;
            }
            BitSet newBitMap = new BitSet(size * this.bitsPerSlot);
            newBitMap.or(this.map);
            this.map = newBitMap;
        }
        if (value) {
            this.setBit(slotIndex, bitWithinSlotIndex);
        } else {
            this.clearBit(slotIndex, bitWithinSlotIndex);
        }
    }

    public void clear() {
        this.map.clear();
    }
}

