/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.common.alloc;

import java.util.ArrayList;
import org.graalvm.compiler.core.common.alloc.Trace;
import org.graalvm.compiler.core.common.alloc.TraceBuilderResult;
import org.graalvm.compiler.core.common.cfg.AbstractBlockBase;
import org.graalvm.compiler.debug.DebugContext;

public final class SingleBlockTraceBuilder {
    public static TraceBuilderResult computeTraces(DebugContext debug, AbstractBlockBase<?> startBlock, AbstractBlockBase<?>[] blocks, TraceBuilderResult.TrivialTracePredicate pred) {
        return SingleBlockTraceBuilder.build(debug, startBlock, blocks, pred);
    }

    private static TraceBuilderResult build(DebugContext debug, AbstractBlockBase<?> startBlock, AbstractBlockBase<?>[] blocks, TraceBuilderResult.TrivialTracePredicate pred) {
        Trace[] blockToTrace = new Trace[blocks.length];
        ArrayList<Trace> traces = new ArrayList<Trace>(blocks.length);
        for (AbstractBlockBase<?> block : blocks) {
            Trace trace;
            blockToTrace[block.getId()] = trace = new Trace(new AbstractBlockBase[]{block});
            block.setLinearScanNumber(0);
            trace.setId(traces.size());
            traces.add(trace);
        }
        assert (((Trace)traces.get(0)).getBlocks()[0].equals(startBlock)) : "The first traces always contains the start block";
        return TraceBuilderResult.create(debug, blocks, traces, blockToTrace, pred);
    }
}

