/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.common;

import jdk.vm.ci.code.CodeUtil;

public class NumUtil {
    public static boolean isShiftCount(int x) {
        return 0 <= x && x < 32;
    }

    public static boolean isUByte(int x) {
        return (x & 0xFF) == x;
    }

    public static boolean isByte(int x) {
        return (byte)x == x;
    }

    public static boolean isUByte(long x) {
        return (x & 0xFFL) == x;
    }

    public static boolean isByte(long l) {
        return (long)((byte)l) == l;
    }

    public static boolean isUInt(long x) {
        return (x & 0xFFFFFFFFL) == x;
    }

    public static boolean isInt(long l) {
        return (long)((int)l) == l;
    }

    public static boolean isShort(int x) {
        return (short)x == x;
    }

    public static boolean isShort(long x) {
        return (long)((short)x) == x;
    }

    public static boolean isUShort(int s) {
        return s == (s & 0xFFFF);
    }

    public static boolean isUShort(long s) {
        return s == (s & 0xFFFFL);
    }

    public static boolean is32bit(long x) {
        return Integer.MIN_VALUE <= x && x < 0x80000000L;
    }

    public static short safeToShort(int v) {
        assert (NumUtil.isShort(v));
        return (short)v;
    }

    public static int safeToInt(long v) {
        assert (NumUtil.isInt(v));
        return (int)v;
    }

    public static int roundUp(int number, int mod) {
        return (number + mod - 1) / mod * mod;
    }

    public static long roundUp(long number, long mod) {
        return (number + mod - 1L) / mod * mod;
    }

    public static int roundDown(int number, int mod) {
        return number / mod * mod;
    }

    public static long roundDown(long number, long mod) {
        return number / mod * mod;
    }

    public static int log2Ceil(int val) {
        int log2 = 0;
        for (int x = 1; x < val; x *= 2) {
            ++log2;
        }
        return log2;
    }

    public static boolean isUnsignedNbit(int n, int value) {
        assert (n > 0 && n < 32);
        return 32 - Integer.numberOfLeadingZeros(value) <= n;
    }

    public static boolean isUnsignedNbit(int n, long value) {
        assert (n > 0 && n < 64);
        return 64 - Long.numberOfLeadingZeros(value) <= n;
    }

    public static boolean isSignedNbit(int n, int value) {
        assert (n > 0 && n < 32);
        int min = -(1 << n - 1);
        int max = (1 << n - 1) - 1;
        return value >= min && value <= max;
    }

    public static boolean isSignedNbit(int n, long value) {
        assert (n > 0 && n < 64);
        long min = -(1L << n - 1);
        long max = (1L << n - 1) - 1L;
        return value >= min && value <= max;
    }

    public static int getNbitNumberInt(int n) {
        assert (n >= 0 && n <= 32) : "0 <= n <= 32; instead: " + n;
        if (n < 32) {
            return (1 << n) - 1;
        }
        return -1;
    }

    public static long getNbitNumberLong(int n) {
        assert (n >= 0 && n <= 64);
        if (n < 64) {
            return (1L << n) - 1L;
        }
        return -1L;
    }

    public static long minValue(int bits) {
        return CodeUtil.minValue((int)bits);
    }

    public static long maxValue(int bits) {
        return CodeUtil.maxValue((int)bits);
    }

    public static long maxValueUnsigned(int bits) {
        return NumUtil.getNbitNumberLong(bits);
    }

    public static long maxUnsigned(long a, long b) {
        if (Long.compareUnsigned(a, b) < 0) {
            return b;
        }
        return a;
    }

    public static long minUnsigned(long a, long b) {
        if (Long.compareUnsigned(a, b) < 0) {
            return a;
        }
        return b;
    }

    public static boolean sameSign(long a, long b) {
        return a < 0L == b < 0L;
    }
}

