/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.aarch64;

import jdk.vm.ci.aarch64.AArch64Kind;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.core.aarch64.AArch64FloatConvertOp;
import org.graalvm.compiler.core.aarch64.AArch64LIRGenerator;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.core.common.calc.FloatConvert;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.ConstantValue;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.LIRValueUtil;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.lir.aarch64.AArch64AddressValue;
import org.graalvm.compiler.lir.aarch64.AArch64ArithmeticLIRGeneratorTool;
import org.graalvm.compiler.lir.aarch64.AArch64ArithmeticOp;
import org.graalvm.compiler.lir.aarch64.AArch64BitManipulationOp;
import org.graalvm.compiler.lir.aarch64.AArch64Move;
import org.graalvm.compiler.lir.aarch64.AArch64ReinterpretOp;
import org.graalvm.compiler.lir.aarch64.AArch64SignExtendOp;
import org.graalvm.compiler.lir.aarch64.AArch64Unary;
import org.graalvm.compiler.lir.gen.ArithmeticLIRGenerator;

public class AArch64ArithmeticLIRGenerator
extends ArithmeticLIRGenerator
implements AArch64ArithmeticLIRGeneratorTool {
    private final AllocatableValue nullRegisterValue;

    public AArch64ArithmeticLIRGenerator(AllocatableValue nullRegisterValue) {
        this.nullRegisterValue = nullRegisterValue;
    }

    @Override
    public AArch64LIRGenerator getLIRGen() {
        return (AArch64LIRGenerator)super.getLIRGen();
    }

    public boolean mustReplaceNullWithNullRegister(JavaConstant nullConstant) {
        return this.nullRegisterValue != null && JavaConstant.NULL_POINTER.equals(nullConstant);
    }

    public AllocatableValue getNullRegisterValue() {
        return this.nullRegisterValue;
    }

    @Override
    protected boolean isNumericInteger(PlatformKind kind) {
        return ((AArch64Kind)kind).isInteger();
    }

    @Override
    protected Variable emitAdd(LIRKind resultKind, Value a, Value b, boolean setFlags) {
        if (this.isNumericInteger(a.getPlatformKind())) {
            AArch64ArithmeticOp op = setFlags ? AArch64ArithmeticOp.ADDS : AArch64ArithmeticOp.ADD;
            return this.emitBinary(resultKind, op, true, a, b);
        }
        assert (!setFlags) : "Cannot set flags on floating point arithmetic";
        return this.emitBinary(resultKind, AArch64ArithmeticOp.FADD, true, a, b);
    }

    @Override
    protected Variable emitSub(LIRKind resultKind, Value a, Value b, boolean setFlags) {
        if (this.isNumericInteger(a.getPlatformKind())) {
            AArch64ArithmeticOp op = setFlags ? AArch64ArithmeticOp.SUBS : AArch64ArithmeticOp.SUB;
            return this.emitBinary(resultKind, op, false, a, b);
        }
        assert (!setFlags) : "Cannot set flags on floating point arithmetic";
        return this.emitBinary(resultKind, AArch64ArithmeticOp.FSUB, false, a, b);
    }

    public Value emitExtendMemory(boolean isSigned, AArch64Kind memoryKind, int resultBits, AArch64AddressValue address, LIRFrameState state) {
        Variable result = this.getLIRGen().newVariable(LIRKind.value((PlatformKind)(resultBits == 32 ? AArch64Kind.DWORD : AArch64Kind.QWORD)));
        int targetSize = resultBits <= 32 ? 32 : 64;
        switch (memoryKind) {
            case BYTE: 
            case WORD: 
            case DWORD: 
            case QWORD: {
                this.getLIRGen().append(new AArch64Unary.MemoryOp(isSigned, targetSize, memoryKind.getSizeInBytes() * 8, result, address, state));
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere();
            }
        }
        return result;
    }

    @Override
    public Value emitMul(Value a, Value b, boolean setFlags) {
        AArch64ArithmeticOp intOp = setFlags ? AArch64ArithmeticOp.MULVS : AArch64ArithmeticOp.MUL;
        return this.emitBinary(LIRKind.combine(a, b), this.getOpCode(a, intOp, AArch64ArithmeticOp.FMUL), true, a, b);
    }

    @Override
    public Value emitMulHigh(Value a, Value b) {
        assert (this.isNumericInteger(a.getPlatformKind()));
        return this.emitBinary(LIRKind.combine(a, b), AArch64ArithmeticOp.SMULH, true, a, b);
    }

    @Override
    public Value emitUMulHigh(Value a, Value b) {
        assert (this.isNumericInteger(a.getPlatformKind()));
        return this.emitBinary(LIRKind.combine(a, b), AArch64ArithmeticOp.UMULH, true, a, b);
    }

    public Value emitMNeg(Value a, Value b) {
        assert (this.isNumericInteger(a.getPlatformKind()) && this.isNumericInteger(b.getPlatformKind()));
        return this.emitBinary(LIRKind.combine(a, b), AArch64ArithmeticOp.MNEG, true, a, b);
    }

    @Override
    public Value emitDiv(Value a, Value b, LIRFrameState state) {
        return this.emitBinary(LIRKind.combine(a, b), this.getOpCode(a, AArch64ArithmeticOp.DIV, AArch64ArithmeticOp.FDIV), false, (Value)this.asAllocatable(a), (Value)this.asAllocatable(b));
    }

    @Override
    public Value emitRem(Value a, Value b, LIRFrameState state) {
        return this.emitBinary(LIRKind.combine(a, b), this.getOpCode(a, AArch64ArithmeticOp.REM, AArch64ArithmeticOp.FREM), false, (Value)this.asAllocatable(a), (Value)this.asAllocatable(b));
    }

    @Override
    public Value emitUDiv(Value a, Value b, LIRFrameState state) {
        assert (this.isNumericInteger(a.getPlatformKind()));
        return this.emitBinary(LIRKind.combine(a, b), AArch64ArithmeticOp.UDIV, false, (Value)this.asAllocatable(a), (Value)this.asAllocatable(b));
    }

    @Override
    public Value emitURem(Value a, Value b, LIRFrameState state) {
        assert (this.isNumericInteger(a.getPlatformKind()));
        return this.emitBinary(LIRKind.combine(a, b), AArch64ArithmeticOp.UREM, false, (Value)this.asAllocatable(a), (Value)this.asAllocatable(b));
    }

    @Override
    public Value emitAnd(Value a, Value b) {
        assert (this.isNumericInteger(a.getPlatformKind()));
        return this.emitBinary(LIRKind.combine(a, b), AArch64ArithmeticOp.AND, true, a, b);
    }

    @Override
    public Value emitOr(Value a, Value b) {
        assert (this.isNumericInteger(a.getPlatformKind()));
        return this.emitBinary(LIRKind.combine(a, b), AArch64ArithmeticOp.OR, true, a, b);
    }

    @Override
    public Value emitXor(Value a, Value b) {
        assert (this.isNumericInteger(a.getPlatformKind()));
        return this.emitBinary(LIRKind.combine(a, b), AArch64ArithmeticOp.XOR, true, a, b);
    }

    @Override
    public Value emitShl(Value a, Value b) {
        assert (this.isNumericInteger(a.getPlatformKind()));
        return this.emitBinary(LIRKind.combine(a, b), AArch64ArithmeticOp.SHL, false, a, b);
    }

    @Override
    public Value emitShr(Value a, Value b) {
        assert (this.isNumericInteger(a.getPlatformKind()));
        return this.emitBinary(LIRKind.combine(a, b), AArch64ArithmeticOp.ASHR, false, a, b);
    }

    @Override
    public Value emitUShr(Value a, Value b) {
        assert (this.isNumericInteger(a.getPlatformKind()));
        return this.emitBinary(LIRKind.combine(a, b), AArch64ArithmeticOp.LSHR, false, a, b);
    }

    @Override
    public Value emitFloatConvert(FloatConvert op, Value inputVal) {
        PlatformKind resultPlatformKind = AArch64ArithmeticLIRGenerator.getFloatConvertResultKind(op);
        LIRKind resultLirKind = LIRKind.combine(inputVal).changeType(resultPlatformKind);
        Variable result = this.getLIRGen().newVariable(resultLirKind);
        this.getLIRGen().append(new AArch64FloatConvertOp(op, result, this.asAllocatable(inputVal)));
        return result;
    }

    Value emitIntegerMAdd(Value a, Value b, Value c, boolean isI2L) {
        return this.emitMultiplyAddSub(isI2L ? AArch64ArithmeticOp.SMADDL : AArch64ArithmeticOp.MADD, a, b, c);
    }

    Value emitIntegerMSub(Value a, Value b, Value c, boolean isI2L) {
        return this.emitMultiplyAddSub(isI2L ? AArch64ArithmeticOp.SMSUBL : AArch64ArithmeticOp.MSUB, a, b, c);
    }

    private Value emitMultiplyAddSub(AArch64ArithmeticOp op, Value a, Value b, Value c) {
        Variable result;
        assert (a.getPlatformKind() == b.getPlatformKind());
        if (op == AArch64ArithmeticOp.SMADDL || op == AArch64ArithmeticOp.SMSUBL) {
            assert (a.getPlatformKind() != c.getPlatformKind());
            result = this.getLIRGen().newVariable(LIRKind.combine(c));
        } else {
            assert (a.getPlatformKind() == c.getPlatformKind());
            if (op == AArch64ArithmeticOp.FADD) {
                assert (a.getPlatformKind() == AArch64Kind.SINGLE || a.getPlatformKind() == AArch64Kind.DOUBLE);
            } else {
                assert (op == AArch64ArithmeticOp.MADD || op == AArch64ArithmeticOp.MSUB);
                assert (this.isNumericInteger(a.getPlatformKind()));
            }
            result = this.getLIRGen().newVariable(LIRKind.combine(a, b, c));
        }
        AllocatableValue x = this.moveSp(this.asAllocatable(a));
        AllocatableValue y = this.moveSp(this.asAllocatable(b));
        AllocatableValue z = this.moveSp(this.asAllocatable(c));
        this.getLIRGen().append(new AArch64ArithmeticOp.MultiplyAddSubOp(op, result, x, y, z));
        return result;
    }

    private static PlatformKind getFloatConvertResultKind(FloatConvert op) {
        switch (op) {
            case F2I: 
            case D2I: {
                return AArch64Kind.DWORD;
            }
            case F2L: 
            case D2L: {
                return AArch64Kind.QWORD;
            }
            case I2F: 
            case L2F: 
            case D2F: {
                return AArch64Kind.SINGLE;
            }
            case I2D: 
            case L2D: 
            case F2D: {
                return AArch64Kind.DOUBLE;
            }
        }
        throw GraalError.shouldNotReachHere();
    }

    @Override
    public Value emitReinterpret(LIRKind to, Value inputVal) {
        ValueKind from = inputVal.getValueKind();
        if (to.equals(from)) {
            return inputVal;
        }
        Variable result = this.getLIRGen().newVariable(to);
        this.getLIRGen().append(new AArch64ReinterpretOp(result, this.asAllocatable(inputVal)));
        return result;
    }

    @Override
    public Value emitNarrow(Value inputVal, int bits) {
        if (inputVal.getPlatformKind() == AArch64Kind.QWORD && bits <= 32) {
            LIRKind resultKind = AArch64ArithmeticLIRGenerator.getResultLirKind(bits, inputVal);
            long mask = NumUtil.getNbitNumberLong(bits);
            ConstantValue maskValue = new ConstantValue(resultKind, (Constant)JavaConstant.forLong((long)mask));
            return this.emitBinary(resultKind, AArch64ArithmeticOp.AND, true, inputVal, maskValue);
        }
        return inputVal;
    }

    @Override
    public Value emitZeroExtend(Value inputVal, int fromBits, int toBits) {
        assert (fromBits <= toBits && toBits <= 64);
        if (fromBits == toBits) {
            return inputVal;
        }
        LIRKind resultKind = AArch64ArithmeticLIRGenerator.getResultLirKind(toBits, inputVal);
        long mask = NumUtil.getNbitNumberLong(fromBits);
        ConstantValue maskValue = new ConstantValue(resultKind, (Constant)JavaConstant.forLong((long)mask));
        return this.emitBinary(resultKind, AArch64ArithmeticOp.AND, true, inputVal, maskValue);
    }

    @Override
    public Value emitSignExtend(Value inputVal, int fromBits, int toBits) {
        LIRKind resultKind = AArch64ArithmeticLIRGenerator.getResultLirKind(toBits, inputVal);
        assert (fromBits <= toBits && toBits <= 64);
        if (fromBits == toBits) {
            return inputVal;
        }
        if (LIRValueUtil.isJavaConstant(inputVal)) {
            JavaConstant javaConstant = LIRValueUtil.asJavaConstant(inputVal);
            long constant = javaConstant.isNull() ? 0L : javaConstant.asLong();
            int shiftCount = AArch64Kind.QWORD.getSizeInBytes() * 8 - fromBits;
            return new ConstantValue(resultKind, (Constant)JavaConstant.forLong((long)(constant << shiftCount >> shiftCount)));
        }
        Variable result = this.getLIRGen().newVariable(resultKind);
        this.getLIRGen().append(new AArch64SignExtendOp(result, this.asAllocatable(inputVal), fromBits, toBits));
        return result;
    }

    private static LIRKind getResultLirKind(int resultBitSize, Value ... inputValues) {
        if (resultBitSize == 64) {
            return LIRKind.combine(inputValues).changeType((PlatformKind)AArch64Kind.QWORD);
        }
        return LIRKind.combine(inputValues).changeType((PlatformKind)AArch64Kind.DWORD);
    }

    protected Variable emitBinary(ValueKind<?> resultKind, AArch64ArithmeticOp op, boolean commutative, Value a, Value b) {
        Variable result = this.getLIRGen().newVariable(resultKind);
        if (AArch64ArithmeticLIRGenerator.isValidBinaryConstant(op, a, b)) {
            this.emitBinaryConst(result, op, this.asAllocatable(a), LIRValueUtil.asJavaConstant(b));
        } else if (commutative && AArch64ArithmeticLIRGenerator.isValidBinaryConstant(op, b, a)) {
            this.emitBinaryConst(result, op, this.asAllocatable(b), LIRValueUtil.asJavaConstant(a));
        } else {
            this.emitBinaryVar(result, op, this.asAllocatable(a), this.asAllocatable(b));
        }
        return result;
    }

    private void emitBinaryVar(Variable result, AArch64ArithmeticOp op, AllocatableValue a, AllocatableValue b) {
        AllocatableValue x = this.moveSp(a);
        AllocatableValue y = this.moveSp(b);
        switch (op) {
            case FREM: 
            case REM: 
            case UREM: {
                this.getLIRGen().append(new AArch64ArithmeticOp.BinaryCompositeOp(op, result, x, y));
                break;
            }
            default: {
                this.getLIRGen().append(new AArch64ArithmeticOp.BinaryOp(op, result, x, y));
            }
        }
    }

    private void emitBinaryConst(Variable result, AArch64ArithmeticOp op, AllocatableValue a, JavaConstant b) {
        AllocatableValue x = this.moveSp(a);
        this.getLIRGen().append(new AArch64ArithmeticOp.BinaryConstOp(op, result, x, b));
    }

    private static boolean isValidBinaryConstant(AArch64ArithmeticOp op, Value a, Value b) {
        if (!LIRValueUtil.isJavaConstant(b)) {
            return false;
        }
        JavaConstant constValue = LIRValueUtil.asJavaConstant(b);
        switch (op.category) {
            case LOGICAL: {
                return AArch64ArithmeticLIRGenerator.isLogicalConstant(constValue);
            }
            case ARITHMETIC: {
                return AArch64ArithmeticLIRGenerator.isArithmeticConstant(constValue);
            }
            case SHIFT: {
                assert (constValue.asLong() >= 0L && constValue.asLong() < (long)(a.getPlatformKind().getSizeInBytes() * 8));
                return true;
            }
            case NONE: {
                return false;
            }
        }
        throw GraalError.shouldNotReachHere();
    }

    private static boolean isLogicalConstant(JavaConstant constValue) {
        switch (constValue.getJavaKind()) {
            case Int: {
                return AArch64MacroAssembler.isLogicalImmediate(constValue.asInt());
            }
            case Long: {
                return AArch64MacroAssembler.isLogicalImmediate(constValue.asLong());
            }
        }
        return false;
    }

    protected static boolean isArithmeticConstant(JavaConstant constValue) {
        switch (constValue.getJavaKind()) {
            case Int: 
            case Long: {
                return AArch64MacroAssembler.isArithmeticImmediate(constValue.asLong());
            }
            case Object: {
                return constValue.isNull();
            }
        }
        return false;
    }

    @Override
    public Value emitNegate(Value inputVal) {
        return this.emitUnary(this.getOpCode(inputVal, AArch64ArithmeticOp.NEG, AArch64ArithmeticOp.FNEG), inputVal);
    }

    @Override
    public Value emitNot(Value input) {
        assert (this.isNumericInteger(input.getPlatformKind()));
        return this.emitUnary(AArch64ArithmeticOp.NOT, input);
    }

    @Override
    public Value emitMathAbs(Value input) {
        return this.emitUnary(this.getOpCode(input, AArch64ArithmeticOp.ABS, AArch64ArithmeticOp.FABS), input);
    }

    @Override
    public Value emitMathSqrt(Value input) {
        assert (input.getPlatformKind() == AArch64Kind.DOUBLE);
        return this.emitUnary(AArch64ArithmeticOp.SQRT, input);
    }

    public Variable emitBitScanForward(Value value) {
        throw GraalError.unimplemented();
    }

    @Override
    public Value emitBitCount(Value operand) {
        assert (((AArch64Kind)operand.getPlatformKind()).isInteger());
        Variable result = this.getLIRGen().newVariable(LIRKind.combine(operand).changeType((PlatformKind)AArch64Kind.DWORD));
        this.getLIRGen().append(new AArch64BitManipulationOp(this.getLIRGen(), AArch64BitManipulationOp.BitManipulationOpCode.POPCNT, result, this.asAllocatable(operand)));
        return result;
    }

    @Override
    public Value emitBitScanReverse(Value value) {
        Variable result = this.getLIRGen().newVariable(LIRKind.combine(value).changeType((PlatformKind)AArch64Kind.DWORD));
        this.getLIRGen().append(new AArch64BitManipulationOp(this.getLIRGen(), AArch64BitManipulationOp.BitManipulationOpCode.BSR, result, this.asAllocatable(value)));
        return result;
    }

    @Override
    public Value emitFusedMultiplyAdd(Value a, Value b, Value c) {
        return this.emitMultiplyAddSub(AArch64ArithmeticOp.FMADD, a, b, c);
    }

    @Override
    public Value emitCountLeadingZeros(Value value) {
        Variable result = this.getLIRGen().newVariable(LIRKind.combine(value).changeType((PlatformKind)AArch64Kind.DWORD));
        this.getLIRGen().append(new AArch64BitManipulationOp(this.getLIRGen(), AArch64BitManipulationOp.BitManipulationOpCode.CLZ, result, this.asAllocatable(value)));
        return result;
    }

    @Override
    public Value emitCountTrailingZeros(Value value) {
        Variable result = this.getLIRGen().newVariable(LIRKind.combine(value).changeType((PlatformKind)AArch64Kind.DWORD));
        this.getLIRGen().append(new AArch64BitManipulationOp(this.getLIRGen(), AArch64BitManipulationOp.BitManipulationOpCode.CTZ, result, this.asAllocatable(value)));
        return result;
    }

    private Variable emitUnary(AArch64ArithmeticOp op, Value inputVal) {
        AllocatableValue input = this.asAllocatable(inputVal);
        Variable result = this.getLIRGen().newVariable(LIRKind.combine(new Value[]{input}));
        this.getLIRGen().append(new AArch64ArithmeticOp.UnaryOp(op, result, input));
        return result;
    }

    private AllocatableValue moveSp(AllocatableValue val) {
        return this.getLIRGen().moveSp(val);
    }

    private AArch64ArithmeticOp getOpCode(Value val, AArch64ArithmeticOp intOp, AArch64ArithmeticOp floatOp) {
        return this.isNumericInteger(val.getPlatformKind()) ? intOp : floatOp;
    }

    @Override
    public Variable emitLoad(LIRKind kind, Value address, LIRFrameState state) {
        AArch64AddressValue loadAddress = this.getLIRGen().asAddressValue(address);
        Variable result = this.getLIRGen().newVariable(this.getLIRGen().toRegisterKind(kind));
        this.getLIRGen().append(new AArch64Move.LoadOp((AArch64Kind)kind.getPlatformKind(), result, loadAddress, state));
        return result;
    }

    @Override
    public void emitStore(ValueKind<?> lirKind, Value address, Value inputVal, LIRFrameState state) {
        JavaConstant c;
        AArch64AddressValue storeAddress = this.getLIRGen().asAddressValue(address);
        AArch64Kind kind = (AArch64Kind)lirKind.getPlatformKind();
        if (LIRValueUtil.isJavaConstant(inputVal) && kind.isInteger() && (c = LIRValueUtil.asJavaConstant(inputVal)).isDefaultForKind()) {
            this.getLIRGen().append(new AArch64Move.StoreConstantOp(kind, storeAddress, c, state));
            return;
        }
        AllocatableValue input = this.asAllocatable(inputVal);
        this.getLIRGen().append(new AArch64Move.StoreOp(kind, storeAddress, input, state));
    }

    @Override
    public Value emitRound(Value value, AArch64ArithmeticLIRGeneratorTool.RoundingMode mode) {
        AArch64ArithmeticOp op;
        switch (mode) {
            case NEAREST: {
                op = AArch64ArithmeticOp.FRINTN;
                break;
            }
            case UP: {
                op = AArch64ArithmeticOp.FRINTP;
                break;
            }
            case DOWN: {
                op = AArch64ArithmeticOp.FRINTM;
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere();
            }
        }
        return this.emitUnary(op, value);
    }
}

