/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.layers;

import java.beans.PropertyVetoException;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.Stamps;
import org.netbeans.core.startup.layers.LayerCacheManager;
import org.netbeans.core.startup.preferences.RelPaths;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.BaseUtilities;
import org.openide.util.Enumerations;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openide.util.io.NbObjectInputStream;

final class BinaryFS
extends FileSystem
implements DataInput {
    static final Logger LOG = Logger.getLogger(BinaryFS.class.getName());
    static final byte[] MAGIC = "org.netbeans.core.projects.cache.BinaryV6".getBytes();
    static final FileObject[] NO_CHILDREN = new FileObject[0];
    String binaryFile;
    ByteBuffer content;
    private FileObject root;
    private final List<String> urls;
    private final List<Long> modifications;
    private final Date lastModified = new Date(Stamps.getModulesJARs().lastModified());
    private final Map<Integer, String> texts;
    private final ByteBuffer strings;

    private void _setSystemName(String string) throws PropertyVetoException {
        this.setSystemName(string);
    }

    public BinaryFS(String string, ByteBuffer byteBuffer) throws IOException {
        try {
            this._setSystemName("BinaryFS" + string.replace('/', '-').replace(File.separatorChar, '-'));
        }
        catch (PropertyVetoException propertyVetoException) {
            throw new IOException(propertyVetoException);
        }
        LayerCacheManager.err.log(Level.FINE, "Reading {0} buffer: {1}", new Object[]{string, byteBuffer.limit()});
        this.binaryFile = string;
        byte[] byArray = new byte[MAGIC.length];
        byteBuffer.get(byArray);
        if (!Arrays.equals(byArray, MAGIC)) {
            throw new IOException("Bad magic header: " + new String(byArray));
        }
        long l = byteBuffer.getInt();
        if ((long)byteBuffer.limit() != l) {
            throw new IOException("Corrupted image, correct length=" + l + ", found=" + byteBuffer.limit());
        }
        LayerCacheManager.err.log(Level.FINER, "Stored Len OK: {0}", l);
        int n = byteBuffer.getInt();
        this.texts = new HashMap<Integer, String>();
        this.strings = byteBuffer.slice().asReadOnlyBuffer();
        byteBuffer.position(byteBuffer.position() + n);
        int n2 = byteBuffer.getInt() + 8 + MAGIC.length + n + 4;
        this.urls = new ArrayList<String>();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (byteBuffer.position() < n2) {
            this.urls.add(BinaryFS.toAbsoluteURL(this.getString(byteBuffer)));
            arrayList.add(null);
        }
        this.modifications = Collections.synchronizedList(arrayList);
        this.content = byteBuffer.slice().order(ByteOrder.LITTLE_ENDIAN);
        LayerCacheManager.err.log(Level.FINER, "Reading root");
        this.root = new BFSFolder("", null, 0);
        LayerCacheManager.err.log(Level.FINER, "Root ready: {0}", this.root);
    }

    public FileObject findResource(String string) {
        String string2;
        FileObject fileObject;
        if (string.length() == 0) {
            return this.root;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        for (fileObject = this.root; fileObject != null && stringTokenizer.hasMoreTokens(); fileObject = fileObject.getFileObject(string2, null)) {
            string2 = stringTokenizer.nextToken();
        }
        return fileObject;
    }

    public String getDisplayName() {
        return "BinaryFS[" + this.binaryFile + "]";
    }

    public FileObject getRoot() {
        return this.root;
    }

    public boolean isReadOnly() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final String getString(ByteBuffer byteBuffer) throws IOException {
        ByteBuffer byteBuffer2 = this.strings;
        synchronized (byteBuffer2) {
            int n = byteBuffer.getInt();
            String string = this.texts.get(n);
            if (string != null) {
                return string;
            }
            this.strings.position(n);
            String string2 = DataInputStream.readUTF(this);
            this.texts.put(n, string2);
            return string2;
        }
    }

    private static String toAbsoluteURL(String string) {
        if (string.startsWith("home@")) {
            return BinaryFS.toJarURI(System.getProperty("netbeans.home")) + string.substring(5);
        }
        if (string.startsWith("user@")) {
            return BinaryFS.toJarURI(System.getProperty("netbeans.user")) + string.substring(5);
        }
        if (string.startsWith("abs@")) {
            return "jar:file:" + string.substring(4);
        }
        int n = string.indexOf(64);
        if (n == -1) {
            return string;
        }
        int n2 = Integer.parseInt(string.substring(0, n));
        return BinaryFS.toJarURI(RelPaths.cluster(n2)) + string.substring(n + 1);
    }

    private static String toJarURI(String string) {
        class DirFile
        extends File {
            public DirFile(String string) {
                super(string);
            }

            @Override
            public boolean isDirectory() {
                return true;
            }

            @Override
            public boolean isFile() {
                return false;
            }

            @Override
            public File getAbsoluteFile() {
                return this;
            }
        }
        String string2 = "jar:" + BaseUtilities.toURI((File)new DirFile(string)).toString();
        assert (!string2.contains("//")) : string2;
        return string2;
    }

    @Override
    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        Thread.holdsLock(this.strings);
        this.strings.get(byArray, n, n2);
    }

    @Override
    public int readUnsignedShort() throws IOException {
        int n;
        Thread.holdsLock(this.strings);
        int n2 = this.strings.get();
        if (n2 < 0) {
            n2 += 256;
        }
        if ((n = this.strings.get()) < 0) {
            n += 256;
        }
        return (n2 << 8) + n;
    }

    @Override
    public void readFully(byte[] byArray) throws IOException {
        throw new IOException();
    }

    @Override
    public int skipBytes(int n) throws IOException {
        throw new IOException();
    }

    @Override
    public boolean readBoolean() throws IOException {
        throw new IOException();
    }

    @Override
    public byte readByte() throws IOException {
        throw new IOException();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        throw new IOException();
    }

    @Override
    public short readShort() throws IOException {
        throw new IOException();
    }

    @Override
    public char readChar() throws IOException {
        throw new IOException();
    }

    @Override
    public int readInt() throws IOException {
        throw new IOException();
    }

    @Override
    public long readLong() throws IOException {
        throw new IOException();
    }

    @Override
    public float readFloat() throws IOException {
        throw new IOException();
    }

    @Override
    public double readDouble() throws IOException {
        throw new IOException();
    }

    @Override
    public String readLine() throws IOException {
        throw new IOException();
    }

    @Override
    public String readUTF() throws IOException {
        throw new IOException();
    }

    static final Map wrapToMap(FileObject fileObject) {
        return fileObject == null ? Collections.emptyMap() : new FileMap(fileObject);
    }

    private static final class FOEntry
    implements Map.Entry<String, Object> {
        private FileObject fo;
        private String attr;

        private FOEntry(FileObject fileObject, String string) {
            this.fo = fileObject;
            this.attr = string;
        }

        @Override
        public String getKey() {
            return this.attr;
        }

        @Override
        public Object getValue() {
            return this.fo.getAttribute(this.attr);
        }

        @Override
        public Object setValue(Object object) {
            throw new UnsupportedOperationException();
        }
    }

    private static final class AttrFileSet
    extends AbstractSet<Map.Entry<String, Object>> {
        private FileObject fo;

        private AttrFileSet(FileObject fileObject) {
            this.fo = fileObject;
        }

        @Override
        public Iterator<Map.Entry<String, Object>> iterator() {
            class Iter
            implements Iterator<Map.Entry<String, Object>> {
                Enumeration<String> attrs;

                Iter() {
                    this.attrs = AttrFileSet.this.fo.getAttributes();
                }

                @Override
                public boolean hasNext() {
                    return this.attrs.hasMoreElements();
                }

                @Override
                public Map.Entry<String, Object> next() {
                    String string = this.attrs.nextElement();
                    return new FOEntry(AttrFileSet.this.fo, string);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            }
            return new Iter();
        }

        @Override
        public int size() {
            Enumeration enumeration = this.fo.getAttributes();
            int n = 0;
            while (enumeration.hasMoreElements()) {
                ++n;
                enumeration.nextElement();
            }
            return n;
        }

        @Override
        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }
    }

    private static final class FileMap
    extends AbstractMap<String, Object> {
        private FileObject fo;

        private FileMap(FileObject fileObject) {
            this.fo = fileObject;
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return new AttrFileSet(this.fo);
        }

        @Override
        public Object get(Object object) {
            if (object == FileObject.class) {
                return this.fo;
            }
            return object instanceof String ? this.fo.getAttribute((String)object) : null;
        }

        @Override
        public Object remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object put(String string, Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof Map)) {
                return false;
            }
            Object v = ((Map)object).get(FileObject.class);
            if (v != null) {
                return this.fo.equals(v);
            }
            return object.equals(this);
        }

        @Override
        public int hashCode() {
            int n = 7;
            n = 37 * n + (this.fo != null ? this.fo.hashCode() : 0);
            return n;
        }

        @Override
        public String toString() {
            return "BinaryFileMap@" + Integer.toHexString(System.identityHashCode(this)) + "{fo=" + this.fo + '}';
        }
    }

    private class BFSFolder
    extends BFSBase {
        Map<String, BFSBase> childrenMap;

        public BFSFolder(String string, FileObject fileObject, int n) {
            super(string, fileObject, n);
            this.childrenMap = Collections.emptyMap();
        }

        public boolean isData() {
            return false;
        }

        public boolean isFolder() {
            return true;
        }

        public long getSize() {
            return 0L;
        }

        public InputStream getInputStream() throws FileNotFoundException {
            throw new FileNotFoundException("Is a directory: " + (Object)((Object)this));
        }

        public FileObject[] getChildren() {
            this.initialize();
            return this.childrenMap.values().toArray(NO_CHILDREN);
        }

        public FileObject getFileObject(String string, String string2) {
            if ("..".equals(string) && string2 == null) {
                return this.getParent();
            }
            this.initialize();
            String string3 = string2 == null ? string : string + "." + string2;
            return this.childrenMap.get(string3);
        }

        @Override
        protected void doInitialize(ByteBuffer byteBuffer) throws Exception {
            int n = byteBuffer.getInt();
            if (n > 0) {
                HashMap<String, BFSBase> hashMap = new HashMap<String, BFSBase>(n * 4 / 3 + 1);
                for (int i = 0; i < n; ++i) {
                    String string = BinaryFS.this.getString(byteBuffer);
                    byte by = byteBuffer.get();
                    int n2 = byteBuffer.getInt();
                    hashMap.put(string, by == 0 ? new BFSFile(string, this, n2) : new BFSFolder(string, this, n2));
                }
                this.childrenMap = hashMap;
                if (LayerCacheManager.err.isLoggable(Level.FINEST)) {
                    LayerCacheManager.err.log(Level.FINEST, "  children for " + this.getPath() + " are: " + this.childrenMap.keySet());
                }
            }
        }

        @Override
        protected boolean specificEquals(BFSBase bFSBase) {
            if (!(bFSBase instanceof BFSFolder)) {
                return false;
            }
            BFSFolder bFSFolder = (BFSFolder)bFSBase;
            this.initialize();
            return this.childrenMap.equals(bFSFolder.childrenMap);
        }
    }

    final class BFSFile
    extends BFSBase {
        private int len;
        private int size;
        private int contentOffset;
        private String uri;

        public BFSFile(String string, FileObject fileObject, int n) {
            super(string, fileObject, n);
            this.size = -1;
        }

        public FileObject[] getChildren() {
            return NO_CHILDREN;
        }

        public FileObject getFileObject(String string, String string2) {
            return null;
        }

        public boolean isData() {
            return true;
        }

        public boolean isFolder() {
            return false;
        }

        private byte[] data() throws IOException {
            if (this.len == -1) {
                throw new IllegalArgumentException();
            }
            byte[] byArray = new byte[this.len];
            ((ByteBuffer)BinaryFS.this.content.duplicate().position(this.contentOffset)).get(byArray);
            return byArray;
        }

        public InputStream getInputStream() throws FileNotFoundException {
            this.initialize();
            try {
                return this.len == -1 ? new URL(this.uri).openConnection().getInputStream() : new ByteArrayInputStream(this.data());
            }
            catch (Exception exception) {
                throw (FileNotFoundException)new FileNotFoundException("Cannot find '" + this.uri + "'").initCause(exception);
            }
        }

        public long getSize() {
            this.initialize();
            try {
                if (this.len == -1) {
                    if (this.size == -1) {
                        this.size = new URL(this.uri).openConnection().getContentLength();
                    }
                    return this.size;
                }
                return this.len;
            }
            catch (Exception exception) {
                System.err.println("exception in getSize() on " + this.name + ": " + exception);
                return 0L;
            }
        }

        @Override
        public Date lastModified() {
            this.initialize();
            try {
                long l;
                int n = -1;
                URLConnection uRLConnection = null;
                if (this.len == -1) {
                    if (this.uri.startsWith("jar:")) {
                        return super.lastModified();
                    }
                    uRLConnection = new URL(this.uri).openConnection();
                } else {
                    String string;
                    ByteBuffer byteBuffer = (ByteBuffer)BinaryFS.this.content.duplicate().order(ByteOrder.LITTLE_ENDIAN).position(this.offset);
                    n = byteBuffer.getInt();
                    if (n <= -10) {
                        n = -(n + 10);
                    }
                    if ((string = (String)BinaryFS.this.urls.get(n)).startsWith("jar:")) {
                        return super.lastModified();
                    }
                    Long l2 = (Long)BinaryFS.this.modifications.get(n);
                    if (l2 != null) {
                        return new Date(l2);
                    }
                    uRLConnection = new URL(string).openConnection();
                }
                if (uRLConnection != null && (l = uRLConnection.getLastModified()) > 0L) {
                    if (n >= 0) {
                        BinaryFS.this.modifications.set(n, l);
                    }
                    return new Date(l);
                }
            }
            catch (Exception exception) {
                LOG.log(Level.WARNING, null, exception);
            }
            return super.lastModified();
        }

        @Override
        protected void doInitialize(ByteBuffer byteBuffer) throws Exception {
            this.len = byteBuffer.getInt();
            this.contentOffset = byteBuffer.position();
            if (this.len == -1) {
                this.uri = BinaryFS.toAbsoluteURL(BinaryFS.this.getString(byteBuffer));
            } else {
                byteBuffer.position(this.contentOffset + this.len);
            }
        }

        @Override
        protected boolean specificEquals(BFSBase bFSBase) {
            if (!(bFSBase instanceof BFSFile)) {
                return false;
            }
            BFSFile bFSFile = (BFSFile)bFSBase;
            this.initialize();
            bFSFile.initialize();
            if (this.len == -1 && bFSFile.len == -1) {
                return this.uri.equals(bFSFile.uri);
            }
            if (this.len != -1 && bFSFile.len != -1) {
                byte[] byArray;
                byte[] byArray2;
                try {
                    byArray2 = this.data();
                    byArray = bFSFile.data();
                }
                catch (IOException iOException) {
                    return false;
                }
                if (byArray2.length != byArray.length) {
                    return false;
                }
                for (int i = 0; i < byArray2.length; ++i) {
                    if (byArray2[i] == byArray[i]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    static final class AttrImpl {
        private int index;
        private String value;
        private static final Set<String> notified = Collections.synchronizedSet(new HashSet());

        AttrImpl(int n, String string) {
            this.index = n;
            this.value = string;
        }

        public boolean equals(Object object) {
            if (object instanceof AttrImpl) {
                AttrImpl attrImpl = (AttrImpl)object;
                return this.index == attrImpl.index && this.value.equals(attrImpl.value);
            }
            return false;
        }

        public int hashCode() {
            return 2343 + this.index + this.value.hashCode();
        }

        public Object getValue(BFSBase bFSBase, String string) {
            try {
                switch (this.index) {
                    case 0: {
                        return Byte.valueOf(this.value);
                    }
                    case 1: {
                        return Short.valueOf(this.value);
                    }
                    case 2: {
                        return Integer.valueOf(this.value);
                    }
                    case 3: {
                        return Long.valueOf(this.value);
                    }
                    case 4: {
                        return Float.valueOf(this.value);
                    }
                    case 5: {
                        return Double.valueOf(this.value);
                    }
                    case 6: {
                        return Boolean.valueOf(this.value);
                    }
                    case 7: {
                        if (this.value.trim().length() != 1) break;
                        return Character.valueOf(this.value.charAt(0));
                    }
                    case 8: {
                        return this.value;
                    }
                    case 9: {
                        return new URL(this.value);
                    }
                    case 10: {
                        return this.methodValue(this.value, bFSBase, string).invoke();
                    }
                    case 11: {
                        Class clazz = this.findClass(this.value);
                        if (SharedClassObject.class.isAssignableFrom(clazz)) {
                            return SharedClassObject.findObject(clazz.asSubclass(SharedClassObject.class), (boolean)true);
                        }
                        Constructor constructor = clazz.getDeclaredConstructor(new Class[0]);
                        constructor.setAccessible(true);
                        return constructor.newInstance(null);
                    }
                    case 12: {
                        return this.decodeValue(this.value);
                    }
                    case 13: {
                        String[] stringArray = this.value.split("#", 2);
                        return NbBundle.getBundle((String)stringArray[0]).getObject(stringArray[1]);
                    }
                    default: {
                        throw new IllegalStateException("Bad index: " + this.index);
                    }
                }
            }
            catch (Exception exception) {
                LOG.log(notified.add(bFSBase.getPath()) ? Level.INFO : Level.FINE, "value = " + this.value + " from " + bFSBase.getPath(), exception);
            }
            return null;
        }

        public Class<?> getType(BFSBase bFSBase) {
            try {
                switch (this.index) {
                    case 0: {
                        return Byte.class;
                    }
                    case 1: {
                        return Short.class;
                    }
                    case 2: {
                        return Integer.class;
                    }
                    case 3: {
                        return Long.class;
                    }
                    case 4: {
                        return Float.class;
                    }
                    case 5: {
                        return Double.class;
                    }
                    case 6: {
                        return Boolean.class;
                    }
                    case 7: {
                        return Character.class;
                    }
                    case 8: {
                        return String.class;
                    }
                    case 9: {
                        return URL.class;
                    }
                    case 10: {
                        return this.methodValue(this.value, bFSBase, null).getMethod().getReturnType();
                    }
                    case 11: {
                        return this.findClass(this.value);
                    }
                    case 12: {
                        return null;
                    }
                    case 13: {
                        return String.class;
                    }
                }
                throw new IllegalStateException("Bad index: " + this.index);
            }
            catch (Exception exception) {
                Exceptions.attachMessage((Throwable)exception, (String)("value = " + this.value + " from " + bFSBase.getPath()));
                LOG.log(notified.add(bFSBase.getPath()) ? Level.INFO : Level.FINE, null, exception);
                return null;
            }
        }

        private MethodAndParams methodValue(String string, BFSBase bFSBase, String string2) throws Exception {
            int n = string.lastIndexOf(46);
            if (n != -1) {
                Class[][] classArrayArray;
                Class clazz = this.findClass(string.substring(0, n));
                String string3 = string.substring(n + 1);
                for (Class[] classArray : classArrayArray = new Class[][]{{FileObject.class, String.class}, {String.class, FileObject.class}, {FileObject.class}, {String.class}, new Class[0], {Map.class, String.class}, {Map.class}}) {
                    Method method;
                    try {
                        method = clazz.getDeclaredMethod(string3, classArray);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        continue;
                    }
                    Object[] objectArray = new Object[classArray.length];
                    for (int i = 0; i < classArray.length; ++i) {
                        if (classArray[i] == FileObject.class) {
                            objectArray[i] = bFSBase.getFileObjectForAttr();
                            continue;
                        }
                        if (classArray[i] == String.class) {
                            objectArray[i] = string2;
                            continue;
                        }
                        assert (classArray[i] == Map.class);
                        objectArray[i] = BinaryFS.wrapToMap(bFSBase.getFileObjectForAttr());
                    }
                    return new MethodAndParams(method, objectArray);
                }
            }
            throw new InstantiationException(string);
        }

        private Object decodeValue(String string) throws Exception {
            if (string == null || string.length() == 0) {
                return null;
            }
            byte[] byArray = new byte[string.length() / 2];
            int n = 0;
            for (int i = 0; i < string.length(); i += 2) {
                int n2 = Integer.parseInt(string.substring(i, i + 2), 16);
                if (n2 > 127) {
                    n2 -= 256;
                }
                byArray[n++] = (byte)n2;
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, 0, n);
            return new NbObjectInputStream((InputStream)byteArrayInputStream).readObject();
        }

        private Class findClass(String string) throws ClassNotFoundException {
            ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            String string2 = BaseUtilities.translate((String)string);
            try {
                if (classLoader == null) {
                    return Class.forName(string2);
                }
                return Class.forName(string2, true, classLoader);
            }
            catch (LinkageError linkageError) {
                throw new ClassNotFoundException("Cannot read " + string, linkageError);
            }
        }

        private static class MethodAndParams {
            private Method method;
            private Object[] params;

            MethodAndParams(Method method, Object[] objectArray) {
                this.method = method;
                this.params = objectArray;
            }

            public Object invoke() throws Exception {
                this.method.setAccessible(true);
                return this.method.invoke(null, this.params);
            }

            public Method getMethod() {
                return this.method;
            }
        }
    }

    private abstract class BFSBase
    extends FileObject {
        private final FileObject parent;
        protected final String name;
        protected final int offset;
        private boolean initialized = false;
        private Map<String, AttrImpl> attrs = Collections.emptyMap();

        public BFSBase(String string, FileObject fileObject, int n) {
            this.name = string;
            this.parent = fileObject;
            this.offset = n;
        }

        public final boolean equals(Object object) {
            if (!(object instanceof BFSBase)) {
                return false;
            }
            if (object == this) {
                return true;
            }
            BFSBase bFSBase = (BFSBase)((Object)object);
            return bFSBase.getPath().equals(this.getPath()) && this.specificEquals(bFSBase) && this.attributeEquals(bFSBase);
        }

        private final boolean attributeEquals(BFSBase bFSBase) {
            this.initialize();
            bFSBase.initialize();
            return this.attrs.equals(bFSBase.attrs);
        }

        public final int hashCode() {
            return this.getPath().hashCode();
        }

        protected abstract boolean specificEquals(BFSBase var1);

        public void addFileChangeListener(FileChangeListener fileChangeListener) {
        }

        public void removeFileChangeListener(FileChangeListener fileChangeListener) {
        }

        @Deprecated
        public boolean isReadOnly() {
            return true;
        }

        @Deprecated
        public void setImportant(boolean bl) {
        }

        public FileObject createData(String string, String string2) throws IOException {
            throw new IOException();
        }

        public FileObject createFolder(String string) throws IOException {
            throw new IOException();
        }

        public void delete(FileLock fileLock) throws IOException {
            throw new IOException();
        }

        public OutputStream getOutputStream(FileLock fileLock) throws IOException {
            throw new IOException();
        }

        public FileLock lock() throws IOException {
            throw new IOException();
        }

        public void rename(FileLock fileLock, String string, String string2) throws IOException {
            throw new IOException();
        }

        public void setAttribute(String string, Object object) throws IOException {
            throw new IOException();
        }

        public FileSystem getFileSystem() {
            return BinaryFS.this;
        }

        public FileObject getParent() {
            return this.parent;
        }

        public boolean isRoot() {
            return this.parent == null;
        }

        public boolean isValid() {
            return true;
        }

        public Date lastModified() {
            return BinaryFS.this.lastModified;
        }

        public String getName() {
            int n = this.name.lastIndexOf(46);
            return n <= 0 ? this.name : this.name.substring(0, n);
        }

        public String getExt() {
            int n = this.name.lastIndexOf(46) + 1;
            return n <= 1 || n == this.name.length() ? "" : this.name.substring(n);
        }

        public String getNameExt() {
            return this.name;
        }

        public Object getAttribute(String string) {
            this.initialize();
            AttrImpl attrImpl = this.attrs.get(string);
            if (attrImpl == null && string.startsWith("class:")) {
                attrImpl = this.attrs.get(string.substring(6));
                return attrImpl == null ? null : attrImpl.getType(this);
            }
            if (attrImpl == null && string.startsWith("raw:")) {
                attrImpl = this.attrs.get(string.substring(4));
                try {
                    if (attrImpl != null && attrImpl.index == 10) {
                        return attrImpl.methodValue(attrImpl.value, this, string).getMethod();
                    }
                    if (attrImpl != null && attrImpl.index == 11) {
                        return attrImpl.getType(this);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
            if (attrImpl == null && string.equals("layers")) {
                return this.getLayersAttr();
            }
            return attrImpl != null ? attrImpl.getValue(this, string) : null;
        }

        public FileObject getFileObjectForAttr() {
            FileObject fileObject = null;
            try {
                Class<?> clazz = Class.forName("org.openide.filesystems.MultiFileObject");
                Field field = clazz.getDeclaredField("attrAskedFileObject");
                field.setAccessible(true);
                ThreadLocal threadLocal = (ThreadLocal)ThreadLocal.class.cast(field.get(null));
                fileObject = (FileObject)threadLocal.get();
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
            return fileObject == null ? this : fileObject;
        }

        public Enumeration<String> getAttributes() {
            this.initialize();
            if (this.attrs == null) {
                return Enumerations.empty();
            }
            return Collections.enumeration(this.attrs.keySet());
        }

        protected final void initialize() {
            if (this.initialized) {
                return;
            }
            try {
                int n;
                ByteBuffer byteBuffer = (ByteBuffer)BinaryFS.this.content.duplicate().order(ByteOrder.LITTLE_ENDIAN).position(this.offset);
                if (!this.isRoot()) {
                    while (byteBuffer.getInt() >= 0) {
                    }
                }
                if ((n = byteBuffer.getInt()) > 0) {
                    this.attrs = new HashMap<String, AttrImpl>(n * 4 / 3 + 1);
                }
                for (int i = 0; i < n; ++i) {
                    String string = BinaryFS.this.getString(byteBuffer);
                    byte by = byteBuffer.get();
                    String string2 = BinaryFS.this.getString(byteBuffer);
                    this.attrs.put(string, new AttrImpl(by, string2));
                }
                this.doInitialize(byteBuffer);
            }
            catch (Exception exception) {
                System.err.println("exception in initialize() on " + this.name + ": " + exception);
            }
            this.initialized = true;
        }

        protected abstract void doInitialize(ByteBuffer var1) throws Exception;

        private Object getLayersAttr() {
            ArrayList<URL> arrayList = new ArrayList<URL>();
            if (this.isRoot()) {
                for (String string : BinaryFS.this.urls) {
                    try {
                        arrayList.add(new URL(string));
                    }
                    catch (MalformedURLException malformedURLException) {
                        LOG.warning("Cannot create URL: " + string);
                    }
                }
            } else {
                ByteBuffer byteBuffer = (ByteBuffer)BinaryFS.this.content.duplicate().order(ByteOrder.LITTLE_ENDIAN).position(this.offset);
                boolean bl = true;
                while (bl) {
                    int n = byteBuffer.getInt();
                    if (n < 0) {
                        bl = false;
                    }
                    if (n <= -10) {
                        n = -(n + 10);
                    }
                    try {
                        arrayList.add(new URL((String)BinaryFS.this.urls.get(n)));
                    }
                    catch (MalformedURLException malformedURLException) {
                        LOG.warning("Cannot create URL: " + (String)BinaryFS.this.urls.get(n));
                    }
                }
            }
            return arrayList.toArray(new URL[arrayList.size()]);
        }
    }
}

