/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.Icon;

final class ScaledBitmapIcon
implements Icon {
    private final Map<Double, Image> cache = new ConcurrentHashMap<Double, Image>();
    private final Image sourceImage;
    private final int width;
    private final int height;

    public ScaledBitmapIcon(Image image, int n, int n2) {
        if (image == null) {
            throw new NullPointerException();
        }
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException();
        }
        this.sourceImage = image;
        this.width = n;
        this.height = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Image getScaledImage(GraphicsConfiguration graphicsConfiguration, double d) {
        Image image = this.cache.get(d);
        if (image != null) {
            return image;
        }
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage((int)Math.ceil((double)this.getIconWidth() * d), (int)Math.ceil((double)this.getIconHeight() * d), 3);
        double d2 = this.sourceImage.getWidth(null);
        double d3 = this.sourceImage.getHeight(null);
        if (d2 >= 1.0 && d3 >= 1.0) {
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            try {
                graphics2D.setTransform(AffineTransform.getScaleInstance(d * (double)this.getIconWidth() / d2, d * (double)this.getIconHeight() / d3));
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                graphics2D.drawImage(this.sourceImage, 0, 0, null);
            }
            finally {
                graphics2D.dispose();
            }
            if (d <= 3.0) {
                this.cache.put(d, bufferedImage);
            }
        }
        return bufferedImage;
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.translate(n, n2);
        AffineTransform affineTransform2 = graphics2D.getTransform();
        int n3 = affineTransform2.getType();
        double d = n3 == 2 || n3 == 3 ? affineTransform2.getScaleX() : 1.0;
        Image image = this.getScaledImage(graphics2D.getDeviceConfiguration(), d);
        if (d != 1.0) {
            AffineTransform affineTransform3 = graphics2D.getTransform();
            graphics2D.setTransform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, (int)affineTransform3.getTranslateX(), (int)affineTransform3.getTranslateY()));
        }
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.setTransform(affineTransform);
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }
}

