/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.views.recording;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeNode;
import org.graalvm.visualvm.core.ui.components.DataViewComponent;
import org.graalvm.visualvm.jfr.JFRSnapshot;
import org.graalvm.visualvm.jfr.model.JFREvent;
import org.graalvm.visualvm.jfr.model.JFREventVisitor;
import org.graalvm.visualvm.jfr.model.JFRModel;
import org.graalvm.visualvm.jfr.model.JFRPropertyNotAvailableException;
import org.graalvm.visualvm.jfr.utils.InstantFormatter;
import org.graalvm.visualvm.jfr.utils.ValuesConverter;
import org.graalvm.visualvm.jfr.views.components.MessageComponent;
import org.graalvm.visualvm.jfr.views.recording.RecordingNode;
import org.graalvm.visualvm.jfr.views.recording.RecordingRenderers;
import org.graalvm.visualvm.lib.ui.components.HTMLTextArea;
import org.graalvm.visualvm.lib.ui.swing.ProfilerTable;
import org.graalvm.visualvm.lib.ui.swing.ProfilerTableContainer;
import org.graalvm.visualvm.lib.ui.swing.ProfilerTreeTable;
import org.graalvm.visualvm.lib.ui.swing.ProfilerTreeTableModel;
import org.graalvm.visualvm.lib.ui.swing.renderer.ProfilerRenderer;
import org.openide.util.NbBundle;

class RecordingViewSupport {
    RecordingViewSupport() {
    }

    static class RecordingsSupport
    extends JPanel
    implements JFREventVisitor {
        private final JFRModel jfrModel;
        private Record[] records;
        private Set<Record> cache;
        private DataModel model;
        private ProfilerTable table;

        RecordingsSupport(JFRModel jfrModel) {
            this.jfrModel = jfrModel;
            this.initComponents();
        }

        DataViewComponent.DetailsView getDetailsView() {
            return new DataViewComponent.DetailsView("Concurrent recordings", null, 10, (JComponent)this, null);
        }

        @Override
        public void init() {
            Record progress = new Record();
            progress.name = "reading data...";
            this.records = new Record[]{progress};
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    model.fireTableDataChanged();
                }
            });
            this.cache = new HashSet<Record>();
        }

        @Override
        public boolean visit(String typeName, JFREvent event) {
            if ("jdk.ActiveRecording".equals(typeName)) {
                try {
                    Record record = new Record();
                    record.name = event.getString("name");
                    record.id = event.getLong("id");
                    record.start = ValuesConverter.instantToRelativeNanos(event.getInstant("recordingStart"), this.jfrModel);
                    record.duration = event.getDuration("recordingDuration");
                    record.maxAge = event.getDuration("maxAge");
                    record.maxSize = event.getLong("maxSize");
                    record.destination = event.getString("destination");
                    if (record.destination == null) {
                        record.destination = "-";
                    }
                    this.cache.add(record);
                }
                catch (JFRPropertyNotAvailableException jFRPropertyNotAvailableException) {
                    // empty catch block
                }
            }
            return false;
        }

        @Override
        public void done() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (cache.isEmpty()) {
                        Record noData = new Record();
                        noData.name = "<no recordings>";
                        cache.add(noData);
                    }
                    RecordingsSupport.access$402(this, cache.toArray(new Record[0]));
                    model.fireTableDataChanged();
                    cache.clear();
                    cache = null;
                }
            });
        }

        private void initComponents() {
            this.model = new DataModel();
            this.table = new ProfilerTable((TableModel)this.model, true, true, null);
            this.table.setMainColumn(0);
            this.table.setFitWidthColumn(0);
            this.table.setDefaultSortOrder(SortOrder.ASCENDING);
            this.table.setSortColumn(1);
            RecordingRenderers.NameRenderer nameRenderer = new RecordingRenderers.NameRenderer();
            this.table.setColumnRenderer(0, (ProfilerRenderer)nameRenderer);
            RecordingRenderers.IdRenderer idRenderer = new RecordingRenderers.IdRenderer();
            this.table.setColumnRenderer(1, (ProfilerRenderer)idRenderer);
            this.table.setDefaultColumnWidth(1, idRenderer.getPreferredWidth());
            this.table.setColumnVisibility(1, RecordingRenderers.IdRenderer.isInitiallyVisible());
            RecordingRenderers.StartRenderer startRenderer = new RecordingRenderers.StartRenderer(this.jfrModel);
            this.table.setColumnRenderer(2, (ProfilerRenderer)startRenderer);
            this.table.setDefaultColumnWidth(2, startRenderer.getPreferredWidth());
            this.table.setColumnVisibility(2, RecordingRenderers.TimeRenderer.isInitiallyVisible());
            RecordingRenderers.DurationRenderer durationRenderer = new RecordingRenderers.DurationRenderer();
            RecordingRenderers.SizeRenderer sizeRenderer = new RecordingRenderers.SizeRenderer();
            RecordingRenderers.AgeRenderer ageRenderer = new RecordingRenderers.AgeRenderer();
            int commonWidth = Math.max(durationRenderer.getPreferredWidth(), sizeRenderer.getPreferredWidth());
            commonWidth = Math.max(commonWidth, ageRenderer.getPreferredWidth());
            this.table.setColumnRenderer(3, (ProfilerRenderer)durationRenderer);
            this.table.setDefaultColumnWidth(3, commonWidth);
            this.table.setColumnVisibility(3, RecordingRenderers.DurationRenderer.isInitiallyVisible());
            this.table.setColumnRenderer(4, (ProfilerRenderer)sizeRenderer);
            this.table.setDefaultColumnWidth(4, commonWidth);
            this.table.setColumnVisibility(4, RecordingRenderers.SizeRenderer.isInitiallyVisible());
            this.table.setColumnRenderer(5, (ProfilerRenderer)ageRenderer);
            this.table.setDefaultColumnWidth(5, commonWidth);
            this.table.setColumnVisibility(5, RecordingRenderers.AgeRenderer.isInitiallyVisible());
            RecordingRenderers.DestinationRenderer destinationRenderer = new RecordingRenderers.DestinationRenderer();
            this.table.setColumnRenderer(6, (ProfilerRenderer)destinationRenderer);
            this.table.setDefaultColumnWidth(6, destinationRenderer.getPreferredWidth());
            this.table.setColumnVisibility(6, RecordingRenderers.DestinationRenderer.isInitiallyVisible());
            this.setLayout(new BorderLayout());
            this.add((Component)new ProfilerTableContainer(this.table, false, null), "Center");
        }

        static /* synthetic */ Record[] access$402(RecordingsSupport x0, Record[] x1) {
            x0.records = x1;
            return x1;
        }

        private class DataModel
        extends AbstractTableModel {
            private DataModel() {
            }

            @Override
            public int getColumnCount() {
                return 7;
            }

            @Override
            public String getColumnName(int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return RecordingRenderers.NameRenderer.getDisplayName();
                    }
                    case 1: {
                        return RecordingRenderers.IdRenderer.getDisplayName();
                    }
                    case 2: {
                        return RecordingRenderers.StartRenderer.getDisplayName();
                    }
                    case 3: {
                        return RecordingRenderers.DurationRenderer.getDisplayName();
                    }
                    case 4: {
                        return RecordingRenderers.SizeRenderer.getDisplayName();
                    }
                    case 5: {
                        return RecordingRenderers.AgeRenderer.getDisplayName();
                    }
                    case 6: {
                        return RecordingRenderers.DestinationRenderer.getDisplayName();
                    }
                }
                return null;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return String.class;
                    }
                    case 1: {
                        return Long.class;
                    }
                    case 2: {
                        return Long.class;
                    }
                    case 3: {
                        return Duration.class;
                    }
                    case 4: {
                        return Long.class;
                    }
                    case 5: {
                        return Duration.class;
                    }
                    case 6: {
                        return String.class;
                    }
                }
                return null;
            }

            @Override
            public int getRowCount() {
                return RecordingsSupport.this.records == null ? 0 : RecordingsSupport.this.records.length;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return ((RecordingsSupport)RecordingsSupport.this).records[rowIndex].name;
                    }
                    case 1: {
                        return ((RecordingsSupport)RecordingsSupport.this).records[rowIndex].id;
                    }
                    case 2: {
                        return ((RecordingsSupport)RecordingsSupport.this).records[rowIndex].start;
                    }
                    case 3: {
                        return ((RecordingsSupport)RecordingsSupport.this).records[rowIndex].duration;
                    }
                    case 4: {
                        return ((RecordingsSupport)RecordingsSupport.this).records[rowIndex].maxSize;
                    }
                    case 5: {
                        return ((RecordingsSupport)RecordingsSupport.this).records[rowIndex].maxAge;
                    }
                    case 6: {
                        return ((RecordingsSupport)RecordingsSupport.this).records[rowIndex].destination;
                    }
                }
                return null;
            }
        }

        private static class Record {
            String name;
            long id = -1L;
            long start = Long.MIN_VALUE;
            Duration duration;
            long maxSize = -1L;
            Duration maxAge;
            String destination;

            private Record() {
            }

            public int hashCode() {
                return Objects.hash(this.name, this.id, this.start, this.duration, this.maxSize, this.maxAge, this.destination);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null) {
                    return false;
                }
                if (!(o instanceof Record)) {
                    return false;
                }
                Record r = (Record)o;
                if (this.id != r.id) {
                    return false;
                }
                if (this.start != r.start) {
                    return false;
                }
                if (!Objects.equals(this.duration, r.duration)) {
                    return false;
                }
                if (this.maxSize != r.maxSize) {
                    return false;
                }
                if (!Objects.equals(this.maxAge, r.maxAge)) {
                    return false;
                }
                if (!Objects.equals(this.name, r.name)) {
                    return false;
                }
                return Objects.equals(this.destination, r.destination);
            }
        }
    }

    static class SettingsSupport
    extends JPanel {
        private final JFRModel jfrModel;
        private DataModel tableModel;
        private ProfilerTreeTable table;

        SettingsSupport(JFRModel jfrModel) {
            this.jfrModel = jfrModel;
            this.initComponents();
        }

        DataViewComponent.DetailsView getDetailsView() {
            return new DataViewComponent.DetailsView("Settings", null, 10, (JComponent)this, null);
        }

        void setData(RecordingNode root) {
            this.tableModel.setRoot((TreeNode)((Object)root));
        }

        private void initComponents() {
            this.tableModel = new DataModel();
            this.table = new ProfilerTreeTable((ProfilerTreeTableModel)this.tableModel, true, true, new int[]{0});
            this.table.setRootVisible(false);
            this.table.setShowsRootHandles(true);
            this.table.setMainColumn(0);
            this.table.setFitWidthColumn(0);
            this.table.setDefaultSortOrder(SortOrder.ASCENDING);
            this.table.setSortColumn(0);
            RecordingRenderers.NameRenderer nameRenderer = new RecordingRenderers.NameRenderer();
            this.table.setTreeCellRenderer((ProfilerRenderer)nameRenderer);
            RecordingRenderers.ValueRenderer valueRenderer = new RecordingRenderers.ValueRenderer();
            RecordingRenderers.TimeRenderer timeRenderer = new RecordingRenderers.TimeRenderer(this.jfrModel);
            int commonWidth = Math.max(valueRenderer.getPreferredWidth(), timeRenderer.getPreferredWidth());
            this.table.setColumnRenderer(1, (ProfilerRenderer)valueRenderer);
            this.table.setDefaultColumnWidth(1, commonWidth);
            this.table.setColumnVisibility(1, RecordingRenderers.ValueRenderer.isInitiallyVisible());
            this.table.setColumnRenderer(2, (ProfilerRenderer)timeRenderer);
            this.table.setDefaultColumnWidth(2, commonWidth);
            this.table.setColumnVisibility(2, RecordingRenderers.TimeRenderer.isInitiallyVisible());
            RecordingRenderers.ThreadRenderer threadRenderer = new RecordingRenderers.ThreadRenderer();
            this.table.setColumnRenderer(3, (ProfilerRenderer)threadRenderer);
            this.table.setDefaultColumnWidth(3, threadRenderer.getPreferredWidth());
            this.table.setColumnVisibility(3, RecordingRenderers.ThreadRenderer.isInitiallyVisible());
            this.setLayout(new BorderLayout());
            this.add((Component)new ProfilerTableContainer((ProfilerTable)this.table, false, null), "Center");
        }

        private static class DataModel
        extends ProfilerTreeTableModel.Abstract {
            DataModel() {
                super((TreeNode)((Object)new RecordingNode.Root("reading data..."){}));
            }

            public int getColumnCount() {
                return 4;
            }

            public Class getColumnClass(int column) {
                switch (column) {
                    case 0: {
                        return JTree.class;
                    }
                    case 1: {
                        return String.class;
                    }
                    case 2: {
                        return Long.class;
                    }
                    case 3: {
                        return String.class;
                    }
                }
                return null;
            }

            public String getColumnName(int column) {
                switch (column) {
                    case 0: {
                        return RecordingRenderers.NameRenderer.getDisplayName();
                    }
                    case 1: {
                        return RecordingRenderers.ValueRenderer.getDisplayName();
                    }
                    case 2: {
                        return RecordingRenderers.TimeRenderer.getDisplayName();
                    }
                    case 3: {
                        return RecordingRenderers.ThreadRenderer.getDisplayName();
                    }
                }
                return null;
            }

            public Object getValueAt(TreeNode node, int column) {
                if (node == null) {
                    return null;
                }
                RecordingNode rnode = (RecordingNode)((Object)node);
                switch (column) {
                    case 0: {
                        return rnode;
                    }
                    case 1: {
                        return rnode.value;
                    }
                    case 2: {
                        return rnode.time;
                    }
                    case 3: {
                        return rnode.thread;
                    }
                }
                return null;
            }

            public void setValueAt(Object o, TreeNode node, int column) {
            }

            public boolean isCellEditable(TreeNode node, int column) {
                return false;
            }
        }
    }

    static abstract class MasterViewSupport
    extends JPanel
    implements JFREventVisitor {
        private HTMLTextArea area;

        MasterViewSupport(JFRSnapshot snapshot, JFRModel model) {
            this.initComponents(model);
        }

        abstract void firstShown();

        DataViewComponent.MasterView getMasterView() {
            return new DataViewComponent.MasterView("Recording", null, (JComponent)this);
        }

        @Override
        public boolean visit(String typeName, JFREvent event) {
            if ("jdk.DumpReason".equals(typeName)) {
                try {
                    final String reason = event.getString("reason");
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            String summary = area.getText();
                            summary = summary + "<br><b>Dump reason:</b>&nbsp;";
                            summary = summary + reason;
                            area.setText(summary);
                        }
                    });
                }
                catch (JFRPropertyNotAvailableException jFRPropertyNotAvailableException) {
                    // empty catch block
                }
                return true;
            }
            return false;
        }

        private void initComponents(JFRModel model) {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            if (model == null) {
                this.add((Component)MessageComponent.notAvailable(), "Center");
            } else {
                this.area = new HTMLTextArea(MasterViewSupport.createSummary(model));
                this.area.setBorder(BorderFactory.createEmptyBorder(14, 8, 14, 8));
                this.add((Component)this.area, "Center");
                this.addHierarchyListener(new HierarchyListener(){

                    @Override
                    public void hierarchyChanged(HierarchyEvent e) {
                        if ((e.getChangeFlags() & 4L) != 0L && this.isShowing()) {
                            this.removeHierarchyListener(this);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    this.firstShown();
                                }
                            });
                        }
                    }
                });
            }
        }

        private static String createSummary(JFRModel model) {
            StringBuilder s = new StringBuilder("<table border='0' cellpadding='0' cellspacing='0'>");
            Instant firstTime = model.getFirstEventTime();
            Instant lastTime = model.getLastEventTime();
            String firstEventTime = InstantFormatter.format(firstTime);
            String lastEventTime = InstantFormatter.format(lastTime);
            String totalTime = MasterViewSupport.getTime(firstTime, lastTime);
            String eventsCount = NumberFormat.getIntegerInstance().format(model.getEventsCount());
            s.append("<tr>");
            s.append("<td><b>First event time:</b>&nbsp;</td><td>").append(firstEventTime).append("</td>");
            s.append("<td style='padding-left: 50px;'><b>Events count:</b>&nbsp;</td><td>").append(eventsCount).append("</td>");
            s.append("</tr>");
            s.append("<tr>");
            s.append("<td><b>Last event time:</b>&nbsp;</td><td>").append(lastEventTime.toString()).append("</td>");
            s.append("<td style='padding-left: 50px;'><b>Events time:</b>&nbsp;</td><td>").append(totalTime).append("</td>");
            s.append("</tr>");
            s.append("</table>");
            return s.toString();
        }

        private static String getTime(Instant firstTime, Instant lastTime) {
            long millis = ValuesConverter.durationToMillis(Duration.between(firstTime, lastTime));
            long hours = millis / 3600000L;
            String sHours = hours == 0L ? null : new DecimalFormat("#0").format(hours);
            long minutes = (millis %= 3600000L) / 60000L;
            String sMinutes = hours == 0L && minutes == 0L ? null : new DecimalFormat(hours > 0L ? "00" : "#0").format(minutes);
            String sSeconds = new DecimalFormat("#0.000").format((double)(millis %= 60000L) / 1000.0);
            if (sMinutes == null) {
                return NbBundle.getMessage(RecordingViewSupport.class, (String)"FORMAT_s", (Object[])new Object[]{sSeconds});
            }
            if (sHours == null) {
                return NbBundle.getMessage(RecordingViewSupport.class, (String)"FORMAT_ms", (Object[])new Object[]{sMinutes, sSeconds});
            }
            return NbBundle.getMessage(RecordingViewSupport.class, (String)"FORMAT_hms", (Object[])new Object[]{sHours, sMinutes, sSeconds});
        }
    }
}

