/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.model;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.model.AbstractModelProvider;
import org.graalvm.visualvm.core.ui.DataSourceWindowManager;
import org.graalvm.visualvm.jfr.JFRSnapshot;
import org.graalvm.visualvm.jfr.model.JFRModel;
import org.graalvm.visualvm.lib.profiler.api.ProfilerDialogs;

public abstract class JFRModelProvider
extends AbstractModelProvider<JFRModel, DataSource> {
    private static final Logger LOGGER = Logger.getLogger(JFRModelProvider.class.getName());
    private final String id;
    private final int priority;

    protected JFRModelProvider(String id, int priority) {
        this.id = id;
        this.priority = priority;
    }

    protected abstract JFRModel createModel(String var1, File var2) throws Exception;

    public final JFRModel createModelFor(final DataSource dataSource) {
        if (dataSource instanceof JFRSnapshot) {
            JFRSnapshot snapshot = (JFRSnapshot)dataSource;
            File file = snapshot.getFile();
            try {
                return this.createModel(this.id, file);
            }
            catch (OutOfMemoryError e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DataSourceWindowManager.sharedInstance().closeDataSource(dataSource);
                        ProfilerDialogs.displayError((String)"<html><br><b>Not enough memory to open JFR snapshot.</b><br><br>Please increase VisualVM heap size using the -Xmx parameter.</html>", (String)"Out Of Memory", null);
                    }
                });
                LOGGER.log(Level.SEVERE, "Not enough memory to load JFR snapshot (" + this.id + "): " + file);
                return JFRModel.OOME;
            }
            catch (Exception e) {
                LOGGER.log(Level.INFO, "Could not load JFR snapshot (" + this.id + "): " + file);
            }
        }
        return null;
    }

    public final int priority() {
        return this.priority;
    }

    public final String toString() {
        return this.id;
    }
}

