/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.nfi.impl.LibFFILibrary;
import com.oracle.truffle.nfi.impl.NFIContext;
import com.oracle.truffle.nfi.impl.NFILanguageImpl;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LibFFILibrary.class)
final class LibFFILibraryGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private LibFFILibraryGen() {
    }

    static {
        LibraryExport.register(LibFFILibrary.class, (LibraryExport[])new LibraryExport[]{new InteropLibraryExports()});
    }

    @GeneratedBy(value=LibFFILibrary.class)
    private static final class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        private InteropLibraryExports() {
            super(InteropLibrary.class, LibFFILibrary.class, false);
        }

        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof LibFFILibrary);
            return new Uncached();
        }

        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof LibFFILibrary);
            return new Cached();
        }

        @GeneratedBy(value=LibFFILibrary.class)
        private static final class Uncached
        extends InteropLibrary {
            private final TruffleLanguage.ContextReference<NFIContext> nFILanguageImplContextReference_ = this.lookupContextReference(NFILanguageImpl.class);

            Uncached() {
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof LibFFILibrary) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export 'com.oracle.truffle.nfi.impl.LibFFILibrary'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LibFFILibrary;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @CompilerDirectives.TruffleBoundary
            public Object readMember(Object arg0Value_, String arg1Value) throws UnknownIdentifierException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LibFFILibrary arg0Value = (LibFFILibrary)arg0Value_;
                return LibFFILibrary.ReadMember.doGeneric(arg0Value, arg1Value, BranchProfile.getUncached(), (NFIContext)this.nFILanguageImplContextReference_.get());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasMembers(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LibFFILibrary)receiver).hasMembers();
            }

            @CompilerDirectives.TruffleBoundary
            public Object getMembers(Object receiver, boolean includeInternal) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LibFFILibrary)receiver).getMembers(includeInternal);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMemberReadable(Object receiver, String member) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LibFFILibrary)receiver).isMemberReadable(member);
            }
        }

        @GeneratedBy(value=LibFFILibrary.class)
        private static final class Cached
        extends InteropLibrary {
            @CompilerDirectives.CompilationFinal
            private int state_;
            @CompilerDirectives.CompilationFinal
            private int exclude_;
            @CompilerDirectives.CompilationFinal
            private TruffleLanguage.ContextReference<NFIContext> nFILanguageImplContextReference_;
            @CompilerDirectives.CompilationFinal
            private CachedData cached_cache;
            @CompilerDirectives.CompilationFinal
            private BranchProfile generic_exception_;

            Cached() {
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof LibFFILibrary) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export 'com.oracle.truffle.nfi.impl.LibFFILibrary'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LibFFILibrary;
            }

            @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LibFFILibrary arg0Value = (LibFFILibrary)arg0Value_;
                int state = this.state_;
                if (state != 0) {
                    if ((state & 1) != 0) {
                        CachedData s1_ = this.cached_cache;
                        while (s1_ != null) {
                            if (arg0Value == s1_.cachedReceiver_ && arg1Value.equals(s1_.cachedSymbol_)) {
                                return LibFFILibrary.ReadMember.doCached(arg0Value, arg1Value, s1_.cachedReceiver_, s1_.cachedSymbol_, this.nFILanguageImplContextReference_, s1_.cachedRet_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state & 2) != 0) {
                        return LibFFILibrary.ReadMember.doGeneric(arg0Value, arg1Value, this.generic_exception_, (NFIContext)this.nFILanguageImplContextReference_.get());
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object executeAndSpecialize(LibFFILibrary arg0Value, String arg1Value) throws UnknownIdentifierException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                int exclude = this.exclude_;
                try {
                    if (exclude == 0) {
                        int count1_ = 0;
                        CachedData s1_ = this.cached_cache;
                        if ((state & 1) != 0) {
                            while (!(s1_ == null || arg0Value == s1_.cachedReceiver_ && arg1Value.equals(s1_.cachedSymbol_))) {
                                s1_ = s1_.next_;
                                ++count1_;
                            }
                        }
                        if (s1_ == null && count1_ < 3) {
                            s1_ = new CachedData(this.cached_cache);
                            s1_.cachedReceiver_ = arg0Value;
                            s1_.cachedSymbol_ = arg1Value;
                            TruffleLanguage.ContextReference nFILanguageImplContextReference__ = this.nFILanguageImplContextReference_;
                            if (nFILanguageImplContextReference__ == null) {
                                this.nFILanguageImplContextReference_ = nFILanguageImplContextReference__ = super.lookupContextReference(NFILanguageImpl.class);
                            }
                            s1_.cachedRet_ = LibFFILibrary.ReadMember.lookupCached(s1_.cachedReceiver_, s1_.cachedSymbol_, (TruffleLanguage.ContextReference<NFIContext>)nFILanguageImplContextReference__);
                            this.cached_cache = s1_;
                            this.state_ = state |= 1;
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            Object object = LibFFILibrary.ReadMember.doCached(arg0Value, arg1Value, s1_.cachedReceiver_, s1_.cachedSymbol_, this.nFILanguageImplContextReference_, s1_.cachedRet_);
                            return object;
                        }
                    }
                    this.generic_exception_ = BranchProfile.create();
                    TruffleLanguage.ContextReference nFILanguageImplContextReference__ = this.nFILanguageImplContextReference_;
                    if (nFILanguageImplContextReference__ == null) {
                        this.nFILanguageImplContextReference_ = nFILanguageImplContextReference__ = super.lookupContextReference(NFILanguageImpl.class);
                    }
                    this.exclude_ = exclude |= 1;
                    this.cached_cache = null;
                    state &= 0xFFFFFFFE;
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    Object object = LibFFILibrary.ReadMember.doGeneric(arg0Value, arg1Value, this.generic_exception_, (NFIContext)nFILanguageImplContextReference__.get());
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public NodeCost getCost() {
                CachedData s1_;
                int state = this.state_;
                if (state == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state & state - 1) == 0 && ((s1_ = this.cached_cache) == null || s1_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            public boolean hasMembers(Object receiver) {
                assert (this.assertAdopted());
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LibFFILibrary)receiver).hasMembers();
            }

            public Object getMembers(Object receiver, boolean includeInternal) throws UnsupportedMessageException {
                assert (this.assertAdopted());
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LibFFILibrary)receiver).getMembers(includeInternal);
            }

            public boolean isMemberReadable(Object receiver, String member) {
                assert (this.assertAdopted());
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LibFFILibrary)receiver).isMemberReadable(member);
            }

            @GeneratedBy(value=LibFFILibrary.class)
            private static final class CachedData {
                @CompilerDirectives.CompilationFinal
                CachedData next_;
                @CompilerDirectives.CompilationFinal
                LibFFILibrary cachedReceiver_;
                @CompilerDirectives.CompilationFinal
                String cachedSymbol_;
                @CompilerDirectives.CompilationFinal
                Object cachedRet_;

                CachedData(CachedData next_) {
                    this.next_ = next_;
                }
            }
        }
    }
}

