/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.hotspot.libgraal;

import org.graalvm.compiler.debug.TTY;
import org.graalvm.compiler.truffle.common.hotspot.libgraal.SVMToHotSpot;
import org.graalvm.compiler.truffle.common.hotspot.libgraal.SVMToHotSpotRepeated;
import org.graalvm.compiler.truffle.compiler.hotspot.libgraal.JNIExceptionWrapperGen;
import org.graalvm.compiler.truffle.compiler.hotspot.libgraal.SVMToHotSpotUtil;
import org.graalvm.libgraal.jni.JNI;
import org.graalvm.libgraal.jni.JNIUtil;
import org.graalvm.word.WordFactory;

final class JNIExceptionWrapper
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final JNI.JThrowable throwableHandle;
    private final boolean throwableRequiresStackTraceUpdate;

    private JNIExceptionWrapper(JNI.JNIEnv env, JNI.JThrowable throwableHandle) {
        super(JNIExceptionWrapper.getMessage(env, throwableHandle));
        this.throwableHandle = throwableHandle;
        this.throwableRequiresStackTraceUpdate = this.createMergedStackTrace(env);
    }

    private void throwInHotSpot(JNI.JNIEnv env) {
        JNI.JThrowable toThrow = this.throwableRequiresStackTraceUpdate ? JNIExceptionWrapper.updateStackTrace(env, this.throwableHandle, JNIExceptionWrapper.encode(this.getStackTrace())) : this.throwableHandle;
        JNIUtil.Throw((JNI.JNIEnv)env, (JNI.JThrowable)toThrow);
    }

    private boolean createMergedStackTrace(JNI.JNIEnv env) {
        boolean res;
        StackTraceElement[] mergedStack;
        StackTraceElement[] hsStack = JNIExceptionWrapper.getJNIExceptionStackTrace(env, (JNI.JObject)this.throwableHandle);
        if (JNIExceptionWrapper.containsHotSpotCall(hsStack)) {
            mergedStack = hsStack;
            res = false;
        } else {
            StackTraceElement[] svmStack = this.getStackTrace();
            mergedStack = JNIExceptionWrapper.mergeStackTraces(hsStack, svmStack, 0, JNIExceptionWrapper.getIndexOfPropagateJNIExceptionFrame(svmStack), true);
            res = true;
        }
        this.setStackTrace(mergedStack);
        return res;
    }

    static void wrapAndThrowPendingJNIException(JNI.JNIEnv env) {
        if (JNIUtil.ExceptionCheck((JNI.JNIEnv)env)) {
            JNI.JThrowable exception = JNIUtil.ExceptionOccurred((JNI.JNIEnv)env);
            if (JNIUtil.tracingAt((int)1) && exception.isNonNull()) {
                JNIUtil.ExceptionDescribe((JNI.JNIEnv)env);
            }
            JNIUtil.ExceptionClear((JNI.JNIEnv)env);
            throw new JNIExceptionWrapper(env, exception);
        }
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.CreateException)
    static void throwInHotSpot(JNI.JNIEnv env, Throwable original) {
        if (JNIUtil.tracingAt((int)1)) {
            original.printStackTrace(TTY.out);
        }
        if (original.getClass() == JNIExceptionWrapper.class) {
            ((JNIExceptionWrapper)original).throwInHotSpot(env);
        } else {
            StringBuilder message = new StringBuilder(original.getClass().getName());
            String originalMessage = original.getMessage();
            if (originalMessage != null) {
                message.append(": ").append(originalMessage);
            }
            JNI.JString hsMessage = JNIUtil.createHSString((JNI.JNIEnv)env, (String)message.toString());
            JNI.JThrowable hsThrowable = (JNI.JThrowable)JNIExceptionWrapperGen.callCreateException(env, (JNI.JObject)hsMessage);
            StackTraceElement[] hsStack = JNIExceptionWrapper.getJNIExceptionStackTrace(env, (JNI.JObject)hsThrowable);
            StackTraceElement[] svmStack = original.getStackTrace();
            String[] merged = JNIExceptionWrapper.encode(JNIExceptionWrapper.mergeStackTraces(hsStack, svmStack, 1, 0, false));
            JNIUtil.Throw((JNI.JNIEnv)env, (JNI.JThrowable)JNIExceptionWrapper.updateStackTrace(env, hsThrowable, merged));
        }
    }

    private static StackTraceElement[] mergeStackTraces(StackTraceElement[] hotSpotStackTrace, StackTraceElement[] svmStackTrace, int hotSpotStackStartIndex, int svmStackStartIndex, boolean originatedInHotSpot) {
        int targetIndex = 0;
        StackTraceElement[] merged = new StackTraceElement[hotSpotStackTrace.length - hotSpotStackStartIndex + svmStackTrace.length - svmStackStartIndex];
        boolean startingHotSpotFrame = true;
        boolean startingSvmFrame = true;
        boolean useHotSpotStack = originatedInHotSpot;
        int hotSpotStackIndex = hotSpotStackStartIndex;
        int svmStackIndex = svmStackStartIndex;
        while (hotSpotStackIndex < hotSpotStackTrace.length || svmStackIndex < svmStackTrace.length) {
            if (useHotSpotStack) {
                while (hotSpotStackIndex < hotSpotStackTrace.length && (startingHotSpotFrame || !hotSpotStackTrace[hotSpotStackIndex].isNativeMethod())) {
                    startingHotSpotFrame = false;
                    merged[targetIndex++] = hotSpotStackTrace[hotSpotStackIndex++];
                }
                startingHotSpotFrame = true;
            } else {
                useHotSpotStack = true;
            }
            while (svmStackIndex < svmStackTrace.length && (startingSvmFrame || !SVMToHotSpotUtil.isHotSpotCall(svmStackTrace[svmStackIndex]))) {
                startingSvmFrame = false;
                merged[targetIndex++] = svmStackTrace[svmStackIndex++];
            }
            startingSvmFrame = true;
        }
        return merged;
    }

    private static String[] encode(StackTraceElement[] stackTrace) {
        String[] res = new String[stackTrace.length];
        for (int i = 0; i < stackTrace.length; ++i) {
            String className = stackTrace[i].getClassName();
            String methodName = stackTrace[i].getMethodName();
            String fileName = stackTrace[i].getFileName();
            int lineNumber = stackTrace[i].getLineNumber();
            res[i] = String.format("%s|%s|%s|%d", className == null ? "" : className.replace('|', '!'), methodName == null ? "" : methodName.replace('|', '!'), fileName == null ? "" : fileName.replace('|', '!'), lineNumber);
        }
        return res;
    }

    @SVMToHotSpotRepeated(value={@SVMToHotSpot(value=SVMToHotSpot.Id.GetStackTrace), @SVMToHotSpot(value=SVMToHotSpot.Id.GetStackTraceElementClassName), @SVMToHotSpot(value=SVMToHotSpot.Id.GetStackTraceElementMethodName), @SVMToHotSpot(value=SVMToHotSpot.Id.GetStackTraceElementFileName), @SVMToHotSpot(value=SVMToHotSpot.Id.GetStackTraceElementLineNumber)})
    private static StackTraceElement[] getJNIExceptionStackTrace(JNI.JNIEnv env, JNI.JObject throwableHandle) {
        JNI.JObjectArray elements = (JNI.JObjectArray)JNIExceptionWrapperGen.callGetStackTrace(env, throwableHandle);
        int len = JNIUtil.GetArrayLength((JNI.JNIEnv)env, (JNI.JArray)elements);
        StackTraceElement[] res = new StackTraceElement[len];
        for (int i = 0; i < len; ++i) {
            JNI.JObject element = JNIUtil.GetObjectArrayElement((JNI.JNIEnv)env, (JNI.JObjectArray)elements, (int)i);
            String className = JNIUtil.createString((JNI.JNIEnv)env, (JNI.JString)((JNI.JString)JNIExceptionWrapperGen.callGetStackTraceElementClassName(env, element)));
            String methodName = JNIUtil.createString((JNI.JNIEnv)env, (JNI.JString)((JNI.JString)JNIExceptionWrapperGen.callGetStackTraceElementMethodName(env, element)));
            String fileName = JNIUtil.createString((JNI.JNIEnv)env, (JNI.JString)((JNI.JString)JNIExceptionWrapperGen.callGetStackTraceElementFileName(env, element)));
            int lineNumber = JNIExceptionWrapperGen.callGetStackTraceElementLineNumber(env, element);
            res[i] = new StackTraceElement(className, methodName, fileName, lineNumber);
        }
        return res;
    }

    private static boolean containsHotSpotCall(StackTraceElement[] stackTrace) {
        for (StackTraceElement e : stackTrace) {
            if (!SVMToHotSpotUtil.isHotSpotCall(e)) continue;
            return true;
        }
        return false;
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.UpdateStackTrace)
    private static JNI.JThrowable updateStackTrace(JNI.JNIEnv env, JNI.JThrowable throwableHandle, String[] encodedStackTrace) {
        SVMToHotSpotUtil.JNIClass string = SVMToHotSpotUtil.getJNIClass(env, String.class);
        JNI.JObjectArray stackTraceHandle = JNIUtil.NewObjectArray((JNI.JNIEnv)env, (int)encodedStackTrace.length, (JNI.JClass)string.jclass, (JNI.JObject)((JNI.JObject)WordFactory.nullPointer()));
        for (int i = 0; i < encodedStackTrace.length; ++i) {
            JNI.JString element = JNIUtil.createHSString((JNI.JNIEnv)env, (String)encodedStackTrace[i]);
            JNIUtil.SetObjectArrayElement((JNI.JNIEnv)env, (JNI.JObjectArray)stackTraceHandle, (int)i, (JNI.JObject)element);
        }
        return (JNI.JThrowable)JNIExceptionWrapperGen.callUpdateStackTrace(env, (JNI.JObject)throwableHandle, (JNI.JObject)stackTraceHandle);
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.GetThrowableMessage)
    private static String getMessage(JNI.JNIEnv env, JNI.JThrowable throwableHandle) {
        JNI.JString message = (JNI.JString)JNIExceptionWrapperGen.callGetThrowableMessage(env, (JNI.JObject)throwableHandle);
        return JNIUtil.createString((JNI.JNIEnv)env, (JNI.JString)message);
    }

    private static int getIndexOfPropagateJNIExceptionFrame(StackTraceElement[] stackTrace) {
        for (int i = 0; i < stackTrace.length; ++i) {
            if (!JNIExceptionWrapper.class.getName().equals(stackTrace[i].getClassName()) || !"wrapAndThrowPendingJNIException".equals(stackTrace[i].getMethodName())) continue;
            return i + 1;
        }
        return 0;
    }
}

