/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.hotspot.libgraal;

import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Path;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugOptions;
import org.graalvm.compiler.debug.TTY;
import org.graalvm.compiler.hotspot.CompilationContext;
import org.graalvm.compiler.hotspot.CompilerConfigurationFactory;
import org.graalvm.compiler.hotspot.HotSpotGraalOptionValues;
import org.graalvm.compiler.hotspot.HotSpotGraalServices;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.TruffleCompilation;
import org.graalvm.compiler.truffle.common.TruffleCompilationTask;
import org.graalvm.compiler.truffle.common.TruffleCompilerListener;
import org.graalvm.compiler.truffle.common.TruffleCompilerRuntime;
import org.graalvm.compiler.truffle.common.TruffleCompilerRuntimeInstance;
import org.graalvm.compiler.truffle.common.TruffleDebugContext;
import org.graalvm.compiler.truffle.common.TruffleDebugJavaMethod;
import org.graalvm.compiler.truffle.common.TruffleInliningPlan;
import org.graalvm.compiler.truffle.common.VoidGraphStructure;
import org.graalvm.compiler.truffle.common.hotspot.libgraal.HotSpotToSVM;
import org.graalvm.compiler.truffle.compiler.TruffleCompilationIdentifier;
import org.graalvm.compiler.truffle.compiler.TruffleCompilerOptions;
import org.graalvm.compiler.truffle.compiler.TruffleDebugContextImpl;
import org.graalvm.compiler.truffle.compiler.hotspot.HotSpotTruffleCompilerImpl;
import org.graalvm.compiler.truffle.compiler.hotspot.libgraal.HSCompilableTruffleAST;
import org.graalvm.compiler.truffle.compiler.hotspot.libgraal.HSTruffleCompilationTask;
import org.graalvm.compiler.truffle.compiler.hotspot.libgraal.HSTruffleCompilerListener;
import org.graalvm.compiler.truffle.compiler.hotspot.libgraal.HSTruffleCompilerRuntime;
import org.graalvm.compiler.truffle.compiler.hotspot.libgraal.HSTruffleInliningPlan;
import org.graalvm.compiler.truffle.compiler.hotspot.libgraal.JNIExceptionWrapper;
import org.graalvm.compiler.truffle.compiler.hotspot.libgraal.SVMObjectHandles;
import org.graalvm.compiler.truffle.compiler.hotspot.libgraal.SVMToHotSpotUtil;
import org.graalvm.graphio.GraphOutput;
import org.graalvm.graphio.GraphStructure;
import org.graalvm.libgraal.LibGraal;
import org.graalvm.libgraal.jni.HSObject;
import org.graalvm.libgraal.jni.HotSpotToSVMScope;
import org.graalvm.libgraal.jni.JNI;
import org.graalvm.libgraal.jni.JNIUtil;
import org.graalvm.nativeimage.Isolate;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.nativeimage.c.type.VoidPointer;
import org.graalvm.util.OptionsEncoder;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

final class HotSpotToSVMEntryPoints {
    HotSpotToSVMEntryPoints() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @HotSpotToSVM(value=HotSpotToSVM.Id.InitializeRuntime)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_HotSpotToSVMCalls_initializeRuntime")
    public static long initializeRuntime(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, JNI.JObject truffleRuntime, long classLoaderDelegateId) {
        try (HotSpotToSVMScope s = new HotSpotToSVMScope((Enum)HotSpotToSVM.Id.InitializeRuntime, env);){
            long truffleRuntimeHandle;
            ResolvedJavaType classLoaderDelegate = (ResolvedJavaType)LibGraal.unhand((HotSpotJVMCIRuntime)HotSpotJVMCIRuntime.runtime(), ResolvedJavaType.class, (long)classLoaderDelegateId);
            HSTruffleCompilerRuntime hsTruffleRuntime = new HSTruffleCompilerRuntime(env, truffleRuntime, classLoaderDelegate, HotSpotGraalOptionValues.defaultOptions());
            TruffleCompilerRuntimeInstance.initialize((TruffleCompilerRuntime)hsTruffleRuntime);
            long l = truffleRuntimeHandle = SVMObjectHandles.create((Object)hsTruffleRuntime);
            return l;
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot(env, t);
            return 0L;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @HotSpotToSVM(value=HotSpotToSVM.Id.InitializeCompiler)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_HotSpotToSVMCalls_initializeCompiler")
    public static long initializeCompiler(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, long truffleRuntimeHandle) {
        try (HotSpotToSVMScope s = new HotSpotToSVMScope((Enum)HotSpotToSVM.Id.InitializeCompiler, env);){
            HSTruffleCompilerRuntime hsTruffleRuntime = SVMObjectHandles.resolve(truffleRuntimeHandle, HSTruffleCompilerRuntime.class);
            long l = SVMObjectHandles.create(HotSpotTruffleCompilerImpl.create((TruffleCompilerRuntime)hsTruffleRuntime));
            return l;
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot(env, t);
            return 0L;
        }
    }

    @HotSpotToSVM(value=HotSpotToSVM.Id.ReleaseHandle)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_HotSpotToSVMCalls_releaseHandle")
    public static void releaseHandle(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, long handle) {
        try (HotSpotToSVMScope s = new HotSpotToSVMScope((Enum)HotSpotToSVM.Id.ReleaseHandle, env);){
            SVMObjectHandles.remove(handle);
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot(env, t);
        }
    }

    @HotSpotToSVM(value=HotSpotToSVM.Id.GetCompilerConfigurationFactoryName)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_HotSpotToSVMCalls_getCompilerConfigurationFactoryName")
    public static JNI.JString getCompilerConfigurationFactoryName(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId) {
        HotSpotToSVMScope scope = new HotSpotToSVMScope((Enum)HotSpotToSVM.Id.GetCompilerConfigurationFactoryName, env);
        try (HotSpotToSVMScope s = scope;){
            OptionValues options = TruffleCompilerOptions.getOptions();
            CompilerConfigurationFactory compilerConfigurationFactory = CompilerConfigurationFactory.selectFactory((String)((String)HotSpotTruffleCompilerImpl.Options.TruffleCompilerConfiguration.getValue(options)), (OptionValues)options);
            String name = compilerConfigurationFactory.getName();
            scope.setObjectResult((JNI.JObject)JNIUtil.createHSString((JNI.JNIEnv)env, (String)name));
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot(env, t);
            return (JNI.JString)WordFactory.nullPointer();
        }
        return (JNI.JString)scope.getObjectResult();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @HotSpotToSVM(value=HotSpotToSVM.Id.OpenCompilation)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_HotSpotToSVMCalls_openCompilation")
    public static long openCompilation(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, long handle, JNI.JObject hsCompilable) {
        HotSpotToSVMScope scope = new HotSpotToSVMScope((Enum)HotSpotToSVM.Id.OpenCompilation, env);
        try (HotSpotToSVMScope s = scope;){
            HotSpotTruffleCompilerImpl compiler = SVMObjectHandles.resolve(handle, HotSpotTruffleCompilerImpl.class);
            HSCompilableTruffleAST compilable = new HSCompilableTruffleAST(env, hsCompilable);
            TruffleCompilation compilation = compiler.openCompilation((CompilableTruffleAST)compilable);
            assert (compilation instanceof TruffleCompilationIdentifier);
            long l = SVMObjectHandles.create(compilation);
            return l;
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot(env, t);
            return 0L;
        }
    }

    @HotSpotToSVM(value=HotSpotToSVM.Id.GetCompilerConfigurationName)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_HotSpotToSVMCalls_getCompilerConfigurationName")
    public static JNI.JString getCompilerConfigurationName(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateId, long handle) {
        HotSpotToSVMScope scope = new HotSpotToSVMScope((Enum)HotSpotToSVM.Id.GetCompilerConfigurationName, env);
        try (HotSpotToSVMScope s = scope;){
            HotSpotTruffleCompilerImpl compiler = SVMObjectHandles.resolve(handle, HotSpotTruffleCompilerImpl.class);
            String name = compiler.getCompilerConfigurationName();
            scope.setObjectResult((JNI.JObject)JNIUtil.createHSString((JNI.JNIEnv)env, (String)name));
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot(env, t);
            return (JNI.JString)WordFactory.nullPointer();
        }
        return (JNI.JString)scope.getObjectResult();
    }

    @HotSpotToSVM(value=HotSpotToSVM.Id.DoCompile)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_HotSpotToSVMCalls_doCompile")
    public static void doCompile(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, long compilerHandle, long debugContextHandle, long compilationHandle, JNI.JByteArray hsOptions, JNI.JObject hsInlining, JNI.JObject hsTask, JNI.JObject hsListener) {
        try (HotSpotToSVMScope scope = new HotSpotToSVMScope((Enum)HotSpotToSVM.Id.DoCompile, env);){
            TruffleCompilationIdentifier compilation = SVMObjectHandles.resolve(compilationHandle, TruffleCompilationIdentifier.class);
            try (CompilationContext hotSpotObjectConstantScope = HotSpotGraalServices.openLocalCompilationContext((Object)compilation);){
                HotSpotTruffleCompilerImpl compiler = SVMObjectHandles.resolve(compilerHandle, HotSpotTruffleCompilerImpl.class);
                TruffleDebugContext debugContext = SVMObjectHandles.resolve(debugContextHandle, TruffleDebugContext.class);
                Map<String, Object> options = HotSpotToSVMEntryPoints.decodeOptions(env, hsOptions);
                HSTruffleInliningPlan inlining = new HSTruffleInliningPlan((HotSpotToSVMScope<HotSpotToSVM.Id>)scope, hsInlining);
                HSTruffleCompilationTask task = hsTask.isNull() ? null : new HSTruffleCompilationTask((HotSpotToSVMScope<HotSpotToSVM.Id>)scope, hsTask);
                HSTruffleCompilerListener listener = hsListener.isNull() ? null : new HSTruffleCompilerListener((HotSpotToSVMScope<HotSpotToSVM.Id>)scope, hsListener);
                compiler.doCompile(debugContext, (TruffleCompilation)compilation, options, (TruffleInliningPlan)inlining, (TruffleCompilationTask)task, (TruffleCompilerListener)listener);
            }
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot(env, t);
        }
    }

    @HotSpotToSVM(value=HotSpotToSVM.Id.CloseCompilation)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_HotSpotToSVMCalls_closeCompilation")
    public static void closeCompilation(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, long compilationHandle) {
        try (HotSpotToSVMScope scope = new HotSpotToSVMScope((Enum)HotSpotToSVM.Id.CloseCompilation, env);){
            TruffleCompilation compilation = SVMObjectHandles.resolve(compilationHandle, TruffleCompilation.class);
            HSCompilableTruffleAST compilable = (HSCompilableTruffleAST)compilation.getCompilable();
            compilable.release(env);
            HSObject.cleanHandles((JNI.JNIEnv)env);
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot(env, t);
        }
    }

    @HotSpotToSVM(value=HotSpotToSVM.Id.Shutdown)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_HotSpotToSVMCalls_shutdown")
    public static void shutdown(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, long handle) {
        try (HotSpotToSVMScope s = new HotSpotToSVMScope((Enum)HotSpotToSVM.Id.Shutdown, env);){
            HotSpotTruffleCompilerImpl compiler = SVMObjectHandles.resolve(handle, HotSpotTruffleCompilerImpl.class);
            compiler.shutdown();
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot(env, t);
        }
    }

    @HotSpotToSVM(value=HotSpotToSVM.Id.InstallTruffleCallBoundaryMethods)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_HotSpotToSVMCalls_installTruffleCallBoundaryMethods")
    public static void installTruffleCallBoundaryMethods(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, long handle) {
        try (HotSpotToSVMScope s = new HotSpotToSVMScope((Enum)HotSpotToSVM.Id.InstallTruffleCallBoundaryMethods, env);){
            HotSpotTruffleCompilerImpl compiler = SVMObjectHandles.resolve(handle, HotSpotTruffleCompilerImpl.class);
            compiler.installTruffleCallBoundaryMethods();
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot(env, t);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @HotSpotToSVM(value=HotSpotToSVM.Id.PendingTransferToInterpreterOffset)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_HotSpotToSVMCalls_pendingTransferToInterpreterOffset")
    public static int pendingTransferToInterpreterOffset(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, long handle) {
        try (HotSpotToSVMScope scope = new HotSpotToSVMScope((Enum)HotSpotToSVM.Id.PendingTransferToInterpreterOffset, env);){
            HotSpotTruffleCompilerImpl compiler = SVMObjectHandles.resolve(handle, HotSpotTruffleCompilerImpl.class);
            int n = compiler.pendingTransferToInterpreterOffset();
            return n;
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot(env, t);
            return 0;
        }
    }

    @HotSpotToSVM(value=HotSpotToSVM.Id.GetGraphDumpDirectory)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_HotSpotToSVMCalls_getGraphDumpDirectory")
    public static JNI.JString getGraphDumpDirectory(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId) {
        HotSpotToSVMScope scope = new HotSpotToSVMScope((Enum)HotSpotToSVM.Id.GetGraphDumpDirectory, env);
        try (HotSpotToSVMScope s = scope;){
            Path path = DebugOptions.getDumpDirectory((OptionValues)HotSpotGraalOptionValues.defaultOptions());
            scope.setObjectResult((JNI.JObject)JNIUtil.createHSString((JNI.JNIEnv)env, (String)path.toString()));
        }
        catch (IOException ioe) {
            return (JNI.JString)WordFactory.nullPointer();
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot(env, t);
            return (JNI.JString)WordFactory.nullPointer();
        }
        return (JNI.JString)scope.getObjectResult();
    }

    @HotSpotToSVM(value=HotSpotToSVM.Id.Log)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_HotSpotToSVMCalls_log")
    public static void log(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, JNI.JString hsMessage) {
        try (HotSpotToSVMScope s = new HotSpotToSVMScope((Enum)HotSpotToSVM.Id.Log, env);){
            String message = JNIUtil.createString((JNI.JNIEnv)env, (JNI.JString)hsMessage);
            TTY.println((String)message);
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot(env, t);
        }
    }

    @HotSpotToSVM(value=HotSpotToSVM.Id.GetInitialOptions)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_HotSpotToSVMCalls_getInitialOptions")
    public static JNI.JByteArray getInitialOptions(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, long truffleRuntimeHandle) {
        HotSpotToSVMScope scope = new HotSpotToSVMScope((Enum)HotSpotToSVM.Id.GetInitialOptions, env);
        try (HotSpotToSVMScope s = scope;){
            HSTruffleCompilerRuntime hsTruffleRuntime = SVMObjectHandles.resolve(truffleRuntimeHandle, HSTruffleCompilerRuntime.class);
            Map<String, Object> allOptions = hsTruffleRuntime.getOptions();
            HashMap<String, Object> options = new HashMap<String, Object>();
            for (Map.Entry<String, Object> option : allOptions.entrySet()) {
                String key = option.getKey();
                Object value = option.getValue();
                if (!OptionsEncoder.isValueSupported((Object)value)) continue;
                options.put(key, value);
            }
            byte[] serializedOptions = OptionsEncoder.encode(options);
            JNI.JByteArray hsSerializedOptions = JNIUtil.NewByteArray((JNI.JNIEnv)env, (int)serializedOptions.length);
            CCharPointer cdata = JNIUtil.GetByteArrayElements((JNI.JNIEnv)env, (JNI.JByteArray)hsSerializedOptions, (JNI.JValue)((JNI.JValue)WordFactory.nullPointer()));
            for (int i = 0; i < serializedOptions.length; ++i) {
                cdata.write(i, serializedOptions[i]);
            }
            JNIUtil.ReleaseByteArrayElements((JNI.JNIEnv)env, (JNI.JByteArray)hsSerializedOptions, (CCharPointer)cdata, (int)0);
            scope.setObjectResult((JNI.JObject)hsSerializedOptions);
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot(env, t);
            return (JNI.JByteArray)WordFactory.nullPointer();
        }
        return (JNI.JByteArray)scope.getObjectResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Object> decodeOptions(JNI.JNIEnv env, JNI.JByteArray hsOptions) {
        Map options;
        int len = JNIUtil.GetArrayLength((JNI.JNIEnv)env, (JNI.JArray)hsOptions);
        CCharPointer optionsCPointer = JNIUtil.GetByteArrayElements((JNI.JNIEnv)env, (JNI.JByteArray)hsOptions, (JNI.JValue)((JNI.JValue)WordFactory.nullPointer()));
        try {
            byte[] optionsBuffer = new byte[len];
            CTypeConversion.asByteBuffer((PointerBase)optionsCPointer, (int)len).get(optionsBuffer);
            options = OptionsEncoder.decode((byte[])optionsBuffer);
        }
        finally {
            JNIUtil.ReleaseByteArrayElements((JNI.JNIEnv)env, (JNI.JByteArray)hsOptions, (CCharPointer)optionsCPointer, (int)2);
        }
        return options;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @HotSpotToSVM(value=HotSpotToSVM.Id.GetSuppliedString)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_HotSpotToSVMCalls_getSuppliedString")
    public static JNI.JString getString(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, long handle) {
        HotSpotToSVMScope scope = new HotSpotToSVMScope((Enum)HotSpotToSVM.Id.GetSuppliedString, env);
        try (HotSpotToSVMScope s = scope;){
            Supplier orig = SVMObjectHandles.resolve(handle, Supplier.class);
            if (orig != null) {
                String stackTrace = (String)orig.get();
                scope.setObjectResult((JNI.JObject)JNIUtil.createHSString((JNI.JNIEnv)env, (String)stackTrace));
                return (JNI.JString)scope.getObjectResult();
            }
            JNI.JString jString = (JNI.JString)WordFactory.nullPointer();
            return jString;
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot(env, t);
            return (JNI.JString)WordFactory.nullPointer();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @HotSpotToSVM(value=HotSpotToSVM.Id.GetNodeCount)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_HotSpotToSVMCalls_getNodeCount")
    public static int getNodeCount(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, long handle) {
        try (HotSpotToSVMScope s = new HotSpotToSVMScope((Enum)HotSpotToSVM.Id.GetNodeCount, env);){
            TruffleCompilerListener.GraphInfo orig = SVMObjectHandles.resolve(handle, TruffleCompilerListener.GraphInfo.class);
            int n = orig.getNodeCount();
            return n;
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot(env, t);
            return 0;
        }
    }

    @HotSpotToSVM(value=HotSpotToSVM.Id.GetNodeTypes)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_HotSpotToSVMCalls_getNodeTypes")
    public static JNI.JObjectArray getNodeTypes(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, long handle, boolean simpleNames) {
        HotSpotToSVMScope scope = new HotSpotToSVMScope((Enum)HotSpotToSVM.Id.GetNodeTypes, env);
        try (HotSpotToSVMScope s = scope;){
            TruffleCompilerListener.GraphInfo orig = SVMObjectHandles.resolve(handle, TruffleCompilerListener.GraphInfo.class);
            String[] nodeTypes = orig.getNodeTypes(simpleNames);
            JNI.JClass componentType = SVMToHotSpotUtil.getJNIClass((JNI.JNIEnv)env, String.class).jclass;
            JNI.JObjectArray res = JNIUtil.NewObjectArray((JNI.JNIEnv)env, (int)nodeTypes.length, (JNI.JClass)componentType, (JNI.JObject)((JNI.JObject)WordFactory.nullPointer()));
            for (int i = 0; i < nodeTypes.length; ++i) {
                JNIUtil.SetObjectArrayElement((JNI.JNIEnv)env, (JNI.JObjectArray)res, (int)i, (JNI.JObject)JNIUtil.createHSString((JNI.JNIEnv)env, (String)nodeTypes[i]));
            }
            scope.setObjectResult((JNI.JObject)res);
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot(env, t);
            return (JNI.JObjectArray)WordFactory.nullPointer();
        }
        return (JNI.JObjectArray)scope.getObjectResult();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @HotSpotToSVM(value=HotSpotToSVM.Id.GetTargetCodeSize)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_HotSpotToSVMCalls_getTargetCodeSize")
    public static int getTargetCodeSize(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, long handle) {
        try (HotSpotToSVMScope s = new HotSpotToSVMScope((Enum)HotSpotToSVM.Id.GetTargetCodeSize, env);){
            int n = SVMObjectHandles.resolve(handle, TruffleCompilerListener.CompilationResultInfo.class).getTargetCodeSize();
            return n;
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot(env, t);
            return 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @HotSpotToSVM(value=HotSpotToSVM.Id.GetTotalFrameSize)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_HotSpotToSVMCalls_getTotalFrameSize")
    public static int getTotalFrameSize(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, long handle) {
        try (HotSpotToSVMScope s = new HotSpotToSVMScope((Enum)HotSpotToSVM.Id.GetTotalFrameSize, env);){
            int n = SVMObjectHandles.resolve(handle, TruffleCompilerListener.CompilationResultInfo.class).getTotalFrameSize();
            return n;
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot(env, t);
            return 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @HotSpotToSVM(value=HotSpotToSVM.Id.GetExceptionHandlersCount)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_HotSpotToSVMCalls_getExceptionHandlersCount")
    public static int getExceptionHandlersCount(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, long handle) {
        try (HotSpotToSVMScope s = new HotSpotToSVMScope((Enum)HotSpotToSVM.Id.GetExceptionHandlersCount, env);){
            int n = SVMObjectHandles.resolve(handle, TruffleCompilerListener.CompilationResultInfo.class).getExceptionHandlersCount();
            return n;
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot(env, t);
            return 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @HotSpotToSVM(value=HotSpotToSVM.Id.GetInfopointsCount)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_HotSpotToSVMCalls_getInfopointsCount")
    public static int getInfopointsCount(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, long handle) {
        try (HotSpotToSVMScope s = new HotSpotToSVMScope((Enum)HotSpotToSVM.Id.GetInfopointsCount, env);){
            int n = SVMObjectHandles.resolve(handle, TruffleCompilerListener.CompilationResultInfo.class).getInfopointsCount();
            return n;
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot(env, t);
            return 0;
        }
    }

    @HotSpotToSVM(value=HotSpotToSVM.Id.GetInfopoints)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_HotSpotToSVMCalls_getInfopoints")
    public static JNI.JObjectArray getInfopoints(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, long handle) {
        HotSpotToSVMScope scope = new HotSpotToSVMScope((Enum)HotSpotToSVM.Id.GetInfopoints, env);
        try (HotSpotToSVMScope s = scope;){
            String[] infoPoints = SVMObjectHandles.resolve(handle, TruffleCompilerListener.CompilationResultInfo.class).getInfopoints();
            JNI.JClass componentType = SVMToHotSpotUtil.getJNIClass((JNI.JNIEnv)env, String.class).jclass;
            JNI.JObjectArray res = JNIUtil.NewObjectArray((JNI.JNIEnv)env, (int)infoPoints.length, (JNI.JClass)componentType, (JNI.JObject)((JNI.JObject)WordFactory.nullPointer()));
            for (int i = 0; i < infoPoints.length; ++i) {
                JNIUtil.SetObjectArrayElement((JNI.JNIEnv)env, (JNI.JObjectArray)res, (int)i, (JNI.JObject)JNIUtil.createHSString((JNI.JNIEnv)env, (String)infoPoints[i]));
            }
            scope.setObjectResult((JNI.JObject)res);
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot(env, t);
            return (JNI.JObjectArray)WordFactory.nullPointer();
        }
        return (JNI.JObjectArray)scope.getObjectResult();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @HotSpotToSVM(value=HotSpotToSVM.Id.GetMarksCount)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_HotSpotToSVMCalls_getMarksCount")
    public static int getMarksCount(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, long handle) {
        try (HotSpotToSVMScope s = new HotSpotToSVMScope((Enum)HotSpotToSVM.Id.GetMarksCount, env);){
            int n = SVMObjectHandles.resolve(handle, TruffleCompilerListener.CompilationResultInfo.class).getMarksCount();
            return n;
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot(env, t);
            return 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @HotSpotToSVM(value=HotSpotToSVM.Id.GetDataPatchesCount)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_HotSpotToSVMCalls_getDataPatchesCount")
    public static int getDataPatchesCount(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, long handle) {
        try (HotSpotToSVMScope s = new HotSpotToSVMScope((Enum)HotSpotToSVM.Id.GetDataPatchesCount, env);){
            int n = SVMObjectHandles.resolve(handle, TruffleCompilerListener.CompilationResultInfo.class).getDataPatchesCount();
            return n;
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot(env, t);
            return 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @HotSpotToSVM(value=HotSpotToSVM.Id.OpenDebugContext)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_HotSpotToSVMCalls_openDebugContext")
    public static long openDebugContext(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, long compilerHandle, long compilationHandle, JNI.JByteArray hsOptions) {
        try (HotSpotToSVMScope s = new HotSpotToSVMScope((Enum)HotSpotToSVM.Id.OpenDebugContext, env);){
            long handle;
            HotSpotTruffleCompilerImpl compiler = SVMObjectHandles.resolve(compilerHandle, HotSpotTruffleCompilerImpl.class);
            TruffleCompilation compilation = SVMObjectHandles.resolve(compilationHandle, TruffleCompilation.class);
            Map<String, Object> options = HotSpotToSVMEntryPoints.decodeOptions(env, hsOptions);
            TruffleDebugContext debugContext = compiler.openDebugContext(options, compilation);
            long l = handle = SVMObjectHandles.create(debugContext);
            return l;
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot(env, t);
            return 0L;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @HotSpotToSVM(value=HotSpotToSVM.Id.OpenDebugContextScope)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_HotSpotToSVMCalls_openDebugContextScope")
    public static long openDebugContextScope(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, long handle, JNI.JString hsName, long compilationHandle) {
        try (HotSpotToSVMScope s = new HotSpotToSVMScope((Enum)HotSpotToSVM.Id.OpenDebugContextScope, env);){
            long scopeHandle;
            AutoCloseable scope;
            TruffleDebugContext debugContext = SVMObjectHandles.resolve(handle, TruffleDebugContext.class);
            String name = JNIUtil.createString((JNI.JNIEnv)env, (JNI.JString)hsName);
            if (compilationHandle == 0L) {
                scope = debugContext.scope(name);
            } else {
                TruffleCompilationIdentifier compilation222 = SVMObjectHandles.resolve(compilationHandle, TruffleCompilationIdentifier.class);
                scope = debugContext.scope(name, (Object)new TruffleDebugJavaMethod(compilation222.getCompilable()));
            }
            if (scope == null) {
                long compilation222 = 0L;
                return compilation222;
            }
            long l = scopeHandle = SVMObjectHandles.create(scope);
            return l;
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot(env, t);
            return 0L;
        }
    }

    @HotSpotToSVM(value=HotSpotToSVM.Id.CloseDebugContext)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_HotSpotToSVMCalls_closeDebugContext")
    public static void closeDebugContext(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, long handle) {
        try (HotSpotToSVMScope s = new HotSpotToSVMScope((Enum)HotSpotToSVM.Id.CloseDebugContext, env);){
            TruffleDebugContext debugContext = SVMObjectHandles.resolve(handle, TruffleDebugContext.class);
            debugContext.close();
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot(env, t);
        }
    }

    @HotSpotToSVM(value=HotSpotToSVM.Id.CloseDebugContextScope)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_HotSpotToSVMCalls_closeDebugContextScope")
    public static void closeDebugContextScope(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, long handle) {
        try (HotSpotToSVMScope s = new HotSpotToSVMScope((Enum)HotSpotToSVM.Id.CloseDebugContextScope, env);){
            AutoCloseable scope = (AutoCloseable)SVMObjectHandles.resolve(handle, DebugContext.Scope.class);
            scope.close();
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot(env, t);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @HotSpotToSVM(value=HotSpotToSVM.Id.IsBasicDumpEnabled)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_HotSpotToSVMCalls_isBasicDumpEnabled")
    public static boolean isBasicDumpEnabled(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, long handle) {
        try (HotSpotToSVMScope s = new HotSpotToSVMScope((Enum)HotSpotToSVM.Id.IsBasicDumpEnabled, env);){
            TruffleDebugContext debugContext = SVMObjectHandles.resolve(handle, TruffleDebugContext.class);
            boolean bl = debugContext.isDumpEnabled();
            return bl;
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot(env, t);
            return false;
        }
    }

    @HotSpotToSVM(value=HotSpotToSVM.Id.GetTruffleCompilationTruffleAST)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_HotSpotToSVMCalls_getTruffleCompilationTruffleAST")
    public static JNI.JObject getTruffleCompilationTruffleAST(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, long compilationHandle) {
        HotSpotToSVMScope scope = new HotSpotToSVMScope((Enum)HotSpotToSVM.Id.GetTruffleCompilationTruffleAST, env);
        try (HotSpotToSVMScope s = scope;){
            HSCompilableTruffleAST compilable = (HSCompilableTruffleAST)SVMObjectHandles.resolve(compilationHandle, TruffleCompilation.class).getCompilable();
            scope.setObjectResult(compilable.getHandle());
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot(env, t);
            return (JNI.JObject)WordFactory.nullPointer();
        }
        return scope.getObjectResult();
    }

    @HotSpotToSVM(value=HotSpotToSVM.Id.GetTruffleCompilationId)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_HotSpotToSVMCalls_getTruffleCompilationId")
    public static JNI.JString getTruffleCompilationId(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, long compilationHandle) {
        HotSpotToSVMScope scope = new HotSpotToSVMScope((Enum)HotSpotToSVM.Id.GetTruffleCompilationId, env);
        try (HotSpotToSVMScope s = scope;){
            String compilationId = SVMObjectHandles.resolve(compilationHandle, TruffleCompilationIdentifier.class).toString(CompilationIdentifier.Verbosity.ID);
            scope.setObjectResult((JNI.JObject)JNIUtil.createHSString((JNI.JNIEnv)env, (String)compilationId));
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot(env, t);
            return (JNI.JString)WordFactory.nullPointer();
        }
        return (JNI.JString)scope.getObjectResult();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @HotSpotToSVM(value=HotSpotToSVM.Id.GetDumpChannel)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_HotSpotToSVMCalls_getDumpChannel")
    public static long getDumpChannel(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, long debugContextHandle) {
        try (HotSpotToSVMScope s = new HotSpotToSVMScope((Enum)HotSpotToSVM.Id.GetDumpChannel, env);){
            TruffleDebugContextImpl debugContext = SVMObjectHandles.resolve(debugContextHandle, TruffleDebugContextImpl.class);
            GraphOutput graphOutput = debugContext.buildOutput(GraphOutput.newBuilder((GraphStructure)VoidGraphStructure.INSTANCE).protocolVersion(6, 1));
            long l = SVMObjectHandles.create(graphOutput);
            return l;
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot(env, t);
            return 0L;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @HotSpotToSVM(value=HotSpotToSVM.Id.IsDumpChannelOpen)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_HotSpotToSVMCalls_isDumpChannelOpen")
    public static boolean isDumpChannelOpen(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, long channelHandle) {
        try (HotSpotToSVMScope s = new HotSpotToSVMScope((Enum)HotSpotToSVM.Id.IsDumpChannelOpen, env);){
            boolean bl = SVMObjectHandles.resolve(channelHandle, WritableByteChannel.class).isOpen();
            return bl;
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot(env, t);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @HotSpotToSVM(value=HotSpotToSVM.Id.DumpChannelWrite)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_HotSpotToSVMCalls_dumpChannelWrite")
    public static int dumpChannelWrite(JNI.JNIEnv env, JNI.JClass hsClass, @CEntryPoint.IsolateThreadContext long isolateThreadId, long channelHandle, JNI.JObject hsSource, int capacity, int position, int limit) {
        try (HotSpotToSVMScope s = new HotSpotToSVMScope((Enum)HotSpotToSVM.Id.DumpChannelWrite, env);){
            WritableByteChannel channel = SVMObjectHandles.resolve(channelHandle, WritableByteChannel.class);
            VoidPointer baseAddr = JNIUtil.GetDirectBufferAddress((JNI.JNIEnv)env, (JNI.JObject)hsSource);
            ByteBuffer source = CTypeConversion.asByteBuffer((PointerBase)baseAddr, (int)capacity);
            source.position(position);
            source.limit(limit);
            int n = channel.write(source);
            return n;
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot(env, t);
            return -1;
        }
    }

    @HotSpotToSVM(value=HotSpotToSVM.Id.DumpChannelClose)
    @CEntryPoint(name="Java_org_graalvm_compiler_truffle_runtime_hotspot_libgraal_HotSpotToSVMCalls_dumpChannelClose")
    public static void dumpChannelClose(JNI.JNIEnv env, JNI.JClass hsClass, @CEntryPoint.IsolateThreadContext long isolateThreadId, long channelHandle) {
        try (HotSpotToSVMScope s = new HotSpotToSVMScope((Enum)HotSpotToSVM.Id.IsDumpChannelOpen, env);){
            SVMObjectHandles.resolve(channelHandle, WritableByteChannel.class).close();
        }
        catch (Throwable t) {
            JNIExceptionWrapper.throwInHotSpot(env, t);
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static void checkHotSpotToSVMCalls() throws InternalError {
        try {
            Class<?> hsClass = Class.forName("org.graalvm.compiler.truffle.runtime.hotspot.libgraal.HotSpotToSVMCalls");
            EnumSet<HotSpotToSVM.Id> unimplemented = EnumSet.allOf(HotSpotToSVM.Id.class);
            for (Method svmMethod : HotSpotToSVMEntryPoints.class.getDeclaredMethods()) {
                HotSpotToSVM call = svmMethod.getAnnotation(HotSpotToSVM.class);
                if (call == null) continue;
                HotSpotToSVMEntryPoints.check(Modifier.isStatic(svmMethod.getModifiers()), "Method annotated by %s must be static: %s", HotSpotToSVM.class, svmMethod);
                CEntryPoint ep = svmMethod.getAnnotation(CEntryPoint.class);
                HotSpotToSVMEntryPoints.check(ep != null, "Method annotated by %s must also be annotated by %s: %s", HotSpotToSVM.class, CEntryPoint.class, svmMethod);
                String name = ep.name();
                String prefix = "Java_" + hsClass.getName().replace('.', '_') + '_';
                HotSpotToSVMEntryPoints.check(name.startsWith(prefix), "Method must be a JNI entry point for a method in %s: %s", hsClass, svmMethod);
                name = name.substring(prefix.length());
                Method hsMethod = HotSpotToSVMEntryPoints.findHSMethod(hsClass, name);
                Class<?>[] svmParameters = svmMethod.getParameterTypes();
                Class<?>[] hsParameters = hsMethod.getParameterTypes();
                HotSpotToSVMEntryPoints.check(hsParameters.length + 2 == svmParameters.length, "%s should have 2 more parameters than %s", svmMethod, hsMethod);
                HotSpotToSVMEntryPoints.check(svmParameters.length >= 3, "Expect at least 3 parameters: %s", svmMethod);
                HotSpotToSVMEntryPoints.check(svmParameters[0] == JNI.JNIEnv.class, "Parameter 0 must be of type %s: %s", JNI.JNIEnv.class, svmMethod);
                HotSpotToSVMEntryPoints.check(svmParameters[1] == JNI.JClass.class, "Parameter 1 must be of type %s: %s", JNI.JClass.class, svmMethod);
                if (ep.builtin() == CEntryPoint.Builtin.ATTACH_THREAD) {
                    HotSpotToSVMEntryPoints.check(svmParameters[2] == Isolate.class, "Parameter 2 must be of type %s: %s", Isolate.class, svmMethod);
                } else {
                    HotSpotToSVMEntryPoints.check(svmParameters[2] == Long.TYPE, "Parameter 2 must be of type long: %s", svmMethod);
                }
                HotSpotToSVMEntryPoints.check(hsParameters[0] == Long.TYPE, "Parameter 0 must be of type long: %s", hsMethod);
                int i = 3;
                int j = 1;
                while (i < svmParameters.length) {
                    Class<Object> hsExpect;
                    Class<?> svm = svmParameters[i];
                    Class<?> hs = hsParameters[j];
                    if (hs.isPrimitive()) {
                        hsExpect = svm;
                    } else if (svm == JNI.JString.class) {
                        hsExpect = String.class;
                    } else if (svm == JNI.JByteArray.class) {
                        hsExpect = byte[].class;
                    } else {
                        HotSpotToSVMEntryPoints.check(svm == JNI.JObject.class, "must be", new Object[0]);
                        hsExpect = Object.class;
                    }
                    HotSpotToSVMEntryPoints.check(hsExpect.isAssignableFrom(hs), "HotSpot parameter %d (%s) incompatible with SVM parameter %d (%s): %s", j, hs.getName(), i, svm.getName(), hsMethod);
                    ++i;
                    ++j;
                }
                unimplemented.remove(call.value());
            }
            HotSpotToSVMEntryPoints.check(unimplemented.isEmpty(), "Unimplemented SVM calls: %s", unimplemented);
        }
        catch (ClassNotFoundException e) {
            throw new InternalError(e);
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static void check(boolean condition, String format, Object ... args) {
        if (!condition) {
            throw new InternalError(String.format(format, args));
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static Method findHSMethod(Class<?> hsClass, String name) {
        Method res = null;
        for (Method m : hsClass.getDeclaredMethods()) {
            if (!m.getName().equals(name)) continue;
            HotSpotToSVMEntryPoints.check(res == null, "More than one method named \"%s\" in %s", name, hsClass);
            HotSpotToSVM call = m.getAnnotation(HotSpotToSVM.class);
            HotSpotToSVMEntryPoints.check(call != null, "Method must be annotated by %s: %s", HotSpotToSVM.class, m);
            HotSpotToSVMEntryPoints.check(Modifier.isStatic(m.getModifiers()) && Modifier.isNative(m.getModifiers()), "Method must be static and native: %s", m);
            res = m;
        }
        HotSpotToSVMEntryPoints.check(res != null, "Could not find method named \"%s\" in %s", name, hsClass);
        return res;
    }

    static {
        HotSpotToSVMEntryPoints.checkHotSpotToSVMCalls();
    }
}

