/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.hotspot.libgraal;

import java.util.function.Supplier;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.compiler.hotspot.HotSpotGraalServices;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.OptimizedAssumptionDependency;
import org.graalvm.compiler.truffle.common.TruffleCallNode;
import org.graalvm.compiler.truffle.common.hotspot.libgraal.HotSpotToSVM;
import org.graalvm.compiler.truffle.common.hotspot.libgraal.SVMToHotSpot;
import org.graalvm.compiler.truffle.common.hotspot.libgraal.SVMToHotSpotRepeated;
import org.graalvm.compiler.truffle.compiler.hotspot.libgraal.HSCompilableTruffleASTGen;
import org.graalvm.compiler.truffle.compiler.hotspot.libgraal.HSTruffleCallNode;
import org.graalvm.compiler.truffle.compiler.hotspot.libgraal.SVMObjectHandles;
import org.graalvm.libgraal.LibGraal;
import org.graalvm.libgraal.jni.HSObject;
import org.graalvm.libgraal.jni.HotSpotToSVMScope;
import org.graalvm.libgraal.jni.JNI;
import org.graalvm.libgraal.jni.JNIUtil;

final class HSCompilableTruffleAST
extends HSObject
implements CompilableTruffleAST,
OptimizedAssumptionDependency {
    private volatile String cachedName;
    private Long cachedFailedSpeculationsAddress;
    private volatile String cachedString;

    HSCompilableTruffleAST(JNI.JNIEnv env, JNI.JObject handle) {
        super(env, handle);
    }

    HSCompilableTruffleAST(HotSpotToSVMScope<HotSpotToSVM.Id> scope, JNI.JObject handle) {
        super(scope, handle);
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.GetFailedSpeculationsAddress)
    public SpeculationLog getCompilationSpeculationLog() {
        Long res = this.cachedFailedSpeculationsAddress;
        if (res == null) {
            this.cachedFailedSpeculationsAddress = res = Long.valueOf(HSCompilableTruffleASTGen.callGetFailedSpeculationsAddress(HotSpotToSVMScope.env(), this.getHandle()));
        }
        return HotSpotGraalServices.newHotSpotSpeculationLog((long)this.cachedFailedSpeculationsAddress);
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.AsJavaConstant)
    public JavaConstant asJavaConstant() {
        return (JavaConstant)LibGraal.unhand((HotSpotJVMCIRuntime)HotSpotJVMCIRuntime.runtime(), JavaConstant.class, (long)HSCompilableTruffleASTGen.callAsJavaConstant(HotSpotToSVMScope.env(), this.getHandle()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SVMToHotSpotRepeated(value={@SVMToHotSpot(value=SVMToHotSpot.Id.CreateStringSupplier), @SVMToHotSpot(value=SVMToHotSpot.Id.OnCompilationFailed)})
    public void onCompilationFailed(Supplier<String> reasonAndStackTrace, boolean bailout, boolean permanentBailout) {
        long reasonAndStackTraceHandle = SVMObjectHandles.create(reasonAndStackTrace);
        boolean success = false;
        JNI.JNIEnv env = HotSpotToSVMScope.env();
        try {
            Object instance = HSCompilableTruffleASTGen.callCreateStringSupplier(env, reasonAndStackTraceHandle);
            HSCompilableTruffleASTGen.callOnCompilationFailed(env, this.getHandle(), instance, bailout, permanentBailout);
            success = true;
        }
        finally {
            if (!success) {
                SVMObjectHandles.remove(reasonAndStackTraceHandle);
            }
        }
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.GetCompilableName)
    public String getName() {
        String res = this.cachedName;
        if (res == null) {
            JNI.JNIEnv env = HotSpotToSVMScope.env();
            JNI.JString name = (JNI.JString)HSCompilableTruffleASTGen.callGetCompilableName(env, this.getHandle());
            this.cachedName = res = JNIUtil.createString((JNI.JNIEnv)env, (JNI.JString)name);
        }
        return res;
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.GetNonTrivialNodeCount)
    public int getNonTrivialNodeCount() {
        return HSCompilableTruffleASTGen.callGetNonTrivialNodeCount(HotSpotToSVMScope.env(), this.getHandle());
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.GetCallNodes)
    public TruffleCallNode[] getCallNodes() {
        HotSpotToSVMScope scope = HotSpotToSVMScope.scope().narrow(HotSpotToSVM.Id.class);
        JNI.JNIEnv env = scope.getEnv();
        JNI.JObjectArray peerArr = (JNI.JObjectArray)HSCompilableTruffleASTGen.callGetCallNodes(env, this.getHandle());
        int len = JNIUtil.GetArrayLength((JNI.JNIEnv)env, (JNI.JArray)peerArr);
        TruffleCallNode[] res = new TruffleCallNode[len];
        for (int i = 0; i < len; ++i) {
            JNI.JObject peerTruffleCallNode = JNIUtil.GetObjectArrayElement((JNI.JNIEnv)env, (JNI.JObjectArray)peerArr, (int)i);
            res[i] = new HSTruffleCallNode((HotSpotToSVMScope<HotSpotToSVM.Id>)scope, peerTruffleCallNode);
        }
        return res;
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.GetCompilableCallCount)
    public int getCallCount() {
        return HSCompilableTruffleASTGen.callGetCompilableCallCount(HotSpotToSVMScope.env(), this.getHandle());
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.CompilableToString)
    public String toString() {
        String res = this.cachedString;
        if (res == null) {
            JNI.JNIEnv env = HotSpotToSVMScope.env();
            JNI.JString value = (JNI.JString)HSCompilableTruffleASTGen.callCompilableToString(env, this.getHandle());
            this.cachedString = res = JNIUtil.createString((JNI.JNIEnv)env, (JNI.JString)value);
        }
        return res;
    }

    private IllegalArgumentException error() {
        throw new IllegalArgumentException("Cannot call method on SVM proxy to HotSpotOptimizedCallTarget " + (Object)((Object)this));
    }

    public CompilableTruffleAST getCompilable() {
        return this;
    }

    public void invalidate() {
        throw this.error();
    }

    public boolean isValid() {
        throw this.error();
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.CancelInstalledTask)
    public void cancelInstalledTask() {
        HSCompilableTruffleASTGen.callCancelInstalledTask(HotSpotToSVMScope.env(), this.getHandle());
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.IsSameOrSplit)
    public boolean isSameOrSplit(CompilableTruffleAST ast) {
        JNI.JObject astHandle = ((HSCompilableTruffleAST)ast).getHandle();
        return HSCompilableTruffleASTGen.callIsSameOrSplit(HotSpotToSVMScope.env(), this.getHandle(), astHandle);
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.GetKnownCallSiteCount)
    public int getKnownCallSiteCount() {
        return HSCompilableTruffleASTGen.callGetKnownCallSiteCount(HotSpotToSVMScope.env(), this.getHandle());
    }
}

