/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.LookupListenerList;
import org.openide.util.lookup.WaitableResult;

public class ProxyLookup
extends Lookup {
    private ImmutableInternalData data;

    public ProxyLookup(Lookup ... lookupArray) {
        this.data = ImmutableInternalData.EMPTY.setLookupsNoFire(lookupArray, true);
    }

    protected ProxyLookup() {
        this.data = ImmutableInternalData.EMPTY;
    }

    public synchronized String toString() {
        return "ProxyLookup(class=" + this.getClass() + ")->" + Arrays.asList(this.getData().getLookups(false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Lookup[] getLookups() {
        ProxyLookup proxyLookup = this;
        synchronized (proxyLookup) {
            return this.getData().getLookups(true);
        }
    }

    private Set<Lookup> identityHashSet(Collection<Lookup> collection) {
        IdentityHashMap identityHashMap = new IdentityHashMap();
        for (Lookup lookup : collection) {
            identityHashMap.put(lookup, null);
        }
        return identityHashMap.keySet();
    }

    protected final void setLookups(Lookup ... lookupArray) {
        this.setLookups((Executor)null, lookupArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setLookups(Executor executor, Lookup ... lookupArray) {
        Collection<Reference<R>> collection;
        IdentityHashMap<Lookup.Result, LookupListener> identityHashMap = new IdentityHashMap<Lookup.Result, LookupListener>();
        IdentityHashMap<Lookup.Result, LookupListener> identityHashMap2 = new IdentityHashMap<Lookup.Result, LookupListener>();
        Object object2 = this;
        synchronized (object2) {
            ImmutableInternalData immutableInternalData = this.getData();
            ImmutableInternalData object3 = this.getData().setLookupsNoFire(lookupArray, false);
            if (object3 == this.getData()) {
                return;
            }
            collection = this.setData(object3, lookupArray, identityHashMap2, identityHashMap);
        }
        for (Map.Entry entry : identityHashMap.entrySet()) {
            ((Lookup.Result)entry.getKey()).removeLookupListener((LookupListener)entry.getValue());
        }
        for (Map.Entry entry : identityHashMap2.entrySet()) {
            ((Lookup.Result)entry.getKey()).addLookupListener((LookupListener)entry.getValue());
        }
        object2 = new ArrayList();
        for (Reference<R> reference : collection) {
            R r = reference.get();
            if (r == null) continue;
            r.collectFires((Collection<Object>)object2);
        }
        class Notify
        implements Runnable {
            final /* synthetic */ ArrayList val$evAndListeners;

            Notify() {
                this.val$evAndListeners = arrayList;
            }

            @Override
            public void run() {
                Iterator iterator = this.val$evAndListeners.iterator();
                while (iterator.hasNext()) {
                    LookupEvent lookupEvent = (LookupEvent)iterator.next();
                    LookupListener lookupListener = (LookupListener)iterator.next();
                    try {
                        lookupListener.resultChanged(lookupEvent);
                    }
                    catch (RuntimeException runtimeException) {
                        Logger.getLogger(ProxyLookup.class.getName()).log(Level.WARNING, null, runtimeException);
                    }
                }
            }
        }
        Notify notify = new Notify();
        if (executor == null) {
            notify.run();
        } else {
            executor.execute(notify);
        }
    }

    protected void beforeLookup(Lookup.Template<?> template) {
    }

    void beforeLookup(boolean bl, Lookup.Template<?> template) {
        if (bl) {
            this.beforeLookup(template);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <T> T lookup(Class<T> clazz) {
        Lookup[] lookupArray;
        this.beforeLookup(new Lookup.Template<T>(clazz));
        ProxyLookup proxyLookup = this;
        synchronized (proxyLookup) {
            lookupArray = this.getData().getLookups(false);
        }
        for (int i = 0; i < lookupArray.length; ++i) {
            T t = lookupArray[i].lookup(clazz);
            if (t == null) continue;
            return t;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <T> Lookup.Item<T> lookupItem(Lookup.Template<T> template) {
        Lookup[] lookupArray;
        this.beforeLookup(template);
        ProxyLookup proxyLookup = this;
        synchronized (proxyLookup) {
            lookupArray = this.getData().getLookups(false);
        }
        for (int i = 0; i < lookupArray.length; ++i) {
            Lookup.Item<T> item = lookupArray[i].lookupItem(template);
            if (item == null) continue;
            return item;
        }
        return null;
    }

    private static <T> R<T> convertResult(R r) {
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <T> Lookup.Result<T> lookup(Lookup.Template<T> template) {
        ProxyLookup proxyLookup = this;
        synchronized (proxyLookup) {
            ImmutableInternalData[] immutableInternalDataArray = new ImmutableInternalData[]{null};
            R<T> r = this.getData().findResult(this, immutableInternalDataArray, template);
            this.setData(immutableInternalDataArray[0], this.getData().getLookups(false), null, null);
            return r;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void unregisterTemplate(Lookup.Template<?> template) {
        ProxyLookup proxyLookup = this;
        synchronized (proxyLookup) {
            ImmutableInternalData immutableInternalData = this.getData();
            if (immutableInternalData == null) {
                return;
            }
            this.setData(immutableInternalData.removeTemplate(this, template), this.getData().getLookups(false), null, null);
        }
    }

    private ImmutableInternalData getData() {
        assert (Thread.holdsLock(this));
        return this.data;
    }

    private Collection<Reference<R>> setData(ImmutableInternalData immutableInternalData, Lookup[] lookupArray, Map<Lookup.Result, LookupListener> map, Map<Lookup.Result, LookupListener> map2) {
        R r;
        assert (Thread.holdsLock(this));
        assert (immutableInternalData != null);
        ImmutableInternalData immutableInternalData2 = this.getData();
        if (immutableInternalData2 == immutableInternalData) {
            return Collections.emptyList();
        }
        if (immutableInternalData.isEmpty()) {
            this.setData(immutableInternalData);
            return Collections.emptyList();
        }
        Collection<Reference<R>> collection = immutableInternalData.references();
        Set<Lookup> set = this.identityHashSet(immutableInternalData2.getLookupsList());
        Set<Lookup> set2 = this.identityHashSet(Arrays.asList(lookupArray));
        Set<Lookup> set3 = this.identityHashSet(set2);
        set.removeAll(set2);
        set3.removeAll(immutableInternalData2.getLookupsList());
        for (Reference<R> reference : collection) {
            r = reference.get();
            if (r == null) continue;
            r.lookupChange(immutableInternalData, lookupArray, immutableInternalData2, set3, set, map, map2);
            if (this.getData() == immutableInternalData2) continue;
        }
        for (Reference<R> reference : collection) {
            r = reference.get();
            if (r == null) continue;
            r.data = immutableInternalData;
        }
        this.setData(immutableInternalData);
        return collection;
    }

    private void setData(ImmutableInternalData immutableInternalData) {
        this.data = immutableInternalData;
    }

    private static final class LazySet
    extends LazyCollection
    implements Set {
        public LazySet(R r, Object[] objectArray, int n, boolean bl, Lookup.Result[] resultArray) {
            super(r, objectArray, n, bl, resultArray);
        }
    }

    private static final class LazyList
    extends LazyCollection
    implements List {
        public LazyList(R r, Object[] objectArray, int n, boolean bl, Lookup.Result[] resultArray) {
            super(r, objectArray, n, bl, resultArray);
        }

        final List delegateList() {
            return (List)this.delegate();
        }

        public Object get(int n) {
            return this.delegateList().get(n);
        }

        public List subList(int n, int n2) {
            return this.delegateList().subList(n, n2);
        }

        @Override
        public int indexOf(Object object) {
            return this.delegateList().indexOf(object);
        }

        @Override
        public int lastIndexOf(Object object) {
            return this.delegateList().lastIndexOf(object);
        }

        public ListIterator listIterator() {
            return this.delegateList().listIterator();
        }

        public ListIterator listIterator(int n) {
            return this.delegateList().listIterator(n);
        }

        public boolean addAll(int n, Collection collection) {
            throw new UnsupportedOperationException();
        }

        public Object set(int n, Object object) {
            throw new UnsupportedOperationException();
        }

        public void add(int n, Object object) {
            throw new UnsupportedOperationException();
        }

        public Object remove(int n) {
            throw new UnsupportedOperationException();
        }
    }

    private static class LazyCollection
    implements Collection {
        private R result;
        private final Object[] cc;
        private final int indexToCache;
        private final boolean callBeforeLookup;
        private final Lookup.Result[] arr;
        private final Collection[] computed;
        private Collection delegate;

        public LazyCollection(R r, Object[] objectArray, int n, boolean bl, Lookup.Result[] resultArray) {
            this.result = r;
            this.indexToCache = n;
            this.cc = objectArray;
            this.callBeforeLookup = bl;
            this.arr = resultArray;
            this.computed = new Collection[resultArray.length];
        }

        final Collection delegate() {
            return this.delegate(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final Collection delegate(boolean bl) {
            Collection collection = null;
            while (true) {
                LazyCollection lazyCollection = this;
                synchronized (lazyCollection) {
                    if (collection != null && this.delegate == null) {
                        this.delegate = collection;
                        this.result = null;
                    }
                    if (this.delegate != null) {
                        return this.delegate;
                    }
                    if (!bl) {
                        return null;
                    }
                }
                collection = this.computeDelegate(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Collection computeDelegate(int[] nArray) {
            Object object;
            int n;
            HashSet hashSet = null;
            Object object2 = null;
            if (nArray == null || nArray[0] == 0) {
                AbstractCollection abstractCollection;
                if (this.indexToCache == 1) {
                    hashSet = abstractCollection = new HashSet();
                    object2 = Collections.unmodifiableSet(abstractCollection);
                } else {
                    hashSet = abstractCollection = new ArrayList(this.arr.length * 2);
                    object2 = Collections.unmodifiableList(abstractCollection);
                }
            }
            int n2 = n = nArray == null ? 0 : nArray[0];
            while (n < this.arr.length) {
                Object object3 = this;
                synchronized (object3) {
                    object = this.getComputed()[n];
                }
                if (object == null) {
                    if (nArray != null && this.callBeforeLookup && this.arr[n] instanceof WaitableResult) {
                        object3 = (WaitableResult)this.arr[n];
                        ((WaitableResult)object3).beforeLookup(this.result.template());
                    }
                    object = this.computeSingleResult(n);
                    assert (object != null);
                }
                boolean bl = false;
                LazyCollection lazyCollection = this;
                synchronized (lazyCollection) {
                    if (this.getComputed()[n] == null) {
                        this.getComputed()[n] = object;
                    }
                    ++n;
                    if (nArray != null) {
                        nArray[0] = n;
                        if (!object.isEmpty()) {
                            object2 = object;
                            break;
                        }
                    } else {
                        bl = true;
                    }
                }
                if (!bl) continue;
                hashSet.addAll(object);
            }
            if (n == this.arr.length && hashSet != null) {
                object = this.result;
                if (object != null) {
                    ((R)object).updateResultCache(this.cc, this.indexToCache, this.arr, object2);
                }
                this.result = null;
            }
            return object2;
        }

        @Override
        public int size() {
            return this.delegate().size();
        }

        @Override
        public boolean isEmpty() {
            return this.delegate().isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            return this.delegate().contains(object);
        }

        @Override
        public Iterator iterator() {
            Collection collection = this.delegate(false);
            return collection != null ? collection.iterator() : this.lazyIterator();
        }

        @Override
        public Object[] toArray() {
            return this.delegate().toArray();
        }

        public Object[] toArray(Object[] objectArray) {
            return this.delegate().toArray(objectArray);
        }

        public String toString() {
            return this.delegate().toString();
        }

        @Override
        public int hashCode() {
            return this.delegate().hashCode();
        }

        @Override
        public boolean equals(Object object) {
            return this.delegate().equals(object);
        }

        public boolean add(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean containsAll(Collection collection) {
            return this.delegate().containsAll(collection);
        }

        public boolean addAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        private Iterator lazyIterator() {
            return new Iterator(){
                private Iterator current;
                private int[] indx = new int[]{0};

                @Override
                public boolean hasNext() {
                    while (this.current == null || !this.current.hasNext()) {
                        if (this.indx[0] == LazyCollection.this.arr.length) {
                            return false;
                        }
                        Collection collection = LazyCollection.this.computeDelegate(this.indx);
                        if (collection != null) {
                            this.current = collection.iterator();
                            continue;
                        }
                        assert (this.indx[0] == LazyCollection.this.arr.length);
                        this.current = null;
                    }
                    return true;
                }

                public Object next() {
                    if (this.hasNext()) {
                        return this.current.next();
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        private Collection computeSingleResult(int n) {
            Collection<Object> collection = null;
            switch (this.indexToCache) {
                case 0: {
                    if (!this.callBeforeLookup && this.arr[n] instanceof WaitableResult) {
                        WaitableResult waitableResult = (WaitableResult)this.arr[n];
                        collection = waitableResult.allInstances(this.callBeforeLookup);
                        break;
                    }
                    collection = this.arr[n].allInstances();
                    break;
                }
                case 1: {
                    collection = this.arr[n].allClasses();
                    break;
                }
                case 2: {
                    if (!this.callBeforeLookup && this.arr[n] instanceof WaitableResult) {
                        WaitableResult waitableResult = (WaitableResult)this.arr[n];
                        collection = waitableResult.allItems(this.callBeforeLookup);
                        break;
                    }
                    collection = this.arr[n].allItems();
                    break;
                }
                default: {
                    assert (false) : "Wrong index: " + this.indexToCache;
                    break;
                }
            }
            return collection;
        }

        private Collection[] getComputed() {
            assert (Thread.holdsLock(this));
            return this.computed;
        }
    }

    private static final class EmptyInternalData
    extends ImmutableInternalData {
        EmptyInternalData() {
        }

        @Override
        protected final boolean isEmpty() {
            return true;
        }

        @Override
        protected Map<Lookup.Template, Reference<R>> getResults() {
            return Collections.emptyMap();
        }

        @Override
        protected Object getRawLookups() {
            return EMPTY_ARR;
        }
    }

    private static final class RealInternalData
    extends ImmutableInternalData {
        private final Object lookups;
        private final Map<Lookup.Template, Reference<R>> results;
        private static Class<?> unmodifiableClass;

        public RealInternalData(Object object, Map<Lookup.Template, Reference<R>> map) {
            this.results = map;
            this.lookups = object;
        }

        @Override
        protected final boolean isEmpty() {
            return false;
        }

        @Override
        protected Map<Lookup.Template, Reference<R>> getResults() {
            boolean bl = false;
            if (!$assertionsDisabled) {
                bl = true;
                if (!true) {
                    throw new AssertionError();
                }
            }
            return bl && !RealInternalData.isUnmodifiable(this.results) ? RealInternalData.unmodifiableMap(this.results) : this.results;
        }

        @Override
        protected Object getRawLookups() {
            return this.lookups;
        }

        private static boolean isUnmodifiable(Map<?, ?> map) {
            return map.getClass() == unmodifiableClass;
        }

        private static <K, V> Map<K, V> unmodifiableMap(Map<K, V> map) {
            Map<K, V> map2 = Collections.unmodifiableMap(map);
            if (unmodifiableClass == null) {
                unmodifiableClass = map2.getClass();
            }
            return map2;
        }
    }

    private static final class SingleInternalData
    extends ImmutableInternalData {
        private final Object lookups;
        private final Lookup.Template template;
        private final Reference<R> result;

        public SingleInternalData(Object object, Lookup.Template<?> template, Reference<R> reference) {
            this.lookups = object;
            this.template = template;
            this.result = reference;
        }

        @Override
        protected final boolean isEmpty() {
            return false;
        }

        @Override
        protected Map<Lookup.Template, Reference<R>> getResults() {
            return Collections.singletonMap(this.template, this.result);
        }

        @Override
        protected Object getRawLookups() {
            return this.lookups;
        }
    }

    static abstract class ImmutableInternalData {
        static final ImmutableInternalData EMPTY = new EmptyInternalData();
        static final Lookup[] EMPTY_ARR = new Lookup[0];

        protected ImmutableInternalData() {
        }

        public static ImmutableInternalData create(Object object, Map<Lookup.Template, Reference<R>> map) {
            if (map.size() == 0 && object == EMPTY_ARR) {
                return EMPTY;
            }
            if (map.size() == 1) {
                Map.Entry<Lookup.Template, Reference<R>> entry = map.entrySet().iterator().next();
                return new SingleInternalData(object, entry.getKey(), entry.getValue());
            }
            return new RealInternalData(object, map);
        }

        protected abstract boolean isEmpty();

        protected abstract Map<Lookup.Template, Reference<R>> getResults();

        protected abstract Object getRawLookups();

        final Collection<Reference<R>> references() {
            return this.getResults().values();
        }

        final <T> ImmutableInternalData removeTemplate(ProxyLookup proxyLookup, Lookup.Template<T> template) {
            if (this.getResults().containsKey(template)) {
                HashMap<Lookup.Template, Reference<R>> hashMap = new HashMap<Lookup.Template, Reference<R>>(this.getResults());
                Reference<R> reference = hashMap.remove(template);
                if (reference != null && reference.get() != null) {
                    return this;
                }
                return ImmutableInternalData.create(this.getRawLookups(), hashMap);
            }
            return this;
        }

        <T> R<T> findResult(ProxyLookup proxyLookup, ImmutableInternalData[] immutableInternalDataArray, Lookup.Template<T> template) {
            R r;
            assert (Thread.holdsLock(proxyLookup));
            Map<Lookup.Template, Reference<R>> map = this.getResults();
            Reference<R> reference = map.get(template);
            R r2 = r = reference == null ? null : reference.get();
            if (r != null) {
                immutableInternalDataArray[0] = this;
                return ProxyLookup.convertResult(r);
            }
            HashMap<Lookup.Template, Reference<R>> hashMap = new HashMap<Lookup.Template, Reference<R>>(map);
            R<T> r3 = new R<T>(proxyLookup, template);
            hashMap.put(template, new SoftReference<R<T>>(r3));
            immutableInternalDataArray[0] = ImmutableInternalData.create(this.getRawLookups(), hashMap);
            ((R)r3).data = immutableInternalDataArray[0];
            return r3;
        }

        final ImmutableInternalData setLookupsNoFire(Lookup[] lookupArray, boolean bl) {
            Object object;
            if (!bl) {
                Lookup[] lookupArray2 = this.getLookups(false);
                if (lookupArray2 == lookupArray) {
                    return this;
                }
                if (lookupArray2.length == lookupArray.length) {
                    int n = 0;
                    for (int i = 0; i < lookupArray2.length && lookupArray[i] == lookupArray2[i]; ++i) {
                        ++n;
                    }
                    if (n == lookupArray2.length) {
                        return this;
                    }
                }
            }
            if (lookupArray.length == 1) {
                object = lookupArray[0];
                assert (object != null) : "Cannot assign null delegate";
            } else {
                object = lookupArray.length == 0 ? EMPTY_ARR : lookupArray.clone();
            }
            if (this.isEmpty() && object == EMPTY_ARR) {
                return this;
            }
            return ImmutableInternalData.create(object, this.getResults());
        }

        final Lookup[] getLookups(boolean bl) {
            Object object = this.getRawLookups();
            if (object instanceof Lookup) {
                return new Lookup[]{(Lookup)object};
            }
            Lookup[] lookupArray = (Lookup[])object;
            if (bl) {
                lookupArray = (Lookup[])lookupArray.clone();
            }
            return lookupArray;
        }

        final List<Lookup> getLookupsList() {
            return Arrays.asList(this.getLookups(false));
        }
    }

    private static final class WeakResult<T>
    extends WaitableResult<T>
    implements LookupListener,
    Runnable {
        private Lookup.Result<T>[] results;
        private final WeakRef<T> result;

        public WeakResult(ProxyLookup proxyLookup, R r, Lookup.Template<T> template) {
            this.result = new WeakRef<T>(r, this, proxyLookup, template);
        }

        final void removeListeners() {
            Lookup.Result<T>[] resultArray = this.getResults();
            if (resultArray == null) {
                return;
            }
            for (int i = 0; i < resultArray.length; ++i) {
                resultArray[i].removeLookupListener(this);
            }
        }

        @Override
        protected void beforeLookup(Lookup.Template template) {
            R r = (R)this.result.get();
            if (r != null) {
                r.beforeLookup(template);
            } else {
                this.removeListeners();
            }
        }

        @Override
        protected void collectFires(Collection<Object> collection) {
            R r = (R)this.result.get();
            if (r != null) {
                r.collectFires(collection);
            } else {
                this.removeListeners();
            }
        }

        @Override
        public void addLookupListener(LookupListener lookupListener) {
            assert (false);
        }

        @Override
        public void removeLookupListener(LookupListener lookupListener) {
            assert (false);
        }

        @Override
        public Collection<T> allInstances() {
            assert (false);
            return null;
        }

        @Override
        public void resultChanged(LookupEvent lookupEvent) {
            R r = (R)this.result.get();
            if (r != null) {
                r.resultChanged(lookupEvent);
            } else {
                this.removeListeners();
            }
        }

        @Override
        public Collection<? extends Lookup.Item<T>> allItems() {
            assert (false);
            return null;
        }

        @Override
        public Set<Class<? extends T>> allClasses() {
            assert (false);
            return null;
        }

        @Override
        public void run() {
            this.removeListeners();
        }

        private Lookup.Result<T>[] getResults() {
            return this.results;
        }

        private void setResults(Lookup.Result<T>[] resultArray) {
            this.results = resultArray;
        }

        @Override
        protected Collection<? extends Object> allInstances(boolean bl) {
            return this.allInstances();
        }

        @Override
        protected Collection<? extends Lookup.Item<T>> allItems(boolean bl) {
            return this.allItems();
        }
    }

    private static final class WeakRef<T>
    extends WeakReference<R>
    implements Runnable {
        final WeakResult<T> result;
        final ProxyLookup proxy;
        final Lookup.Template<T> template;

        public WeakRef(R r, WeakResult<T> weakResult, ProxyLookup proxyLookup, Lookup.Template<T> template) {
            super(r);
            this.result = weakResult;
            this.template = template;
            this.proxy = proxyLookup;
        }

        @Override
        public void run() {
            this.result.removeListeners();
            this.proxy.unregisterTemplate(this.template);
        }
    }

    private static final class R<T>
    extends WaitableResult<T> {
        private final WeakResult<T> weakL;
        private LookupListenerList listeners;
        private Collection[] cache;
        private ImmutableInternalData data;
        private static ThreadLocal<R> IN = new ThreadLocal();
        private static final Collection[] NO_CACHE = new Collection[0];

        public R(ProxyLookup proxyLookup, Lookup.Template<T> template) {
            this.weakL = new WeakResult<T>(proxyLookup, this, template);
        }

        private ProxyLookup proxy() {
            return ((WeakResult)this.weakL).result.proxy;
        }

        private Lookup.Result<T>[] newResults(int n) {
            return new Lookup.Result[n];
        }

        protected void finalize() {
            ((WeakResult)this.weakL).result.run();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        private Lookup.Result<T>[] initResults() {
            Lookup.Result[] resultArray;
            block4: while (true) {
                resultArray = this.proxy();
                // MONITORENTER : resultArray
                if (((WeakResult)this.weakL).getResults() != null) {
                    // MONITOREXIT : resultArray
                    return ((WeakResult)this.weakL).getResults();
                }
                Lookup[] lookupArray = this.data.getLookups(false);
                ImmutableInternalData immutableInternalData = this.data;
                // MONITOREXIT : resultArray
                resultArray = this.newResults(lookupArray.length);
                for (int i = 0; i < resultArray.length; ++i) {
                    resultArray[i] = lookupArray[i].lookup(this.template());
                }
                ProxyLookup proxyLookup = this.proxy();
                // MONITORENTER : proxyLookup
                if (immutableInternalData != this.data) {
                    // MONITOREXIT : proxyLookup
                    continue;
                }
                Lookup[] lookupArray2 = this.data.getLookups(false);
                if (lookupArray2.length != lookupArray.length) {
                    // MONITOREXIT : proxyLookup
                    continue;
                }
                for (int i = 0; i < lookupArray2.length; ++i) {
                    if (lookupArray2[i] == lookupArray[i]) continue;
                    // MONITOREXIT : proxyLookup
                    continue block4;
                }
                break;
            }
            if (((WeakResult)this.weakL).getResults() != null) {
                // MONITOREXIT : proxyLookup
                return ((WeakResult)this.weakL).getResults();
            }
            ((WeakResult)this.weakL).setResults(resultArray);
            // MONITOREXIT : proxyLookup
            int n = 0;
            while (n < resultArray.length) {
                resultArray[n].addLookupListener(this.weakL);
                ++n;
            }
            return resultArray;
        }

        final void lookupChange(ImmutableInternalData immutableInternalData, Lookup[] lookupArray, ImmutableInternalData immutableInternalData2, Set<Lookup> set, Set<Lookup> set2, Map<Lookup.Result, LookupListener> map, Map<Lookup.Result, LookupListener> map2) {
            if (((WeakResult)this.weakL).getResults() == null) {
                return;
            }
            Lookup[] lookupArray2 = immutableInternalData2.getLookups(false);
            IdentityHashMap<Lookup, Lookup.Result> identityHashMap = new IdentityHashMap<Lookup, Lookup.Result>(lookupArray2.length * 2);
            for (int i = 0; i < lookupArray2.length; ++i) {
                if (set2.contains(lookupArray2[i])) {
                    if (map2 == null) continue;
                    map2.put(((WeakResult)this.weakL).getResults()[i], this.weakL);
                    continue;
                }
                identityHashMap.put(lookupArray2[i], ((WeakResult)this.weakL).getResults()[i]);
            }
            Lookup.Result[] resultArray = this.newResults(lookupArray.length);
            for (int i = 0; i < lookupArray.length; ++i) {
                if (set.contains(lookupArray[i])) {
                    resultArray[i] = lookupArray[i].lookup(this.template());
                    if (map == null) continue;
                    map.put(resultArray[i], this.weakL);
                    continue;
                }
                resultArray[i] = (Lookup.Result)identityHashMap.get(lookupArray[i]);
                if (resultArray[i] != null) continue;
                throw new IllegalStateException();
            }
            ((WeakResult)this.weakL).setResults(resultArray);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addLookupListener(LookupListener lookupListener) {
            ProxyLookup proxyLookup = this.proxy();
            synchronized (proxyLookup) {
                if (this.listeners == null) {
                    this.listeners = new LookupListenerList();
                }
            }
            this.listeners.add(lookupListener);
            this.initResults();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeLookupListener(LookupListener lookupListener) {
            LookupListenerList lookupListenerList;
            ProxyLookup proxyLookup = this.proxy();
            synchronized (proxyLookup) {
                lookupListenerList = this.listeners;
            }
            if (lookupListenerList != null) {
                lookupListenerList.remove(lookupListener);
            }
        }

        @Override
        public Collection<T> allInstances() {
            return this.allInstances(true);
        }

        @Override
        protected Collection<T> allInstances(boolean bl) {
            return this.computeResult(0, bl);
        }

        @Override
        public Set<Class<? extends T>> allClasses() {
            return (Set)this.computeResult(1, true);
        }

        @Override
        public Collection<? extends Lookup.Item<T>> allItems() {
            return this.allItems(true);
        }

        @Override
        public Collection<? extends Lookup.Item<T>> allItems(boolean bl) {
            return this.computeResult(2, bl);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Collection computeResult(int n, boolean bl) {
            Object[] objectArray;
            Collection collection = null;
            Lookup.Result[] resultArray = this.proxy();
            synchronized (resultArray) {
                objectArray = this.getCache();
                if (objectArray != null && objectArray != NO_CACHE) {
                    collection = objectArray[n];
                }
            }
            resultArray = this.myBeforeLookup(bl, collection != null);
            ProxyLookup proxyLookup = this.proxy();
            synchronized (proxyLookup) {
                objectArray = this.getCache();
                if (objectArray != null && objectArray != NO_CACHE) {
                    collection = objectArray[n];
                }
            }
            if (collection != null) {
                return collection;
            }
            if (n == 1) {
                return new LazySet(this, objectArray, n, bl, resultArray);
            }
            return new LazyList(this, objectArray, n, bl, resultArray);
        }

        public void resultChanged(LookupEvent lookupEvent) {
            this.collectFires(null);
        }

        @Override
        protected void collectFires(Collection<Object> collection) {
            R r = IN.get();
            if (this == r) {
                return;
            }
            try {
                IN.set(this);
                this.collImpl(collection);
            }
            finally {
                IN.set(r);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        private void collImpl(Collection<Object> collection) {
            Object object;
            Collection[] collectionArray;
            boolean bl;
            block31: {
                bl = true;
                try {
                    ProxyLookup proxyLookup = this.proxy();
                    // MONITORENTER : proxyLookup
                    collectionArray = this.getCache();
                    if (collectionArray != NO_CACHE) break block31;
                    // MONITOREXIT : proxyLookup
                    ProxyLookup proxyLookup2 = this.proxy();
                }
                catch (Throwable throwable) {
                    ProxyLookup proxyLookup = this.proxy();
                    // MONITORENTER : proxyLookup
                    if (this.getCache() == NO_CACHE) {
                        this.setCache(null);
                    }
                    // MONITOREXIT : proxyLookup
                    throw throwable;
                }
                if (this.getCache() == NO_CACHE) {
                    this.setCache(null);
                }
                // MONITOREXIT : proxyLookup2
                return;
            }
            Collection collection2 = collectionArray == null ? null : collectionArray[0];
            Object object2 = object = collectionArray == null ? null : collectionArray[2];
            if (this.listeners == null || this.listeners.getListenerCount() == 0) {
                this.setCache(new Collection[3]);
                // MONITOREXIT : proxyLookup
                ProxyLookup proxyLookup = this.proxy();
                // MONITORENTER : proxyLookup
                if (this.getCache() == NO_CACHE) {
                    this.setCache(null);
                }
                // MONITOREXIT : proxyLookup
                return;
            }
            Object[] objectArray = this.listeners.getListenerList();
            assert (objectArray != null);
            this.setCache(NO_CACHE);
            // MONITOREXIT : proxyLookup
            if (object != null) {
                Collection<Lookup.Item<T>> collection3 = this.allItems(false);
                if (collection3 != null && collection3.size() == object.size() && object.equals(collection3)) {
                    bl = false;
                }
            } else if (collection2 != null) {
                Collection<T> collection4 = this.allInstances(false);
                if (collection4 != null && collection4.size() == collection2.size() && collection2.equals(collection4)) {
                    bl = false;
                }
            } else {
                Collection<Lookup.Item<T>> collection5 = this.allItems(false);
                if (collection5.isEmpty()) {
                    bl = false;
                }
                ProxyLookup proxyLookup = this.proxy();
                // MONITORENTER : proxyLookup
                if (this.getCache() == NO_CACHE) {
                    this.setCache(new Collection[3]);
                }
                // MONITOREXIT : proxyLookup
            }
            object = this.proxy();
            if (this.getCache() == NO_CACHE) {
                this.setCache(null);
            }
            // MONITOREXIT : object
            if (!bl) return;
            object = new LookupEvent(this);
            AbstractLookup.notifyListeners(objectArray, (LookupEvent)object, collection);
        }

        private Lookup.Result<T>[] myBeforeLookup(boolean bl, boolean bl2) {
            Lookup.Template<T> template = this.template();
            this.proxy().beforeLookup(bl, template);
            Lookup.Result<T>[] resultArray = this.initResults();
            if (bl2) {
                for (int i = 0; i < resultArray.length; ++i) {
                    if (!(resultArray[i] instanceof WaitableResult)) continue;
                    WaitableResult waitableResult = (WaitableResult)resultArray[i];
                    waitableResult.beforeLookup(template);
                }
            }
            return resultArray;
        }

        @Override
        protected void beforeLookup(Lookup.Template template) {
            if (template.getType() == this.template().getType()) {
                this.myBeforeLookup(true, true);
            }
        }

        private Collection[] getCache() {
            return this.cache;
        }

        private void setCache(Collection[] collectionArray) {
            assert (Thread.holdsLock(this.proxy()));
            this.cache = collectionArray;
        }

        private Lookup.Template<T> template() {
            return ((WeakResult)this.weakL).result.template;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateResultCache(Object[] objectArray, int n, Lookup.Result[] resultArray, Collection<Object> collection) {
            ProxyLookup proxyLookup = this.proxy();
            synchronized (proxyLookup) {
                Collection[] collectionArray = this.getCache();
                if (collectionArray != objectArray) {
                    return;
                }
                if (collectionArray == null || collectionArray == NO_CACHE) {
                    collectionArray = new Collection[3];
                    this.setCache(collectionArray);
                }
                if (resultArray == ((WeakResult)this.weakL).getResults()) {
                    collectionArray[n] = collection;
                }
            }
        }
    }
}

