/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.core.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.ui.DataSourceCaption;
import org.graalvm.visualvm.core.ui.DataSourceView;
import org.graalvm.visualvm.core.ui.components.DataViewComponent;
import org.graalvm.visualvm.uisupport.ProfilerTabbedPane;
import org.graalvm.visualvm.uisupport.UISupport;

abstract class DataSourceWindowTabbedPane
extends JPanel {
    private final ProfilerTabbedPane tabpane = new ProfilerTabbedPane(){

        protected void closeTab(Component component) {
            DataSourceWindowTabbedPane.this.closeView((ViewContainer)component);
        }
    };

    DataSourceWindowTabbedPane() {
        super(new BorderLayout());
        this.tabpane.setFocusCycleRoot(false);
        this.tabpane.setOpaque(false);
        if (UIManager.getLookAndFeel().getID().equals("Aqua")) {
            this.tabpane.setBorder(BorderFactory.createEmptyBorder(0, -11, -13, -10));
        } else {
            this.tabpane.setBorder(BorderFactory.createEmptyBorder());
            Insets i = UIManager.getInsets("TabbedPane.contentBorderInsets");
            if (i != null) {
                this.tabpane.setBorder(BorderFactory.createEmptyBorder(0, -i.left, -i.bottom, -i.right));
            }
        }
        this.add((Component)this.tabpane, "Center");
    }

    @Override
    public final boolean requestFocusInWindow() {
        Component sel = this.tabpane.getSelectedComponent();
        if (sel != null) {
            return sel.requestFocusInWindow();
        }
        return super.requestFocusInWindow();
    }

    public void addView(DataSource dataSource, DataSourceView view) {
        ViewContainer container = new ViewContainer(new DataSourceCaption<DataSource>(dataSource), view);
        this.tabpane.addTab(view.getName(), (Icon)new ImageIcon(view.getImage()), (Component)container, null, view.isClosable());
    }

    public void removeView(int index) {
        ViewContainer container = (ViewContainer)this.tabpane.getComponentAt(index);
        this.tabpane.removeTabAt(index);
        container.getCaption().finish();
    }

    public DataSourceView getView(ViewContainer container) {
        return container.getView();
    }

    public int indexOfView(final DataSourceView view) {
        final int[] index = new int[]{-1};
        UISupport.runInEventDispatchThreadAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < DataSourceWindowTabbedPane.this.tabpane.getTabCount(); ++i) {
                    if (((ViewContainer)DataSourceWindowTabbedPane.this.tabpane.getComponentAt(i)).getViewComponent() != view.getView()) continue;
                    index[0] = i;
                }
            }
        });
        return index[0];
    }

    public List<DataSourceView> getViews() {
        ArrayList<DataSourceView> views = new ArrayList<DataSourceView>();
        for (int i = 0; i < this.tabpane.getTabCount(); ++i) {
            ViewContainer container = (ViewContainer)this.tabpane.getComponentAt(i);
            views.add(container.getView());
        }
        return views;
    }

    public void setViewIndex(int index) {
        this.tabpane.setSelectedIndex(index);
    }

    public void setViewBackground(int index, Color background) {
        this.tabpane.setBackgroundAt(index, background);
    }

    protected abstract void closeView(ViewContainer var1);

    static class ViewContainer
    extends JPanel {
        private DataSourceCaption caption;
        private DataSourceView view;
        private DataViewComponent viewComponent;

        public ViewContainer(DataSourceCaption caption, DataSourceView view) {
            Color backgroundColor = UISupport.getDefaultBackground();
            this.caption = caption;
            this.view = view;
            this.viewComponent = view.getView();
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createMatteBorder(5, 5, 5, 5, backgroundColor));
            this.setBackground(backgroundColor);
            this.setFocusable(false);
            this.add((Component)this.viewComponent, "Center");
            if (caption != null) {
                caption.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
                caption.setBackground(backgroundColor);
                this.add((Component)caption, "North");
            }
        }

        @Override
        public final boolean requestFocusInWindow() {
            if (this.getComponentCount() > 0) {
                return this.getComponent(0).requestFocusInWindow();
            }
            return super.requestFocusInWindow();
        }

        public DataSourceCaption getCaption() {
            return this.caption;
        }

        public DataSourceView getView() {
            return this.view;
        }

        public DataViewComponent getViewComponent() {
            return this.viewComponent;
        }
    }
}

