/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.core.snapshot;

import java.awt.Image;
import java.io.File;
import java.util.Date;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.core.datasource.descriptor.DataSourceDescriptorFactory;
import org.graalvm.visualvm.core.datasupport.Utils;
import org.graalvm.visualvm.core.properties.PropertiesSupport;
import org.graalvm.visualvm.core.snapshot.GeneralPropertiesProvider;
import org.graalvm.visualvm.core.snapshot.Snapshot;
import org.graalvm.visualvm.lib.jfluid.utils.StringUtils;
import org.graalvm.visualvm.lib.profiler.api.ProfilerDialogs;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

public final class SnapshotsSupport {
    private static final Image SNAPSHOT_BADGE = ImageUtilities.loadImage((String)"org/graalvm/visualvm/core/ui/resources/snapshotBadge.png", (boolean)true);
    private static SnapshotsSupport instance;

    public static synchronized SnapshotsSupport getInstance() {
        if (instance == null) {
            instance = new SnapshotsSupport();
        }
        return instance;
    }

    public void saveAs(final Snapshot snapshot, String dialogTitle) {
        final File file = snapshot.getFile();
        if (file == null) {
            ProfilerDialogs.displayError((String)NbBundle.getMessage(SnapshotsSupport.class, (String)"LBL_CannotSave"));
        } else {
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle(dialogTitle);
            chooser.setSelectedFile(new File(snapshot.getFile().getName()));
            chooser.setAcceptAllFileFilterUsed(false);
            chooser.setFileFilter(snapshot.getCategory().getFileFilter());
            if (chooser.showSaveDialog(WindowManager.getDefault().getMainWindow()) == 0) {
                String categorySuffix = snapshot.getCategory().getSuffix();
                String filePath = chooser.getSelectedFile().getAbsolutePath();
                if (!filePath.endsWith(categorySuffix)) {
                    filePath = filePath + categorySuffix;
                }
                final File copy = new File(filePath);
                RequestProcessor.getDefault().post(new Runnable(){

                    @Override
                    public void run() {
                        ProgressHandle pHandleF;
                        ProgressHandle pHandle = null;
                        try {
                            pHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(SnapshotsSupport.class, (String)"LBL_Saving", (Object)DataSourceDescriptorFactory.getDescriptor(snapshot).getName()));
                            pHandle.setInitialDelay(0);
                            pHandle.start();
                            Utils.copyFile(file, copy);
                            pHandleF = pHandle;
                        }
                        catch (Throwable throwable) {
                            ProgressHandle pHandleF2 = pHandle;
                            SwingUtilities.invokeLater(new Runnable(pHandleF2){
                                final /* synthetic */ ProgressHandle val$pHandleF;
                                {
                                    this.val$pHandleF = progressHandle;
                                }

                                @Override
                                public void run() {
                                    if (this.val$pHandleF != null) {
                                        this.val$pHandleF.finish();
                                    }
                                }
                            });
                            throw throwable;
                        }
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    }
                });
            }
        }
    }

    public String getTimeStamp(long time) {
        return StringUtils.formatUserDate((Date)new Date(time));
    }

    public Image createSnapshotIcon(Image icon) {
        return ImageUtilities.mergeImages((Image)icon, (Image)SNAPSHOT_BADGE, (int)0, (int)0);
    }

    private SnapshotsSupport() {
        PropertiesSupport.sharedInstance().registerPropertiesProvider(new GeneralPropertiesProvider(), Snapshot.class);
    }
}

