/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.nashorn.regexp.joni;

import com.oracle.truffle.regex.nashorn.regexp.joni.ApplyCaseFold;
import com.oracle.truffle.regex.nashorn.regexp.joni.CaseFoldTable;
import com.oracle.truffle.regex.nashorn.regexp.joni.encoding.IntHolder;
import java.util.Arrays;
import java.util.function.ObjIntConsumer;

public final class EncodingHelper {
    static final int NEW_LINE = 10;
    static final int CARRIAGE_RETURN = 13;
    static final int LINE_SEPARATOR = 8232;
    static final int PARAGRAPH_SEPARATOR = 8233;
    static final char[] EMPTYCHARS = new char[0];
    static final int[][] codeRanges = new int[15][];

    public static int digitVal(int code) {
        return code - 48;
    }

    public static int odigitVal(int code) {
        return EncodingHelper.digitVal(code);
    }

    public static boolean isXDigit(int code) {
        return Character.isDigit(code) || code >= 97 && code <= 102 || code >= 65 && code <= 70;
    }

    public static int xdigitVal(int code) {
        if (Character.isDigit(code)) {
            return code - 48;
        }
        if (code >= 97 && code <= 102) {
            return code - 97 + 10;
        }
        return code - 65 + 10;
    }

    public static boolean isDigit(int code) {
        return code >= 48 && code <= 57;
    }

    public static boolean isWord(int code) {
        return 97 <= code && code <= 122 || 65 <= code && code <= 90 || 48 <= code && code <= 57 || code == 95;
    }

    public static boolean isNewLine(int code) {
        return code == 10 || code == 13 || code == 8232 || code == 8233;
    }

    public static boolean isSpace(int code) {
        return 9 <= code && code <= 13 || 8192 <= code && code <= 8202 || code == 32 || code == 160 || code == 5760 || code == 8232 || code == 8233 || code == 8239 || code == 8287 || code == 12288 || code == 65279;
    }

    public static int prevCharHead(int p, int s) {
        return s <= p ? -1 : s - 1;
    }

    public static int rightAdjustCharHeadWithPrev(int s, IntHolder prev) {
        if (prev != null) {
            prev.value = -1;
        }
        return s;
    }

    public static int stepBack(int p, int sp, int np) {
        int s;
        int n = np;
        for (s = sp; s != -1 && n-- > 0; --s) {
            if (s > p) continue;
            return -1;
        }
        return s;
    }

    public static int mbcodeStartPosition() {
        return 128;
    }

    public static char[] caseFoldCodesByString0(int flag, char c) {
        char[] codes = EMPTYCHARS;
        char upper = EncodingHelper.toUpperCase(c);
        if (upper != EncodingHelper.toLowerCase(upper)) {
            char c2;
            int count = 0;
            char ch = '\u0000';
            do {
                char u;
                if ((u = EncodingHelper.toUpperCase(ch)) == upper && ch != c) {
                    codes = count == 0 ? new char[1] : Arrays.copyOf(codes, count + 1);
                    codes[count++] = ch;
                }
                c2 = ch;
                ch = (char)(ch + '\u0001');
            } while (c2 < '\uffff');
        }
        return codes;
    }

    public static char[] caseFoldCodesByString1(int flag, char c) {
        char lower;
        char upper = EncodingHelper.toUpperCase(c);
        if (upper != (lower = EncodingHelper.toLowerCase(upper))) {
            char[] cached = CaseFoldCodesTable.lookup(c);
            if (cached != null) {
                return cached;
            }
            return new char[]{upper == c ? lower : upper};
        }
        return EMPTYCHARS;
    }

    public static void applyAllCaseFold1(int flag, ApplyCaseFold fun, Object arg) {
        int upper;
        int c;
        for (c = 0; c < 65535; ++c) {
            if (!Character.isLowerCase(c) || (upper = EncodingHelper.toUpperCase(c)) == c) continue;
            ApplyCaseFold.apply(c, upper, arg);
        }
        for (c = 0; c < 65535; ++c) {
            if (!Character.isLowerCase(c) || (upper = EncodingHelper.toUpperCase(c)) == c) continue;
            ApplyCaseFold.apply(upper, c, arg);
        }
    }

    public static char[] caseFoldCodesByString(int flag, char c) {
        int[] codes = EncodingHelper.lookupCaseFoldCodes(CaseFoldTable.UCS2.instance(), c);
        if (codes.length > 0) {
            char[] chars = new char[codes.length];
            for (int i = 0; i < codes.length; ++i) {
                chars[i] = (char)codes[i];
            }
            return chars;
        }
        return EMPTYCHARS;
    }

    public static void applyAllCaseFold(int flag, ApplyCaseFold fun, Object arg) {
        EncodingHelper.iterateCaseFoldTable(CaseFoldTable.UCS2.instance(), (to, from) -> {
            for (int j = 0; j < ((int[])to).length; ++j) {
                int toc = to[j];
                assert (from != toc);
                ApplyCaseFold.apply(from, toc, arg);
            }
        });
    }

    public static char toLowerCase(char c) {
        return (char)EncodingHelper.toLowerCase((int)c);
    }

    public static int toLowerCase(int c) {
        if (c < 128) {
            return 65 <= c && c <= 90 ? c + 32 : c;
        }
        int lower = Character.toLowerCase(c);
        return lower < 128 ? c : lower;
    }

    public static char toUpperCase(char c) {
        return (char)EncodingHelper.toUpperCase((int)c);
    }

    public static int toUpperCase(int c) {
        if (c < 128) {
            return 97 <= c && c <= 122 ? c + -32 : c;
        }
        int upper = Character.toUpperCase(c);
        return upper < 128 ? c : upper;
    }

    public static int[] ctypeCodeRange(int ctype, IntHolder sbOut) {
        sbOut.value = 256;
        int[] range = null;
        if (ctype < codeRanges.length && (range = codeRanges[ctype]) == null) {
            range = new int[16];
            int rangeCount = 0;
            int lastCode = -2;
            for (int code = 0; code <= 65535; ++code) {
                if (!EncodingHelper.isCodeCType(code, ctype)) continue;
                if (lastCode < code - 1) {
                    if (rangeCount * 2 + 2 >= range.length) {
                        range = Arrays.copyOf(range, range.length * 2);
                    }
                    range[rangeCount * 2 + 1] = code;
                    ++rangeCount;
                }
                range[rangeCount * 2] = lastCode = code;
            }
            if (rangeCount * 2 + 1 < range.length) {
                range = Arrays.copyOf(range, rangeCount * 2 + 1);
            }
            range[0] = rangeCount;
            EncodingHelper.codeRanges[ctype] = range;
        }
        return range;
    }

    public static boolean isInCodeRange(int[] p, int offset, int code) {
        int n;
        int low = 0;
        int high = n = p[offset];
        while (low < high) {
            int x = low + high >> 1;
            if (code > p[(x << 1) + 2 + offset]) {
                low = x + 1;
                continue;
            }
            high = x;
        }
        return low < n && code >= p[(low << 1) + 1 + offset];
    }

    public static boolean isCodeCType(int code, int ctype) {
        switch (ctype) {
            case 0: {
                return EncodingHelper.isNewLine(code);
            }
            case 1: {
                return (1 << Character.getType(code) & 0x1FE) != 0;
            }
            case 2: {
                return code == 9 || Character.getType(code) == 12;
            }
            case 3: {
                int type = Character.getType(code);
                return (1 << type & 0xD8000) != 0 || type == 0;
            }
            case 4: {
                return EncodingHelper.isDigit(code);
            }
            case 5: {
                switch (code) {
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: {
                        return false;
                    }
                }
                int type = Character.getType(code);
                return (1 << type & 0x8F000) == 0 && type != 0;
            }
            case 6: {
                return Character.isLowerCase(code);
            }
            case 7: {
                int type = Character.getType(code);
                return (1 << type & 0x88000) == 0 && type != 0;
            }
            case 8: {
                return (1 << Character.getType(code) & 0x61F00000) != 0;
            }
            case 9: {
                return EncodingHelper.isSpace(code);
            }
            case 10: {
                return Character.isUpperCase(code);
            }
            case 11: {
                return EncodingHelper.isXDigit(code);
            }
            case 12: {
                return EncodingHelper.isWord(code);
            }
            case 13: {
                return (1 << Character.getType(code) & 0x3FE) != 0;
            }
            case 14: {
                return code < 128;
            }
        }
        throw new RuntimeException("illegal character type: " + ctype);
    }

    private static int[] getToSet(int type, int from, int value, CaseFoldTable table) {
        int[] to;
        switch (type) {
            case 1: {
                int[] set = table.getSetTable()[value];
                to = EncodingHelper.complement(set, from);
                break;
            }
            case 2: 
            case 3: {
                to = new int[]{type == 2 ? from + value : from - value};
                break;
            }
            case 4: 
            case 5: {
                to = new int[]{type == 4 ? from ^ 1 : (from - 1 ^ 1) + 1};
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return to;
    }

    private static void iterateCaseFoldTable(CaseFoldTable table, ObjIntConsumer<int[]> caseFoldConsumer) {
        int ranges = table.getRangeCount();
        for (int i = 0; i < ranges; ++i) {
            int start = table.getRangeStart(i);
            int end = table.getRangeEnd(i);
            int value = table.getRangeValue(i);
            int type = table.getRangeType(i);
            if (type == 0) continue;
            for (int j = start; j <= end; ++j) {
                int[] to = EncodingHelper.getToSet(type, j, value, table);
                caseFoldConsumer.accept(to, j);
            }
        }
    }

    private static int[] lookupCaseFoldCodes(CaseFoldTable table, int from) {
        int rangeIndex = EncodingHelper.binaryRangeSearch(table, from);
        if (rangeIndex >= 0) {
            int value = table.getRangeValue(rangeIndex);
            int type = table.getRangeType(rangeIndex);
            if (type != 0) {
                int[] to = EncodingHelper.getToSet(type, from, value, table);
                return to;
            }
        }
        return new int[0];
    }

    private static int binaryRangeSearch(CaseFoldTable table, int key) {
        int low = 0;
        int high = table.getRangeCount() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int midValLower = table.getRangeStart(mid);
            int midValUpper = table.getRangeEnd(mid);
            if (midValUpper < key) {
                low = mid + 1;
                continue;
            }
            if (midValLower > key) {
                high = mid - 1;
                continue;
            }
            assert (key >= midValLower && key <= midValUpper);
            return mid;
        }
        return -(low + 1);
    }

    private static int[] complement(int[] set, int minus) {
        int[] sub = new int[set.length - 1];
        int j = 0;
        for (int i = 0; i < set.length; ++i) {
            if (set[i] == minus) continue;
            sub[j++] = set[i];
        }
        assert (j == sub.length);
        return sub;
    }

    private static class CaseFoldCodesTable {
        private static final char[][] ALTS = CaseFoldCodesTable.calculateCaseFoldCodeTable();

        private CaseFoldCodesTable() {
        }

        private static char[][] calculateCaseFoldCodeTable() {
            int tableSize = 8492;
            char[][] alts = new char[8492][];
            for (char i = '\u0000'; i < '\u212c'; i = (char)(i + '\u0001')) {
                char[] result = EncodingHelper.caseFoldCodesByString0(0, i);
                if (result.length <= 1 && (result.length != 0 || EncodingHelper.toLowerCase(EncodingHelper.toUpperCase(i)) == EncodingHelper.toUpperCase(i))) continue;
                alts[i] = result;
            }
            assert (CaseFoldCodesTable.verifyTableSize('\u212c'));
            return alts;
        }

        static char[] lookup(char c) {
            return c < ALTS.length ? ALTS[c] : null;
        }

        private static boolean verifyTableSize(char tableSize) {
            for (char i = tableSize; i < '\uffff'; i = (char)(i + '\u0001')) {
                char[] result = EncodingHelper.caseFoldCodesByString0(0, i);
                assert (result.length <= 1 && (result.length != 0 || EncodingHelper.toLowerCase(EncodingHelper.toUpperCase(i)) == EncodingHelper.toUpperCase(i))) : i;
            }
            return true;
        }
    }
}

