/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.joni;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.js.runtime.joni.AbstractConstantKeysObject;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=AbstractConstantKeysObject.class)
public final class AbstractConstantKeysObjectFactory {

    @GeneratedBy(value=AbstractConstantKeysObject.ReadCacheNode.class)
    public static final class ReadCacheNodeGen
    extends AbstractConstantKeysObject.ReadCacheNode {
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;
        @CompilerDirectives.CompilationFinal
        private ReadIdentityData readIdentity_cache;
        @CompilerDirectives.CompilationFinal
        private ReadEqualsData readEquals_cache;

        private ReadCacheNodeGen() {
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public Object execute(AbstractConstantKeysObject arg0Value, String arg1Value) throws UnknownIdentifierException {
            int state = this.state_;
            if (state != 0) {
                if ((state & 1) != 0) {
                    ReadIdentityData s1_ = this.readIdentity_cache;
                    while (s1_ != null) {
                        if (arg1Value == s1_.cachedSymbol_) {
                            return this.readIdentity(arg0Value, arg1Value, s1_.cachedSymbol_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 2) != 0) {
                    ReadEqualsData s2_ = this.readEquals_cache;
                    while (s2_ != null) {
                        if (arg1Value.equals(s2_.cachedSymbol_)) {
                            return this.readEquals(arg0Value, arg1Value, s2_.cachedSymbol_);
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state & 4) != 0) {
                    return AbstractConstantKeysObject.ReadCacheNode.read(arg0Value, arg1Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object executeAndSpecialize(AbstractConstantKeysObject arg0Value, String arg1Value) throws UnknownIdentifierException {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                if ((exclude & 1) == 0) {
                    int count1_ = 0;
                    ReadIdentityData s1_ = this.readIdentity_cache;
                    if ((state & 1) != 0) {
                        while (s1_ != null && arg1Value != s1_.cachedSymbol_) {
                            s1_ = s1_.next_;
                            ++count1_;
                        }
                    }
                    if (s1_ == null && count1_ < 8) {
                        s1_ = new ReadIdentityData(this.readIdentity_cache);
                        s1_.cachedSymbol_ = arg1Value;
                        this.readIdentity_cache = s1_;
                        this.state_ = state |= 1;
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        Object object = this.readIdentity(arg0Value, arg1Value, s1_.cachedSymbol_);
                        return object;
                    }
                }
                if ((exclude & 2) == 0) {
                    int count2_ = 0;
                    ReadEqualsData s2_ = this.readEquals_cache;
                    if ((state & 2) != 0) {
                        while (s2_ != null && !arg1Value.equals(s2_.cachedSymbol_)) {
                            s2_ = s2_.next_;
                            ++count2_;
                        }
                    }
                    if (s2_ == null && count2_ < 8) {
                        s2_ = new ReadEqualsData(this.readEquals_cache);
                        s2_.cachedSymbol_ = arg1Value;
                        this.readEquals_cache = s2_;
                        this.exclude_ = exclude |= 1;
                        this.readIdentity_cache = null;
                        state &= 0xFFFFFFFE;
                        this.state_ = state |= 2;
                    }
                    if (s2_ != null) {
                        lock.unlock();
                        hasLock = false;
                        Object object = this.readEquals(arg0Value, arg1Value, s2_.cachedSymbol_);
                        return object;
                    }
                }
                this.exclude_ = exclude |= 3;
                this.readIdentity_cache = null;
                this.readEquals_cache = null;
                state &= 0xFFFFFFFC;
                this.state_ = state |= 4;
                lock.unlock();
                hasLock = false;
                Object object = AbstractConstantKeysObject.ReadCacheNode.read(arg0Value, arg1Value);
                return object;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                ReadIdentityData s1_ = this.readIdentity_cache;
                ReadEqualsData s2_ = this.readEquals_cache;
                if (!(s1_ != null && s1_.next_ != null || s2_ != null && s2_.next_ != null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static AbstractConstantKeysObject.ReadCacheNode create() {
            return new ReadCacheNodeGen();
        }

        public static AbstractConstantKeysObject.ReadCacheNode getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=AbstractConstantKeysObject.ReadCacheNode.class)
        private static final class Uncached
        extends AbstractConstantKeysObject.ReadCacheNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object execute(AbstractConstantKeysObject arg0Value, String arg1Value) throws UnknownIdentifierException {
                return AbstractConstantKeysObject.ReadCacheNode.read(arg0Value, arg1Value);
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            public boolean isAdoptable() {
                return false;
            }
        }

        @GeneratedBy(value=AbstractConstantKeysObject.ReadCacheNode.class)
        private static final class ReadEqualsData {
            @CompilerDirectives.CompilationFinal
            ReadEqualsData next_;
            @CompilerDirectives.CompilationFinal
            String cachedSymbol_;

            ReadEqualsData(ReadEqualsData next_) {
                this.next_ = next_;
            }
        }

        @GeneratedBy(value=AbstractConstantKeysObject.ReadCacheNode.class)
        private static final class ReadIdentityData {
            @CompilerDirectives.CompilationFinal
            ReadIdentityData next_;
            @CompilerDirectives.CompilationFinal
            String cachedSymbol_;

            ReadIdentityData(ReadIdentityData next_) {
                this.next_ = next_;
            }
        }
    }

    @GeneratedBy(value=AbstractConstantKeysObject.IsReadableCacheNode.class)
    public static final class IsReadableCacheNodeGen
    extends AbstractConstantKeysObject.IsReadableCacheNode {
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;
        @CompilerDirectives.CompilationFinal
        private CacheIdentityData cacheIdentity_cache;
        @CompilerDirectives.CompilationFinal
        private CacheEqualsData cacheEquals_cache;

        private IsReadableCacheNodeGen() {
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public boolean execute(AbstractConstantKeysObject arg0Value, String arg1Value) {
            int state = this.state_;
            if (state != 0) {
                if ((state & 1) != 0) {
                    CacheIdentityData s1_ = this.cacheIdentity_cache;
                    while (s1_ != null) {
                        if (arg1Value == s1_.cachedSymbol_) {
                            return AbstractConstantKeysObject.IsReadableCacheNode.cacheIdentity(arg0Value, arg1Value, s1_.cachedSymbol_, s1_.result_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 2) != 0) {
                    CacheEqualsData s2_ = this.cacheEquals_cache;
                    while (s2_ != null) {
                        if (arg1Value.equals(s2_.cachedSymbol_)) {
                            return AbstractConstantKeysObject.IsReadableCacheNode.cacheEquals(arg0Value, arg1Value, s2_.cachedSymbol_, s2_.result_);
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state & 4) != 0) {
                    return AbstractConstantKeysObject.IsReadableCacheNode.isReadable(arg0Value, arg1Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean executeAndSpecialize(AbstractConstantKeysObject arg0Value, String arg1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                if ((exclude & 1) == 0) {
                    int count1_ = 0;
                    CacheIdentityData s1_ = this.cacheIdentity_cache;
                    if ((state & 1) != 0) {
                        while (s1_ != null && arg1Value != s1_.cachedSymbol_) {
                            s1_ = s1_.next_;
                            ++count1_;
                        }
                    }
                    if (s1_ == null && count1_ < 8) {
                        s1_ = new CacheIdentityData(this.cacheIdentity_cache);
                        s1_.cachedSymbol_ = arg1Value;
                        s1_.result_ = AbstractConstantKeysObject.IsReadableCacheNode.isReadable(arg0Value, s1_.cachedSymbol_);
                        this.cacheIdentity_cache = s1_;
                        this.state_ = state |= 1;
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        boolean bl = AbstractConstantKeysObject.IsReadableCacheNode.cacheIdentity(arg0Value, arg1Value, s1_.cachedSymbol_, s1_.result_);
                        return bl;
                    }
                }
                if ((exclude & 2) == 0) {
                    int count2_ = 0;
                    CacheEqualsData s2_ = this.cacheEquals_cache;
                    if ((state & 2) != 0) {
                        while (s2_ != null && !arg1Value.equals(s2_.cachedSymbol_)) {
                            s2_ = s2_.next_;
                            ++count2_;
                        }
                    }
                    if (s2_ == null && count2_ < 8) {
                        s2_ = new CacheEqualsData(this.cacheEquals_cache);
                        s2_.cachedSymbol_ = arg1Value;
                        s2_.result_ = AbstractConstantKeysObject.IsReadableCacheNode.isReadable(arg0Value, s2_.cachedSymbol_);
                        this.cacheEquals_cache = s2_;
                        this.exclude_ = exclude |= 1;
                        this.cacheIdentity_cache = null;
                        state &= 0xFFFFFFFE;
                        this.state_ = state |= 2;
                    }
                    if (s2_ != null) {
                        lock.unlock();
                        hasLock = false;
                        boolean bl = AbstractConstantKeysObject.IsReadableCacheNode.cacheEquals(arg0Value, arg1Value, s2_.cachedSymbol_, s2_.result_);
                        return bl;
                    }
                }
                this.exclude_ = exclude |= 3;
                this.cacheIdentity_cache = null;
                this.cacheEquals_cache = null;
                state &= 0xFFFFFFFC;
                this.state_ = state |= 4;
                lock.unlock();
                hasLock = false;
                boolean bl = AbstractConstantKeysObject.IsReadableCacheNode.isReadable(arg0Value, arg1Value);
                return bl;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                CacheIdentityData s1_ = this.cacheIdentity_cache;
                CacheEqualsData s2_ = this.cacheEquals_cache;
                if (!(s1_ != null && s1_.next_ != null || s2_ != null && s2_.next_ != null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static AbstractConstantKeysObject.IsReadableCacheNode create() {
            return new IsReadableCacheNodeGen();
        }

        public static AbstractConstantKeysObject.IsReadableCacheNode getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=AbstractConstantKeysObject.IsReadableCacheNode.class)
        private static final class Uncached
        extends AbstractConstantKeysObject.IsReadableCacheNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean execute(AbstractConstantKeysObject arg0Value, String arg1Value) {
                return AbstractConstantKeysObject.IsReadableCacheNode.isReadable(arg0Value, arg1Value);
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            public boolean isAdoptable() {
                return false;
            }
        }

        @GeneratedBy(value=AbstractConstantKeysObject.IsReadableCacheNode.class)
        private static final class CacheEqualsData {
            @CompilerDirectives.CompilationFinal
            CacheEqualsData next_;
            @CompilerDirectives.CompilationFinal
            String cachedSymbol_;
            @CompilerDirectives.CompilationFinal
            boolean result_;

            CacheEqualsData(CacheEqualsData next_) {
                this.next_ = next_;
            }
        }

        @GeneratedBy(value=AbstractConstantKeysObject.IsReadableCacheNode.class)
        private static final class CacheIdentityData {
            @CompilerDirectives.CompilationFinal
            CacheIdentityData next_;
            @CompilerDirectives.CompilationFinal
            String cachedSymbol_;
            @CompilerDirectives.CompilationFinal
            boolean result_;

            CacheIdentityData(CacheIdentityData next_) {
                this.next_ = next_;
            }
        }
    }
}

