/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.control;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.GetIteratorNode;
import com.oracle.truffle.js.nodes.access.GetMethodNode;
import com.oracle.truffle.js.nodes.access.IteratorCompleteNode;
import com.oracle.truffle.js.nodes.access.IteratorNextNode;
import com.oracle.truffle.js.nodes.access.IteratorValueNode;
import com.oracle.truffle.js.nodes.access.JSReadFrameSlotNode;
import com.oracle.truffle.js.nodes.access.WriteNode;
import com.oracle.truffle.js.nodes.control.AsyncGeneratorYieldNode;
import com.oracle.truffle.js.nodes.control.ReturnNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.GraalJSException;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.objects.Completion;
import com.oracle.truffle.js.runtime.objects.IteratorRecord;
import com.oracle.truffle.js.runtime.objects.Undefined;

class AsyncGeneratorYieldStarNode
extends AsyncGeneratorYieldNode {
    @Node.Child
    private JavaScriptNode readIteratorTemp;
    @Node.Child
    private WriteNode writeIteratorTemp;
    @Node.Child
    private GetIteratorNode getIteratorNode;
    @Node.Child
    private IteratorNextNode iteratorNextNode;
    @Node.Child
    private IteratorCompleteNode iteratorCompleteNode;
    @Node.Child
    private IteratorValueNode iteratorValueNode;
    @Node.Child
    private GetMethodNode getThrowMethodNode;
    @Node.Child
    private GetMethodNode getReturnMethodNode;
    @Node.Child
    private JSFunctionCallNode callThrowNode;
    @Node.Child
    private JSFunctionCallNode callReturnNode;

    protected AsyncGeneratorYieldStarNode(JSContext context, JavaScriptNode expression, JSReadFrameSlotNode readAsyncContextNode, JSReadFrameSlotNode readYieldResultNode, ReturnNode returnNode, JavaScriptNode readTemp, WriteNode writeTemp) {
        super(context, expression, readAsyncContextNode, readYieldResultNode, returnNode);
        this.readIteratorTemp = readTemp;
        this.writeIteratorTemp = writeTemp;
        this.getIteratorNode = GetIteratorNode.createAsync(context, null);
        this.iteratorNextNode = IteratorNextNode.create();
        this.iteratorCompleteNode = IteratorCompleteNode.create(context);
        this.iteratorValueNode = IteratorValueNode.create(context, null);
        this.getThrowMethodNode = GetMethodNode.create(context, null, "throw");
        this.getReturnMethodNode = GetMethodNode.create(context, null, "return");
        this.callThrowNode = JSFunctionCallNode.createCall();
        this.callReturnNode = JSFunctionCallNode.createCall();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object resume(VirtualFrame frame) {
        IteratorRecord iteratorRecord;
        int state = this.getStateAsInt(frame);
        boolean loopBegin = true;
        int normalOrThrowAwaitInnerResult = 2;
        int returnAwaitInnerReturnResult = 3;
        int asyncGeneratorYieldInnerResult = 4;
        int asyncGeneratorYieldInnerResultSuspendedYield = 5;
        int asyncGeneratorYieldInnerResultReturn = 6;
        int returnAwaitReceivedValue = 7;
        int throwAwaitReturnResult = 8;
        if (state == 0) {
            iteratorRecord = this.getIteratorNode.execute(this.expression.execute(frame));
            this.writeIteratorTemp.executeWrite(frame, iteratorRecord);
            state = 1;
        } else {
            iteratorRecord = (IteratorRecord)this.readIteratorTemp.execute(frame);
        }
        DynamicObject iterator = iteratorRecord.getIterator();
        Completion received = Completion.forNormal(Undefined.instance);
        while (true) {
            switch (state) {
                case 1: {
                    if (received.isNormal()) {
                        DynamicObject innerResult = this.iteratorNextNode.execute(iteratorRecord, received.getValue());
                        this.awaitWithNext(frame, innerResult, 2);
                        break;
                    }
                    if (received.isThrow()) {
                        Object returnResult;
                        Object throwMethod = this.getThrowMethodNode.executeWithTarget(iterator);
                        if (throwMethod != Undefined.instance) {
                            Object object = this.callThrowMethod(throwMethod, iterator, received.getValue());
                            this.awaitWithNext(frame, object, 2);
                            break;
                        }
                        Object object = this.getReturnMethodNode.executeWithTarget(iterator);
                        if (object == Undefined.instance) throw Errors.createTypeErrorYieldStarThrowMethodMissing(this);
                        try {
                            returnResult = this.callReturnNode.executeCall(JSArguments.createZeroArg(iterator, object));
                        }
                        catch (GraalJSException e) {
                            throw Errors.createTypeErrorYieldStarThrowMethodMissing(this);
                        }
                        this.awaitWithNext(frame, returnResult, 8);
                        throw Errors.createTypeErrorYieldStarThrowMethodMissing(this);
                    }
                    assert (received.isReturn());
                    Object returnMethod = this.getReturnMethodNode.executeWithTarget(iterator);
                    if (returnMethod != Undefined.instance) {
                        Object object = this.callReturnMethod(returnMethod, iterator, received.getValue());
                        this.awaitWithNext(frame, object, 3);
                        break;
                    }
                    this.awaitWithNext(frame, received.getValue(), 7);
                    break;
                }
                case 2: {
                    Object awaited = this.resumeAwait(frame);
                    DynamicObject dynamicObject = this.checkcastIterResult(awaited);
                    boolean done = this.iteratorCompleteNode.execute(dynamicObject);
                    if (done) {
                        this.reset(frame);
                        return this.iteratorValueNode.execute(dynamicObject);
                    }
                    Object iteratorValue = this.iteratorValueNode.execute(dynamicObject);
                    this.awaitWithNext(frame, iteratorValue, 4);
                    break;
                }
                case 3: {
                    Object awaited = this.resumeAwait(frame);
                    DynamicObject dynamicObject = this.checkcastIterResult(awaited);
                    boolean done = this.iteratorCompleteNode.execute(dynamicObject);
                    if (done) {
                        this.reset(frame);
                        return this.returnValue(frame, this.iteratorValueNode.execute(dynamicObject));
                    }
                    Object iteratorValue = this.iteratorValueNode.execute(dynamicObject);
                    this.awaitWithNext(frame, iteratorValue, 4);
                    break;
                }
                case 4: {
                    Object awaited = this.resumeAwait(frame);
                    this.yieldWithNext(frame, awaited, 5);
                    break;
                }
                case 5: {
                    Completion resumptionValue = this.resumeYield(frame);
                    if (!resumptionValue.isReturn()) {
                        received = resumptionValue;
                        state = 1;
                        break;
                    }
                    assert (resumptionValue.isReturn());
                    this.awaitWithNext(frame, resumptionValue.getValue(), 6);
                    break;
                }
                case 6: {
                    Completion returnValue = this.resumeYield(frame);
                    if (returnValue.isNormal()) {
                        received = Completion.forReturn(returnValue.getValue());
                    } else {
                        assert (returnValue.isThrow());
                        received = returnValue;
                    }
                    state = 1;
                    break;
                }
                case 7: {
                    Object awaited = this.resumeAwait(frame);
                    this.reset(frame);
                    return this.returnValue(frame, awaited);
                }
                case 8: {
                    this.resumeAwait(frame);
                    throw Errors.createTypeErrorYieldStarThrowMethodMissing(this);
                }
                default: {
                    throw Errors.shouldNotReachHere();
                }
            }
            assert (state == 1);
        }
    }

    private void awaitWithNext(VirtualFrame frame, Object value, int nextState) {
        this.setState(frame, nextState);
        this.suspendAwait(frame, value);
    }

    private Object yieldWithNext(VirtualFrame frame, Object value, int nextState) {
        this.setState(frame, nextState);
        return this.suspendYield(frame, value);
    }

    private void reset(VirtualFrame frame) {
        this.setState(frame, 0);
        this.writeIteratorTemp.executeWrite(frame, Undefined.instance);
    }

    private Object callThrowMethod(Object throwMethod, DynamicObject iterator, Object received) {
        return this.callThrowNode.executeCall(JSArguments.createOneArg(iterator, throwMethod, received));
    }

    private Object callReturnMethod(Object returnMethod, DynamicObject iterator, Object received) {
        return this.callReturnNode.executeCall(JSArguments.createOneArg(iterator, returnMethod, received));
    }

    private DynamicObject checkcastIterResult(Object iterResult) {
        if (!JSRuntime.isObject(iterResult)) {
            throw Errors.createTypeErrorIterResultNotAnObject(iterResult, this);
        }
        return (DynamicObject)iterResult;
    }

    @Override
    protected JavaScriptNode copyUninitialized() {
        return AsyncGeneratorYieldStarNode.createYieldStar(this.context, AsyncGeneratorYieldStarNode.cloneUninitialized(this.expression), AsyncGeneratorYieldStarNode.cloneUninitialized(this.readAsyncContextNode), AsyncGeneratorYieldStarNode.cloneUninitialized(this.readAsyncResultNode), AsyncGeneratorYieldStarNode.cloneUninitialized(this.returnNode), AsyncGeneratorYieldStarNode.cloneUninitialized(this.readIteratorTemp), (WriteNode)((Object)AsyncGeneratorYieldStarNode.cloneUninitialized((JavaScriptNode)((Object)this.writeIteratorTemp))));
    }
}

