/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.simd;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.simd.SIMDTypeFunctionBuiltins;
import com.oracle.truffle.js.builtins.simd.SIMDTypePrototypeBuiltinsFactory;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNodeGen;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSSIMD;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.ArrayList;

public final class SIMDTypePrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<SIMDTypePrototype> {
    public SIMDTypePrototypeBuiltins() {
        super("SIMDTypes.prototype", SIMDTypePrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, SIMDTypePrototype builtinEnum) {
        switch (builtinEnum) {
            case valueOf: {
                return SIMDValueOfNode.create(context, builtin, SIMDTypePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case toLocaleString: {
                return SIMDToLocaleStringNode.create(context, builtin, SIMDTypePrototypeBuiltins.args().varArgs().withThis().createArgumentNodes(context));
            }
            case toString: {
                return SIMDToStringNode.create(context, builtin, SIMDTypePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
        }
        return null;
    }

    public static abstract class SIMDValueOfNode
    extends SIMDTypeFunctionBuiltins.JSBasicSimdOperation {
        public SIMDValueOfNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin, null);
        }

        public static SIMDValueOfNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] createArgumentNodes) {
            return SIMDTypePrototypeBuiltinsFactory.SIMDValueOfNodeGen.create(context, builtin, createArgumentNodes);
        }

        @Specialization
        protected Object doValueOf(DynamicObject a) {
            if (!JSSIMD.isJSSIMD((Object)a)) {
                throw Errors.createSIMDExpected();
            }
            return a;
        }
    }

    public static abstract class SIMDToLocaleStringNode
    extends SIMDToStringNode {
        private JSFunctionCallNode callToLocaleStringNode;
        private PropertyGetNode getToLocaleStringNode;

        protected SIMDToLocaleStringNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        public static SIMDToLocaleStringNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] createArgumentNodes) {
            return SIMDTypePrototypeBuiltinsFactory.SIMDToLocaleStringNodeGen.create(context, builtin, createArgumentNodes);
        }

        private Object callToLocaleString(VirtualFrame frame, Object nextElement) {
            Object toLocaleString;
            if (this.getToLocaleStringNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getToLocaleStringNode = (PropertyGetNode)this.insert(PropertyGetNode.create("toLocaleString", false, this.getContext()));
                this.callToLocaleStringNode = (JSFunctionCallNode)this.insert(JSFunctionCallNode.create(false));
            }
            if (!JSFunction.isJSFunction(toLocaleString = this.getToLocaleStringNode.getValue(nextElement))) {
                return nextElement;
            }
            return this.callToLocaleStringNode.executeCall(JSArguments.create(nextElement, toLocaleString, new Object[0]));
        }

        @Override
        @Specialization
        protected Object doToString(VirtualFrame frame, DynamicObject a) {
            String separator = ", ";
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < JSSIMD.simdTypeGetSIMDType(a).getNumberOfElements(); ++i) {
                String r = this.toString(this.callToLocaleString(frame, SIMDToLocaleStringNode.getLane(a, i)));
                list.add(r);
            }
            String t = JSSIMD.simdTypeGetSIMDType(a).getFactory().getName();
            String e = this.arrayJoin(a, separator);
            return SIMDToLocaleStringNode.doToStringIntl(t, e);
        }

        @CompilerDirectives.TruffleBoundary
        private static String doToStringIntl(String t, String e) {
            return "SIMD." + t + "(" + e + ")";
        }
    }

    public static abstract class SIMDToStringNode
    extends SIMDTypeFunctionBuiltins.JSBasicSimdOperation {
        @Node.Child
        private JSToStringNode toStringNode;

        protected SIMDToStringNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin, null);
        }

        public static SIMDToStringNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] createArgumentNodes) {
            return SIMDTypePrototypeBuiltinsFactory.SIMDToStringNodeGen.create(context, builtin, createArgumentNodes);
        }

        protected final String toString(Object target) {
            if (this.toStringNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toStringNode = (JSToStringNode)this.insert(JSToStringNodeGen.create());
            }
            return this.toStringNode.executeString(target);
        }

        @CompilerDirectives.TruffleBoundary
        public String arrayJoin(DynamicObject simd, Object separator) {
            long len = JSSIMD.simdTypeGetSIMDType(simd).getNumberOfElements();
            String sep = JSRuntime.toString(separator == null ? Character.valueOf(',') : separator);
            if (len == 0L) {
                return "";
            }
            Object[] simdArray = (Object[])JSSIMD.simdGetArray(simd, JSSIMD.isJSSIMD((Object)simd));
            StringBuilder sb = new StringBuilder();
            Object element0 = simdArray[0];
            if (element0 != null && element0 != Undefined.instance) {
                sb.append(JSRuntime.toString(SIMDToStringNode.toDouble(element0)));
            }
            int k = 1;
            while ((long)k < len) {
                sb.append(sep);
                Object element = simdArray[k];
                if (element != null && element != Undefined.instance) {
                    sb.append(JSRuntime.toString(SIMDToStringNode.toDouble(element)));
                }
                ++k;
            }
            return sb.toString();
        }

        private static double toDouble(Object element) {
            return ((Number)element).doubleValue();
        }

        @Specialization
        protected Object doToString(VirtualFrame frame, DynamicObject a) {
            String t = JSSIMD.simdTypeGetSIMDType(a).getFactory().getName();
            String e = this.arrayJoin(a, ",");
            return "SIMD." + t + "(" + e + ")";
        }
    }

    public static enum SIMDTypePrototype implements BuiltinEnum<SIMDTypePrototype>
    {
        valueOf(0),
        toLocaleString(0),
        toString(0);

        private final int length;

        private SIMDTypePrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }
}

