/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.profiles.PrimitiveValueProfile;
import com.oracle.truffle.js.builtins.ForInIteratorPrototypeBuiltinsFactory;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.helper.ListGetNode;
import com.oracle.truffle.js.builtins.helper.ListSizeNode;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.GetPrototypeNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.JSTruffleOptions;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSObjectPrototype;
import com.oracle.truffle.js.runtime.builtins.JSUserObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSProperty;
import com.oracle.truffle.js.runtime.objects.JSShape;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.ForInIterator;
import java.util.List;

public final class ForInIteratorPrototypeBuiltins
extends JSBuiltinsContainer.Switch {
    protected ForInIteratorPrototypeBuiltins() {
        super("%ForInIteratorPrototype%");
        this.defineFunction("next", 0);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget) {
        switch (builtin.getName()) {
            case "next": {
                return ForInIteratorPrototypeBuiltinsFactory.ForInIteratorPrototypeNextNodeGen.create(context, builtin, ForInIteratorPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
        }
        return null;
    }

    @ImportStatic(value={JSObject.class})
    public static abstract class HasOnlyShapePropertiesNode
    extends JavaScriptBaseNode {
        protected HasOnlyShapePropertiesNode() {
        }

        public static HasOnlyShapePropertiesNode create() {
            return ForInIteratorPrototypeBuiltinsFactory.HasOnlyShapePropertiesNodeGen.create();
        }

        public final boolean execute(DynamicObject object) {
            return this.execute(object, JSObject.getJSClass(object));
        }

        public abstract boolean execute(DynamicObject var1, JSClass var2);

        @Specialization(guards={"jsclass == cachedJSClass", "!isJSObjectPrototype(cachedJSClass)"}, limit="3")
        static boolean doCached(DynamicObject object, JSClass jsclass, @Cached(value="jsclass") JSClass cachedJSClass) {
            return cachedJSClass.hasOnlyShapeProperties(object);
        }

        @Specialization(guards={"isJSObjectPrototype(jsclass)"})
        static boolean doObjectPrototype(DynamicObject object, JSClass jsclass, @Cached(value="getJSContext(object)") JSContext context) {
            if (context.getArrayPrototypeNoElementsAssumption().isValid()) {
                assert (jsclass.hasOnlyShapeProperties(object));
                return true;
            }
            return JSObjectPrototype.INSTANCE.hasOnlyShapeProperties(object);
        }

        @Specialization(replaces={"doCached", "doObjectPrototype"})
        static boolean doUncached(DynamicObject object, JSClass jsclass) {
            return jsclass.hasOnlyShapeProperties(object);
        }

        static boolean isJSObjectPrototype(JSClass jsclass) {
            return jsclass == JSObjectPrototype.INSTANCE;
        }
    }

    public static abstract class ForInIteratorPrototypeNextNode
    extends JSBuiltinNode {
        @Node.Child
        private PropertySetNode setValueNode;
        @Node.Child
        private PropertySetNode setDoneNode;
        @Node.Child
        private PropertyGetNode getIteratorNode;
        @Node.Child
        private GetPrototypeNode getPrototypeNode;
        @Node.Child
        private HasOnlyShapePropertiesNode hasOnlyShapePropertiesNode;
        @Node.Child
        private ListGetNode listGet;
        @Node.Child
        private ListSizeNode listSize;
        private final BranchProfile errorBranch = BranchProfile.create();
        private final BranchProfile growProfile = BranchProfile.create();
        private final ConditionProfile fastOwnKeysProfile = ConditionProfile.createBinaryProfile();
        private final ConditionProfile sameShapeProfile = ConditionProfile.createBinaryProfile();
        private static final Object DONE = null;
        private static final int MAX_PROTO_DEPTH = 1000;

        public ForInIteratorPrototypeNextNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.setValueNode = PropertySetNode.create("value", false, context, false);
            this.setDoneNode = PropertySetNode.create("done", false, context, false);
            this.getIteratorNode = PropertyGetNode.createGetHidden(JSRuntime.FOR_IN_ITERATOR_ID, context);
            this.getPrototypeNode = GetPrototypeNode.create();
            this.hasOnlyShapePropertiesNode = HasOnlyShapePropertiesNode.create();
            this.listGet = ListGetNode.create();
            this.listSize = ListSizeNode.create();
        }

        @Specialization
        public DynamicObject execute(Object target, @Cached(value="createEqualityProfile()") PrimitiveValueProfile valuesProfile) {
            boolean done;
            Object iteratorValue = this.getIteratorNode.getValue(target);
            if (iteratorValue == Undefined.instance) {
                this.errorBranch.enter();
                throw Errors.createTypeErrorIncompatibleReceiver(target);
            }
            ForInIterator state = (ForInIterator)iteratorValue;
            Object nextValue = this.findNext(state);
            boolean bl = done = nextValue == DONE;
            if (done) {
                nextValue = Undefined.instance;
            } else if (valuesProfile.profile(state.iterateValues)) {
                nextValue = JSObject.get(state.object, nextValue);
            } else assert (nextValue instanceof String);
            return this.createIterResultObject(nextValue, done);
        }

        private Object findNext(ForInIterator state) {
            while (true) {
                DynamicObject object = state.object;
                if (!state.objectWasVisited) {
                    int size;
                    List<Object> list;
                    boolean fastOwnKeys;
                    JSClass jsclass = JSObject.getJSClass(object);
                    Shape objectShape = object.getShape();
                    if (this.fastOwnKeysProfile.profile(JSTruffleOptions.FastOwnKeys && this.hasOnlyShapePropertiesNode.execute(object, jsclass))) {
                        fastOwnKeys = true;
                        list = JSShape.getPropertiesIfHasEnumerablePropertyNames(objectShape);
                        size = list.size();
                    } else {
                        fastOwnKeys = false;
                        list = jsclass.ownPropertyKeys(object);
                        size = this.listSize.execute(list);
                    }
                    state.objectShape = objectShape;
                    state.remainingKeys = list;
                    state.remainingKeysSize = size;
                    state.remainingKeysIndex = 0;
                    state.fastOwnKeys = fastOwnKeys;
                    state.objectWasVisited = true;
                }
                assert (state.remainingKeysSize == state.remainingKeys.size());
                while (state.remainingKeysIndex < state.remainingKeysSize) {
                    PropertyDescriptor desc;
                    Object next;
                    Object key;
                    if (!((key = ForInIteratorPrototypeNextNode.getKey(next = this.listGet.execute(state.remainingKeys, state.remainingKeysIndex++))) instanceof String) || state.isVisitedKey(key)) continue;
                    if (this.fastOwnKeysProfile.profile(state.fastOwnKeys && next instanceof Property)) {
                        if (this.sameShapeProfile.profile(state.objectShape == object.getShape())) {
                            if (!JSProperty.isEnumerable((Property)next)) continue;
                            return key;
                        }
                        ForInIteratorPrototypeNextNode.addPreviouslyVisitedKeys(state);
                        state.fastOwnKeys = false;
                    }
                    if ((desc = JSObject.getOwnProperty(object, key)) == null) continue;
                    state.addVisitedKey(key);
                    if (!desc.getEnumerable()) continue;
                    return key;
                }
                DynamicObject proto = this.getPrototypeNode.executeJSObject(object);
                if (this.tryFastForwardImmutablePrototype(proto)) {
                    proto = Null.instance;
                }
                state.object = proto;
                state.objectWasVisited = false;
                if (proto == Null.instance) {
                    return DONE;
                }
                if (this.fastOwnKeysProfile.profile(state.fastOwnKeys)) {
                    state.addVisitedShape(state.objectShape, this.growProfile);
                    continue;
                }
                if (++state.protoDepth > 1000) break;
            }
            this.errorBranch.enter();
            throw Errors.createRangeErrorStackOverflow();
        }

        private static Object getKey(Object next) {
            return next instanceof Property ? ((Property)next).getKey() : next;
        }

        @CompilerDirectives.TruffleBoundary
        private static void addPreviouslyVisitedKeys(ForInIterator state) {
            for (int i = 0; i < state.remainingKeysIndex - 1; ++i) {
                state.addVisitedKey(ForInIteratorPrototypeNextNode.getKey(state.remainingKeys.get(i)));
            }
        }

        private boolean tryFastForwardImmutablePrototype(DynamicObject proto) {
            if (proto == Null.instance) {
                return false;
            }
            JSClass jsclass = JSObject.getJSClass(proto);
            if (jsclass == JSObjectPrototype.INSTANCE && this.hasOnlyShapePropertiesNode.execute(proto, jsclass) && JSShape.getEnumerablePropertyNames(proto.getShape()).isEmpty()) {
                assert (JSObject.getPrototype(proto) == Null.instance);
                return true;
            }
            return false;
        }

        private DynamicObject createIterResultObject(Object value, boolean done) {
            DynamicObject iterResultObject = JSUserObject.create(this.getContext());
            this.setValueNode.setValue(iterResultObject, value);
            this.setDoneNode.setValueBoolean(iterResultObject, done);
            return iterResultObject;
        }
    }

    public static enum EnumerateIteratorPrototype implements BuiltinEnum<EnumerateIteratorPrototype>
    {
        next(0);

        private final int length;

        private EnumerateIteratorPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }
}

