/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer.model;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.graalvm.component.installer.Version;

public final class ComponentInfo {
    private final String id;
    private final String versionString;
    private final Version version;
    private final String name;
    private String infoPath;
    private String licensePath;
    private String licenseType;
    private final Map<String, String> requiredGraalValues = new HashMap<String, String>();
    private final List<String> paths = new ArrayList<String>();
    private final Set<String> workingDirectories = new LinkedHashSet<String>();
    private final Map<String, Object> providedValues = new HashMap<String, Object>();
    private URL remoteURL;
    private boolean polyglotRebuild;
    private byte[] shaDigest;
    private String postinstMessage;
    private boolean nativeComponent;
    private Set<String> dependencies = Collections.emptySet();
    private String origin;
    private static final Comparator<ComponentInfo> COMPARATOR_VERSIONS = new Comparator<ComponentInfo>(){

        @Override
        public int compare(ComponentInfo o1, ComponentInfo o2) {
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.getVersion().compareTo(o2.getVersion());
        }
    };

    public ComponentInfo(String id, String name, String versionString) {
        this.id = id;
        this.versionString = versionString;
        this.name = name;
        this.version = Version.fromString(versionString);
    }

    public ComponentInfo(String id, String name, Version v) {
        this.id = id;
        this.versionString = v == null ? null : v.originalString();
        this.name = name;
        this.version = v == null ? Version.NO_VERSION : v;
    }

    public String getId() {
        return this.id;
    }

    public String getVersionString() {
        return this.versionString;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getRequiredGraalValues() {
        return Collections.unmodifiableMap(this.requiredGraalValues);
    }

    public void addRequiredValues(Map<String, String> vals) {
        this.requiredGraalValues.putAll(vals);
    }

    public void addRequiredValue(String s, String val) {
        if (val == null) {
            this.requiredGraalValues.remove(s);
        } else {
            this.requiredGraalValues.put(s, val);
        }
    }

    public void addPaths(List<String> filePaths) {
        this.paths.addAll(filePaths);
    }

    public void setPaths(List<String> filePaths) {
        this.paths.clear();
        this.addPaths(filePaths);
    }

    public List<String> getPaths() {
        return Collections.unmodifiableList(this.paths);
    }

    public String getInfoPath() {
        return this.infoPath;
    }

    public void setInfoPath(String infoPath) {
        this.infoPath = infoPath;
    }

    public String getLicensePath() {
        return this.licensePath;
    }

    public void setLicensePath(String licensePath) {
        this.licensePath = licensePath;
    }

    public URL getRemoteURL() {
        return this.remoteURL;
    }

    public void setRemoteURL(URL remoteURL) {
        this.remoteURL = remoteURL;
    }

    public byte[] getShaDigest() {
        return this.shaDigest;
    }

    public void setShaDigest(byte[] shaDigest) {
        this.shaDigest = shaDigest;
    }

    public boolean isPolyglotRebuild() {
        return this.polyglotRebuild;
    }

    public void setPolyglotRebuild(boolean polyglotRebuild) {
        this.polyglotRebuild = polyglotRebuild;
    }

    public Set<String> getWorkingDirectories() {
        return this.workingDirectories;
    }

    public void addWorkingDirectories(Collection<String> dirs) {
        this.workingDirectories.addAll(dirs);
    }

    public String getPostinstMessage() {
        return this.postinstMessage;
    }

    public void setPostinstMessage(String postinstMessage) {
        this.postinstMessage = postinstMessage;
    }

    public String getLicenseType() {
        return this.licenseType;
    }

    public void setLicenseType(String licenseType) {
        this.licenseType = licenseType;
    }

    public int hashCode() {
        int hash = 5;
        hash = 37 * hash + Objects.hashCode(this.id);
        hash = 37 * hash + Objects.hashCode(this.version);
        if (this.remoteURL != null) {
            hash = 37 * hash + Objects.hashCode(this.remoteURL);
        }
        if (this.origin != null) {
            hash = 37 * hash + Objects.hashCode(this.origin);
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ComponentInfo other = (ComponentInfo)obj;
        if (!Objects.equals(this.id, other.id)) {
            return false;
        }
        if (!Objects.equals(this.version, other.version)) {
            return false;
        }
        if (!Objects.equals(this.remoteURL, other.remoteURL)) {
            return false;
        }
        return Objects.equals(this.origin, other.origin);
    }

    public Version getVersion() {
        return this.version;
    }

    public String toString() {
        return this.getId() + "[" + this.getVersion().toString() + "]";
    }

    public static Comparator<ComponentInfo> versionComparator() {
        return COMPARATOR_VERSIONS;
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public boolean isNativeComponent() {
        return this.nativeComponent;
    }

    public void setNativeComponent(boolean nativeComponent) {
        this.nativeComponent = nativeComponent;
    }

    public <T> void provideValue(String k, T v) {
        this.providedValues.put(k, v);
    }

    public <T> T getProvidedValue(String k, Class<T> type) {
        Object o = this.providedValues.get(k);
        if (!type.isInstance(o)) {
            if (type != String.class || o == null) {
                return null;
            }
            o = o.toString();
        }
        Object ret = o;
        return (T)ret;
    }

    public Map<String, Object> getProvidedValues() {
        return Collections.unmodifiableMap(this.providedValues);
    }

    public void addProvidedValues(Map<String, Object> vals) {
        for (String s : vals.keySet()) {
            this.provideValue(s, vals.get(s));
        }
    }

    public void setDependencies(Set<String> deps) {
        this.dependencies = deps;
    }

    public Set<String> getDependencies() {
        return Collections.unmodifiableSet(this.dependencies);
    }

    public boolean isInstalled() {
        return this.infoPath != null;
    }
}

