/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer.commands;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.graalvm.component.installer.CommandInput;
import org.graalvm.component.installer.ComponentCollection;
import org.graalvm.component.installer.Feedback;
import org.graalvm.component.installer.Version;
import org.graalvm.component.installer.commands.ListInstalledCommand;
import org.graalvm.component.installer.model.ComponentInfo;

public class AvailableCommand
extends ListInstalledCommand {
    private Version.Match vmatch;

    @Override
    public Map<String, String> supportedOptions() {
        HashMap<String, String> opts = new HashMap<String, String>(super.supportedOptions());
        opts.put("a", "");
        opts.put("all-versions", "a");
        opts.put("V", "s");
        opts.put("use-version", "V");
        opts.put("c", "X");
        opts.put("C", "s");
        opts.put("custom-catalog", "C");
        return opts;
    }

    @Override
    protected ComponentCollection initRegistry() {
        super.initRegistry();
        return this.input.getRegistry();
    }

    @Override
    public void init(CommandInput commandInput, Feedback feedBack) {
        super.init(commandInput, feedBack);
        String v = commandInput.optValue("V");
        if (v != null) {
            this.vmatch = Version.versionFilter(v);
        }
    }

    @Override
    public int execute() throws IOException {
        if (this.input.optValue("h") != null) {
            this.feedback.output("AVAILABLE_Help", new Object[0]);
            return 0;
        }
        return super.execute();
    }

    @Override
    protected List<ComponentInfo> filterDisplayedVersions(String id, Collection<ComponentInfo> infos) {
        if (this.input.optValue("a") != null) {
            return super.filterDisplayedVersions(id, infos);
        }
        HashSet<Version> seen = new HashSet<Version>();
        ArrayList<ComponentInfo> filtered = new ArrayList<ComponentInfo>();
        for (ComponentInfo ci : infos) {
            if (!seen.add(ci.getVersion().installVersion())) continue;
            filtered.add(ci);
        }
        return super.filterDisplayedVersions(id, filtered);
    }

    @Override
    protected String acceptExpression(String expr) {
        if (this.vmatch != null) {
            return super.acceptExpression(expr);
        }
        Version.Match vm = Version.versionFilter(expr);
        if (vm == null) {
            this.vmatch = this.getRegistry().getGraalVersion().match(Version.Match.Type.INSTALLABLE);
            return expr;
        }
        this.vmatch = vm;
        return null;
    }

    @Override
    protected Version.Match getVersionFilter() {
        return this.vmatch == null ? super.getVersionFilter() : this.vmatch;
    }
}

