/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.persistence;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.core.windows.Debug;
import org.netbeans.core.windows.persistence.GroupConfig;
import org.netbeans.core.windows.persistence.InternalConfig;
import org.netbeans.core.windows.persistence.PersistenceManager;
import org.netbeans.core.windows.persistence.TCGroupConfig;
import org.netbeans.core.windows.persistence.TCGroupParser;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.ModuleInfo;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

class GroupParser {
    public static final String INSTANCE_DTD_ID_2_0 = "-//NetBeans//DTD Group Properties 2.0//EN";
    private static final boolean DEBUG = Debug.isLoggable(GroupParser.class);
    private FileObject moduleParentFolder;
    private FileObject localParentFolder;
    private InternalConfig internalConfig;
    private Map<String, TCGroupParser> tcGroupParserMap = new HashMap<String, TCGroupParser>(19);
    private String groupName;
    private boolean inModuleFolder;
    private boolean inLocalFolder;

    public GroupParser(String string) {
        this.groupName = string;
    }

    GroupConfig load() throws IOException {
        GroupConfig groupConfig = new GroupConfig();
        this.readProperties(groupConfig);
        this.readTCGroups(groupConfig);
        return groupConfig;
    }

    void save(GroupConfig groupConfig) throws IOException {
        this.writeProperties(groupConfig);
        this.writeTCGroups(groupConfig);
    }

    private void readProperties(GroupConfig groupConfig) throws IOException {
        if (DEBUG) {
            Debug.log(GroupParser.class, "readProperties ENTER group:" + this.getName());
        }
        PropertyHandler propertyHandler = new PropertyHandler();
        InternalConfig internalConfig = this.getInternalConfig();
        internalConfig.clear();
        propertyHandler.readData(groupConfig, internalConfig);
        if (DEBUG) {
            Debug.log(GroupParser.class, "readProperties LEAVE group:" + this.getName());
        }
    }

    private void readTCGroups(GroupConfig groupConfig) throws IOException {
        TCGroupParser tCGroupParser;
        int n;
        Object object;
        if (DEBUG) {
            Debug.log(GroupParser.class, "readTCGroups ENTER group:" + this.getName());
        }
        Object object2 = this.tcGroupParserMap.keySet().iterator();
        while (object2.hasNext()) {
            object = this.tcGroupParserMap.get(object2.next());
            ((TCGroupParser)object).setInModuleFolder(false);
            ((TCGroupParser)object).setInLocalFolder(false);
        }
        if (this.isInModuleFolder() && (object2 = this.moduleParentFolder.getFileObject(this.groupName)) != null) {
            object = object2.getChildren();
            for (n = 0; n < ((FileObject[])object).length; ++n) {
                if (object[n].isFolder() || !"wstcgrp".equals(object[n].getExt())) continue;
                tCGroupParser = this.tcGroupParserMap.get(object[n].getName());
                if (tCGroupParser == null) {
                    tCGroupParser = new TCGroupParser(object[n].getName());
                    this.tcGroupParserMap.put(object[n].getName(), tCGroupParser);
                }
                tCGroupParser.setInModuleFolder(true);
                tCGroupParser.setModuleParentFolder((FileObject)object2);
            }
        }
        if (this.isInLocalFolder() && (object2 = this.localParentFolder.getFileObject(this.groupName)) != null) {
            object = object2.getChildren();
            for (n = 0; n < ((FileObject[])object).length; ++n) {
                if (object[n].isFolder() || !"wstcgrp".equals(object[n].getExt())) continue;
                if (this.tcGroupParserMap.containsKey(object[n].getName())) {
                    tCGroupParser = this.tcGroupParserMap.get(object[n].getName());
                } else {
                    tCGroupParser = new TCGroupParser(object[n].getName());
                    this.tcGroupParserMap.put(object[n].getName(), tCGroupParser);
                }
                tCGroupParser.setInLocalFolder(true);
                tCGroupParser.setLocalParentFolder((FileObject)object2);
            }
        }
        object2 = new ArrayList(this.tcGroupParserMap.size());
        object = new ArrayList(this.tcGroupParserMap.size());
        Iterator<String> iterator = this.tcGroupParserMap.keySet().iterator();
        while (iterator.hasNext()) {
            TCGroupConfig tCGroupConfig;
            tCGroupParser = this.tcGroupParserMap.get(iterator.next());
            try {
                tCGroupConfig = tCGroupParser.load();
            }
            catch (IOException iOException) {
                object.add(tCGroupParser);
                this.deleteLocalTCGroup(tCGroupParser.getName());
                Logger.getLogger(GroupParser.class.getName()).log(Level.INFO, null, iOException);
                continue;
            }
            boolean bl = this.acceptTCGroup(tCGroupParser, tCGroupConfig);
            if (bl) {
                object2.add(tCGroupConfig);
                continue;
            }
            object.add(tCGroupParser);
            this.deleteLocalTCGroup(tCGroupParser.getName());
        }
        for (int i = 0; i < object.size(); ++i) {
            tCGroupParser = (TCGroupParser)object.get(i);
            this.tcGroupParserMap.remove(tCGroupParser.getName());
        }
        groupConfig.tcGroupConfigs = object2.toArray(new TCGroupConfig[object2.size()]);
        PersistenceManager persistenceManager = PersistenceManager.getDefault();
        for (int i = 0; i < groupConfig.tcGroupConfigs.length; ++i) {
            persistenceManager.addUsedTCId(groupConfig.tcGroupConfigs[i].tc_id);
        }
        if (DEBUG) {
            Debug.log(GroupParser.class, "readTCGroups LEAVE group:" + this.getName());
        }
    }

    private boolean acceptTCGroup(TCGroupParser tCGroupParser, TCGroupConfig tCGroupConfig) {
        InternalConfig internalConfig = tCGroupParser.getInternalConfig();
        if (internalConfig.moduleCodeNameBase != null) {
            ModuleInfo moduleInfo = PersistenceManager.findModule(internalConfig.moduleCodeNameBase, internalConfig.moduleCodeNameRelease, internalConfig.moduleSpecificationVersion);
            if (moduleInfo == null) {
                PersistenceManager.LOG.fine("Cannot find module '" + internalConfig.moduleCodeNameBase + " " + internalConfig.moduleCodeNameRelease + " " + internalConfig.moduleSpecificationVersion + "' for tcgrp with name '" + tCGroupConfig.tc_id + "'");
            }
            return moduleInfo != null && moduleInfo.isEnabled();
        }
        return true;
    }

    private void writeProperties(GroupConfig groupConfig) throws IOException {
        if (DEBUG) {
            Debug.log(GroupParser.class, "writeProperties ENTER group:" + this.getName());
        }
        PropertyHandler propertyHandler = new PropertyHandler();
        InternalConfig internalConfig = this.getInternalConfig();
        propertyHandler.writeData(groupConfig, internalConfig);
        if (DEBUG) {
            Debug.log(GroupParser.class, "writeProperties LEAVE group:" + this.getName());
        }
    }

    private void writeTCGroups(GroupConfig groupConfig) throws IOException {
        int n;
        TCGroupParser tCGroupParser;
        if (DEBUG) {
            Debug.log(GroupParser.class, "writeTCGroups ENTER group:" + this.getName());
        }
        HashMap<String, TCGroupConfig> hashMap = new HashMap<String, TCGroupConfig>(19);
        for (int i = 0; i < groupConfig.tcGroupConfigs.length; ++i) {
            hashMap.put(groupConfig.tcGroupConfigs[i].tc_id, groupConfig.tcGroupConfigs[i]);
        }
        ArrayList<String> arrayList = new ArrayList<String>(10);
        for (String object2 : this.tcGroupParserMap.keySet()) {
            tCGroupParser = this.tcGroupParserMap.get(object2);
            if (hashMap.containsKey(tCGroupParser.getName())) continue;
            arrayList.add(tCGroupParser.getName());
        }
        for (n = 0; n < arrayList.size(); ++n) {
            this.tcGroupParserMap.remove(arrayList.get(n));
            this.deleteLocalTCGroup((String)arrayList.get(n));
        }
        for (n = 0; n < groupConfig.tcGroupConfigs.length; ++n) {
            if (this.tcGroupParserMap.containsKey(groupConfig.tcGroupConfigs[n].tc_id)) continue;
            TCGroupParser tCGroupParser2 = new TCGroupParser(groupConfig.tcGroupConfigs[n].tc_id);
            this.tcGroupParserMap.put(groupConfig.tcGroupConfigs[n].tc_id, tCGroupParser2);
        }
        FileObject fileObject = this.localParentFolder.getFileObject(this.getName());
        if (fileObject == null && this.tcGroupParserMap.size() > 0) {
            fileObject = FileUtil.createFolder((FileObject)this.localParentFolder, (String)this.getName());
        }
        Iterator<String> iterator = this.tcGroupParserMap.keySet().iterator();
        while (iterator.hasNext()) {
            tCGroupParser = this.tcGroupParserMap.get(iterator.next());
            tCGroupParser.setLocalParentFolder(fileObject);
            tCGroupParser.setInLocalFolder(true);
            tCGroupParser.save((TCGroupConfig)hashMap.get(tCGroupParser.getName()));
        }
        if (DEBUG) {
            Debug.log(GroupParser.class, "writeTCGroups LEAVE group:" + this.getName());
        }
    }

    private void deleteLocalTCGroup(String string) {
        if (DEBUG) {
            Debug.log(GroupParser.class, "deleteLocalTCGroup group:" + string);
        }
        if (this.localParentFolder == null) {
            return;
        }
        FileObject fileObject = this.localParentFolder.getFileObject(this.groupName);
        if (fileObject == null) {
            return;
        }
        FileObject fileObject2 = fileObject.getFileObject(string, "wstcgrp");
        if (fileObject2 != null) {
            PersistenceManager.deleteOneFO(fileObject2);
        }
    }

    void removeTCGroup(String string) {
        this.tcGroupParserMap.remove(string);
        this.deleteLocalTCGroup(string);
    }

    TCGroupConfig addTCGroup(String string) {
        TCGroupParser tCGroupParser = this.tcGroupParserMap.get(string);
        if (tCGroupParser != null) {
            PersistenceManager.LOG.log(Level.INFO, "[WinSys.GroupParser.addTCGroup] Warning: GroupParser " + this.getName() + ". TCGroupParser " + string + " exists but it should not.");
            this.tcGroupParserMap.remove(string);
        }
        tCGroupParser = new TCGroupParser(string);
        FileObject fileObject = this.moduleParentFolder.getFileObject(this.groupName);
        tCGroupParser.setModuleParentFolder(fileObject);
        tCGroupParser.setInModuleFolder(true);
        this.tcGroupParserMap.put(string, tCGroupParser);
        TCGroupConfig tCGroupConfig = null;
        try {
            tCGroupConfig = tCGroupParser.load();
        }
        catch (IOException iOException) {
            PersistenceManager.LOG.log(Level.INFO, "[WinSys.GroupParser.addTCGroup] Warning: GroupParser " + this.getName() + ". Cannot load tcGroup " + string, iOException);
        }
        return tCGroupConfig;
    }

    InternalConfig getInternalConfig() {
        if (this.internalConfig == null) {
            this.internalConfig = new InternalConfig();
        }
        return this.internalConfig;
    }

    void setModuleParentFolder(FileObject fileObject) {
        this.moduleParentFolder = fileObject;
    }

    void setLocalParentFolder(FileObject fileObject) {
        this.localParentFolder = fileObject;
    }

    String getName() {
        return this.groupName;
    }

    boolean isInModuleFolder() {
        return this.inModuleFolder;
    }

    void setInModuleFolder(boolean bl) {
        this.inModuleFolder = bl;
    }

    boolean isInLocalFolder() {
        return this.inLocalFolder;
    }

    void setInLocalFolder(boolean bl) {
        this.inLocalFolder = bl;
    }

    private final class PropertyHandler
    extends DefaultHandler {
        private GroupConfig groupConfig = null;
        private InternalConfig internalConfig = null;
        private final Object RW_LOCK = new Object();

        private FileObject getConfigFOInput() {
            FileObject fileObject = GroupParser.this.isInLocalFolder() ? GroupParser.this.localParentFolder.getFileObject(GroupParser.this.getName(), "wsgrp") : (GroupParser.this.isInModuleFolder() ? GroupParser.this.moduleParentFolder.getFileObject(GroupParser.this.getName(), "wsgrp") : null);
            return fileObject;
        }

        private FileObject getConfigFOOutput() throws IOException {
            FileObject fileObject = GroupParser.this.localParentFolder.getFileObject(GroupParser.this.getName(), "wsgrp");
            if (fileObject != null) {
                return fileObject;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(GroupParser.this.getName());
            stringBuffer.append('.');
            stringBuffer.append("wsgrp");
            fileObject = FileUtil.createData((FileObject)GroupParser.this.localParentFolder, (String)stringBuffer.toString());
            return fileObject;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void readData(GroupConfig groupConfig, InternalConfig internalConfig) throws IOException {
            this.groupConfig = groupConfig;
            this.internalConfig = internalConfig;
            FileObject fileObject = this.getConfigFOInput();
            if (fileObject == null) {
                throw new FileNotFoundException("[WinSys] Missing Group configuration file:" + GroupParser.this.getName());
            }
            InputStream inputStream = null;
            try {
                Object object = this.RW_LOCK;
                synchronized (object) {
                    inputStream = fileObject.getInputStream();
                    PersistenceManager.getDefault().getXMLParser(this).parse(new InputSource(inputStream));
                }
            }
            catch (SAXException sAXException) {
                String string = NbBundle.getMessage(GroupParser.class, (String)"EXC_GroupParse", (Object)fileObject);
                throw (IOException)new IOException(string).initCause(sAXException);
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    Logger.getLogger(GroupParser.class.getName()).log(Level.INFO, null, iOException);
                }
            }
            groupConfig = this.groupConfig;
            internalConfig = this.internalConfig;
            this.groupConfig = null;
            this.internalConfig = null;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if ("group".equals(string3)) {
                this.handleGroup(attributes);
            } else if (this.internalConfig.specVersion.compareTo((Object)new SpecificationVersion("2.0")) == 0) {
                if ("module".equals(string3)) {
                    this.handleModule(attributes);
                } else if ("name".equals(string3)) {
                    this.handleName(attributes);
                } else if ("state".equals(string3)) {
                    this.handleState(attributes);
                }
            } else if (DEBUG) {
                Debug.log(GroupParser.class, "-- GroupParser.startElement PARSING OLD");
            }
        }

        @Override
        public void error(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        private void handleGroup(Attributes attributes) {
            String string = attributes.getValue("version");
            if (string != null) {
                this.internalConfig.specVersion = new SpecificationVersion(string);
            } else {
                PersistenceManager.LOG.log(Level.INFO, "[WinSys.GroupParser.handleGroup] Warning: Missing attribute \"version\" of element \"group\".");
                this.internalConfig.specVersion = new SpecificationVersion("2.0");
            }
        }

        private void handleModule(Attributes attributes) {
            String string = attributes.getValue("name");
            this.internalConfig.moduleCodeNameBase = null;
            this.internalConfig.moduleCodeNameRelease = null;
            this.internalConfig.moduleSpecificationVersion = null;
            if (string != null) {
                int n = string.indexOf(47);
                if (n != -1) {
                    this.internalConfig.moduleCodeNameBase = string.substring(0, n);
                    this.internalConfig.moduleCodeNameRelease = string.substring(n + 1);
                    this.checkReleaseCode(this.internalConfig);
                } else {
                    this.internalConfig.moduleCodeNameBase = string;
                }
                this.internalConfig.moduleSpecificationVersion = attributes.getValue("spec");
            }
        }

        private void checkReleaseCode(InternalConfig internalConfig) {
            if ("null".equals(internalConfig.moduleCodeNameRelease)) {
                Logger.getLogger(GroupParser.class.getName()).log(Level.INFO, null, new IllegalStateException("Module release code was saved as null string for module " + internalConfig.moduleCodeNameBase + "! Repairing."));
                internalConfig.moduleCodeNameRelease = null;
            }
        }

        private void handleName(Attributes attributes) throws SAXException {
            String string = attributes.getValue("unique");
            if (string != null) {
                this.groupConfig.name = string;
                if (!string.equals(GroupParser.this.getName())) {
                    PersistenceManager.LOG.log(Level.INFO, "[WinSys.GroupParser.handleName] Error: Value of attribute \"unique\" of element \"name\" and configuration file name must be the same.");
                    throw new SAXException("Invalid attribute value");
                }
            } else {
                PersistenceManager.LOG.log(Level.INFO, "[WinSys.GroupParser.handleName] Error: Missing required attribute \"unique\" of element \"name\".");
                throw new SAXException("Missing required attribute");
            }
        }

        private void handleState(Attributes attributes) throws SAXException {
            String string = attributes.getValue("opened");
            if (string != null) {
                if ("true".equals(string)) {
                    this.groupConfig.opened = true;
                } else if ("false".equals(string)) {
                    this.groupConfig.opened = false;
                } else {
                    PersistenceManager.LOG.log(Level.INFO, "[WinSys.GroupParser.handleState] Warning: Invalid value of attribute \"opened\" of element \"state\".");
                    this.groupConfig.opened = false;
                }
            } else {
                PersistenceManager.LOG.log(Level.INFO, "[WinSys.GroupParser.handleState] Error: Missing required attribute \"opened\" of element \"state\".");
                this.groupConfig.opened = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void writeData(GroupConfig groupConfig, InternalConfig internalConfig) throws IOException {
            StringBuffer stringBuffer = this.fillBuffer(groupConfig, internalConfig);
            Object object = this.RW_LOCK;
            synchronized (object) {
                FileObject fileObject = this.getConfigFOOutput();
                FileLock fileLock = null;
                OutputStream outputStream = null;
                OutputStreamWriter outputStreamWriter = null;
                try {
                    fileLock = fileObject.lock();
                    outputStream = fileObject.getOutputStream(fileLock);
                    outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
                    outputStreamWriter.write(stringBuffer.toString());
                }
                finally {
                    try {
                        if (outputStreamWriter != null) {
                            outputStreamWriter.close();
                        }
                    }
                    catch (IOException iOException) {
                        Logger.getLogger(GroupParser.class.getName()).log(Level.INFO, null, iOException);
                    }
                    if (fileLock != null) {
                        fileLock.releaseLock();
                    }
                }
            }
        }

        private StringBuffer fillBuffer(GroupConfig groupConfig, InternalConfig internalConfig) throws IOException {
            StringBuffer stringBuffer = new StringBuffer(800);
            stringBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n");
            stringBuffer.append("<group version=\"2.0\">\n");
            this.appendModule(internalConfig, stringBuffer);
            this.appendName(groupConfig, stringBuffer);
            this.appendState(groupConfig, stringBuffer);
            stringBuffer.append("</group>\n");
            return stringBuffer;
        }

        private void appendModule(InternalConfig internalConfig, StringBuffer stringBuffer) {
            if (internalConfig == null) {
                return;
            }
            if (internalConfig.moduleCodeNameBase != null) {
                stringBuffer.append("    <module");
                stringBuffer.append(" name=\"");
                stringBuffer.append(internalConfig.moduleCodeNameBase);
                if (internalConfig.moduleCodeNameRelease != null) {
                    stringBuffer.append("/" + internalConfig.moduleCodeNameRelease);
                }
                if (internalConfig.moduleSpecificationVersion != null) {
                    stringBuffer.append("\" spec=\"");
                    stringBuffer.append(internalConfig.moduleSpecificationVersion);
                }
                stringBuffer.append("\" />\n");
            }
        }

        private void appendName(GroupConfig groupConfig, StringBuffer stringBuffer) {
            stringBuffer.append("    <name");
            stringBuffer.append(" unique=\"");
            stringBuffer.append(groupConfig.name);
            stringBuffer.append("\"");
            stringBuffer.append(" />\n");
        }

        private void appendState(GroupConfig groupConfig, StringBuffer stringBuffer) {
            stringBuffer.append("    <state");
            stringBuffer.append(" opened=\"");
            if (groupConfig.opened) {
                stringBuffer.append("true");
            } else {
                stringBuffer.append("false");
            }
            stringBuffer.append("\"");
            stringBuffer.append(" />\n");
        }

        @Override
        public InputSource resolveEntity(String string, String string2) throws SAXException {
            if (GroupParser.INSTANCE_DTD_ID_2_0.equals(string)) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(new byte[0]);
                return new InputSource(byteArrayInputStream);
            }
            return null;
        }
    }
}

