/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.heapviewer.utils.Bundle;
import org.graalvm.visualvm.lib.jfluid.heap.FieldValue;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.JavaClass;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectFieldValue;
import org.graalvm.visualvm.lib.profiler.api.ProfilerDialogs;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsUtils;

public final class HeapUtils {
    private static final String CLASS_URL_PREFIX = "file://class/";
    private static final String INSTANCE_URL_PREFIX = "file://instance/";
    private static boolean OOME_NOTIFIED = false;

    public static Collection<JavaClass> getSubclasses(Heap heap, String baseClass) {
        HashSet<JavaClass> subclasses = new HashSet<JavaClass>();
        String escapedClassName = "\\Q" + baseClass + "\\E";
        Collection jClasses = heap.getJavaClassesByRegExp(escapedClassName);
        for (JavaClass jClass : jClasses) {
            subclasses.add(jClass);
            subclasses.addAll(jClass.getSubClasses());
        }
        return subclasses;
    }

    public static Iterator<Instance> instancesIterator(Collection<JavaClass> classes) {
        return new InstancesIterator(classes);
    }

    public static Object[] getValuesOfFields(Instance instance, String ... fields) {
        Object[] values = new Object[fields.length];
        HashMap<String, Integer> fieldsM = new HashMap<String, Integer>();
        for (int i = 0; i < fields.length; ++i) {
            fieldsM.put(fields[i], i);
        }
        List fieldValues = instance.getFieldValues();
        for (int i = fieldValues.size() - 1; i >= 0; --i) {
            FieldValue fieldValue = (FieldValue)fieldValues.get(i);
            String fieldName = fieldValue.getField().getName();
            Integer valueIdx = (Integer)fieldsM.remove(fieldName);
            if (valueIdx == null) continue;
            String value = fieldValue instanceof ObjectFieldValue ? ((ObjectFieldValue)fieldValue).getInstance() : fieldValue.getValue();
            values[valueIdx.intValue()] = value;
            if (fieldsM.isEmpty()) break;
        }
        return values;
    }

    public static String classToHtml(JavaClass javaClass) {
        return HeapUtils.classToHtml(javaClass, null);
    }

    private static String classToHtml(JavaClass javaClass, String prefix) {
        if (javaClass == null) {
            return Bundle.HeapUtils_UnknownClass();
        }
        long id = javaClass.getJavaClassId();
        return "<a href='file://class/" + id + "' name='" + id + "'>" + (prefix == null ? "" : prefix) + javaClass.getName() + "</a>";
    }

    public static boolean isClass(String html) {
        return html.startsWith(CLASS_URL_PREFIX);
    }

    public static JavaClass classFromHtml(String html, Heap heap) {
        String classIdS = html.substring(CLASS_URL_PREFIX.length());
        try {
            long classId = Long.parseLong(classIdS);
            return heap.getJavaClassByID(classId);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static String instanceToHtml(Instance instance, boolean logicalValue, Heap heap, JavaClass javaClassClass) {
        JavaClass javaClass;
        if (instance == null) {
            return Bundle.HeapUtils_UnknownInstance();
        }
        JavaClass jcls = instance.getJavaClass();
        if (jcls == null) {
            return Bundle.HeapUtils_UnknownInstance() + " #" + instance.getInstanceId();
        }
        if (jcls.equals(javaClassClass) && (javaClass = heap.getJavaClassByID(instance.getInstanceId())) != null) {
            return HeapUtils.classToHtml(javaClass, Bundle.HeapUtils_Class() + " ");
        }
        long id = instance.getInstanceId();
        String instanceHtml = "<a href='file://instance/" + id + "' name='" + id + "'>" + jcls.getName() + '#' + instance.getInstanceNumber() + "</a>";
        if (!logicalValue) {
            return instanceHtml;
        }
        String details = DetailsUtils.getInstanceString((Instance)instance, (Heap)heap);
        if (details == null) {
            return instanceHtml;
        }
        details = "<span style=\"color: #666666\"> : " + HeapUtils.htmlize(details) + "</span>";
        return instanceHtml + details;
    }

    public static boolean isInstance(String html) {
        return html.startsWith(INSTANCE_URL_PREFIX);
    }

    public static Instance instanceFromHtml(String html, Heap heap) {
        String classIdS = html.substring(INSTANCE_URL_PREFIX.length());
        try {
            long classId = Long.parseLong(classIdS);
            return heap.getInstanceByID(classId);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static String htmlize(String text) {
        if (text == null) {
            return null;
        }
        return text.replace(">", "&gt;").replace("<", "&lt;");
    }

    public static void handleOOME(final boolean skipSuccessive, OutOfMemoryError e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!OOME_NOTIFIED || !skipSuccessive) {
                    OOME_NOTIFIED = true;
                    ProfilerDialogs.displayError((String)Bundle.HeapUtils_OomeMsg(), (String)Bundle.HeapUtils_OomeCaption(), null);
                }
            }
        });
    }

    private HeapUtils() {
    }

    private static class InstancesIterator
    implements Iterator<Instance> {
        private final Iterator<JavaClass> classIt;
        private Iterator<Instance> instanceIt;

        public InstancesIterator(Collection<JavaClass> cls) {
            this.classIt = cls.iterator();
            this.instanceIt = Collections.EMPTY_LIST.iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.instanceIt.hasNext()) {
                return true;
            }
            if (!this.classIt.hasNext()) {
                return false;
            }
            this.instanceIt = this.classIt.next().getInstancesIterator();
            return this.hasNext();
        }

        @Override
        public Instance next() {
            return this.instanceIt.next();
        }
    }
}

