/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.utils;

import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.heapviewer.HeapFragment;
import org.graalvm.visualvm.heapviewer.utils.Bundle;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.JavaClass;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.util.RequestProcessor;

public final class HeapOperations {
    private static Map<Heap, HeapOperations> INSTANCES;
    private static boolean referencesInitialized;
    private static volatile RequestProcessor.Task referencesComputer;
    private static boolean gcrootsInitialized;
    private static volatile RequestProcessor.Task gcrootsComputer;
    private static boolean retainedInitialized;
    private static volatile RequestProcessor.Task retainedComputer;

    private HeapOperations() {
    }

    private static synchronized HeapOperations get(Heap heap) {
        HeapOperations instance;
        if (INSTANCES == null) {
            INSTANCES = new WeakHashMap<Heap, HeapOperations>();
        }
        if ((instance = INSTANCES.get(heap)) == null) {
            instance = new HeapOperations();
            INSTANCES.put(heap, instance);
        }
        return instance;
    }

    public static void initializeReferences(Heap heap) throws InterruptedException {
        HeapOperations.get(heap).initializeReferencesImpl(heap);
    }

    public static void initializeGCRoots(Heap heap) throws InterruptedException {
        HeapOperations.get(heap).initializeGCRootsImpl(heap);
    }

    public static void initializeRetainedSizes(Heap heap) throws InterruptedException {
        HeapOperations.get(heap).initializeRetainedSizesImpl(heap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeReferencesImpl(final Heap heap) throws InterruptedException {
        RequestProcessor.Task _referencesComputer;
        HeapOperations heapOperations = this;
        synchronized (heapOperations) {
            if (referencesInitialized) {
                return;
            }
            if (referencesComputer == null) {
                Runnable workerR = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        ProgressHandle pHandle = null;
                        try {
                            pHandle = ProgressHandle.createHandle((String)Bundle.HeapOperations_ComputingReferences());
                            pHandle.setInitialDelay(1000);
                            pHandle.start(1000);
                            HeapFragment.setProgress(pHandle, 0);
                            Instance dummy = (Instance)heap.getAllInstancesIterator().next();
                            dummy.getReferences();
                        }
                        finally {
                            if (pHandle != null) {
                                pHandle.finish();
                            }
                        }
                        1 var2_2 = this;
                        synchronized (var2_2) {
                            referencesInitialized = false;
                            referencesComputer = null;
                        }
                    }
                };
                _referencesComputer = referencesComputer = new RequestProcessor("References Computer").post(workerR);
            } else {
                _referencesComputer = referencesComputer;
            }
        }
        assert (!SwingUtilities.isEventDispatchThread());
        _referencesComputer.waitFinished(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeGCRootsImpl(final Heap heap) throws InterruptedException {
        RequestProcessor.Task _gcrootsComputer;
        this.initializeReferencesImpl(heap);
        HeapOperations heapOperations = this;
        synchronized (heapOperations) {
            if (gcrootsInitialized) {
                return;
            }
            if (gcrootsComputer == null) {
                Runnable workerR = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        ProgressHandle pHandle = null;
                        try {
                            pHandle = ProgressHandle.createHandle((String)Bundle.HeapOperations_ComputingGCRoots());
                            pHandle.setInitialDelay(1000);
                            pHandle.start(1000);
                            HeapFragment.setProgress(pHandle, 0);
                            Instance dummy = (Instance)heap.getAllInstancesIterator().next();
                            dummy.getNearestGCRootPointer();
                        }
                        finally {
                            if (pHandle != null) {
                                pHandle.finish();
                            }
                        }
                        2 var2_2 = this;
                        synchronized (var2_2) {
                            gcrootsInitialized = false;
                            gcrootsComputer = null;
                        }
                    }
                };
                _gcrootsComputer = gcrootsComputer = new RequestProcessor("GC Roots Computer").post(workerR);
            } else {
                _gcrootsComputer = gcrootsComputer;
            }
        }
        assert (!SwingUtilities.isEventDispatchThread());
        _gcrootsComputer.waitFinished(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeRetainedSizesImpl(final Heap heap) throws InterruptedException {
        RequestProcessor.Task _retainedComputer;
        this.initializeGCRootsImpl(heap);
        HeapOperations heapOperations = this;
        synchronized (heapOperations) {
            if (retainedInitialized) {
                return;
            }
            if (retainedComputer == null) {
                Runnable workerR = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        ProgressHandle pHandle = null;
                        try {
                            pHandle = ProgressHandle.createHandle((String)Bundle.HeapOperations_ComputingRetainedSizes());
                            pHandle.setInitialDelay(1000);
                            pHandle.start();
                            HeapFragment.setProgress(pHandle, 0);
                            List classes = heap.getAllClasses();
                            if (!classes.isEmpty()) {
                                ((JavaClass)classes.get(0)).getRetainedSizeByClass();
                            }
                        }
                        finally {
                            if (pHandle != null) {
                                pHandle.finish();
                            }
                        }
                        3 var2_2 = this;
                        synchronized (var2_2) {
                            retainedInitialized = false;
                            retainedComputer = null;
                        }
                    }
                };
                _retainedComputer = retainedComputer = new RequestProcessor("Retained Sizes Computer").post(workerR);
            } else {
                _retainedComputer = retainedComputer;
            }
        }
        assert (!SwingUtilities.isEventDispatchThread());
        _retainedComputer.waitFinished(0L);
    }
}

