/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.java.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.heapviewer.HeapContext;
import org.graalvm.visualvm.heapviewer.java.InstanceNode;
import org.graalvm.visualvm.heapviewer.java.InstanceNodeRenderer;
import org.graalvm.visualvm.heapviewer.java.InstanceReferenceNode;
import org.graalvm.visualvm.heapviewer.java.InstancesWrapper;
import org.graalvm.visualvm.heapviewer.java.JavaHeapFragment;
import org.graalvm.visualvm.heapviewer.java.impl.Bundle;
import org.graalvm.visualvm.heapviewer.model.DataType;
import org.graalvm.visualvm.heapviewer.model.ErrorNode;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNodeFilter;
import org.graalvm.visualvm.heapviewer.model.Progress;
import org.graalvm.visualvm.heapviewer.model.RootNode;
import org.graalvm.visualvm.heapviewer.model.TextNode;
import org.graalvm.visualvm.heapviewer.swing.LinkButton;
import org.graalvm.visualvm.heapviewer.ui.HeapViewPlugin;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerActions;
import org.graalvm.visualvm.heapviewer.ui.TreeTableView;
import org.graalvm.visualvm.heapviewer.ui.TreeTableViewColumn;
import org.graalvm.visualvm.heapviewer.ui.UIThresholds;
import org.graalvm.visualvm.heapviewer.utils.HeapOperations;
import org.graalvm.visualvm.heapviewer.utils.HeapUtils;
import org.graalvm.visualvm.heapviewer.utils.NodesComputer;
import org.graalvm.visualvm.heapviewer.utils.ProgressIterator;
import org.graalvm.visualvm.lib.jfluid.heap.ArrayItemValue;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectFieldValue;
import org.graalvm.visualvm.lib.jfluid.heap.Value;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.ui.UIUtils;
import org.graalvm.visualvm.lib.ui.swing.renderer.LabelRenderer;
import org.openide.util.NbPreferences;

public class PathToGCRootPlugin
extends HeapViewPlugin {
    private static final TreeTableView.ColumnConfiguration CCONF_CLASS = new TreeTableView.ColumnConfiguration(DataType.COUNT, null, DataType.COUNT, SortOrder.DESCENDING, Boolean.FALSE);
    private static final TreeTableView.ColumnConfiguration CCONF_INSTANCE = new TreeTableView.ColumnConfiguration(null, DataType.COUNT, DataType.NAME, SortOrder.UNSORTED, null);
    private final Heap heap;
    private HeapViewerNode selected;
    private volatile boolean mergedRequest;
    private final TreeTableView objectsView;
    private volatile boolean showingClass;
    private JComponent component;
    private static final String KEY_MERGED_GCROOTS = "HeapViewer.autoMergedGcRoots";

    public PathToGCRootPlugin(HeapContext context, HeapViewerActions actions) {
        super(Bundle.PathToGCRootPlugin_Name(), Bundle.PathToGCRootPlugin_Description(), Icons.getIcon((String)"ProfilerIcons.RunGC"));
        this.heap = context.getFragment().getHeap();
        TreeTableViewColumn[] columns = new TreeTableViewColumn[]{new TreeTableViewColumn.Name(this.heap), new TreeTableViewColumn.LogicalValue(this.heap), new TreeTableViewColumn.Count(this.heap, true, true), new TreeTableViewColumn.OwnSize(this.heap, false, false), new TreeTableViewColumn.RetainedSize(this.heap, false, false), new TreeTableViewColumn.ObjectID(this.heap)};
        this.objectsView = new TreeTableView("java_objects_gcroots", context, actions, columns){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected HeapViewerNode[] computeData(RootNode root, Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) throws InterruptedException {
                Collection data;
                Instance instance;
                HeapViewerNode _selected;
                if (PathToGCRootPlugin.this.mergedRequest) {
                    return HeapViewerNode.NO_NODES;
                }
                TreeTableView treeTableView = PathToGCRootPlugin.this.objectsView;
                synchronized (treeTableView) {
                    _selected = PathToGCRootPlugin.this.selected;
                }
                if (_selected == null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (!CCONF_INSTANCE.equals(PathToGCRootPlugin.this.objectsView.getCurrentColumnConfiguration())) {
                                PathToGCRootPlugin.this.objectsView.configureColumns(CCONF_INSTANCE);
                            }
                        }
                    });
                    return new HeapViewerNode[]{new TextNode(Bundle.PathToGCRootPlugin_NoSelection())};
                }
                InstancesWrapper wrapper = HeapViewerNode.getValue(_selected, DataType.INSTANCES_WRAPPER, heap);
                if (wrapper != null) {
                    instance = null;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (!CCONF_CLASS.equals(PathToGCRootPlugin.this.objectsView.getCurrentColumnConfiguration())) {
                                PathToGCRootPlugin.this.objectsView.configureColumns(CCONF_CLASS);
                            }
                        }
                    });
                } else {
                    instance = HeapViewerNode.getValue(_selected, DataType.INSTANCE, heap);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (!CCONF_INSTANCE.equals(PathToGCRootPlugin.this.objectsView.getCurrentColumnConfiguration())) {
                                PathToGCRootPlugin.this.objectsView.configureColumns(CCONF_INSTANCE);
                            }
                        }
                    });
                    if (instance == null) {
                        return new HeapViewerNode[]{new TextNode(Bundle.PathToGCRootPlugin_NoSelection())};
                    }
                }
                HeapOperations.initializeGCRoots(heap);
                if (instance != null) {
                    data = PathToGCRootPlugin.computeInstanceRoots(instance, progress);
                    if (data != null) {
                        PathToGCRootPlugin.this.showingClass = false;
                    }
                } else {
                    data = PathToGCRootPlugin.computeInstancesRoots(wrapper.getInstancesIterator(), wrapper.getInstancesCount(), progress);
                    if (data != null) {
                        PathToGCRootPlugin.this.showingClass = true;
                    }
                }
                if (data == null) {
                    return null;
                }
                if (data.size() == 1) {
                    return new HeapViewerNode[]{(HeapViewerNode)((Object)data.iterator().next())};
                }
                final Collection _data = data;
                NodesComputer<HeapViewerNode> computer = new NodesComputer<HeapViewerNode>(_data.size(), UIThresholds.MAX_MERGED_OBJECTS){

                    @Override
                    protected boolean sorts(DataType dataType) {
                        return true;
                    }

                    @Override
                    protected HeapViewerNode createNode(HeapViewerNode node) {
                        return node;
                    }

                    @Override
                    protected ProgressIterator<HeapViewerNode> objectsIterator(int index, Progress progress) {
                        Iterator iterator = _data.iterator();
                        return new ProgressIterator<HeapViewerNode>(iterator, index, true, progress);
                    }

                    @Override
                    protected String getMoreNodesString(String moreNodesCount) {
                        return Bundle.PathToGCRootPlugin_MoreNodes(moreNodesCount);
                    }

                    @Override
                    protected String getSamplesContainerString(String objectsCount) {
                        return Bundle.PathToGCRootPlugin_SamplesContainer(objectsCount);
                    }

                    @Override
                    protected String getNodesContainerString(String firstNodeIdx, String lastNodeIdx) {
                        return Bundle.PathToGCRootPlugin_NodesContainer(firstNodeIdx, lastNodeIdx);
                    }
                };
                return computer.computeNodes(root, heap, viewID, null, dataTypes, sortOrders, progress);
            }

            @Override
            protected void populatePopup(HeapViewerNode node, JPopupMenu popup) {
                if (popup.getComponentCount() > 0) {
                    popup.addSeparator();
                }
                popup.add(new JCheckBoxMenuItem(Bundle.PathToGCRootPlugin_AutoComputeMergedRootsLbl(), PathToGCRootPlugin.this.isAutoMerge()){

                    @Override
                    protected void fireActionPerformed(ActionEvent event) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                PathToGCRootPlugin.this.setAutoMerge(this.isSelected());
                            }
                        });
                    }
                });
            }

            @Override
            protected void childrenChanged() {
                if (!PathToGCRootPlugin.this.showingClass) {
                    this.fullyExpandNode(this.getRoot());
                }
            }

            @Override
            protected void nodeExpanded(HeapViewerNode node) {
                if (PathToGCRootPlugin.this.showingClass && node instanceof GCInstanceNode) {
                    this.fullyExpandNode(node);
                }
            }

            private void fullyExpandNode(HeapViewerNode node) {
                while (node != null) {
                    this.expandNode(node);
                    node = node.getNChildren() > 0 ? node.getChild(0) : null;
                }
            }
        };
    }

    private void showObjectsView() {
        JComponent c = this.objectsView.getComponent();
        if (c.isVisible()) {
            return;
        }
        c.setVisible(true);
        this.component.removeAll();
        this.component.add((Component)c, "Center");
        this.mergedRequest = false;
        this.component.invalidate();
        this.component.revalidate();
        this.component.repaint();
    }

    private void showMergedView() {
        JComponent c = this.objectsView.getComponent();
        if (!c.isVisible()) {
            return;
        }
        c.setVisible(false);
        this.component.removeAll();
        JButton jb = new JButton(Bundle.PathToGCRootPlugin_ComputeMergedRootsLbl(), Icons.getIcon((String)"ProfilerIcons.RunGC")){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                PathToGCRootPlugin.this.showObjectsView();
                PathToGCRootPlugin.this.objectsView.reloadView();
            }
        };
        jb.setIconTextGap(jb.getIconTextGap() + 2);
        jb.setToolTipText(Bundle.PathToGCRootPlugin_ComputeMergedRootsTtp());
        Insets margin = jb.getMargin();
        if (margin != null) {
            jb.setMargin(new Insets(margin.top + 3, margin.left + 3, margin.bottom + 3, margin.right + 3));
        }
        LinkButton lb = new LinkButton(Bundle.PathToGCRootPlugin_AutoComputeMergedRootsLbl()){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                PathToGCRootPlugin.this.setAutoMerge(true);
                PathToGCRootPlugin.this.showObjectsView();
                PathToGCRootPlugin.this.objectsView.reloadView();
            }
        };
        lb.setToolTipText(Bundle.PathToGCRootPlugin_AutoComputeMergedRootsTtp());
        JPanel p = new JPanel(new GridBagLayout());
        p.setOpaque(false);
        GridBagConstraints g = new GridBagConstraints();
        g.fill = 2;
        g.gridy = 0;
        p.add((Component)jb, g);
        g = new GridBagConstraints();
        g.fill = 2;
        g.gridy = 1;
        g.insets = new Insets(10, 0, 0, 0);
        p.add((Component)lb, g);
        this.component.add(p);
        this.mergedRequest = true;
        this.component.invalidate();
        this.component.revalidate();
        this.component.repaint();
    }

    @Override
    protected JComponent createComponent() {
        this.component = new JPanel(new BorderLayout());
        this.component.setOpaque(true);
        this.component.setBackground(UIUtils.getProfilerResultsBackground());
        this.objectsView.getComponent().setVisible(false);
        this.showObjectsView();
        return this.component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void nodeSelected(HeapViewerNode node, boolean adjusting) {
        TreeTableView treeTableView = this.objectsView;
        synchronized (treeTableView) {
            if (Objects.equals((Object)this.selected, (Object)node)) {
                return;
            }
            this.selected = node;
        }
        if (this.selected != null && !this.isAutoMerge() && HeapViewerNode.getValue(this.selected, DataType.INSTANCES_WRAPPER, this.heap) != null) {
            this.showMergedView();
        } else {
            this.showObjectsView();
        }
        this.objectsView.reloadView();
    }

    @Override
    protected void closed() {
        this.objectsView.closed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<HeapViewerNode> computeInstanceRoots(Instance instance, Progress progress) throws InterruptedException {
        Instance nextInstance = instance.getNearestGCRootPointer();
        if (nextInstance == null) {
            return Collections.singleton(new TextNode(Bundle.PathToGCRootPlugin_NoRoot()));
        }
        if (nextInstance == instance) {
            return Collections.singleton(new TextNode(Bundle.PathToGCRootPlugin_IsRoot()));
        }
        ToRoot node = null;
        HeapViewerNode firstNode = null;
        ToRoot previousNode = null;
        try {
            progress.setupUnknownSteps();
            Thread current = Thread.currentThread();
            while (!current.isInterrupted() && instance != nextInstance) {
                List references = instance.getReferences();
                for (Value reference : references) {
                    if (!nextInstance.equals(reference.getDefiningInstance())) continue;
                    if (reference instanceof ObjectFieldValue) {
                        node = new FieldToRoot((ObjectFieldValue)reference);
                    } else if (reference instanceof ArrayItemValue) {
                        node = new ArrayItemToRoot((ArrayItemValue)reference);
                    }
                    if (firstNode == null) {
                        firstNode = (HeapViewerNode)((Object)node);
                        break;
                    }
                    previousNode.setChildren(new HeapViewerNode[]{(HeapViewerNode)((Object)node)});
                    break;
                }
                instance = nextInstance;
                nextInstance = instance.getNearestGCRootPointer();
                progress.step();
                previousNode = node;
            }
            if (current.isInterrupted()) {
                throw new InterruptedException();
            }
            if (node != null) {
                node.setChildren(HeapViewerNode.NO_NODES);
            }
        }
        finally {
            progress.finish();
        }
        return Collections.singleton(firstNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<HeapViewerNode> computeInstancesRoots(Iterator<Instance> instances, int count, Progress progress) throws InterruptedException {
        HashMap<Instance, GCRootNode> gcRoots = new HashMap<Instance, GCRootNode>();
        try {
            progress.setupKnownSteps(count);
            Thread current = Thread.currentThread();
            while (!current.isInterrupted() && instances.hasNext()) {
                Instance instance = instances.next();
                Instance gcRoot = PathToGCRootPlugin.getGCRoot(instance, current);
                GCRootNode gcRootNode = (GCRootNode)((Object)gcRoots.get(gcRoot));
                if (gcRootNode == null) {
                    gcRootNode = new GCRootNode(gcRoot);
                    gcRoots.put(gcRoot, gcRootNode);
                }
                gcRootNode.addInstance(instance);
                progress.step();
            }
            if (current.isInterrupted()) {
                throw new InterruptedException();
            }
        }
        catch (OutOfMemoryError e) {
            System.err.println("Out of memory in PathToGCRootPlugin: " + e.getMessage());
            HeapUtils.handleOOME(true, e);
            Set<HeapViewerNode> set = Collections.singleton(new ErrorNode.OOME());
            return set;
        }
        finally {
            progress.finish();
        }
        if (!gcRoots.isEmpty()) {
            return gcRoots.values();
        }
        return Collections.singleton(new TextNode(Bundle.PathToGCRootPlugin_NoRoot()));
    }

    private static Instance getGCRoot(Instance instance, Thread current) {
        Instance previousInstance = null;
        while (!current.isInterrupted() && instance != null && instance != previousInstance) {
            previousInstance = instance;
            instance = instance.getNearestGCRootPointer();
        }
        return instance;
    }

    private boolean isAutoMerge() {
        return NbPreferences.root().getBoolean(KEY_MERGED_GCROOTS, false);
    }

    private void setAutoMerge(boolean value) {
        NbPreferences.root().putBoolean(KEY_MERGED_GCROOTS, value);
    }

    public static class Provider
    extends HeapViewPlugin.Provider {
        @Override
        public HeapViewPlugin createPlugin(HeapContext context, HeapViewerActions actions, String viewID) {
            if (!viewID.startsWith("diff") && JavaHeapFragment.isJavaHeap(context)) {
                return new PathToGCRootPlugin(context, actions);
            }
            return null;
        }
    }

    private static class ArrayItemToRoot
    extends InstanceReferenceNode.ArrayItem
    implements ToRoot {
        public ArrayItemToRoot(ArrayItemValue value) {
            super(value, true);
        }

        @Override
        public void setChildren(HeapViewerNode[] ch) {
            super.setChildren(ch);
        }
    }

    private static class FieldToRoot
    extends InstanceReferenceNode.Field
    implements ToRoot {
        public FieldToRoot(ObjectFieldValue value) {
            super(value, true);
        }

        @Override
        public void setChildren(HeapViewerNode[] ch) {
            super.setChildren(ch);
        }
    }

    private static interface ToRoot {
        public void setChildren(HeapViewerNode[] var1);
    }

    private static class GCInstanceNode
    extends InstanceNode {
        public GCInstanceNode(Instance instance) {
            super(instance);
        }

        @Override
        protected HeapViewerNode[] lazilyComputeChildren(Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) throws InterruptedException {
            Collection nodes = PathToGCRootPlugin.computeInstanceRoots(this.getInstance(), progress);
            return nodes == null ? null : nodes.toArray(HeapViewerNode.NO_NODES);
        }
    }

    static class GCRootNode
    extends InstanceNode.IncludingNull {
        private final List<Instance> instances = new ArrayList<Instance>();

        public GCRootNode(Instance gcRoot) {
            super(gcRoot);
        }

        void addInstance(Instance instance) {
            this.instances.add(instance);
        }

        public int getCount() {
            return this.instances.size();
        }

        @Override
        protected HeapViewerNode[] lazilyComputeChildren(Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) throws InterruptedException {
            final Instance gcRoot = this.getInstance();
            final boolean isArray = gcRoot != null && gcRoot.getJavaClass().isArray();
            NodesComputer<Instance> computer = new NodesComputer<Instance>(this.instances.size(), UIThresholds.MAX_MERGED_OBJECTS){

                @Override
                protected boolean sorts(DataType dataType) {
                    return !DataType.COUNT.equals(dataType) && (!DataType.OWN_SIZE.equals(dataType) || isArray);
                }

                @Override
                protected HeapViewerNode createNode(Instance object) {
                    return new GCInstanceNode(object){

                        @Override
                        public boolean isLeaf() {
                            return gcRoot == null;
                        }
                    };
                }

                @Override
                protected ProgressIterator<Instance> objectsIterator(int index, Progress progress) {
                    ListIterator iterator = instances.listIterator(index);
                    return new ProgressIterator<Instance>(iterator, index, false, progress);
                }

                @Override
                protected String getMoreNodesString(String moreNodesCount) {
                    return Bundle.GCRootNode_MoreNodes(moreNodesCount);
                }

                @Override
                protected String getSamplesContainerString(String objectsCount) {
                    return Bundle.GCRootNode_SamplesContainer(objectsCount);
                }

                @Override
                protected String getNodesContainerString(String firstNodeIdx, String lastNodeIdx) {
                    return Bundle.GCRootNode_NodesContainer(firstNodeIdx, lastNodeIdx);
                }
            };
            return computer.computeNodes(this, heap, viewID, null, dataTypes, sortOrders, progress);
        }

        @Override
        protected Object getValue(DataType type, Heap heap) {
            if (type == DataType.COUNT) {
                return this.getCount();
            }
            return super.getValue(type, heap);
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        static class Renderer
        extends InstanceNodeRenderer {
            private static final ImageIcon ICON = Icons.getImageIcon((String)"ProfilerIcons.NodeForward");

            Renderer(Heap heap) {
                super(heap);
            }

            @Override
            public void setValue(Object value, int row) {
                GCRootNode node;
                if (value != null && (node = (GCRootNode)((Object)value)).getInstance() == null) {
                    this.setNormalValue(Bundle.PathToGCRootPlugin_NoRoot());
                    this.setBoldValue("");
                    this.setGrayValue("");
                    this.setIcon(ICON);
                    return;
                }
                super.setValue(value, row);
                this.setIconTextGap(4);
                ((LabelRenderer)this.valueRenderers()[0]).setMargin(3, 3, 3, 0);
            }

            @Override
            protected ImageIcon getIcon(Instance instance, boolean isGCRoot) {
                return ICON;
            }
        }
    }
}

