/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.hotspot.libgraal;

import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.graal.hotspot.libgraal.LibGraalFeature;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Map;
import jdk.vm.ci.hotspot.HotSpotCompilationRequest;
import jdk.vm.ci.hotspot.HotSpotInstalledCode;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethod;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.compiler.hotspot.CompilationTask;
import org.graalvm.compiler.hotspot.HotSpotGraalCompiler;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.options.OptionsParser;
import org.graalvm.compiler.serviceprovider.GraalUnsafeAccess;
import org.graalvm.libgraal.LibGraal;
import org.graalvm.nativeimage.Isolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.util.OptionsEncoder;
import org.graalvm.word.PointerBase;
import sun.misc.Unsafe;

public final class LibGraalEntryPoints {
    private static final Unsafe UNSAFE = GraalUnsafeAccess.getUnsafe();
    private static long cachedOptionsHash;
    private static OptionValues cachedOptions;

    @CEntryPoint(builtin=CEntryPoint.Builtin.GET_CURRENT_THREAD, name="Java_org_graalvm_libgraal_LibGraal_getCurrentIsolateThread")
    private static native IsolateThread getCurrentIsolateThread(PointerBase var0, PointerBase var1, @CEntryPoint.IsolateContext Isolate var2);

    private static synchronized OptionValues decodeOptions(long address, int size, int hash) {
        if (cachedOptionsHash != (long)hash) {
            byte[] buffer = new byte[size];
            UNSAFE.copyMemory(null, address, buffer, Unsafe.ARRAY_BYTE_BASE_OFFSET, size);
            int actualHash = Arrays.hashCode(buffer);
            if (actualHash != hash) {
                throw new IllegalArgumentException(actualHash + " != " + hash);
            }
            Map srcMap = OptionsEncoder.decode((byte[])buffer);
            EconomicMap dstMap = OptionValues.newOptionMap();
            Iterable loader = OptionsParser.getOptionsLoader();
            for (Map.Entry e : srcMap.entrySet()) {
                String optionName = (String)e.getKey();
                Object optionValue = e.getValue();
                OptionsParser.parseOption((String)optionName, optionValue, (EconomicMap)dstMap, (Iterable)loader);
            }
            cachedOptionsHash = hash;
            cachedOptions = new OptionValues((UnmodifiableEconomicMap)dstMap);
        }
        return cachedOptions;
    }

    @CEntryPoint(name="Java_org_graalvm_libgraal_LibGraal_setCurrentThreadName")
    @CEntryPointOptions(include=LibGraalFeature.IsEnabled.class)
    private static void setCurrentThreadName(PointerBase jniEnv, PointerBase jclass, @CEntryPoint.IsolateThreadContext long isolateThread, CCharPointer nameCString) {
        try {
            String name = CTypeConversion.toJavaString((CCharPointer)nameCString);
            Thread.currentThread().setName(name);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @CEntryPoint(name="Java_org_graalvm_compiler_hotspot_test_CompileTheWorld_compileMethodInLibgraal")
    @CEntryPointOptions(include=LibGraalFeature.IsEnabled.class)
    private static long compileMethod(PointerBase jniEnv, PointerBase jclass, @CEntryPoint.IsolateThreadContext long isolateThread, long methodHandle, boolean useProfilingInfo, boolean installAsDefault, long optionsAddress, int optionsSize, int optionsHash, long stackTraceAddress, int stackTraceCapacity) {
        try {
            HotSpotJVMCIRuntime runtime = HotSpotJVMCIRuntime.runtime();
            HotSpotResolvedJavaMethod method = (HotSpotResolvedJavaMethod)LibGraal.unhand((HotSpotJVMCIRuntime)runtime, HotSpotResolvedJavaMethod.class, (long)methodHandle);
            int entryBCI = -1;
            HotSpotCompilationRequest request = new HotSpotCompilationRequest(method, entryBCI, 0L);
            HotSpotGraalCompiler compiler = (HotSpotGraalCompiler)runtime.getCompiler();
            OptionValues options = LibGraalEntryPoints.decodeOptions(optionsAddress, optionsSize, optionsHash);
            CompilationTask task = new CompilationTask(runtime, compiler, request, useProfilingInfo, installAsDefault);
            task.runCompilation(options);
            HotSpotInstalledCode installedCode = task.getInstalledCode();
            return LibGraal.translate((HotSpotJVMCIRuntime)runtime, (Object)installedCode);
        }
        catch (Throwable t) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            t.printStackTrace(new PrintStream(baos));
            byte[] stackTrace = baos.toByteArray();
            int length = Math.min(stackTraceCapacity - 4, stackTrace.length);
            UNSAFE.putInt(stackTraceAddress, length);
            UNSAFE.copyMemory(stackTrace, Unsafe.ARRAY_BYTE_BASE_OFFSET, null, stackTraceAddress + 4L, length);
            return 0L;
        }
    }
}

