/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.agentscript.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;

final class RootNameFilter
implements Predicate<String> {
    private final Object fn;
    private final AtomicBoolean initializationFinished;
    private final ThreadLocal<Boolean> querying;

    RootNameFilter(Object fn, AtomicBoolean initializationFinished) {
        this.fn = fn;
        this.initializationFinished = initializationFinished;
        this.querying = new ThreadLocal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean test(String rootName) {
        if (!this.initializationFinished.get()) {
            return false;
        }
        if (rootName == null) {
            return false;
        }
        Boolean prev = this.querying.get();
        try {
            if (Boolean.TRUE.equals(prev)) {
                boolean bl = false;
                return bl;
            }
            this.querying.set(true);
            InteropLibrary iop = (InteropLibrary)InteropLibrary.getFactory().getUncached();
            Object res = iop.execute(this.fn, new Object[]{rootName});
            boolean bl = (Boolean)res;
            return bl;
        }
        catch (ArityException | UnsupportedMessageException | UnsupportedTypeException ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.querying.set(prev);
        }
    }
}

